	//When form ready
	jQuery(document).ready(function ()
	{	
		var account_id 	= 	jQuery('#web_creative_anchor').attr('data-account-id');
		var campaign_id = 	jQuery('#web_creative_anchor').attr('data-campaign-id');
		
		//Store it to a hidden feild
		jQuery('#_vid_account_id').val(account_id);
		jQuery('#_vid_campaign_id').val(campaign_id);
		
		if(campaign_id)
		{
			jQuery('#wvid_campaign_group').hide();
			jQuery('#campaign').val(campaign_id);
		}
		
		jQuery('#small_upload_image').hide();
		
		//Define default

		var input = document.getElementById("video_creative"),formdata = false;
		//Bind the event to onchange of the url file
		input.addEventListener("change",handleVideoFileSelect , false);	
				
		//REINITIATE VALIDATE CLASS FOR MODAL BOX
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
				var id = $(this).attr('id');
				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
						element.parents('.controls').append(error);
					},
					highlight: function(label) {
						$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
						label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}
		//REINITIATE CHECKBOX CLASS FOR MODAL BOX
		if($(".icheck-me").length > 0)
		{
			$(".icheck-me").each(function(){
				var $el = $(this);
				var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
				color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

				var opt = {
					checkboxClass: 'icheckbox' + skin + color,
					radioClass: 'iradio' + skin + color,
					increaseArea: "10%"
				}

				$el.iCheck(opt);
			});
		}
		
		special_delivery_type();
	});
		
	
	//Specify in bytes to avoid code complexity
	var iab_video_size_mb = '2MB';
	var iab_video_max_size	='2097152';
	var iab_video_file_type	=['video/ogg','video/mp4','video/webm'];

	
	if (window.FormData)
	{
  		formdata = new FormData();  
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_creative_form" );
	
	
	/* name: handleVideoFileSelect
	 * @param:null
	 * 
	 * Description:Handle video creative select, validate and process through ajax.
	 * */

	function handleVideoFileSelect(evt)
 	{		
		var form 			= 	jQuery( "#video_creative_form" );

		var isvalid_creative=	true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;
			
			//Check weather it's image
			if ((file = this.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_video_creative').val()!='')
				{
					var tmp_video_creative_name	=	jQuery('#tmp_video_creative').val();
					jQuery.ajax({
						type:'POST',
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_video_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#video_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_video_creative').val('');//empty temporary feild value
				console.log(file.type);
				console.log(!!file.type.match(/video.*/));
				if (!!file.type.match(/video.*/))
				{
					//Fetch creative attribute
					var creative_size=file.size;
					var creative_type=file.type;						
					//VALIDATE THE SELECTED IMAGE
					
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_video_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"video_creative": "Creative file format should be ogg, webm or mp4."});
							isvalid_creative=false;
							jQuery('#video_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_creative').val('');
							jQuery('#tmp_video_creative').val('');
						}
						//IAB size check
						else if (creative_size > iab_video_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"video_creative": "Creative file size should not exceeds "+iab_video_size_mb});
							isvalid_creative=false;
							jQuery('#video_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_creative').val('');
							jQuery('#tmp_video_creative').val('');
						}						
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							$("#add_video_creative").val('please wait').attr('disabled',true);
							//Validate the particular feild
							form.validate().element(jQuery('#video_creative'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_video_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											$("#add_video_creative").val('Submit').removeAttr('disabled');
											jQuery('#tmp_video_creative').val(data.response.file_name);
											jQuery('#tmp_video_creative_content_type').val(data.response.file_type);
											jQuery('#tmp_video_creative_url').val(data.response.full_path);
											jQuery('#tmp_video_creative_raw_name').val(data.response.raw_name);
											jQuery('#tmp_video_creative_file_ext').val(data.response.file_ext);
											jQuery('#tmp_video_creative_size').val(creative_size/1024);
										}
										else
										{											
											//window.location.replace(data.redirect);
											jQuery('#tmp_video_creative').val('');
											var validator = form.validate();
											validator.showErrors(data.msg);
										}
									}
								});
							}
						}
				}
				else
				{
					var validator = form.validate();
					jQuery('#video_creative').val('');
					jQuery('#video_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"video_creative": "Creative must be video "});
				}
				
			}	
		}
	}	
	
	/* name:reset_video_upload
	 * @param:
	 * 
	 * Make video upload refresh when change delivery type is changed
	 * */
	 
	function reset_video_upload()
	{
		jQuery('#video_element.fileupload').removeClass('fileupload-exists');
		jQuery('#video_element.fileupload').addClass('fileupload-new');
		jQuery('#video_creative').val('');
		jQuery('#video_creative .fileupload-preview').html('');
		
		//jQuery('#preview_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_creative_form" );
		form.validate().element(jQuery('#video_creative'));
		
		if(jQuery('#tmp_video_creative').val() !='')
		{
			var tmp_video_creative_name=jQuery('#tmp_video_creative').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_video_creative').val('');
		jQuery('#video_creative').val('');
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * Name:M.sudhakar
	 * Modified Date:09/03/2015
	 * issue:Video File is not changed 
	 * Modified :Fixing name conflict issue in javascript code
	 * */
	jQuery(function(){
		var form = jQuery("#video_creative_form");
		var validator = form.validate();
		
		jQuery( "#add_video_creative" ).unbind().bind('click',function(evt){			
			if(form.valid()==true)
			{
					evt.preventDefault();

						jQuery.ajax({
							type:'POST',
							url: form.attr("action"),
							data:form.serialize(),
							success: function(data, textStatus, jqXHR){
								
								if(data.response == 'ok')
								{
									jQuery("#add_video_creative" ).unbind('click');
									
									if(jQuery('#_vid_campaign_id').val() !='')
									{
										refresh_existing_creative(jQuery('#_vid_campaign_id').val());
										$('#add_creative_msg').attr("data-notify-message","Video creative added sucessfully");
										$('#add_creative_msg').trigger('click');	
									}
									
									//Switch modal box
									/*$('#modal_video_creative_add').one('hidden.bs.modal', function (e) {
										jQuery('.modal-backdrop').remove();
											
										if(jQuery('#_vid_campaign_id').val() =='')
										{
											jQuery('#modal_video_creative_success').modal('show');
										}
									}).modal('hide');*/
																		
									form.get(0).reset();
									//Reset hidden feilds
									jQuery('#tmp_video_creative').val('');
									jQuery('#tmp_video_creative_content_type').val('');
									jQuery('#tmp_video_creative_url').val('');
									jQuery('#tmp_video_creative_size').val('');
									
									$('#add_creative_msg').attr("data-notify-message","Creative created sucessfully!");
									$('#add_creative_msg').trigger('click');							
									setTimeout(function(){window.location.href = data.redirect; }, 2000); 
									
								}
								else
								{
									var validator = jQuery("#video_creative_form").validate();
									validator.showErrors({'video_creative':data.msg});
								}
							}, 
							// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
							error: function(jqXHR, textStatus, errorThrown){
							//alert('Oh no! A problem with the AJAX request!');
							}
						}); 
					
				
			}
		});
	});

/* this end for send datas in form */

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#video_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#video_creative'));
			
			jQuery('#video_element.fileupload').removeClass('fileupload-exists');
			jQuery('#video_element.fileupload').addClass('fileupload-new');
			jQuery('#video_creative').val('');
			jQuery('#video_element .fileupload-preview').html('');
			
			if(jQuery('#tmp_video_creative').val() !='')
			{
				var tmp_video_creative_name=jQuery('#tmp_video_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_video_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#video_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
		});
	});
	
	
	
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size	='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default
	jQuery(document).ready(function ()
	{
	var imagefile = document.getElementById("small_image_file"),formdata = false;
	//Bind the event to onchange of the url file
	imagefile.addEventListener("change",handleFileSelect , false);	
	});
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_creative_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */
	 
	function handleFileSelect(evt)
 	{		
		var form = jQuery( "#video_creative_form" );

		var isvalid_creative=true;		//form check list

		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_small_image_creative').val()!='')
				{
					var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
					jQuery.ajax({
						type:'POST',
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_small_image_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#small_image_file'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
		
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								var validator = form.validate();
								validator.showErrors({"small_image_file": "Creative file format should be jpeg, png, jpg or gif"});
								isvalid_creative=false;
								jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#small_image_file').val('');
								jQuery('#tmp_small_image_creative').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								var validator = form.validate();
								validator.showErrors({"small_image_file": "Creative file size should not exceeds "+iab_size_kb});
								isvalid_creative=false;
								jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#small_image_file').val('');
								jQuery('#tmp_small_image_creative').val('');
							}
							
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#small_image_file'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/video_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_small_image_creative').val(data.response.file_name);
												jQuery('#tmp_small_image_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_small_image_creative_url').val(data.response.full_path);
											}
											else
											{	
												//window.location.replace(data.redirect);
												jQuery('#tmp_small_image_creative').val('');
												var validator = form.validate();
												validator.showErrors(data.msg);
											}
										}
									});
								}
							}
						}
						
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#small_image_file').val('');
					jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"small_image_file": "Creative must be an image "});
				}
			}	
		}
	}
	
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('#small_image.fileupload').removeClass('fileupload-exists');
		jQuery('#small_image.fileupload').addClass('fileupload-new');
		jQuery('#small_image_file').val('');
		jQuery('#preview_image').html('');
		
		//Validate the particular field
		var form = jQuery( "#video_creative_form" );
		form.validate().element(jQuery('#small_image_file'));
		
		if(jQuery('#tmp_small_image_creative').val() !='')
		{
			var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_small_image_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_small_image_creative').val('');
		jQuery('#small_image_file').val('');
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_image" ).click(function(evt){
			var form = jQuery("#video_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#small_image_file'));
			
			jQuery('#small_image.fileupload').removeClass('fileupload-exists');
			jQuery('#small_image.fileupload').addClass('fileupload-new');
			jQuery('#small_image_file').val('');
			jQuery('#preview_image').html('');
		
			if(jQuery('#tmp_small_image_creative').val() !='')
			{
				var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_small_image_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#small_image_file'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
		});
	});

	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			url : site_url+"/buyer/campaigns/fetch_campaign_creative",
			 // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
	function show_video_type(val)
	{
		if(val=='small')
		{
			jQuery('#small_upload_image').show();
		}
		else
		{
			jQuery('#small_upload_image').hide();
		}
	}
	
	/* name: special_delivery_type
	 * @param:null
	 * 
	 * switch between HTTP and RTMP.
	 * */
	
	function special_delivery_type()
	{
		if(jQuery('#special_delivery_method').is(':checked'))
		{
			jQuery('#special_http_block').hide();
			jQuery('#special_third_party_block').show();
			jQuery('#upload_vast').hide();
			reset_video_upload();
		}
		else
		{
			jQuery('#special_http_block').show();
			jQuery('#special_third_party_block').hide();
		}
	}
	
	/* name: vast_upload
	 * @param:null
	 * 
	 * switch between Local and URL.
	 * */
	
	function vast_upload()
	{
		if(jQuery('#is_vast_upload').is(':checked'))
		{
			jQuery('#vast_tag_url').attr('disabled','disabled');
			jQuery('#upload_vast').show();
		}
		else
		{
			jQuery('#vast_tag_url').removeAttr('disabled');
			jQuery('#upload_vast').hide();
		}
	}
		
	/* name: xml_upload
	 * @param:null
	 * 
	 * switch between Local and URL.
	 * */
	
	function xml_upload(target)
	{
		var form = jQuery("#video_creative_form");
		var isvalid_creative=false;
		var file;
		if(file	= target.files[0])
		{
			var type=	file.type;
			var size=	file.size;
			
			if(type=='text/xml')
			{
				var isvalid_creative=true;
				
				if (formdata)
				{
					formdata.append("creative", file);
					formdata.append("api_key", api_key);
				}

				//If everything goes right move to a tmp location
				if (isvalid_creative==true)
				{
					$("#add_video_creative").val('please wait').attr('disabled',true);
					//Validate the particular feild
					form.validate().element(jQuery('#vast_tag_upload'));
					if (formdata)
					{
						jQuery.ajax({
							//site_url is defined in header.php (advertiser layout) file,
							url: site_url+'/api/v1/video_creative/creative_xml_to_tmp_location/format/json',
							type: "POST",
							data: formdata,
							processData: false,
							contentType: false,
							success:function(data, textStatus, jqXHR)
							{
								console.log(data.response);
								if(data.response != 'error')
								{
									$("#add_video_creative").val('Submit').removeAttr('disabled');
									jQuery('#tmp_vast_tag_upload_creative').val(data.response.file_name);
									jQuery('#tmp_vast_tag_upload_creative_content_type').val(data.response.file_type);
									jQuery('#tmp_vast_tag_upload_creative_url').val(data.response.full_path);
								}
								else
								{											
									//window.location.replace(data.redirect);
									jQuery('#tmp_vast_tag_upload_creative').val('');
									var validator = form.validate();
									validator.showErrors(data.msg);
								}
							}
						});
					}
				}
			}
			else
			{
				var validator = form.validate();
				jQuery('#vast_tag_upload').val('');
				jQuery('#vast_tag_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
				validator.showErrors({"vast_tag_upload": "Upload must be an xml file"});
			}
		}		
	}

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#vast_tag_remove" ).click(function(evt){
			var form = jQuery("#video_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#vast_tag_upload'));
			
			jQuery('#vast_tag_upload_element.fileupload').removeClass('fileupload-exists');
			jQuery('#vast_tag_upload_element.fileupload').addClass('fileupload-new');
			jQuery('#vast_tag_upload').val('');
			jQuery('#preview_vast_tag_upload').html('');
			
			if(jQuery('#tmp_vast_tag_upload_creative').val() !='')
			{
				var tmp_vast_creative_name=jQuery('#tmp_vast_tag_upload_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_vast_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#vast_tag_upload'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_vast_tag_upload_creative').val('');//empty temporary feild value
			
		});
	});  