	//When form ready
	jQuery(document).ready(function ()
	{
		 //REINITIATE VALIDATE CLASS FOR MODAL BOX
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
			var id = $(this).attr('id');
				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
					element.parents('.custom_error_class').append(error);
					},
					highlight: function(label) {
					$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
					label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}

	});

	//Define default
	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});

	var form = jQuery( "#flex_creative_edit_form" );
	
	//Specify in bytes to avoid code complexity
	var iab_size_kb 	= 	'250KB';
	var iab_max_size	=	'256000';
	var iab_file_type	=	['image/png','image/jpeg','image/jpg','image/gif'];
	
	//Set IAB creative standard

	/* name: handleFileSelect
	 * @param: type of image such as base, filmstrip, horizontal, vertical,
	 * 
	 * Description:Handle base creative select, validate and process through ajax.
	 * */

	function handleFileSelect(target,creative_type)
 	{
		if(creative_type=='base_portrait')
		{
			var iab_max_width= '320'; 
			var iab_max_height= '50';
		}
		else if(creative_type=='base_landscape')
		{
			var iab_max_width= '480'; 
			var iab_max_height= '50';
		}		
		else if(creative_type=='horizantal_ad1' || creative_type=='vertical_ad1')
		{
			var iab_max_width= '1280'; 
			var iab_max_height= '1280';
		}		
		else if(creative_type=='horizantal_ad2' || creative_type=='vertical_ad2')
		{
			var iab_max_width= '1024'; 
			var iab_max_height= '1024';
		}
		else if(creative_type=='horizantal_ad3' || creative_type=='vertical_ad3')
		{
			var iab_max_width= '800'; 
			var iab_max_height= '800';
		}
		else if(creative_type=='horizantal_ad4' || creative_type=='vertical_ad4')
		{
			var iab_max_width= '480'; 
			var iab_max_height= '480';
		}
		else if(creative_type=='content_ad1')
		{
			var iab_max_width= '768'; 
			var iab_max_height= '768';
		}
		else if(creative_type=='content_ad2')
		{
			var iab_max_width= '600'; 
			var iab_max_height= '600';
		}
		else if(creative_type=='content_ad3')
		{
			var iab_max_width= '480'; 
			var iab_max_height= '480';
		}
		else if(creative_type=='content_ad4')
		{
			var iab_max_width= '320'; 
			var iab_max_height= '320';
		}

		var form = jQuery( "#flex_creative_edit_form" );
					
		var isvalid_creative=true;		//form check list

		
		var file, img;

		//Check weather it's image
		if ((file = target.files[0]))
		{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_'+creative_type+'_creative').val()!=jQuery('#old_'+creative_type+'_creative').val())
				{
					if(jQuery('#tmp_'+creative_type+'_creative').val()!='')
					{
						var tmp_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
			
						jQuery.ajax({
							type:'POST',
							async:false,
							url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
							data: {creative_name:tmp_creative_name, api_key:api_key},
							success: function(data, textStatus, jqXHR){
								console.log(jqXHR);
								console.log(data.response);
				
								if(data.response == 'ok')
								{
									console.log(data.msg);
								}
								else
								{
									console.log(data.msg);
								}
								//Validate the particular feild
								form.validate().element(jQuery('#'+creative_type));
							}, 
							// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
							error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
							}
						}); 
					}
				}
				jQuery('#tmp_'+creative_type+'_creative').val('');//empty temporary feild value

				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
					
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
					
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type_check=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
								//IAB type check
								var creative_type_flag=jQuery.inArray(creative_type_check, iab_file_type);
								if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
								{
									var validator = form.validate();
									var errorMessage = "Creative file format should be jpeg, png, jpg or gif";
									var obj = new Object();
									obj[creative_type] = errorMessage;
									validator.showErrors(obj);
								
									isvalid_creative=false;

									jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');

									jQuery('#'+creative_type).val('');
									jQuery('#tmp_'+creative_type+'_creative').val('');
								}
								//IAB size check
								else if (creative_size > iab_max_size )
								{

									var validator = form.validate();
									var errorMessage = "Creative file size should not exceeds "+iab_size_kb;
									var obj = new Object();
									obj[creative_type] = errorMessage;
									validator.showErrors(obj);

									isvalid_creative=false;
									jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#'+creative_type).val('');
									jQuery('#tmp_'+creative_type+'_creative').val('');
								}

								//IAB width check
								else if (creative_width != iab_max_width || creative_height != iab_max_height)
								{
									var validator = form.validate();
									var errorMessage = "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions";
									var obj = new Object();
									obj[creative_type] = errorMessage;
									validator.showErrors(obj);

									isvalid_creative=false;

									jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');

									jQuery('#'+creative_type).val('');
									jQuery('#tmp_'+creative_type+'_creative').val('');
								}

								//IAB height check
								/*if (creative_height != iab_max_height )
								{
									var validator = form.validate();
									var errorMessage = "creative height is not upto Iab standard.";
									var obj = new Object();
									obj[creative_type] = errorMessage;
									validator.showErrors(obj);

									isvalid_creative=false;

									jQuery('#'+creative_type+'_element').removeClass('fileupload-exists').addClass('fileupload-new');

									jQuery('#'+creative_type).val('');
									jQuery('#tmp_'+creative_type+'_creative').val('');
								}*/

								
								
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("api_key", api_key);
								formdata.append("creative", file);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#'+creative_type));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/mobile_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_'+creative_type+'_creative').val(data.response.file_name);
												jQuery('#tmp_'+creative_type+'_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_'+creative_type+'_creative_url').val(data.response.full_path);
											}
											else
											{
												//window.location.replace(data.redirect);
												var validator = form.validate();
												validator.showErrors(data.msg);
												//jQuery('#tmp_interstitial_creative').val('');
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);
				}
				else
				{
					jQuery('#'+creative_type).val('');
					jQuery("#"+creative_type+"_element").removeClass('fileupload-exists').addClass('fileupload-new');

					var validator = form.validate();
					var errorMessage = "Creative must be an image";
					var obj = new Object();
					obj[creative_type] = errorMessage;
					validator.showErrors(obj);
				}
			}	
	}
	
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the mobile interstitial creative form
	 * */
	jQuery(function(){
		
		//var validator = jQuery("#flex_creative_edit_form").validate();
		var form = jQuery("#flex_creative_edit_form");
		var validator = form.validate();  
		//jQuery( "#edit_flex_creative" ).unbind().bind('click',function(evt){
		jQuery(document).on('click','#edit_flex_creative',function(evt){	  												  
															  
			if(jQuery("#flex_creative_edit_form").valid()==true)
			{			  
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
																	
						if(data.response == 'ok')
						{
							//Prevent multiple requests
							jQuery( "#edit_flex_creative" ).unbind('click');			  
							validator.resetForm();
							form.get(0).reset();
							
							//Reset base creative hidden feilds
							jQuery('#tmp_base_portrait_creative').val('');
							jQuery('#tmp_base_portrait_creative_content_type').val('');
							jQuery('#tmp_base_portrait_creative_url').val('');
							
							jQuery('#old_base_portrait_creative').val('');
							jQuery('#old_base_portrait_creative_content_type').val('');
							jQuery('#old_base_portrait_creative_url').val('');
							
							jQuery('#tmp_base_landscape_creative').val('');
							jQuery('#tmp_base_landscape_creative_content_type').val('');
							jQuery('#tmp_base_landscape_creative_url').val('');
													
							jQuery('#tmp_horizantal_ad1_creative').val('');
							jQuery('#tmp_horizantal_ad1_content_type').val('');
							jQuery('#tmp_horizantal_ad1_url').val('');
							
							jQuery('#tmp_horizantal_ad2_creative').val('');
							jQuery('#tmp_horizantal_ad2_content_type').val('');
							jQuery('#tmp_horizantal_ad2_url').val('');
							
							jQuery('#tmp_horizantal_ad3_creative').val('');
							jQuery('#tmp_horizantal_ad3_content_type').val('');
							jQuery('#tmp_horizantal_ad3_url').val('');
							
							jQuery('#tmp_horizantal_ad4_creative').val('');
							jQuery('#tmp_horizantal_ad4_content_type').val('');
							jQuery('#tmp_horizantal_ad4_url').val('');
							
							jQuery('#tmp_vertical_ad1_creative').val('');
							jQuery('#tmp_vertical_ad1_content_type').val('');
							jQuery('#tmp_vertical_ad1_url').val('');
							
							jQuery('#tmp_vertical_ad2_creative').val('');
							jQuery('#tmp_vertical_ad2_content_type').val('');
							jQuery('#tmp_vertical_ad2_url').val('');
							
							jQuery('#tmp_vertical_ad3_creative').val('');
							jQuery('#tmp_vertical_ad3_content_type').val('');
							jQuery('#tmp_vertical_ad3_url').val('');
							
							jQuery('#tmp_vertical_ad4_creative').val('');
							jQuery('#tmp_vertical_ad4_content_type').val('');
							jQuery('#tmp_vertical_ad4_url').val('');
							
							jQuery('#tmp_content_ad1_creative').val('');
							jQuery('#tmp_content_ad1_content_type').val('');
							jQuery('#tmp_content_ad1_url').val('');
							
							jQuery('#tmp_content_ad2_creative').val('');
							jQuery('#tmp_content_ad2_content_type').val('');
							jQuery('#tmp_content_ad2_url').val('');
							
							jQuery('#tmp_content_ad3_creative').val('');
							jQuery('#tmp_content_ad3_content_type').val('');
							jQuery('#tmp_content_ad3_url').val('');
							
							jQuery('#tmp_content_ad4_creative').val('');
							jQuery('#tmp_content_ad4_content_type').val('');
							jQuery('#tmp_content_ad4_url').val('');
																				
							$('#add_creative_msg').attr("data-notify-message","Creative created sucessfully!");
							$('#add_creative_msg').trigger('click');							
							setTimeout(function(){window.location.href = data.redirect; }, 2000);
							
							//RELOAD DATATABLES			
							//jQuery('.dataTable').dataTable(custom_opt).fnDraw();
							jQuery('.dataTable').dataTable().fnDraw();
							jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("adv_user_list_length_select");
							new AcostUISelect(t);
							jQuery("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if(jQuery(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if(jQuery(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();
							//RELOAD DATATABLES
							
																		
														
						}
						else
						{
							validator.showErrors(data.msg);
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the base creative when remove button is clicked
	 * */

	function remove(creative_type)
 	{
		var form = jQuery("#flex_creative_edit_form");
		form.validate().element(jQuery('#'+creative_type));

		if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
		{
			var tmp_base_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/mobile_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_base_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#'+creative_type));
				}, 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
		jQuery('#tmp_'+creative_type+'_creative').val('');	
	}
	/* name: 		
	 * @param:		null
	 * 
	 * Retorr to old creative
	 * */

	function restore(creative_type)
 	{
		remove(creative_type)
		if(jQuery('#old_'+creative_type+'_creative_url').val() !='')
		{
			jQuery( "#flex_creative_edit_form" ).validate().element(jQuery('#'+creative_type));
					
			var old_creative=jQuery('#old_'+creative_type+'_creative').val();
			var old_creative_content_type=jQuery('#old_'+creative_type+'_content_type').val();
			var old_creative_url=jQuery('#old_'+creative_type+'_url').val();

			jQuery( '#'+creative_type+'_group' ).removeClass( "error" ).addClass( "success" );
			jQuery( '#'+creative_type+'_element' ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			
			jQuery('#tmp_'+creative_type+'_creative').val(old_creative);
			jQuery('#tmp_'+creative_type+'_content_type').val(old_creative_content_type);
			jQuery('#tmp_'+creative_type+'_url').val(old_creative_url);

			jQuery('#preview_'+creative_type).html("<img src='"+old_creative_url+"'/>");
		}
	}
	
