
if($(".select2-me").length > 0){
	$(".select2-me").select2();
} 

//When form ready
	jQuery(document).ready(function ()
	{
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
				var id = $(this).attr('id');

				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
						element.parents('.controls').append(error);
					},
					highlight: function(label) {
						$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
						label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}
		
		//REINITIATE CHECKBOX CLASS FOR MODAL BOX
		if($(".icheck-me").length > 0)
		{
			$(".icheck-me").each(function(){
				var $el = $(this);
				var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
				color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

				var opt = {
					checkboxClass: 'icheckbox' + skin + color,
					radioClass: 'iradio' + skin + color,
					increaseArea: "10%"
				}

				$el.iCheck(opt);
			});
		}
		
		// Hide Attachments
		jQuery('#image_block').hide();
		jQuery('#file_block').hide();
		
	});
	
	function upload_type(val)
	{
		if(val=='image')
		{
			jQuery('#image_block').show();
			jQuery('#file_block').hide();
			reset_upload('file_upload');
		}
		else if(val=='file')
		{
			jQuery('#image_block').hide();
			jQuery('#file_block').show();
			reset_upload('image_upload');
		}
		else
		{
			jQuery('#image_block').hide();
			jQuery('#file_block').hide();
			reset_upload('image_upload');
			reset_upload('file_upload');
		}
	}
	
	//Specify in bytes to avoid code complexity
	var iab_max_size	='256000';
	var iab_file_type	=['image/png','image/jpeg','image/jpg','image/gif'];

	if (window.FormData)
	{
  		formdata = new FormData();
  	}
  	
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle image select for message, validate and process through ajax.
	 * */

	function handlesendImageFileSelect(target)
 	{	
		var form = jQuery( "#message_send_form" );

		var isvalid_message=true;		//form check list

		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_image_upload').val()!='')
		{
			var tmp_image_upload_name=jQuery('#tmp_image_upload').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/message/delete_a_tmp_attach/format/json',
				data: {attach_name:tmp_image_upload_name},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
					console.log(data.response);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#image_upload'));
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
		jQuery('#tmp_image_upload').val('');//empty temporary feild value
		
		var i = 0, len = target.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = target.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = target.files[0]))
			{
				if (!!file.type.match(/image.*/))
				{
					//To fetch wight and heigh of the selected image using File API.
					img = new Image();
					img.onload = function() //After programatically loding selcted image get inside the method
					{
						//Fetch creative attribute
						var image_size	=	file.size;
						var image_type	=	file.type;
						
						//VALIDATE THE SELECTED IMAGE
						
						//IAB size check
						if (image_size > iab_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"image_upload": "Upload image size exceeds IAB standard."});
							isvalid_message=false;
							jQuery('#image_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#image_upload').val('');
							jQuery('#tmp_image_upload').val('');
						}
						
						//IAB type check
						var image_type_flag=jQuery.inArray(image_type, iab_file_type);
						if (image_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"image_upload": "Upload type not supported by IAB"});
							isvalid_message=false;
							jQuery('#image_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#image_upload').val('');
							jQuery('#tmp_image_upload').val('');
						}
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("api_key", api_key);
							formdata.append("attachment", file);
						}

						//If everything goes right move to a tmp location
						if (isvalid_message==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#image_upload'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/message/attach_image_to_tmp_location/format/json',
									type: "POST",
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#message_send_form #tmp_image_upload').val(data.response.file_name);
											jQuery('#message_send_form #tmp_image_upload_content_type').val(data.response.image_type);
											jQuery('#message_send_form #tmp_image_upload_url').val(data.response.full_path);
										}
										else
										{
											//window.location.replace(data.redirect);
											jQuery('#message_send_form #tmp_image_upload').val('');
											var validator = form.validate();
											validator.showErrors({"tmp_image_upload": data.msg});
										}
									}
								});
							}
						}
					}
					img.src = _URL.createObjectURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#image_upload').val('');
					jQuery('#image_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"image_upload": "Upload must be an image "});
				}
			}	
		}
	}
	
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload(type)
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#'+type).val('');
		jQuery('#preview_image').html('');
		//Validate the particular field
		var form = jQuery( "#message_send_form" );
		form.validate().element(jQuery('#'+type));
		
		if(jQuery('#tmp_'+type).val() !='')
		{
			var tmp_upload_name=jQuery('#tmp_'+type).val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/message/delete_a_tmp_attach/format/json',
				data: {attach_name:tmp_upload_name},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_'+type).val('');
		jQuery('#'+type).val('');
	}
	
	//Specify in bytes to avoid code complexity
	var iab_max_file_size		=	'256000';
	var iab_upload_file_type	=	['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
  	
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle file select for message, validate and process through ajax.
	 * */

	function handlesendFileSelect(target)
 	{	
		var form = jQuery( "#message_send_form" );

		var isvalid_message=true;		//form check list

		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_file_upload').val()!='')
		{
			var tmp_file_upload_name=jQuery('#tmp_file_upload').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/message/delete_a_tmp_attach/format/json',
				data: {attach_name:tmp_file_upload_name},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
					console.log(data.response);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#file_upload'));
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
		jQuery('#tmp_file_upload').val('');//empty temporary feild value
		
		var i = 0, len = target.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = target.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = target.files[0]))
			{
				if (!file.type.match(/image.*/))
				{
					//To fetch wight and heigh of the selected image using File API.
					/*img = new Image();
					img.onload = function() //After programatically loding selcted image get inside the method
					{*/
						//Fetch attachment attribute
						var file_size=file.size;
						var file_type=file.type;
						
						//VALIDATE THE SELECTED IMAGE
						
						//IAB size check
						if (file_size > iab_max_file_size )
						{
							var validator = form.validate();
							validator.showErrors({"file_upload": "Upload file size exceeds IAB standard."});
							isvalid_message=false;
							jQuery('#file_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#file_upload').val('');
							jQuery('#tmp_file_upload').val('');
						}
						
						//IAB type check
						var file_type_flag=jQuery.inArray(file_type, iab_upload_file_type);
						if (file_type_flag !='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"file_upload": "Upload type not supported by IAB"});
							isvalid_message=false;
							jQuery('#file_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#file_upload').val('');
							jQuery('#tmp_file_upload').val('');
						}
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("api_key", api_key);
							formdata.append("attachment", file);
						}

						//If everything goes right move to a tmp location
						if (isvalid_message==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#file_upload'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/message/attach_file_to_tmp_location/format/json',
									type: "POST",
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#message_send_form #tmp_file_upload').val(data.response.file_name);
											jQuery('#message_send_form #tmp_file_upload_content_type').val(data.response.image_type);
											jQuery('#message_send_form #tmp_file_upload_url').val(data.response.full_path);
										}
										else
										{
											//window.location.replace(data.redirect);
											jQuery('#message_send_form #tmp_file_upload').val('');
											var validator = form.validate();
											validator.showErrors({"tmp_file_upload": data.msg});
										}
									}
								});
							}
						}
					/*}
					img.src = _URL.createObjectURL(file);*/
				}
				else
				{
					var validator = form.validate();
					jQuery('#file_upload').val('');
					jQuery('#file_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"file_upload": "Upload must be a file "});
				}
			}	
		}
	}

	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form = jQuery("#message_send_form");
		var validator = form.validate();
		
		$("#send_message").unbind().bind('click',function(evt) {
			if(form.valid()==true)
			{	          
				evt.preventDefault();
				jQuery.ajax({
					type:'POST',
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							$( "#send_message" ).unbind('click');
							validator.resetForm();
							form.get(0).reset();
							//RELOAD SENT ITEMS COUNT
							jQuery('.sent_count').html(((data.count)?'('+data.count+')':''));
							//RELOAD DATATABLES			
							var sent	=	jQuery('#sent.dataTable').dataTable(sent_opt);
							sent.fnDraw();
							
							jQuery('#sent.dataTables_filter input').attr("placeholder", "Search here...");
							jQuery("#sent.dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							jQuery("#sent #check_all").click(function(e){
								$('input', sent.fnGetNodes()).prop('checked',this.checked);
							});
							if(jQuery(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if(jQuery(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();
							//RELOAD DATATABLES			
							//$('#send_message').bind('click.msg',false);
							//jQuery( "#send_message" ).removeAttr('disabled');
							
							//Switch modal box
							$('#modal_send_message').one('hidden.bs.modal', function (e) {
								jQuery('.modal-backdrop').remove();
								jQuery('#modal_send_message_success').modal('show');
							}).modal('hide');
						}
						else
						{
							//$('#send_message').bind('click.msg',false);
							//jQuery( "#send_message" ).removeAttr('disabled');
							jQuery('.alert-error').show();
							jQuery('#error_msg').html(data.msg);
							validator.showErrors(data.msg);
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
						//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});

	function send_message()
	{
		var form = jQuery("#message_send_form");
		var validator = form.validate();
		
		if(form.valid()==true)
		{   
			jQuery.ajax({
				type:'POST',
				url: form.attr("action"),
				data:form.serialize(),
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
		
					if(data.response == 'ok')
					{
						validator.resetForm();
						form.get(0).reset();
						$("#subject,#msg_content").val('');
						$("#attach_type_image,#attach_type_file").iCheck('uncheck');
						$("#image_upload,#file_upload").val('');
						jQuery('#image_block').hide();
						jQuery('#file_block').hide();
		
						//RELOAD SENT ITEMS COUNT
						jQuery('.sent_count').html('('+data.count+')');
						//RELOAD DATATABLES			
						jQuery('#sent.dataTable').dataTable(sent_opt).fnDraw();
						jQuery('#sent.dataTables_filter input').attr("placeholder", "Search here...");
						jQuery("#sent.dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
							disable_search_threshold: 9999999
						});
						jQuery("#check_all").click(function(e){
							$('input', oTable.fnGetNodes()).prop('checked',this.checked);
						});
						if(jQuery(this).hasClass("dataTable-fixedcolumn")){
							new FixedColumns( oTable );
						}
						if(jQuery(this).hasClass("dataTable-columnfilter")){
							oTable.columnFilter({
								"sPlaceHolder" : "head:after"
							});
						}
						resize_chosen();
						//RELOAD DATATABLES			
						
						$( "#response" ).empty();
						$("<div class='alert alert-success'></div>").appendTo("div#response");	
						var content = "<button data-dismiss='alert' class='close' type='button'>×</button><span id='success_msg'></span>";					
						$(".alert-success").append(content);	
						$('#success_msg').html(data.msg);
								
						//Switch modal box
						/*jQuery('#modal_send_message').modal('hide');
						jQuery('#modal_send_message_success').modal('show');*/
						$( "ul.tabs li:eq(1) a" ).tab('show');
					}
					else
					{
						$( "#response" ).empty();
						$("<div class='alert alert-error'></div>").appendTo("div#response");	
						var content = "<button data-dismiss='alert' class='close' type='button'>×</button><span id='error_msg'></span>";					
						$(".alert-error").append(content);
						$('#error_msg').html(data.msg);
					}
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
				}
			}); 
		
		}
	}
	
