// dataTables

var account_id = $('#manager_account_id').val();

//Preload with the first column since you know it will always be there
var includedColumns = [{ 	
							"mData"		:"user_id",
							 "orderable": false,
							"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
							{
								$(nTd).addClass('with-checkbox'); // center the link                        
							},
							"mRender"	: function (data, type, full)
							{	
								var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
								return checkbox;
							}
						}];
includedColumns.push({ 	"mData"		: "user_id",
						"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
						{
							$(nTd).addClass('checkbox_id'); // Remove border                        
						},
						//"asSorting": [ "desc","asc"],
						"mRender": function (data, type, full)
						{
							return full.row_number;
						}
						});
//Add additional columns
includedColumns.push({ 	"mData"		:null,
						"mRender"	: function (data, type, full)
						{
							return full.contact_name.charAt(0).toUpperCase()+full.contact_name.slice(1);
						}
					});
includedColumns.push({ "mData"		: "email_address" });
includedColumns.push({ "mData"		: "role_name" });

includedColumns.push({ 	"mData"		: null,

						"sClass":"no-print table-buttons",

						"mRender"	: function (data, type, full) {
							
							return action_button(full);

						}
					});
					
$.each(includedColumns, function (i, column) {
	column.aTargets = [i];
});

//options dataTable

var custom_opt = {

        "bProcessing": true,

        "bAutoWidth": false,

		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
        "oLanguage":{

						
						"sSearch": "<span>Search:</span> ",

						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/template/flat/img/ajax-loader.gif' alt='Loading...' /></div>",

						"sLengthMenu": "_MENU_ <span>entries per page</span>"

					},

        "sPaginationType": "full_numbers",

        "sAjaxSource": site_url+"/buyer/users/fetch_user",
		"aoColumnDefs": includedColumns,
        dom: 'Bfrtip',
		'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
		],
		select:{
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'excelHtml5',
               exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1,2,3,4],
                      rows: '.selected'
                }
            }
         
        ]
    };

// Action 

function action_button(full)
{
	var user_id		=	full.user_id;

	var account_id	=	full.default_account_id;

	var status		=	full.user_status;
	
	var role_block	=	full.role_block;

	var rev_url = site_url+'/buyer/users/edit_user'; 

	var rev_btn = '<a data-toggle="modal" role="button" title="Edit" class="table-buttons-optimize" data-target="#modal_edit_adv_user" data_backdrop="static" href="'+rev_url+'/'+user_id+'/'+account_id+'"><span></span></a>';
	
	if(role_block!=1)
	{
		if(status==1)			
		{			
			//var block_btn = '&nbsp;<a type="button" id="blockbutton" data-toggle="modal" role="button" class="table-buttons confirm" title="Block" data="'+user_id+'" data-bb="confirm"><span><i  class="icon-lock"></i></span></a>';

			var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testcheck" data-toggle="modal" role="button" class="table-buttons" onclick="blockfunc('+user_id+');" title="Block" data="'+user_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-lock"></span></a>';

			//var block_btn = '&nbsp;<button class="table-buttons btn-danger confirm" title="Block" data="'+user_id+'" data-bb="confirm"><i class="icon-lock"></i></button>';
		}			
		else			
		{			
			//var block_btn = '&nbsp;<button class="table-buttons btn-success confirm_unblock"  title="Unblock" data="'+user_id+'" data-bb="confirm"><i class="icon-key"></i></button>';

			//var block_btn = '&nbsp;<a data-toggle="modal" role="button" class="table-buttons-default confirm_unblock" title="Unblock" data="'+user_id+'" data-bb="confirm"><span></span></a>';

			var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testuncheck" data-toggle="modal" role="button" class="table-buttons" onclick="unblockfunc('+user_id+');"  title="Unblock" data="'+user_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-key"></i></span></a>';
		}
	}
	else
	{
		var block_btn='( Role is Blocked ) ';	
	}
 
	return rev_btn+block_btn;

}

$('.modal').on('hidden', function () {

	$(this).removeData('modal');

});

// Using check box
function delete_user(user_id)
{
	if(user_id)
	{
		$("#del_user_id").val(account_id);

		$('#modal_delete_adv_user').modal('show');
	}
	else
	{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#del_user_id").val(box_check);
			$('#modal_delete_adv_user').modal('show');	
		}
		else
		{
			$('#modal_no_selection').modal('show');
		}
	}
}

// Block  Functionality with Confirm Box

function blockfunc(block_id)
{
	bootbox.confirm("Are you sure you want to block this users ?", function(result) {
  			
			if(result===true){

				// AJAX request to get the data

				$.ajax({

					// URL from the link that was clicked on

					type:'GET',

					url: site_url+'/api/v1/subaccount/block/format/json',

					data:{'block_id':block_id,'api_key':api_key},

					// Success function. the 'data' parameter is an array of objects that can be looped over

					success: function(data, textStatus, jqXHR){

						//console.log(jqXHR);

						if(data.response == 'ok'){
                           /* $('#block_adv_user_msg').attr("data-notify-message",data.msg);

							$('#block_adv_user_msg').trigger('click');	*/
							console.log('blocked');	
							$('#item').hide();						
							run();	
							$('#block_adv_user_msg').attr("data-notify-message",data.msg);

							$('#block_adv_user_msg').trigger('click');	

						}
							

					}, 

					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 

					error: function(jqXHR, textStatus, errorThrown){

					//alert('Oh no! A problem with the AJAX request!');

					}

				}); 

			}

		});
}
	// UnBlock  Functionality with Confirm Box

	function unblockfunc(unblock_id) {
    
	 	bootbox.confirm("Are you sure you want to unblock this users ?", function(result) {

  			//alert(result);


			if(result===true){

				// AJAX request to get the data

				$.ajax({

					// URL from the link that was clicked on

					type:'GET',

					url: site_url+'/api/v1/subaccount/unblock/format/json',

					data:{'unblock_id':unblock_id,'api_key':api_key},

					// Success function. the 'data' parameter is an array of objects that can be looped over

					success: function(data, textStatus, jqXHR){

						//console.log(jqXHR);

						if(data.response == 'ok'){
							 /* $('#block_adv_user_msg').attr("data-notify-message",data.msg);

							$('#block_adv_user_msg').trigger('click');	*/
							console.log('unblocked');
							$('#item').hide();
							run();	
							$('#unblock_adv_user_msg').attr("data-notify-message",data.msg);

							$('#unblock_adv_user_msg').trigger('click');	
	

						}
						else
						{
							run();	
							$('#unblock_adv_user_msg').attr("data-notify-message",data.msg);

							$('#unblock_adv_user_msg').trigger('click');	
						}			

					}, 

					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 

					error: function(jqXHR, textStatus, errorThrown){

					//alert('Oh no! A problem with the AJAX request!');

					}

				}); 

			}

		}); 

}


function muser_Block()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#block_id").val(box_check);
			$('#modal_block_adv_user').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function muser_Unblock()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#unblock_id").val(box_check);
			$('#modal_unblock_adv_user').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function run(){	
		//alert('one');
	var campaign		    =	$('#cam_name').val();  
	var campaign_type		=	$('#campaign_type').val();
	custom_opt.dom= 'Bfrtip';
	//custom_opt.sdom=  'B<"clear">lfrtip';	
	custom_opt.select=  { 'style':'multi' };
	custom_opt.columnDefs=[
					 {
						'checkboxes': {
						   'selectRow': true
							}
						 }
					  ];
				custom_opt.buttons=[
                {
						extend: 'copyHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'csvHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'excelHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'pdfHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'print',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					} 
         
				];	
	custom_opt.sAjaxSource	=	site_url+"/buyer/users/fetch_user";
	custom_opt.fnServerParams	= function ( aoData ) {
										aoData.push({ "name": "campaign_type", "value": campaign_type});							 		
										aoData.push({ "name": "campaign", "value": campaign});							 		
									};
	custom_opt.fnServerData	= 	function ( sSource, aoData, fnCallback ) {
									$.ajax({
										"dataType": 'json',
										"type": "POST",
										"url": sSource,
										"data":aoData,
										"success":fnCallback,
									  }
									);
								};
								
								
								
		dataTableRedraw();
}
function dataTableRedraw(){
	$('#adv_user_list.dataTable').dataTable(custom_opt);
	var t = document.getElementById("adv_user_list_length_select");
     new AcostUISelect(t);
	
	/*$('.dataTables_filter input').attr("placeholder", "Search here...");*/
	
	
	/*$(".dataTables_length aui-select").wrap("<div class='input-mini'></div>").val({
		disable_search_threshold: 9999999
	}).trigger('change');
	$("#check_all").click(function(e){
		//$('input', oTable.fnGetNodes()).prop('checked',this.checked);
	});
	if($(this).hasClass("dataTable-fixedcolumn")){
		new FixedColumns( oTable );
	}
	if($(this).hasClass("dataTable-columnfilter")){
		oTable.columnFilter({
			"sPlaceHolder" : "head:after"
		});
	}*/
	resize_chosen();
}
