// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
        "bDestroy": true,
        "bDom":'Bfrtip',
		"sPaginationType": "full_numbers",
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sProcessing": "<img src='"+site_url+"/template/flat/img/loader.gif'>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
		buttons: [
            {
                extend: 'copyHtml5'
            },
            {
                extend: 'csvHtml5'
            },
            {
                extend: 'excelHtml5'
            },
            {
                extend: 'pdfHtml5'
            },
            {
                extend: 'print'
            }
         
        ],
        "sAjaxSource": site_url+"/advertiser/tracker/fetch_pixel_list",
	
		"aoColumnDefs": [
			{
				"aTargets"	: [0],
				"mData"		:"trackerid",
				"orderable":false,
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('with-checkbox'); // center the link                        
				},
				"mRender"	: function (data, type, full)
				{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
				}
			},
			{
				"aTargets": [1],
				"mData": "trackerid",				
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('checkbox_id'); // Remove border                        
				},								
				"mRender": function (data, type, full)
				{
					return full.row_number;
				}
			},			
			{
				"aTargets": [2],
				"mData":"trackername",
				"mRender": function (data, type, full)
				{
					return data;
				}				
			},
			
			{
				"aTargets": [3],
				"mData":"pixel_type",
				
			},
			{
				"aTargets": [4],
				"mData":"pixel_category",
				"mRender": function (data, type, full)
				{
					return data;
				}				
			},
			/*{
				"aTargets": [5],
				"mData":"campaignname",
			},*/
			{
				"aTargets": [5],
				"mData": "trackerid",
				"sClass":"no-print",
				"mRender": function (data, type, full)
				{
					return action_column(full);
				}
				
			}
		
    	]/*,
		"fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
			var index = (iDisplayIndexFull + 1);
			$("td:first", nRow).html(index);
			return nRow;
		}*/
    };
    
    
function pixel_category(full)
{
	return full.name.charAt(0).toUpperCase() + full.name.slice(1);
}
    
function action_column(full)
{	
	var edit_url 	= 	site_url+'/advertiser/tracker/edit_pixel_tracker';
	
	var data_target		=	"#modal_pixel_tracker_edit";  
	
	var data_backdrop	=	"static";
	
	//var edit_btn 	= 	'<a data-toggle="modal" role="button" title="Edit" class="btn btn-small"  data-target="'+data_target+'" data-backdrop="'+data_backdrop+'" href="'+edit_url+'/'+full.trackerid+'"><i class="icon-edit"></i></a>';
	
	//var delete_btn 	= 	'<a data-toggle="modal" role="button" title="Delete" class="btn btn-small" onclick="delete_tracker('+full.trackerid+')"><i class="icon-trash"></i></a>';
	
	
	var edit_btn 	= 	'<a data-toggle="modal" role="button" title="Edit" class="btn btn-small"  onclick="security_checking(&#39;edit_tracker&#39;,'+full.trackerid+',&#39;'+edit_url+'/'+full.trackerid+'&#39;,&#39;'+data_target+'&#39;)"><i class="icon-edit"></i></a>';
	var delete_btn 	= 	'<a data-toggle="modal" role="button" title="Delete" class="btn btn-small" onclick="security_checking(&#39;delete_tracker&#39;,'+full.trackerid+',&#39;&#39;,&#39;&#39;)"><i class="icon-trash"></i></a>';	
	var tracker_url = 	site_url+'/advertiser/tracker/view_tracker';
	
	var tracker_btn = 	'<a data-toggle="modal" role="button"  class="btn btn-small" title="Code" data-target="#modal_tracker" data-backdrop="'+data_backdrop+'" href="'+tracker_url+'/'+full.trackerid+'"><i class="icon-tasks"></i></a>';
	
	var link_url 	= 	site_url+'/advertiser/tracker/link_tracker';
	
	//var link_btn = 	'<a data-toggle="modal" role="button" class="btn btn-small" title="Link" href="'+link_url+'/'+full.trackerid+'"><i class="icon-link"></i></a>';
	var link_btn = 	'<a data-toggle="modal" role="button" class="btn btn-small" title="Link" onclick="security_checking(&#39;link_tracker&#39;,'+full.trackerid+',&#39;'+link_url+'/'+full.trackerid+'&#39;,&#39;&#39;)"><i class="icon-link"></i></a>';
	
	return edit_btn+''+delete_btn+''+tracker_btn+''+link_btn;	
}

//Delete a country bidding

function delete_tracker(tracker_id)
{	
	$("#delete_tracker_id").val(tracker_id);
    $('#modal_del_tracker').modal('show');	
}

function delete_track()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

	if(box_check!="")	
	{
		$("#tracker_id").val(box_check);
		$('#modal_form_delete_track').modal('show');	
	}
	else
	{  
		$('#modal_no_selection').modal('show');
	}
	 
}

function security_checking(action,tracker_id,edit_url,data_target){
	//console.log(bannerid);
	if(tracker_id == ""){
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check==""){
			$('#modal_no_selection').modal('show');
			return false;
		}
	}
	
	$.ajax({
			method: "GET",
			async: false,
			data: { 'action' : action, 'api_key':api_key },
			//dataType : "json",
			url: site_url+"/api/v1/network/security_check/format/json",
			success: function(data){
				if(data.response == 'ok' || data.response == 'info')
				{
					
							$('#mobile_span').html("Please enter your mobile number (Ends with xxxxx"+data.mobileno.slice(-3)+" )");
							$('#mobileno').val(data.mobileno);
						
							$('#email_span').html("Please enter your email id (Ends with xxxxx"+data.email.slice(-4)+" )");
							$('#email').val(data.email);
							$('#question').html(data.question);
							$('#tracker_id').val(tracker_id);
							$('#action_type').val(action);
							$('#edit_url').val(edit_url);
							$('#data_target').val(data_target);	
							$('#question').hide();
							$('#mobile_span').hide();
							$('#email_span').hide();
							$('#verify_code').hide();
							$('#verification_code').val("");
							$('#verify_codes').val("");
							$('#error_verification').html("");
							$("select option[value='']").prop("selected",true);
							$('#modal_verification_code').modal('show');
				}
				else{
					if(action == 'delete_tracker'){
						if(tracker_id){
							delete_tracker(tracker_id);
						}else{
						delete_track();
						}
						
					}
					if(action == 'edit_tracker'){
						
						if(tracker_id){
							$(data_target).modal('show').find('.modal-body').load(edit_url);
								
						}
					}
					if(action == 'link_tracker'){
						
						if(tracker_id){
							//$(data_target).modal('show').find('.modal-body').load(edit_url);
								window.location.replace(edit_url);	
								//console.log(edit_url);
						}
					}
				}
			},
			 error: function(){
					//return '2';
			}
		});
	
}
