// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sProcessing": "<img src='"+site_url+"/template/flat/img/loader.gif'>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/advertiser/payments/fetch_payment_deposit_list",
		"aaSorting" : [[0, 'desc']],
		dom: 'Bfrtip',
		buttons: [
            {
                extend: 'copyHtml5'
            },
            {
                extend: 'csvHtml5'
            },
            {
                extend: 'excelHtml5'
            },
            {
                extend: 'pdfHtml5'
            },
            {
                extend: 'print'
            }
         
        ],
	  "aoColumnDefs": [
        {
				"aTargets": [0],
				"mData": "id",
				"mRender": function (data, type, full)
				{
					return full.row_number;
				}
			},
			{
			"aTargets": [1],
			"mData": null,
			"mRender": function (data, type, full) {
				var a= full.admin_approval_status;
			  
				if(a==0)
				{
					return '<a role="button"  class="btn btn-small" title="Pending"><i class="icon-circle" style="color:Red"></i></a>';
				}
				else if(a==1)
				{
					return '<a role="button"  class="btn btn-small" title="Paid"><i class="icon-circle" style="color:green"></i></a>';
				}
				else
				{
					return '<a role="button"  class="btn btn-small" title="Cancelled"><i class="icon-ok-circle" style="color:red"></i></a>';
					
				} 
			}
		},
		
		{
			"aTargets": [2],
			"mData":null,
			"mRender":function (data,type,full) {
			   var paid_date= full.date;
			   return getFormattedDate(paid_date);
			}
		},
		{
			"aTargets": [3],
			"mData":"name",
		},
        {
			"aTargets": [4],
			"mData": "email",
		},
		{
			"aTargets": [5],
			"mData": null,
			"mRender": function (data, type, full) {
			  var amount=currency +' '+full.amount;
			  return amount;  
			}
		},
		{
			"aTargets": [6],
			"mData": null,
			"mRender": function (data, type, full) {
			  var pay_type=full.payment_type;
			  var b_id=full.billing_id;
			  return action_button(pay_type,b_id);
		  }
		},		
    	]
    };

//date seperator
function getFormattedDate(dString)
 {
  var d = new Date(dString.split(".")[0].replace(/-/g,"/")); 
  var mm = d.getMonth()+1;
  var dd = d.getDate();
  if (mm<10)mm="0"+mm;
  if (dd<10)dd="0"+dd;
  return d.getFullYear()+"/"+mm+"/"+dd;
}

function action_button(pay_type,b_id)
{	
	if(pay_type==1)
	{ 
		var block_btn = '&nbsp;<a onclick="call_detail('+b_id+');" role="button" class="btn" data-toggle="modal">Wire</a>';  
	}
	else if(pay_type==2) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="btn" data-toggle="modal">Paypal</a>';
	}
	else if(pay_type==3) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="btn" data-toggle="modal">Zpurse</a>';
	}
	else if(pay_type==4) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="btn" data-toggle="modal">Bitcoin</a>';
	}
	else if(pay_type==5) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="btn" data-toggle="modal">Authorize</a>';
	}
	
	return block_btn;
}

//$('#submit_search').click(function (){
function run(){	
	var status				=	$('#status').val();
	var payment_type		=	$('#paymenttype').val();
	custom_opt.sAjaxSource	=	site_url+"/advertiser/payments/fetch_payment_deposit_list";
	custom_opt.fnServerParams	= function ( aoData ) {
										aoData.push({ "name": "status", "value": status});							 		
										aoData.push({ "name": "payment_type", "value": payment_type});							 		
									};
	custom_opt.fnServerData	= 	function ( sSource, aoData, fnCallback ) {
									$.ajax({
										"dataType": 'json',
										"type": "POST",
										"url": sSource,
										"data":aoData,
										"success":fnCallback,
									  }
									);
								};
	dataTableRedraw();
	//$('.dataTable').dataTable(custom_opt);
//});
}
function dataTableRedraw(){
	$('#adv_deposit.dataTable').dataTable(custom_opt);
	$('.dataTables_filter input').attr("placeholder", "Search here...");
	$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
		disable_search_threshold: 9999999
		});
	$("#check_all").click(function(e){
		$('input', oTable.fnGetNodes()).prop('checked',this.checked);
	});
	if($(this).hasClass("dataTable-fixedcolumn")){
		new FixedColumns( oTable );
	}
	if($(this).hasClass("dataTable-columnfilter")){
		oTable.columnFilter({
			"sPlaceHolder" : "head:after"
		});
	}
	resize_chosen();	
}
