	if($(".select2-me").length > 0){
		$(".select2-me").select2();
	}
	//When form ready
	jQuery(document).ready(function ()
	{
		var account_id = jQuery('#web_creative_anchor').attr('data-account-id');
		var campaign_id = jQuery('#web_creative_anchor').attr('data-campaign-id');
		
		//Store it to a hidden feild
		jQuery('#_wpop_account_id').val(account_id);
		jQuery('#_wpop_campaign_id').val(campaign_id);
		
		if(campaign_id)
		{
			jQuery('#wpop_adv_group').hide();
			jQuery('#wpop_campaign_group').hide();
		}
		
		jQuery('#wpop_adv_name').change(function() {

			jQuery.ajax({
				type:'GET',
				async:false,
				dataType:'json',
				url: site_url+'/api/v1/creative/fetch_campaigns/format/json',
				data: {account_id:this.value,campaign_type:'WEB',api_key:api_key},
				success: function(data, textStatus, jqXHR){
					
					if(data != 'error')
					{						
						var option	=	"<select name='campaign' id='wpop_campaign' class='select2-me input-xlarge' data-rule-required='true' data-nosearch='true'>"+
										"<option value=''>Choose Campaign</option>";
						jQuery.each(data, function(key, value) {							
							if(value.campaignid != '')
							{
								option +=	"<option value='"+value.campaignid+"' >"+value.campaignname+"</option>";
							}					 
						});
						option +=	'</select>'+
									'<span class="hidden-480">'+
									'&nbsp;&nbsp;&nbsp;<a  class="" rel="popover" data-trigger="hover" title="Campaign" data-content="Select any one of the campaign"><i class="glyphicon-circle_exclamation_mark"></i></a>'+
									'</span>';
					}
					else
					{					
						var option=	"<select name='campaign' id='wpop_campaign' class='select2-me input-xlarge' data-rule-required='true' data-nosearch='true'>";
						option +=	"<option value='' >No campaign found</option>";
						option +=	'</select>'+
									'<span class="hidden-480">'+
									'&nbsp;&nbsp;&nbsp;<a  class="" rel="popover" data-trigger="hover" title="Campaign" data-content="Select any one of the campaign"><i class="glyphicon-circle_exclamation_mark"></i></a>'+
									'</span>';
					}
					
					jQuery('#wpop_campaign_list').html(option);
					jQuery('#wpop_campaign').select2();
					jQuery('[rel="popover"]').popover();
				}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
				}
				 
			});
	 
		});
				
	});
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the HTML creative form
	 * */
	jQuery(function(){
		var form = jQuery("#popup_creative_form");
		var validator = form.validate();
		jQuery( "#popup_creative" ).unbind().bind('click',function(evt){

		  if(form.valid()==true)
		  {
			  evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery( "#popup_creative" ).unbind('click');
							if(jQuery('#_wpop_campaign_id').val() !='')
							{
								refresh_existing_creative(jQuery('#_wpop_campaign_id').val());
								$('#add_creative_msg').attr("data-notify-message","Creative added sucessfully");
								$('#add_creative_msg').trigger('click');
							}

							//Switch modal box
							$('#modal_popup_creative_add').one('hidden.bs.modal', function (e) {
								if(jQuery('#_wpop_campaign_id').val() =='')
								{
									jQuery('#modal_popup_creative_success').modal('show');
								}								
							}).modal('hide');						
							
							validator.resetForm();
							form.get(0).reset();							
						}
						else
						{
							var validator = jQuery( "#popup_creative_form" ).validate();
							validator.showErrors({"popup_creative_name": data.msg});
							$(this).modal('hide');
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/admin/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
