	if($(".select2-me").length > 0){
		$(".select2-me").select2();
	}
	
	//REINITIATE CHECKBOX CLASS FOR MODAL BOX
	if($(".icheck-me").length > 0)
	{
		$(".icheck-me").each(function(){
			var $el = $(this);
			var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
			color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

			var opt = {
				checkboxClass: 'icheckbox' + skin + color,
				radioClass: 'iradio' + skin + color,
				increaseArea: "10%"
			}

			$el.iCheck(opt);
		});
	}
	
	//When form ready
	jQuery(document).ready(function (){
		source_type();
	});
	
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];
	
	var iab_flash_file_type=['application/x-shockwave-flash'];

	//Define default

	var input = document.getElementById("layer_creative"),formdata = false;
	var input_flash = document.getElementById("flash_creative"),formdata = false;
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleFileSelect , false);
	input_flash.addEventListener("change",handleFlashFileSelect , false);
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#layer_creative_form" );

	/* name: source_type
	 * @param:null
	 * 
	 * switch between url and text.
	 * */
	
	function source_type()
	{
		if (jQuery('#is_external').is(':checked'))
		{
			jQuery('#url').show();
			jQuery('#html').hide();
			jQuery('#flash').hide();		
			jQuery('#upload_group').hide();
			jQuery('#external_group').show();			
			jQuery('#html_group').hide();
			jQuery('#flash_upload').hide();
		}
		else if (jQuery('#is_html').is(':checked'))
		{
			jQuery('#url').hide();
			jQuery('#html').show();
			jQuery('#flash').hide();
			jQuery('#upload_group').hide();
			jQuery('#external_group').hide();			
			jQuery('#html_group').show();
			jQuery('#flash_upload').hide();
		}
		else if (jQuery('#is_flash').is(':checked'))
		{
			jQuery('#url').hide();
			jQuery('#html').hide();
			jQuery('#flash').show();
			jQuery('#upload_group').hide();
			jQuery('#external_group').hide();			
			jQuery('#html_group').hide();
			jQuery('#flash_upload').show();
		}
		else
		{	
			jQuery('#url').show();
			jQuery('#html').show();
			jQuery('#flash').show();
			jQuery('#upload_group').show();
			jQuery('#external_group').hide();			
			jQuery('#html_group').hide();
			jQuery('#flash_upload').hide();
		}
	}
	
	
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		var sel_creative_size	=	jQuery('#layer_creative_size').val();
		var csize_split 		= 	sel_creative_size.split('x');
		var iab_max_width		= 	parseInt(csize_split[0], 10); 
		var iab_max_height		= 	parseInt(csize_split[1], 10);

		var form = jQuery( "#layer_creative_form" );

		var isvalid_creative	=	true;		//form check list

		
		
		var i = 0, len = this.files.length, img, reader, file;
		//for ( ; i < len; i++ )
		//{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_layer_creative').val()!='')
				{
					var tmp_web_creative_name=jQuery('#tmp_layer_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_web_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#layer_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
				jQuery('#tmp_layer_creative').val('');//empty temporary feild value
						
				if ((!!file.type.match(/image.*/)))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size	=	file.size;
							var creative_type	=	file.type;
							var creative_width	=	parseInt(this.width,10);
							var creative_height	=	parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
								//IAB type check
								var creative_type_flag	=	jQuery.inArray(creative_type, iab_file_type);
								if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
								{
									var validator 		= 	form.validate();
									validator.showErrors({"layer_creative": "Creative file format should be jpeg, png, jpg or gif"});
									isvalid_creative	=	false;
									jQuery('#layer_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#layer_creative').val('');
									jQuery('#tmp_layer_creative').val('');
								}
								
								//IAB size check
								if (creative_size > iab_max_size )
								{
									var validator 		= 	form.validate();
									validator.showErrors({"layer_creative": "Creative file size should not exceeds "+iab_size_kb});
									isvalid_creative	=	false;
									jQuery('#layer_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#layer_creative').val('');
									jQuery('#tmp_layer_creative').val('');
								}

								//IAB width check
								else if (creative_width != iab_max_width || creative_height != iab_max_height)
								{
									var validator 		= 	form.validate();
									
									validator.showErrors({"layer_creative": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
									isvalid_creative	=	false;
									jQuery('#layer_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#layer_creative').val('');
									jQuery('#tmp_layer_creative').val('');
								}

								//IAB height check
								/*if (creative_height != iab_max_height )
								{
									var validator = form.validate();
									validator.showErrors({"web_creative": "creative height is not upto Iab standard."});
									isvalid_creative=false;
									jQuery('#creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#web_creative').val('');
									jQuery('#tmp_web_creative').val('');
								}*/

							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								jQuery( "#layer_creative_form" ).validate().element(jQuery('#layer_creative'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_layer_creative').val(data.response.file_name);
												jQuery('#tmp_layer_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_layer_creative_url').val(data.response.full_path);
											}
											else
											{												
												//window.location.replace(data.redirect);
												jQuery('#tmp_layer_creative').val('');
												var validator = jQuery( "#layer_creative_form" ).validate();
												validator.showErrors({"layer_creative": data.msg});
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);	
				}
				else
				{
					var validator = jQuery( "#layer_creative_form" ).validate();
					jQuery('#layer_creative').val('');
					jQuery('#layer_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"layer_creative": "Creative must be an image "});
				}
			}	
		//}
		
	}
	
	/* name: handleFlashFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFlashFileSelect(evt)
 	{
		var sel_creative_size=jQuery('#layer_creative_size').val();
		var csize_split = sel_creative_size.split('x');
		var iab_max_width= parseInt(csize_split[0], 10); 
		var iab_max_height= parseInt(csize_split[1], 10);

		var form = jQuery( "#layer_creative_form" );
		
		var isvalid_creative=true;		//form check list

		
		
		var i = 0, len = this.files.length, img, reader, file;

			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_flash_creative').val()!='')
				{
					var tmp_web_creative_name=jQuery('#tmp_flash_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_web_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
						//Validate the particular feild
						form.validate().element(jQuery('#flash_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
				jQuery('#tmp_flash_creative').val('');//empty temporary feild value
				if ((file.type=='application/x-shockwave-flash'))
				{
					if (window.FileReader)
					{
						reader = new FileReader();
						reader.readAsDataURL(file);
					}
					if (formdata)
					{
						formdata.append("api_key", api_key);
						formdata.append("creative", file);
					}

					//If everything goes right move to a tmp location
					if (isvalid_creative==true)
					{
						//Validate the particular feild
						jQuery( "#layer_creative_form" ).validate().element(jQuery('#flash_creative'));
						if (formdata)
						{
							jQuery.ajax({
								//site_url is defined in header.php (advertiser layout) file,
								url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
								type: "POST",
								async:false,
								data: formdata,
								processData: false,
								contentType: false,
								success:function(data, textStatus, jqXHR)
								{
									if(data.response != 'error')
									{
										console.log(data.response);
										jQuery('#tmp_flash_creative').val(data.response.file_name);
										jQuery('#tmp_flash_creative_content_type').val(data.response.image_type);
										jQuery('#tmp_flash_creative_url').val(data.response.full_path);
									}
									else
									{
										window.location.replace(data.redirect);
										jQuery('#tmp_flash_creative').val('');
									}
								}
							});
						}
					}
				}
				else
				{
					var validator = jQuery( "#layer_creative_form" ).validate();
					jQuery('#flash_creative').val('');
					jQuery('#flash_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"flash_creative": "Creative must be an swf file"});
				}
			}	
	}

	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#layer_creative').val('');
		jQuery('#preview_image').html('');
		
		//Validate the particular feild
		var form = jQuery( "#layer_creative_form" );
		form.validate().element(jQuery('#layer_creative'));
		
		if(jQuery('#tmp_layer_creative').val() !='')
		{
			var tmp_web_creative_name=jQuery('#tmp_layer_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_web_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_layer_creative').val('');
	}

	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form = jQuery("#layer_creative_form");
		var validator = form.validate();
		jQuery( "#layerad_creative" ).unbind().bind('click',function(evt){

			if(form.valid()==true)
			{
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					url: form.attr("action"),
					async:false,
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery( "#layerad_creative" ).unbind('click');
							
							var validator = jQuery( "#layer_creative_form" ).validate();
							validator.resetForm();
							form.get(0).reset();	
							
							//RELOAD DATATABLES	
							//html5 export data buttons
							exportdatabutton();				
							jQuery('.dataTable').dataTable(custom_opt).fnDraw();
							jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
							jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							jQuery("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if(jQuery(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if(jQuery(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//Reset hidden feilds
							jQuery('#tmp_layer_creative').val('');
							jQuery('#tmp_layer_creative_content_type').val('');
							jQuery('#tmp_layer_creative_url').val('');
							
							jQuery('#tmp_flash_creative').val('');
							jQuery('#tmp_flash_creative_content_type').val('');
							jQuery('#tmp_flash_creative_url').val('');
							
							$('#modal_layer_creative_edit').one('hidden.bs.modal', function (e) {
								jQuery('#modal_layer_creative_edit_success').modal('show');
							}).modal('hide');
						}
						else
						{
							var validator = jQuery( "#layer_creative_form" ).validate();
							validator.showErrors({"layer_creative": data.msg});
							$(this).modal('hide');
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#layer_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#layer_creative'));
			
			jQuery('.fileupload').removeClass('fileupload-exists');
			jQuery('.fileupload').addClass('fileupload-new');
			jQuery('#layer_creative').val('');
			jQuery('#preview_image').html('');
		
			if(jQuery('#tmp_layer_creative').val() !='')
			{
				var tmp_web_creative_name=jQuery('#tmp_layer_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_web_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
					//Validate the particular feild
					form.validate().element(jQuery('#layer_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_layer_creative').val('');
			
		});
	});	
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the base creative when remove button is clicked
	 * */

	function remove(creative_type)
 	{
		var form = jQuery("#layer_creative_form");
		form.validate().element(jQuery('#'+creative_type+'_creative'));
		
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#'+creative_type+'_creative').val('');
		jQuery('#preview_image').html('');
		
		if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
		{
			var tmp_base_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_base_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
					//Validate the particular feild
					form.validate().element(jQuery('#'+creative_type+'_creative'));
				}, 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}	
		jQuery('#tmp_'+creative_type+'_creative').val('');		
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Retore to old creative
	 * */

	jQuery(function(){
		jQuery( "#restore" ).click(function(evt){

			evt.preventDefault();
			remove('layer');
			if(jQuery('#old_layer_creative').val() !='')
			{
				jQuery( "#layer_creative_form" ).validate().element(jQuery('#layer_creative'));
					
				var old_creative				=	jQuery('#old_layer_creative').val();
				var old_creative_content_type	=	jQuery('#old_layer_creative_content_type').val();
				var old_creative_url			=	jQuery('#old_layer_creative_url').val();

				jQuery("#layercreative" ).removeClass( "error" ).addClass( "success" );
				jQuery("#layer_creative_element" ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
				
				jQuery('#tmp_layer_creative').val(old_creative);
				jQuery('#tmp_layer_creative_content_type').val(old_creative_content_type);
				jQuery('#tmp_layer_creative_url').val(old_creative_url);
				
				jQuery('#preview_image').html("<img src='"+old_creative_url+"'/>");

			}
			
		});
	});
