	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['application/x-shockwave-flash'];
	var iab_backup_file_type=['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default

	var input = document.getElementById("flash_creative_edit"),formdata = false;

	
	var input_back_up_creative = document.getElementById("backup_creative_edit"),formdata = false;
	
	//Bind the event to onchange of the url file

	input.addEventListener("change",handleFileSelect , false);	

	input_back_up_creative.addEventListener("change",handleBackupcreativeFileSelect , false);

	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#flash_creative_edit_form");

	
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		var selcted_creative_size=jQuery('#flash_creative_size').val();
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);		
		
		var form = jQuery( "#flash_creative_edit_form" );

		var isvalid_creative=true;		//form check list		
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_flash_creative').val()!='')
				{
					var tmp_web_creative_name=jQuery('#tmp_flash_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_web_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#flash_creative_edit'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
				jQuery('#tmp_flash_creative').val('');//empty temporary feild value
		
				if ((file.type=='application/x-shockwave-flash'))
				{
					if (window.FileReader)
					{
						reader = new FileReader();
						reader.readAsDataURL(file);
					}
					if (formdata)
					{
						formdata.append("creative", file);
						formdata.append("api_key", api_key);
					}

					//If everything goes right move to a tmp location
					if (isvalid_creative==true)
					{
						//Validate the particular feild
						jQuery( "#flash_creative_edit_form" ).validate().element(jQuery('#flash_creative_edit'));
						if (formdata)
						{
							jQuery.ajax({
								//site_url is defined in header.php (advertiser layout) file,
								url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
								type: "POST",
								async:false,
								data: formdata,
								processData: false,
								contentType: false,
								success:function(data, textStatus, jqXHR)
								{
									console.log(data.response);
									if(data.response != 'error')
									{
										jQuery('#tmp_flash_creative').val(data.response.file_name);
										jQuery('#tmp_flash_creative_content_type').val(data.response.image_type);
										jQuery('#tmp_flash_creative_url').val(data.response.full_path);
									}
									else
									{
										//window.location.replace(data.redirect);
										var validator = jQuery( "#flash_creative_edit_form" ).validate();
										validator.showErrors(data.msg);
										jQuery('#tmp_flash_creative').val('');
									}
								}
							});
						}
					}
				}
				else
				{
					var validator = jQuery( "#flash_creative_edit_form" ).validate();
					jQuery('#flash_creative_edit').val('');
					jQuery('#flash_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"flash_creative_edit": "Creative must be an swf file"});
				}
			}	
		}
	}
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleBackupcreativeFileSelect(evt)
 	{
		var selcted_creative_size=jQuery('#flash_creative_size').val();
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);
		
		var form = jQuery( "#flash_creative_edit_form" );

		var isvalid_creative=true;		//form check list

		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_backup_flash_creative').val()!='')
				{
					var tmp_web_creative_name=jQuery('#tmp_backup_flash_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_web_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
						//Validate the particular feild
						form.validate().element(jQuery('#backup_creative_edit'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_backup_flash_creative').val('');//empty temporary feild value
		
		
				if ((!!file.type.match(/image.*/)))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
								//IAB type check
								var creative_type_flag=jQuery.inArray(creative_type, iab_backup_file_type);
								if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
								{
									var validator = form.validate();
									validator.showErrors({"backup_creative_edit": "creative type not supported by Iab"});
									isvalid_creative=false;
									jQuery('#flash_backup_creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#backup_creative_edit').val('');
									jQuery('#tmp_backup_flash_creative').val('');
								}
								//IAB size check
								else if (creative_size > iab_max_size )
								{
									var validator = form.validate();
									validator.showErrors({"backup_creative_edit":"Creative file size should not exceeds "+iab_size_kb});
									isvalid_creative=false;
									jQuery('#flash_backup_creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#backup_creative_edit').val('');
									jQuery('#tmp_backup_flash_creative').val('');
								}

								//IAB width check
								else if (creative_width != iab_max_width || creative_height != iab_max_height)
								{
									var validator = form.validate();
									validator.showErrors({"backup_creative_edit": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
									isvalid_creative=false;
									jQuery('#flash_backup_creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#backup_creative_edit').val('');
									jQuery('#tmp_backup_flash_creative').val('');
								}

								//IAB height check
								/*if (creative_height != iab_max_height )
								{
									var validator = form.validate();
									validator.showErrors({"backup_creative_edit": "creative height is not upto Iab standard."});
									isvalid_creative=false;
									jQuery('#flash_backup_creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#backup_creative_edit').val('');
									jQuery('#tmp_backup_flash_creative').val('');
								}*/

								
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								jQuery( "#flash_creative_edit_form" ).validate().element(jQuery('#backup_creative_edit'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_backup_flash_creative').val(data.response.file_name);
												jQuery('#tmp_backup_flash_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_backup_flash_creative_url').val(data.response.full_path);
											}
											else
											{
												//window.location.replace(data.redirect);	
												var validator = jQuery( "#flash_creative_edit_form" ).validate();
												validator.showErrors(data.msg);
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = jQuery( "#flash_creative_edit_form" ).validate();
					jQuery('#backup_creative_edit').val('');
					jQuery('#flash_backup_creative_edit_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"backup_creative_edit": "Creative must be an image "});
					
				}
			}	
		}
	}


	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){

		//var form = jQuery("#flash_creative_form");
		var validator = jQuery("#flash_creative_edit_form").validate();

		jQuery( "#edit_flash_creative" ).unbind().bind('click',function(evt){

		  if(jQuery("#flash_creative_edit_form").valid()==true)
		  {
			  //jQuery('#edit_flash_creative').unbind('click');
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					async:false,
					url: form.attr("action"),
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{

							jQuery('#edit_flash_creative').unbind('click');
							
							var validator = jQuery("#flash_creative_edit_form").validate();
							validator.resetForm();
							form.get(0).reset();

							//RELOAD DATATABLES	
							//html5 export data buttons
							exportdatabutton();				
							jQuery('.dataTable').dataTable(custom_opt).fnDraw();
							jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
							jQuery(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							jQuery("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if(jQuery(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if(jQuery(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();
							//RELOAD DATATABLES			
							//Reset hidden feilds
							jQuery('#tmp_flash_creative').val('');
							jQuery('#tmp_flash_creative_content_type').val('');
							jQuery('#tmp_flash_creative_url').val('');

							jQuery('#tmp_backup_flash_creative').val('');
							jQuery('#tmp_backup_flash_creative_content_type').val('');
							jQuery('#tmp_backup_flash_creative_url').val('');
							
							//Switch modal box
							$('#modal_flash_creative_edit').one('hidden.bs.modal', function (e) {
								jQuery('#modal_flash_creative_edit_success').modal('show');
							}).modal('hide');
							
						}
						else
						{
							var validator = jQuery( "#flash_creative_edit_form" ).validate();
							validator.showErrors(data.msg);
							$(this).modal('hide');
						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});


	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when swf remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_edit" ).click(function(evt){
			var form = jQuery("#flash_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#flash_creative_edit'));
			
			jQuery('.fileupload').removeClass('fileupload-exists');
			jQuery('.fileupload').addClass('fileupload-new');
			jQuery('#flash_creative_edit').val('');
			jQuery('#preview_image').html('');
			
			if(jQuery('#tmp_flash_creative').val() !='')
			{
				var tmp_flash_creative_name=jQuery('#tmp_flash_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_flash_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#flash_creative_edit'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
			jQuery('#tmp_flash_creative').val('');
		});
	});

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when backup remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#backup_creative_remove_edit" ).click(function(evt){
			var form = jQuery("#flash_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#backup_creative_edit'));
			
			jQuery('.fileupload').removeClass('fileupload-exists');
			jQuery('.fileupload').addClass('fileupload-new');
			jQuery('#backup_creative').val('');
			jQuery('#preview_image').html('');
			
			if(jQuery('#tmp_backup_flash_creative').val() !='')
			{
				var tmp_flash_creative_name=jQuery('#tmp_backup_flash_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_flash_creative_name, api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
					//Validate the particular feild
					form.validate().element(jQuery('#backup_creative_edit'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_backup_flash_creative').val() 
		});
	});
	


	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('.fileupload').removeClass('fileupload-exists');
		jQuery('.fileupload').addClass('fileupload-new');
		jQuery('#backup_creative').val('');
		jQuery('#preview_image').html('');
		//Validate the particular feild
		var form = jQuery( "#flash_creative_edit_form" );
		form.validate().element(jQuery('#backup_creative_Edit'));
		
		if(jQuery('#tmp_backup_flash_creative').val() !='')
		{
			var tmp_web_creative_name=jQuery('#tmp_backup_flash_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_web_creative_name, api_key:api_key},
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_backup_flash_creative').val('');
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Retore to old creative
	 * */

	jQuery(function(){
		jQuery( "#restore_backup" ).click(function(evt){

			evt.preventDefault();
			if(jQuery('#old_backup_creative').val() !='')
			{
				jQuery( "#flash_creative_edit_form" ).validate().element(jQuery('#backup_creative_edit'));
					
				var old_backup_creative=jQuery('#old_backup_creative').val();
				var old_backup_creative_content_type=jQuery('#old_backup_creative_content_type').val();
				var old_backup_creative_url=jQuery('#old_backup_creative_url').val();
				
				jQuery( "#backup_image" ).removeClass( "error" ).addClass( "success" );
				jQuery( "#flash_backup_creative_edit_element" ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
				
				jQuery('#tmp_backup_flash_creative').val(old_backup_creative);
				jQuery('#tmp_backup_flash_creative_content_type').val(old_backup_creative_content_type);
				jQuery('#tmp_backup_flash_creative_url').val(old_backup_creative_url);

				
				jQuery('#backup_preview').html("<img src='"+old_backup_creative_url+"'/>");

			}
			
		});
	});
	
	/* name: 		
	 * @param:		null
	 * 
	 * Retore to old creative
	 * */

	jQuery(function(){
		jQuery( "#restore_flash" ).click(function(evt){

			evt.preventDefault();
			if(jQuery('#old_flash_creative').val() !='')
			{
				jQuery( "#flash_creative_edit_form" ).validate().element(jQuery('#flash_creative_edit'));
					
				var old_creative=jQuery('#old_flash_creative').val();
				var old_creative_content_type=jQuery('#old_flash_creative_content_type').val();
				var old_creative_url=jQuery('#old_flash_creative_url').val();

				jQuery( "#flashcreative" ).removeClass( "error" ).addClass( "success" );
				jQuery( "#flash_creative_edit_element" ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
				
				jQuery('#tmp_flash_creative').val(old_creative);
				jQuery('#tmp_flash_creative_content_type').val(old_creative_content_type);
				jQuery('#tmp_flash_creative_url').val(old_creative_url);

				
				jQuery('#flash_preview').html(old_creative);

			}
			
		});
	});
