//When form ready
jQuery(document).ready(function ()
{
	 //REINITIATE VALIDATE CLASS FOR MODAL BOX
	if($('.form-validate').length > 0)
	{
		$('.form-validate').each(function(){
		var id = $(this).attr('id');
			$("#"+id).validate({
				errorElement:'span',
				errorClass: 'help-block error',
				errorPlacement:function(error, element){
				element.parents('.controls').append(error);
				},
				highlight: function(label) {
				$(label).closest('.control-group').removeClass('error success').addClass('error');
				},
				success: function(label) {
				label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
				}
			});
		});
	}
	//REINITIATE CHECKBOX CLASS FOR MODAL BOX
	if($(".icheck-me").length > 0)
	{
		$(".icheck-me").each(function(){
			var $el = $(this);
			var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
			color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

			var opt = {
				checkboxClass: 'icheckbox' + skin + color,
				radioClass: 'iradio' + skin + color,
				increaseArea: "10%"
			}

			$el.iCheck(opt);
		});
	}
	
	html5_delivery_type(delivery_type);
		
});
	
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_video_size_mb = '2MB';
	var iab_video_max_size	='2097152';
	var iab_video_file_type	=['video/ogg','video/mp4','video/webm'];

	//Define default

	var input = document.getElementById("video_html5_creative"),formdata = false;
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleVideoFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_html5_creative_edit_form" );

	
	/* name: inline_delivery_type
	 * @param:null
	 * 
	 * switch between HTTP and RTMP.
	 * */
	
	function html5_delivery_type(val)
	{
		if(val=='progressive')
		{
			jQuery('#html5_http_block').show();
			jQuery('#html5_third_party_block').hide();
		}
		else if(val=='vast')
		{
			jQuery('#html5_http_block').hide();
			jQuery('#html5_third_party_block').show();
			jQuery('#upload_vast').hide();
			reset_video_upload();
		}
		else
		{
			jQuery('#html5_http_block').show();
			jQuery('#html5_third_party_block').hide();
		}
	}
		
	/* name: handleVideoFileSelect
	 * @param:null
	 * 
	 * Description:Handle video creative select, validate and process through ajax.
	 * */

	function handleVideoFileSelect(evt)
 	{		
		var form 			= 	jQuery( "#video_html5_creative_edit_form" );

		var isvalid_creative=	true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;
			
			//Check weather it's image
			if ((file = this.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_video_html5_creative').val()!='')
				{
					var tmp_video_html5_creative_name	=	jQuery('#tmp_video_html5_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_video_html5_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#video_html5_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_video_html5_creative').val('');//empty temporary feild value		
			
				if (!!file.type.match(/video.*/))
				{
					//Fetch creative attribute
					var creative_size=file.size;
					var creative_type=file.type;						
					
					//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_video_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"video_html5_creative": "Creative file format should be flv or mp4."});
							isvalid_creative=false;
							jQuery('#video_html5_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_html5_creative').val('');
							jQuery('#tmp_video_html5_creative').val('');
							jQuery('#tmp_video_html5').val('');
						}
						//IAB size check
						else if (creative_size > iab_video_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"video_html5_creative": "Creative file size should not exceeds "+iab_video_size_mb});
							isvalid_creative=false;
							jQuery('#video_html5_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_html5_creative').val('');
							jQuery('#tmp_video_html5_creative').val('');
							jQuery('#tmp_video_html5').val('');
						}
						
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							$("#edit_video_html5_creative").val('please wait').attr('disabled',true);
							//Validate the particular feild
							form.validate().element(jQuery('#video_html5_creative'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_video_to_tmp_location/format/json',
									type: "POST",
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											$("#edit_video_html5_creative").val('Submit').removeAttr('disabled');
											jQuery('#tmp_video_html5').val(data.response.file_name);
											jQuery('#tmp_video_html5_creative').val(data.response.file_name);
											jQuery('#tmp_video_html5_creative_content_type').val(data.response.file_type);
											jQuery('#tmp_video_html5_creative_url').val(data.response.full_path);
											jQuery('#tmp_video_html5_creative_raw_name').val(data.response.raw_name);
											jQuery('#tmp_video_html5_creative_file_ext').val(data.response.file_ext);
										}
										else
										{	
											//window.location.replace(data.redirect);
											jQuery('#tmp_video_html5_creative').val('');
											var validator = form.validate();
											validator.showErrors(data.msg);
										}
									}
								});
							}
						}
				}
				else
				{
					var validator = form.validate();
					jQuery('#tmp_video_html5').val('');
					jQuery('#video_html5_creative').val('');
					jQuery('#video_html5_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"video_html5_creative": "Creative must be an video "});
				}
				
			}	
		}
	}	
	
	/* name:reset_video_upload
	 * @param:
	 * 
	 * Make video upload refresh when change delivery type is changed
	 * */
	 
	function reset_video_upload()
	{
		jQuery('#video_html5_element.fileupload').removeClass('fileupload-exists');
		jQuery('#video_html5_element.fileupload').addClass('fileupload-new');
		jQuery('#video_html5_creative').val('');
		jQuery('#video_html5_creative .fileupload-preview').html('');
		//Validate the particular field
		var form = jQuery( "#video_html5_creative_edit_form" );
		form.validate().element(jQuery('#video_html5_creative'));
		
		if(jQuery('#tmp_video_html5_creative').val() !='')
		{
			var tmp_video_html5_creative_name=jQuery('#tmp_video_html5_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_html5_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_video_html5_creative').val('');
		jQuery('#video_html5_creative').val('');
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form 		= 	jQuery("#video_html5_creative_edit_form");
		var validator 	= 	form.validate();
		jQuery( "#edit_video_html5_creative" ).unbind().bind('click',function(evt){
			
			if(form.valid()==true)
			{
				if((jQuery('#html5_delivery_method:checked').val()=='progressive' && (jQuery('#tmp_video_html5_creative').val()!='' || jQuery('#tmp_video_html5').val()!='')) || (jQuery('#html5_delivery_method:checked').val()=='vast' && jQuery('#tmp_video_html5_creative').val()==''))
				{					
					//jQuery('#edit_video_html5_creative').unbind('click');
					evt.preventDefault();

					jQuery.ajax({
						type:'POST',
						async:false,
						url: form.attr("action"),
						data:form.serialize(),
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							if(data.response == 'ok')
							{
								jQuery('#edit_video_html5_creative').unbind('click');
								validator.resetForm();
								form.get(0).reset();
									
								
								//Reset hidden feilds
								jQuery('#tmp_video_html5').val('');
								jQuery('#tmp_video_html5_creative').val('');
								jQuery('#tmp_video_html5_creative_content_type').val('');
								jQuery('#tmp_video_html5_creative_url').val('');
								jQuery('#tmp_video_html5_creative_size').val('');
								
								//Switch modal box
								jQuery('#modal_video_html5_creative_edit').modal('hide');
								jQuery('#modal_video_html5_creative_edit_success').modal('show');
								jQuery( "#edit_video_html5_creative" ).bind('click')
							}
							else
							{
								jQuery('.alert-error').show();
								jQuery('#error_msg').html(data.msg);
								//var validator = form.validate();
								validator.showErrors(data.msg);
							}
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Oh no! A problem with the AJAX request!');
						}
					}); 
				
				}
				else
				{
					validator.showErrors({"video_html5_creative": "Video is not uploaded correctly, Please try again.."});
				}
			
			}
		});
	});
	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/admin/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id,api_key:api_key},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when creative is uplaoded and changed as a Streaming creative(RTMP Banner)
	 * */

	jQuery( "#html5_delivery_vast" ).click(function(evt){
		reset_video_upload();
	});
	
	/* name: 		
	* @param:		null
	* 
	* Retorr to old creative
	* */

	function restore(creative_type)
 	{
		if(jQuery('#old_'+creative_type+'_creative_url').val() !='')
		{
			jQuery( "#video_html5_creative_edit_form" ).validate().element(jQuery('#'+creative_type+'_creative'));
					
			var old_creative				=	jQuery('#old_'+creative_type+'_creative').val();
			var old_creative_content_type	=	jQuery('#old_'+creative_type+'_creative_content_type').val();
			var old_creative_url			=	jQuery('#old_'+creative_type+'_creative_url').val();

			jQuery( '#'+creative_type+'_group' ).removeClass( "error" ).addClass( "success" );
			jQuery( '#'+creative_type+'_element' ).removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			
			if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
			{
				var tmp_creative_name	=	jQuery('#tmp_'+creative_type+'_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
					}, 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
					
			}
			
			jQuery('#tmp_'+creative_type).val(old_creative);
			jQuery('#tmp_'+creative_type+'_creative').val('');
			jQuery('#tmp_'+creative_type+'_creative_content_type').val('');
			jQuery('#tmp_'+creative_type+'_creative_url').val('');

			jQuery('#preview_'+creative_type).html(old_creative);
		}
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#video_html5_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#video_html5_creative'));
			
			jQuery('#video_html5_element.fileupload').removeClass('fileupload-exists');
			jQuery('#video_html5_element.fileupload').addClass('fileupload-new');
			jQuery('#video_html5_creative').val('');
			jQuery('#video_html5_element .fileupload-preview').html('');
			
			if(jQuery('#tmp_video_html5_creative').val() !='')
			{
				var tmp_video_html5_creative_name=jQuery('#tmp_video_html5_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_video_html5_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#video_html5_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_video_html5_creative').val('');//empty temporary feild value
			
		});
	});
	/* name: vast_upload
	 * @param:null
	 * 
	 * switch between Local and URL.
	 * */
	
	function vast_upload()
	{
		if(jQuery('#is_vast_upload').is(':checked'))
		{
			jQuery('#vast_tag_url').attr('disabled','disabled');
			jQuery('#upload_vast').show();
		}
		else
		{
			jQuery('#vast_tag_url').removeAttr('disabled');
			jQuery('#upload_vast').hide();
		}
	}
		
	/* name: xml_upload
	 * @param:null
	 * 
	 * switch between Local and URL.
	 * */
	
	function xml_upload(target)
	{
		var form = jQuery("#video_html5_creative_edit_form");
		var isvalid_creative=false;
		var file;
		if(file	= target.files[0])
		{
			var type=	file.type;
			var size=	file.size;
			
			if(type=='text/xml')
			{
				var isvalid_creative=true;
				
				if (formdata)
				{
					formdata.append("creative", file);
					formdata.append("api_key", api_key);
				}

				//If everything goes right move to a tmp location
				if (isvalid_creative==true)
				{
					$("#edit_video_html5_creative").val('please wait').attr('disabled',true);
					//Validate the particular feild
					form.validate().element(jQuery('#vast_tag_upload'));
					if (formdata)
					{
						jQuery.ajax({
							//site_url is defined in header.php (advertiser layout) file,
							url: site_url+'/api/v1/video_creative/creative_xml_to_tmp_location/format/json',
							type: "POST",
							data: formdata,
							processData: false,
							contentType: false,
							success:function(data, textStatus, jqXHR)
							{
								console.log(data.response);
								if(data.response != 'error')
								{
									$("#edit_video_html5_creative").val('Submit').removeAttr('disabled');
									jQuery('#tmp_vast_tag_upload_creative').val(data.response.file_name);
									jQuery('#tmp_vast_tag_upload_creative_content_type').val(data.response.file_type);
									jQuery('#tmp_vast_tag_upload_creative_url').val(data.response.full_path);
								}
								else
								{											
									//window.location.replace(data.redirect);
									jQuery('#tmp_vast_tag_upload_creative').val('');
									var validator = form.validate();
									validator.showErrors(data.msg);
								}
							}
						});
					}
				}
			}
			else
			{
				var validator = form.validate();
				jQuery('#vast_tag_upload').val('');
				jQuery('#vast_tag_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
				validator.showErrors({"vast_tag_upload": "Upload must be an xml file"});
			}
		}		
	}

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#vast_tag_remove" ).click(function(evt){
			var form = jQuery("#video_html5_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#vast_tag_upload'));
			
			jQuery('#vast_tag_upload_element.fileupload').removeClass('fileupload-exists');
			jQuery('#vast_tag_upload_element.fileupload').addClass('fileupload-new');
			jQuery('#vast_tag_upload').val('');
			jQuery('#preview_vast_tag_upload').html('');
			
			if(jQuery('#tmp_vast_tag_upload_creative').val() !='')
			{
				var tmp_vast_creative_name=jQuery('#tmp_vast_tag_upload_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_vast_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#inline_companion_file'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_vast_tag_upload_creative').val('');//empty temporary feild value
			
		});
	});

	/* name: show_skippable
	* @param:null
	* 
	* switch between show_skippable.
	* */
	
	function show_skippable(val)
	{
		if(val=='yes')
		{
			jQuery('#skip_ad').show();
		}
		else
		{
			jQuery('#skip_ad').hide();
		}
	}
