
	//When form ready
	jQuery(document).ready(function ()
	{
		var account_id = jQuery('#web_creative_anchor').attr('data-account-id');
		var campaign_id = jQuery('#web_creative_anchor').attr('data-campaign-id');
		
		//Store it to a hidden feild
		jQuery('#_wsit_account_id').val(account_id);
		jQuery('#_wsit_campaign_id').val(campaign_id);
		
		jQuery("#wsit_campaign").prop("disabled", true);	
		
		if(campaign_id)
		{
			jQuery('#wsit_adv_group').hide();
			jQuery('#wsit_campaign_group').hide();
		}
		
		jQuery('#wsit_adv_name').change(function() {
			
			jQuery("#wsit_campaign").prop("disabled", false);	

			jQuery.ajax({
				type:'GET',
				async:false,
				dataType:'json',
				url: site_url+'/api/v1/creative/fetch_campaigns/format/json',
				data: {account_id:this.value,campaign_type:'WEB',api_key:api_key},
				success: function(data, textStatus, jqXHR){
					
					/*if(data != 'error')
					{						
						var option	=	"<select name='campaign' id='wsit_campaign' class='form-control fmctrl valid' data-rule-required='true' data-nosearch='true'>"+
										"<option value=''>Choose Campaign</option>";
						jQuery.each(data, function(key, value) {							
							if(value.campaignid != '')
							{
								option +="<option value='"+value.campaignid+"' >"+value.campaignname+"</option>";
							}					 
						});
						option +=	'</select>'+
									'<span class="hidden-480">'+
									'&nbsp;&nbsp;&nbsp;<a  class="" rel="popover" data-trigger="hover" title="Campaign" data-content="Select any one of the campaign"><i class="glyphicon-circle_exclamation_mark"></i></a>'+
									'</span>';
					}
					else
					{					
						var option=	"<select name='campaign' id='wsit_campaign' class='form-control fmctrl valid' data-rule-required='true' data-nosearch='true'>";
						option +=	"<option value='' >No campaign found</option>";
						option +=	'</select>'+
									'<span class="hidden-480">'+
									'&nbsp;&nbsp;&nbsp;<a  class="" rel="popover" data-trigger="hover" title="Campaign" data-content="Select any one of the campaign"><i class="glyphicon-circle_exclamation_mark"></i></a>'+
									'</span>';
					}
					
					jQuery('#wsit_campaign_list').html(option);
					jQuery('#wsit_campaign').select();
					jQuery('[rel="popover"]').popover();*/
					
					if(data != 'error')
					{						
						var campaign_list='<option value="">Choose Campaigns</option>';
						jQuery.each(data, function(key, value) {	     						
							if(value.campaignid != '')
							{
								campaign_list+=	"<option value='"+value.campaignid+"' >"+value.campaignname+"</option>";
							}					 
						});
						
						$('#wsit_campaign').html(campaign_list);		
						
					}
					else 
					{
						$('#wsit_campaign').html('<option value="">Choose Campaigns</option>');		
						
					}				
				}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
				}
				 
			});
	 
		});		
		
		jQuery('#left_right').show();
		jQuery('#background').hide();
	});
	
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default

	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#siteskin_creative_form" );

	/*
	 * name: show_type
	 * Description: show image or text depends on catfish type
	 * 
	 * */
	 
	function site_skin_type(val)
	{
		if(val=='LR')
		{
			jQuery('#left_right').show();
			jQuery('#background').hide();
		}
		else if(val=='BGD')
		{
			jQuery('#left_right').hide();
			jQuery('#background').show();			 
		}
		else
		{
			jQuery('#left_right').show();
			jQuery('#background').hide();
		}		 
	}
	
	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select, validate and process through ajax.
	 * */

	function handleFileSelect(target,type)
 	{
		var input_name 		= 	type+"_creative";
		if(type=='siteskin_left' || type=='siteskin_right')
		{
			var iab_max_width	= 	'120'; 
			var iab_max_height	= 	'600';
		}
		else
		{
			var iab_max_width	= 	'1920'; 
			var iab_max_height	= 	'1200';
		}

		var form = jQuery( "#siteskin_creative_form" );

		var isvalid_creative=true;		//form check list		
		
		//var i = 0, len = this.files.length, img, reader, file;
		//for ( ; i < len; i++ )
		//{
			//file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = target.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_'+type+'_creative').val()!='')
				{
					var tmp_creative_name	=	jQuery('#tmp_'+type+'_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#'+type+'_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
				jQuery('#tmp_'+type+'_creative').val('');//empty temporary feild value
		
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
								//IAB type check
								var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
								if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
								{
									var validator = form.validate();
									var errorMessage = "Creative file format should be jpeg, png, jpg or gif";
							
									var obj = new Object();
									obj[input_name] = errorMessage;
									validator.showErrors(obj);
									
									isvalid_creative=false;
									$('#'+type+'_creative_element').removeClass('fileupload-exists');
									$('#'+type+'_creative_element').addClass('fileupload-new');
							
									jQuery('#'+type+'_creative').val('');
									jQuery('#tmp_'+type+'_creative').val('');
									
								}
								
								//IAB size check
								if (creative_size > iab_max_size )
								{
									var validator = form.validate();
									var errorMessage = "Creative file size should not exceeds "+iab_size_kb;
							
									var obj = new Object();
									obj[input_name] = errorMessage;
									
									validator.showErrors(obj);
									isvalid_creative=false;
									$('#'+type+'_creative_element').removeClass('fileupload-exists');
									$('#'+type+'_creative_element').addClass('fileupload-new');
							
									jQuery('#'+type+'_creative').val('');
									jQuery('#tmp_'+type+'_creative').val('');									
								}

								//IAB width check
								else if (creative_width != iab_max_width || creative_height != iab_max_height)
								{
									var validator = form.validate();
									var errorMessage = "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions";
							
									var obj = new Object();
									obj[input_name] = errorMessage;
									
									validator.showErrors(obj);
									isvalid_creative=false;
									jQuery('#'+type+'_creative_element').removeClass('fileupload-exists');
									jQuery('#'+type+'_creative_element').addClass('fileupload-new');
							
									jQuery('#'+type+'_creative').val('');
									jQuery('#tmp_'+type+'_creative').val('');
									
								}

								//IAB height check
								/*if (creative_height != iab_max_height )
								{
									var validator = form.validate();
									validator.showErrors({"web_creative": "creative height is not upto Iab standard."});
									isvalid_creative=false;
									jQuery('#creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
									jQuery('#web_creative').val('');
									jQuery('#tmp_web_creative').val('');
								}*/

							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#'+type+'_creative'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/web_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_'+type+'_creative').val(data.response.file_name);
												jQuery('#tmp_'+type+'_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_'+type+'_creative_url').val(data.response.full_path);	
											}
											else
											{												
												//window.location.replace(data.redirect);
												jQuery('#tmp_'+type+'_creative').val('');
												var validator = form.validate();
												validator.showErrors({input_name: data.msg});
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);	
				}
				else
				{
					var validator = form.validate();
					jQuery('#'+type+'_creative').val('');
					jQuery('#'+type+'_creative_element').removeClass('fileupload-exists');
					jQuery('#'+type+'_creative_element').addClass('fileupload-new');
					validator.showErrors({input_name: "Creative must be an image "});
				}
			}	
		//}
		
	}
	
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload(val)
	{	
		if(val=='LR')
		{
			jQuery('#siteskin_left_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
			jQuery('#siteskin_right_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
			var type	=	'siteskin_left';
			jQuery('#'+type+'_creative').val('');
			jQuery('#preview_'+type).html('');
			
			//Validate the particular feild
			var form = jQuery( "#siteskin_creative_form" );
			form.validate().element(jQuery('#'+type+'_creative'));
			
			if(jQuery('#tmp_'+type+'_creative').val() !='')
			{
				
				var tmp_creative_name=jQuery('#tmp_'+type+'_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
					
			}
			jQuery('#tmp_'+type+'_creative').val('');
			
			var type	=	'siteskin_right';
		}
		else
		{
			jQuery('#siteskin_background_creative_element').removeClass('fileupload-exists').addClass('fileupload-new');
			
			var type	=	'siteskin_background';
			
		}		
		
		jQuery('#'+type+'_creative').val('');
		jQuery('#preview_'+type).html('');
		//Validate the particular feild
		var form = jQuery( "#siteskin_creative_form" );
		form.validate().element(jQuery('#'+type+'_creative'));
			
		if(jQuery('#tmp_'+type+'_creative').val() !='')
		{
			var tmp_creative_name=jQuery('#tmp_'+type+'_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
				console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_'+type+'_creative').val('');
	}

	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form = jQuery("#siteskin_creative_form");
		var validator = form.validate();
		/*jQuery( "#siteskin_creative" ).unbind().bind('click',function(evt){*/
		jQuery(document).on('click','#siteskin_creative',function(evt){  

			if(form.valid()==true)
			{
				evt.preventDefault();

				jQuery.ajax({
					type:'POST',
					url: form.attr("action"),
					async:false,
					data:form.serialize(),
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
			
						if(data.response == 'ok')
						{
							jQuery( "#siteskin_creative" ).unbind('click');
							
							/*if(jQuery('#_wsit_campaign_id').val() !='')
							{
								refresh_existing_creative(jQuery('#_wsit_campaign_id').val());
								$('#add_creative_msg').attr("data-notify-message","Creative added sucessfully");
								$('#add_creative_msg').trigger('click');
							}

							//Switch modal box
							$('#modal_siteskin_creative_add').one('hidden.bs.modal', function (e) {
								if(jQuery('#_wsit_campaign_id').val() =='')
								{
									jQuery('#modal_siteskin_creative_success').modal('show');
								}								
							}).modal('hide');*/
							
							var validator = jQuery("#siteskin_creative_form").validate();	
							validator.resetForm();
							form.get(0).reset();
							//Reset Siteskin 1 creative hidden feilds
							jQuery('#tmp_siteskin_left_creative').val('');
							jQuery('#tmp_siteskin_left_creative_content_type').val('');
							jQuery('#tmp_siteskin_left_creative_url').val('');
							
							//Reset Siteskin 2 creative hidden feilds
							jQuery('#tmp_siteskin_right_creative').val('');
							jQuery('#tmp_siteskin_right_creative_content_type').val('');
							jQuery('#tmp_siteskin_right_creative_url').val('');
							
							//Reset Siteskin background creative hidden feilds
							jQuery('#tmp_siteskin_background_creative').val('');
							jQuery('#tmp_siteskin_background_creative_content_type').val('');
							jQuery('#tmp_siteskin_background_creative_url').val('');

							$('#add_creative_msg').attr("data-notify-message","Creative created sucessfully!");
							$('#add_creative_msg').trigger('click');							
							setTimeout(function(){window.location.href = data.redirect; }, 2000);
							
						}
						else
						{
							validator.showErrors(data.msg);
							$(this).modal('hide');

						}
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					alert('Oh no! A problem with the AJAX request!');
					}
				}); 
			
			}
		});
	});

	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			async:false,
			url : site_url+"/admin/campaigns/fetch_campaign_creative", // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the base creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery(".remove" ).click(function(evt){
		
			var creative_type	=	jQuery(this).attr('id');
			
			var form = jQuery("#siteskin_creative_form");
			form.validate().element(jQuery('#'+creative_type+'_creative'));
			
			jQuery('#'+creative_type+'_creative_element.fileupload').removeClass('fileupload-exists').addClass('fileupload-new');
			jQuery('#'+creative_type+'_creative').val('');
			jQuery('#preview_'+creative_type).html('');
			
			if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
			{
				var tmp_base_creative_name=jQuery('#tmp_'+creative_type+'_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/web_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_base_creative_name, api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#'+creative_type+'_creative'));
					}, 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}	
			jQuery('#tmp_'+creative_type+'_creative').val('');		
		});
	});

