	//When form ready
	jQuery(document).ready(function ()
	{
			
		var account_id = jQuery('#web_creative_anchor').attr('data-account-id');
		var campaign_id = jQuery('#web_creative_anchor').attr('data-campaign-id');
		
		//Store it to a hidden feild
		jQuery('#_vsm_account_id').val(account_id);
		jQuery('#_vsm_campaign_id').val(campaign_id);
		
		jQuery("#vsm_campaign").prop("disabled", true);	
		
		
		if(campaign_id)
		{
			jQuery('#vsm_adv_group').hide();
			jQuery('#vsm_campaign_group').hide();
			jQuery('#vsm_campaign').val(campaign_id);
			
		}
		
		
		jQuery('#vsm_adv_name').change(function() {
			
			jQuery("#vsm_campaign").prop("disabled", false);	

			jQuery.ajax({
				type:'GET',
				async:false,
				dataType:'json',
				url: site_url+'/api/v1/creative/fetch_campaigns/format/json',
				data: {account_id:this.value,campaign_type:'WEB',api_key:api_key},
				success: function(data, textStatus, jqXHR){
					
					if(data != 'error')
					{						
						var option	=	"<select name='campaign' id='vsm_campaign' class='select2-me input-xlarge' data-rule-required='true' data-nosearch='true'>"+
										"<option value=''>Choose Campaign</option>";
						jQuery.each(data, function(key, value) {							
							if(value.campaignid != '')
							{
								option +="<option value='"+value.campaignid+"' >"+value.campaignname+"</option>";
							}					 
						});
						option +=	"</select>"+
									'<span class="hidden-480">'+
									'&nbsp;&nbsp;&nbsp;<a  class="" rel="popover" data-trigger="hover" title="Campaign" data-content="Select any one of the campaign"><i class="glyphicon-circle_exclamation_mark"></i></a>'+
									'</span>';	
					}
					else
					{					
						var option="<select name='campaign' id='vsm_campaign' class='select2-me input-xlarge' data-rule-required='true' data-nosearch='true'>";
						option +="<option value='' >No campaign found</option>";
						option +=	"</select>"+
									'<span class="hidden-480">'+
									'&nbsp;&nbsp;&nbsp;<a  class="" rel="popover" data-trigger="hover" title="Campaign" data-content="Select any one of the campaign"><i class="glyphicon-circle_exclamation_mark"></i></a>'+
									'</span>';	
					}
					
					jQuery('#vsm_campaign_list').html(option);
					jQuery('#vsm_campaign').select2();
					jQuery('[rel="popover"]').popover();
				}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
				}
				 
			});
	 
		});
		
		
		
		 //REINITIATE VALIDATE CLASS FOR MODAL BOX
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
				var id = $(this).attr('id');
				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
						element.parents('.controls').append(error);
					},
					highlight: function(label) {
						$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
						label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}
		//REINITIATE CHECKBOX CLASS FOR MODAL BOX
		if($(".icheck-me").length > 0)
		{
			$(".icheck-me").each(function(){
				var $el = $(this);
				var skin = ($el.attr('data-skin') !== undefined) ? "_"+$el.attr('data-skin') : "",
				color = ($el.attr('data-color') !== undefined) ? "-"+$el.attr('data-color') : "";

				var opt = {
					checkboxClass: 'icheckbox' + skin + color,
					radioClass: 'iradio' + skin + color,
					increaseArea: "10%"
				}

				$el.iCheck(opt);
			});
		}

		//Hide external web creative feild
		jQuery('#rtmp_block').hide();
		
			
	});
		
	//Set IAB creative standard
	var isvalid_companion=false;
	
	//Specify in bytes to avoid code complexity
	var iab_video_size_mb = '2MB';
	var iab_video_max_size	='2097152';
	var iab_video_file_type	=['video/x-flv','video/mp4','video/flv'];

	//Define default

	var input = document.getElementById("video_small_creative"),formdata = false;
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleVideoFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_small_creative_form" );
	
	
	
	/* name: empty_companion
	 * @param:null
	 * 
	 * if we change campaign empty companion information
	 * */
	function empty_companion()
	{
		
		//jQuery('#select_companion').hide();
		//jQuery('#upload_image').hide();
		
		//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
		if(jQuery('#tmp_small_image_creative').val()!='')
		{
			var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_small_image_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
					console.log(data.response);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				//Validate the particular feild
				form.validate().element(jQuery('#small_image_file'));
				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
		}
		jQuery('#tmp_small_image_creative').val('');//empty temporary feild value
	}
	/* name: check_companion
	 * @param:null
	 * 
	 * Description:Check companion size with web creatives,if match size then choose companion banner from web creatives and process through ajax.
	 * */
	
	function check_companion_size(csize)
	{	
		var campaign=	jQuery('#campaign').val();
		var size 	= 	csize.split("x");
		var width 	= 	size[0];
		var height	=	size[1];
		if(campaign!='')
		{
			if(width!='' && height!='')
			{
				jQuery.ajax({
						type: "POST",
						url: site_url+'/api/v1/video_creative/check_companion_size/format/json',
						data: {campaign_id:campaign,companion_width:width,companion_height:height,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								isvalid_companion=false;
								jQuery('#select_companion').show();
								jQuery('#upload_image').hide();
								filter_companions(campaign,width,height);
							}
							else
							{
								isvalid_companion=true;
								jQuery('#select_companion').hide();
								jQuery('#upload_image').show();
							}
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
				}); 
			}
			else
			{
				isvalid_companion=false;
				jQuery('#select_companion').hide();
				jQuery('#upload_image').hide();
			}
		}
		
		else
		{
			var form 		= jQuery( "#video_small_creative_form" );
			var validator 	= form.validate();
			validator.showErrors({"campaign": "Please choose campaign for upload/select companion"});
			jQuery('#inline_companion_size').val('');
			jQuery('#select_companion').hide();
			jQuery('#upload_image').hide();
		}
	}
	
	

	/* name: handleVideoFileSelect
	 * @param:null
	 * 
	 * Description:Handle video creative select, validate and process through ajax.
	 * */

	function handleVideoFileSelect(evt)
 	{		
		var form 			= 	jQuery( "#video_small_creative_form" );

		var isvalid_creative=	true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;
			
			//Check weather it's image
			if ((file = this.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_video_small_creative').val()!='')
				{
					var tmp_video_small_creative_name	=	jQuery('#tmp_video_small_creative').val();
					jQuery.ajax({
						type:'POST',
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_video_small_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#video_small_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_video_small_creative').val('');//empty temporary feild value
				console.log(file.type);
				console.log(!!file.type.match(/video.*/));
				if (!!file.type.match(/video.*/))
				{
					//Fetch creative attribute
					var creative_size=file.size;
					var creative_type=file.type;						
					//VALIDATE THE SELECTED IMAGE
					
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_video_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"video_small_creative": "Creative file format should be flv or mp4."});
							isvalid_creative=false;
							jQuery('#video_small_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_small_creative').val('');
							jQuery('#tmp_video_small_creative').val('');
						}
						//IAB size check
						else if (creative_size > iab_video_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"video_small_creative": "Creative file size should not exceeds "+iab_video_size_mb});
							isvalid_creative=false;
							jQuery('#video_small_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_small_creative').val('');
							jQuery('#tmp_video_small_creative').val('');
						}						
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							$("#add_video_small_creative").val('please wait').attr('disabled',true);
							//Validate the particular feild
							form.validate().element(jQuery('#video_small_creative'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_video_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											$("#add_video_small_creative").val('Submit').removeAttr('disabled');
											jQuery('#tmp_video_small_creative').val(data.response.file_name);
											jQuery('#tmp_video_small_creative_content_type').val(data.response.file_type);
											jQuery('#tmp_video_small_creative_url').val(data.response.full_path);
											jQuery('#tmp_video_small_creative_raw_name').val(data.response.raw_name);
											jQuery('#tmp_video_small_creative_file_ext').val(data.response.file_ext);
										}
										else
										{											
											//window.location.replace(data.redirect);
											jQuery('#tmp_video_small_creative').val('');
											var validator = form.validate();
											validator.showErrors(data.msg);
										}
									}
								});
							}
						}
				}
				else
				{
					var validator = form.validate();
					jQuery('#video_small_creative').val('');
					jQuery('#video_small_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"video_small_creative": "Creative must be video "});
				}
				
			}	
		}
	}	
	
	/* name:reset_video_upload
	 * @param:
	 * 
	 * Make video upload refresh when change delivery type is changed
	 * */
	 
	function reset_video_upload()
	{
		jQuery('#video_small_element.fileupload').removeClass('fileupload-exists');
		jQuery('#video_small_element.fileupload').addClass('fileupload-new');
		jQuery('#video_small_creative').val('');
		jQuery('#video_small_creative .fileupload-preview').html('');
		
		//jQuery('#preview_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_small_creative_form" );
		form.validate().element(jQuery('#video_small_creative'));
		
		if(jQuery('#tmp_video_small_creative').val() !='')
		{
			var tmp_video_small_creative_name=jQuery('#tmp_video_small_creative').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_small_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_video_small_creative').val('');
		jQuery('#video_small_creative').val('');
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * Name:M.sudhakar
	 * Modified Date:09/03/2015
	 * issue:Video File is not changed 
	 * Modified :Fixing name conflict issue in javascript code
	 * */
	jQuery(function(){
		var form = jQuery("#video_small_creative_form");
		var validator = form.validate();
		
		jQuery( "#add_video_small_creative" ).unbind().bind('click',function(evt){			
			if(form.valid()==true)
			{
					evt.preventDefault();

						jQuery.ajax({
							type:'POST',
							url: form.attr("action"),
							data:form.serialize(),
							success: function(data, textStatus, jqXHR){
								
								if(data.response == 'ok')
								{
									jQuery("#add_video_small_creative" ).unbind('click');
									
									if(jQuery('#_vsm_campaign_id').val() !='')
									{
										refresh_existing_creative(jQuery('#_vsm_campaign_id').val());
										$('#add_creative_msg').attr("data-notify-message","Small video creative added sucessfully");
										$('#add_creative_msg').trigger('click');	
									}
									
									//Switch modal box
									$('#modal_video_small_creative_add').one('hidden.bs.modal', function (e) {
										jQuery('.modal-backdrop').remove();
											
										if(jQuery('#_vsm_campaign_id').val() =='')
										{
											jQuery('#modal_video_small_creative_success').modal('show');
										}
									}).modal('hide');
									
									
									
									form.get(0).reset();
									//Reset hidden feilds
									jQuery('#tmp_video_small_creative').val('');
									jQuery('#tmp_video_small_creative_content_type').val('');
									jQuery('#tmp_video_small_creative_url').val('');
									
									
								}
								else
								{
									jQuery('.alert-error').show();
									jQuery('#error_msg').html(data.msg);
									var validator = form.validate();
									validator.showErrors(data.msg);
								}
							}, 
							// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
							error: function(jqXHR, textStatus, errorThrown){
							//alert('Oh no! A problem with the AJAX request!');
							}
						}); 
					
				
			}
		});
	});

/* this end for send datas in form */

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#video_small_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#video_small_creative'));
			
			jQuery('#video_small_element.fileupload').removeClass('fileupload-exists');
			jQuery('#video_small_element.fileupload').addClass('fileupload-new');
			jQuery('#video_small_creative').val('');
			jQuery('#video_small_element .fileupload-preview').html('');
			
			if(jQuery('#tmp_video_small_creative').val() !='')
			{
				var tmp_video_small_creative_name=jQuery('#tmp_video_small_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_video_small_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#video_small_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
		});
	});
	
	
	
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size	='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];

	//Define default

	var imagefile = document.getElementById("small_image_file"),formdata = false;
	//Bind the event to onchange of the url file
	imagefile.addEventListener("change",handleFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_small_creative_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */
	 
	 

	function handleFileSelect(evt)
 	{
		//var selcted_creative_size=jQuery('#inline_companion_size').val();
		//var creative_size_split = selcted_creative_size.split('x');
		//var iab_max_width= parseInt(creative_size_split[0], 10); 
		//var iab_max_height= parseInt(creative_size_split[1], 10);

		var form = jQuery( "#video_small_creative_form" );

		var isvalid_creative=true;		//form check list

		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_small_image_creative').val()!='')
				{
					var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
					jQuery.ajax({
						type:'POST',
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_small_companion_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#small_image_file'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				
		
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								var validator = form.validate();
								validator.showErrors({"small_image_file": "Creative file format should be jpeg, png, jpg or gif"});
								isvalid_creative=false;
								jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#small_image_file').val('');
								jQuery('#tmp_small_image_creative').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								var validator = form.validate();
								validator.showErrors({"small_image_file": "Creative file size should not exceeds "+iab_size_kb});
								isvalid_creative=false;
								jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#small_image_file').val('');
								jQuery('#tmp_small_image_creative').val('');
							}

							//IAB width check
							//
							/*
							else if (creative_width != iab_max_width || creative_height != iab_max_height)
							{
								var validator = form.validate();
								validator.showErrors({"small_image_file": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
								isvalid_creative=false;
								jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#small_image_file').val('');
								jQuery('#tmp_small_image_creative').val('');
							}

							*/
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#small_image_file'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/video_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_small_image_creative').val(data.response.file_name);
												jQuery('#tmp_small_image_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_small_image_creative_url').val(data.response.full_path);
											}
											else
											{	
												//window.location.replace(data.redirect);
												jQuery('#tmp_small_image_creative').val('');
												var validator = form.validate();
												validator.showErrors(data.msg);
											}
										}
									});
								}
							}
						}
						
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#small_image_file').val('');
					jQuery('#small_image').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"small_image_file": "Creative must be an image "});
				}
			}	
		}
	}
	
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('#small_image.fileupload').removeClass('fileupload-exists');
		jQuery('#small_image.fileupload').addClass('fileupload-new');
		jQuery('#small_image_file').val('');
		jQuery('#preview_image').html('');
		
		//Validate the particular field
		var form = jQuery( "#video_small_creative_form" );
		form.validate().element(jQuery('#small_image_file'));
		
		if(jQuery('#tmp_small_image_creative').val() !='')
		{
			var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
			jQuery.ajax({
				type:'POST',
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_small_image_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_small_image_creative').val('');
		jQuery('#small_image_file').val('');
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_image" ).click(function(evt){
			var form = jQuery("#video_small_creative_form");
			evt.preventDefault();
			form.validate().element(jQuery('#small_image_file'));
			
			jQuery('#small_image.fileupload').removeClass('fileupload-exists');
			jQuery('#small_image.fileupload').addClass('fileupload-new');
			jQuery('#small_image_file').val('');
			jQuery('#preview_image').html('');
		
			if(jQuery('#tmp_small_image_creative').val() !='')
			{
				var tmp_small_image_creative_name=jQuery('#tmp_small_image_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_small_image_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#small_image_file'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			
		});
	});

	
	/* name: 		refresh_existing_creative
	 * @param:		null
	 *
	 * this function refresh the existing creative table.
	 * */
	function refresh_existing_creative(campaign_id)
	{
		jQuery.ajax({
			type:'POST',
			url : site_url+"/admin/campaigns/fetch_campaign_creative",
			 // the url which stores the stuff in db for each step
			data : {_campaign_id:campaign_id},
			
			success : function(data){

				if(data!='')
				{
					jQuery("#_existing_creative").html(data);
				}
				return true;
				//return true to make the wizard move to the next step, false will cause the wizard to stay on the CV step
			}, 
			error: function(jqXHR, textStatus, errorThrown){
			//alert('Oh no! A problem with the AJAX request!');
			}
		}); 
	}

