	//When form ready
	jQuery(document).ready(function ()
	{
		 //REINITIATE VALIDATE CLASS FOR MODAL BOX
		if($('.form-validate').length > 0)
		{
			$('.form-validate').each(function(){
			var id = $(this).attr('id');
				$("#"+id).validate({
					errorElement:'span',
					errorClass: 'help-block error',
					errorPlacement:function(error, element){
					element.parents('.controls').append(error);
					},
					highlight: function(label) {
					$(label).closest('.control-group').removeClass('error success').addClass('error');
					},
					success: function(label) {
					label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
					}
				});
			});
		}
		//REINITIATE CHECKBOX CLASS FOR MODAL BOX
		
		
		video_overlay_type(ovl_format);
		overlay_action(ovl_action);
		overlay_delivery_type(delivery_type);
		check_overlay_companion_size(companion_size);
		
	});
		
	//Set IAB creative standard

	//Specify in bytes to avoid code complexity
	var iab_size_kb = '250KB';
	var iab_max_size	='256000';
	var iab_file_type=['image/png','image/jpeg','image/jpg','image/gif'];


	//Define default for Overlay Image

	var overlay_img = document.getElementById("overlay_image"),formdata = false;
	//Bind the event to onchange of the url file
	overlay_img.addEventListener("change",handleImageFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_edit_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */

	function handleImageFileSelect(evt)
 	{	
		var form = jQuery( "#video_overlay_creative_edit_form" );

		var isvalid_creative=true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_overlay_image_creative').val()!='')
				{
					var tmp_overlay_image_creative_name=jQuery('#tmp_overlay_image_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_overlay_image_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
						//Validate the particular feild
						form.validate().element(jQuery('#overlay_image'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_overlay_image_creative').val('');//empty temporary feild value		
		
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							
							//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								var validator = form.validate();
								validator.showErrors({"overlay_image": "Creative file format should be jpeg, png, jpg or gif"});
								isvalid_creative=false;
								jQuery('#overlay_image_element').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#overlay_image').val('');
								jQuery('#tmp_overlay_image_creative').val('');
								jQuery('#tmp_overlay_image').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								var validator = form.validate();
								validator.showErrors({"overlay_image": "Creative file size should not exceeds "+iab_size_kb});
								isvalid_creative=false;
								jQuery('#overlay_image_element').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#overlay_image').val('');
								jQuery('#tmp_overlay_image_creative').val('');
								jQuery('#tmp_overlay_image').val('');
							}
								
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#overlay_image'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/video_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_overlay_image').val(data.response.file_name);
												jQuery('#tmp_overlay_image_creative').val(data.response.file_name);
												jQuery('#tmp_overlay_image_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_overlay_image_creative_url').val(data.response.full_path);
											}
											else
											{	
												//window.location.replace(data.redirect);
												jQuery('#tmp_overlay_image_creative').val('');
												var validator = form.validate();
												validator.showErrors(data.msg);
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#tmp_overlay_image').val('');
					jQuery('#overlay_image').val('');
					jQuery('#overlay_image_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"overlay_image": "Creative must be an image "});
				}
			}	
		}
	}
	
	/* name:reset_img_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_img_upload()
	{
		jQuery('#overlay_image_element.fileupload').removeClass('fileupload-exists');
		jQuery('#overlay_image_element.fileupload').addClass('fileupload-new');
		jQuery('#overlay_image').val('');
		jQuery('#preview_overlay_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_edit_form" );
		form.validate().element(jQuery('#overlay_image'));
		
		if(jQuery('#tmp_overlay_image_creative').val() !='')
		{
			var tmp_overlay_image_creative_name=jQuery('#tmp_overlay_image_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_image_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_overlay_image_creative').val('');
		jQuery('#overlay_image').val('');
	}
	
	//Define default for Overlay Image
	var iab_swf_file_type=['application/x-shockwave-flash'];
	
	var overlay_swf = document.getElementById("overlay_swf"),formdata = false;
	//Bind the event to onchange of the url file
	overlay_swf.addEventListener("change",handleSwfFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_edit_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */

	function handleSwfFileSelect(evt)
 	{	
		var form = jQuery( "#video_overlay_creative_edit_form" );

		var isvalid_creative=true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_overlay_swf_creative').val()!='')
				{
					var tmp_overlay_swf_creative_name=jQuery('#tmp_overlay_swf_creative').val();
					jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_overlay_swf_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
					console.log(jqXHR);
					console.log(data.response);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
					//Validate the particular feild
					form.validate().element(jQuery('#overlay_swf'));
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
					}); 
				}
				jQuery('#tmp_overlay_swf_creative').val('');//empty temporary feild value
		
				//To fetch wight and heigh of the selected image using File API.
				/*img = new Image();
				img.onload = function() //After programatically loding selcted image get inside the method
				{*/
					if (!!file.type.match(/application.*/))
					{
						//Fetch creative attribute
						var creative_size=file.size;
						var creative_type=file.type;
						
						//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_swf_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"overlay_swf": "Creative file format should be swf"});
							isvalid_creative=false;
							jQuery('#overlay_swf_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_swf').val('');
							jQuery('#tmp_overlay_swf_creative').val('');
							jQuery('#tmp_overlay_swf').val('');
						}
						//IAB size check
						else if (creative_size > iab_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"overlay_swf": "Creative file size should not exceeds "+iab_size_kb});
							isvalid_creative=false;
							jQuery('#overlay_swf_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#overlay_swf').val('');
							jQuery('#tmp_overlay_swf_creative').val('');
							jQuery('#tmp_overlay_swf').val('');
						}
						
						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#overlay_swf'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_swf_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_overlay_swf').val(data.response.file_name);
											jQuery('#tmp_overlay_swf_creative').val(data.response.file_name);
											jQuery('#tmp_overlay_swf_creative_content_type').val(data.response.image_type);
											jQuery('#tmp_overlay_swf_creative_url').val(data.response.full_path);
										}
										else
										{	
											//window.location.replace(data.redirect);
											jQuery('#tmp_overlay_swf_creative').val('');
											var validator = form.validate();
											validator.showErrors(data.msg);
										}
									}
								});
							}
						}
					}
					else
					{
						var validator = form.validate();
						jQuery('#tmp_overlay_swf').val('');
						jQuery('#overlay_swf').val('');
						jQuery('#overlay_swf_element').removeClass('fileupload-exists').addClass('fileupload-new');
						validator.showErrors({"overlay_swf": "Creative must be an swf file "});
					}
				/*}
				img.src = _URL.createObjectURL(file);*/
			}	
		}
	}
	
	/* name:reset_swf_upload
	 * @param:
	 * 
	 * Make swf upload refresh when creative size is changed
	 * */
	 
	function reset_swf_upload()
	{
		jQuery('#overlay_swf_element.fileupload').removeClass('fileupload-exists');
		jQuery('#overlay_swf_element.fileupload').addClass('fileupload-new');
		jQuery('#overlay_swf').val('');
		jQuery('#preview_overlay_swf').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_edit_form" );
		form.validate().element(jQuery('#overlay_swf'));
		
		if(jQuery('#tmp_overlay_swf_creative').val() !='')
		{
			var tmp_overlay_swf_creative_name=jQuery('#tmp_overlay_swf_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_swf_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_overlay_swf_creative').val('');
		jQuery('#overlay_swf').val('');
	}

	//Specify in bytes to avoid code complexity
	var iab_video_size_mb = '2MB';
	var iab_video_max_size	='2097152';
	var iab_video_file_type	=['video/x-flv','video/mp4','video/flv'];

	//Define default

	var input = document.getElementById("video_overlay_creative"),formdata = false;
	//Bind the event to onchange of the url file
	input.addEventListener("change",handleVideoFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_edit_form" );
	
	
	/* name: overlay_type
	 * @param:null
	 * 
	 * switch between image or swf or text overlay.
	 * */
	
	function video_overlay_type(val)
	{
		if(val=='image_overlay')
		{
			jQuery('#img_block').show();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			jQuery('#edit_third_party_block').hide();
			jQuery('#third_party_overlay_companion').hide();
			if(jQuery('#tmp_overlay_swf_creative').val()!='')
			{
				reset_swf_upload();
			}
		}
		else if(val=='swf_overlay')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').show();
			jQuery('#txt_block').hide();
			jQuery('#edit_third_party_block').hide();
			jQuery('#third_party_overlay_companion').hide();
			if(jQuery('#tmp_overlay_image_creative').val()!='')
			{
				reset_img_upload();
			}
		}
		else if(val=='text_overlay')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').show();
			jQuery('#edit_third_party_block').hide();
			jQuery('#third_party_overlay_companion').hide();
			if(jQuery('#tmp_overlay_image_creative').val()!='')
			{
				reset_img_upload();
			}
			if(jQuery('#tmp_overlay_swf_creative').val()!='')
			{
				reset_swf_upload();
			}
		}
		else if(val=='vast_overlay')
		{
			jQuery('#img_block').hide();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			//jQuery('#overlay_action').hide();
			jQuery('#edit_third_party_block').show();
			jQuery('#third_party_overlay_companion').show();
			if(jQuery('#tmp_overlay_image_creative').val()!='')
			{
				reset_img_upload();
			}
			if(jQuery('#tmp_overlay_swf_creative').val()!='')
			{
				reset_swf_upload();
			}
		}
		else
		{
			jQuery('#img_block').show();
			jQuery('#swf_block').hide();
			jQuery('#txt_block').hide();
			jQuery('#edit_third_party_block').hide();
			jQuery('#third_party_overlay_companion').hide();
		}
	}
	
	/* name: overlay_delivery_type
	 * @param:null
	 * 
	 * switch between click to Page or Click to Video.
	 * */
	
	function overlay_action(val)
	{
		if(val=='click_to_page')
		{
			jQuery('#page_block').show();
			jQuery('#video_block').hide();
			if(jQuery('#tmp_video_overlay_creative').val()!='')
			{
				reset_video_upload();
			}
		}
		else if(val=='click_to_video')
		{
			jQuery('#page_block').hide();
			jQuery('#video_block').show();
		}
		else
		{
			jQuery('#page_block').show();
			jQuery('#video_block').hide();
		}
	}
	
	/* name: overlay_delivery_type
	 * @param:null
	 * 
	 * switch between HTTP and RTMP
	 * */
	
	function overlay_delivery_type(val)
	{
		if(val=='progressive')
		{
			jQuery('#ohttp_block').show();
			jQuery('#ortmp_block').hide();
		}
		else if(val=='streaming')
		{
			jQuery('#ohttp_block').hide();
			jQuery('#ortmp_block').show();
			if(jQuery('#tmp_video_overlay_creative').val()!='')
			{
				reset_video_upload();
			}
		}
		else
		{
			jQuery('#ohttp_block').show();
			jQuery('#ortmp_block').hide();
		}
	}
		
	/* name: check_companion
	 * @param:null
	 * 
	 * Description:Check companion size with web creatives,if match size then choose companion banner from web creatives and process through ajax.
	 * */
	
	function check_overlay_companion_size(csize)
	{	
		var campaign=	jQuery('#overlay_campaign').val();
		var size 	= 	csize.split("x");
		var width 	= 	size[0];
		var height	=	size[1];
		var isvalid_companion;
		if(campaign!='')
		{
			if(width!='' && height!='')
			{
				jQuery.ajax({
						type: "POST",
						async:false,
						url: site_url+'/api/v1/video_creative/check_companion_size/format/json',
						data: {campaign_id:campaign,companion_width:width,companion_height:height,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(campaign);
								isvalid_companion=false;
								jQuery('#ovl_select_companion').show();
								jQuery('#ovl_upload_companion').hide();
								filter_overlay_companions(campaign,width,height,companion_id);
							}
							else
							{
								isvalid_companion=true;
								//console.log(data.msg);
								jQuery('#ovl_select_companion').hide();
								jQuery('#ovl_upload_companion').show();
							}
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
				}); 
			}
			else
			{
				jQuery('#ovl_select_companion').hide();
				jQuery('#ovl_upload_companion').hide()
			}
		}
		else
		{
			var form 		= jQuery( "#video_overlay_creative_edit_form" );
			var validator 	= form.validate();
			validator.showErrors({"overlay_campaign": "Please choose campaign for upload/select companion"});
			jQuery('#overlay_companion_size').val('');
			jQuery('#select_companion_overlay').hide();
			jQuery('#upload_companion_overlay').hide();
		}
	}
	
	/* name: filter_companions
	 * @param:null
	 * 
	 * Description:Filter web creatives for companion banner, match size and process through ajax.
	 * */
	
	function filter_overlay_companions(campaign,width,height,companion_id)
	{
		if(campaign!='')
		{
			if(width!='' && height!='')
			{	
				jQuery.ajax({
					type: "POST",
					async:false,
					url: site_url+'/admin/creatives/filter_companions/'+campaign+'/'+width+'/'+height+'/'+companion_id,
					success: function(data){
						//console.log(data.msg);
						jQuery("#overlay_companion_list").html(data);					
					}
				}); 								
			}
			else
			{
				return false;	
			}
		}
		else
		{
			return false;	
		}		
	}

	/* name: handleVideoFileSelect
	 * @param:null
	 * 
	 * Description:Handle video creative select, validate and process through ajax.
	 * */

	function handleVideoFileSelect(evt)
 	{		
		var form 			= 	jQuery( "#video_overlay_creative_edit_form" );

		var isvalid_creative=	true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var _URL = window.URL || window.webkitURL;//to fetch image width and height
			var file, img;
			
			//Check weather it's image
			if ((file = this.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_video_overlay_creative').val()!='')
				{
					var tmp_video_overlay_creative_name	=	jQuery('#tmp_video_overlay_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_video_overlay_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
							console.log(jqXHR);
							console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
							//Validate the particular feild
							form.validate().element(jQuery('#video_overlay_creative'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
							//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_video_overlay_creative').val('');//empty temporary feild value		
			
				if (!!file.type.match(/video.*/))
				{
					//Fetch creative attribute
					var creative_size=file.size;
					var creative_type=file.type;						
					
					//VALIDATE THE SELECTED IMAGE
						//IAB type check
						var creative_type_flag=jQuery.inArray(creative_type, iab_video_file_type);
						if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
						{
							var validator = form.validate();
							validator.showErrors({"video_overlay_creative": "Creative file format should be flv or mp4"});
							isvalid_creative=false;
							jQuery('#video_overlay_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_overlay_creative').val('');
							jQuery('#tmp_video_overlay_creative').val('');
							jQuery('#tmp_video_overlay').val('');
						}
						//IAB size check
						else if (creative_size > iab_video_max_size )
						{
							var validator = form.validate();
							validator.showErrors({"video_overlay_creative": "Creative file size should not exceeds "+iab_video_size_mb});
							isvalid_creative=false;
							jQuery('#video_overlay_element').removeClass('fileupload-exists').addClass('fileupload-new');
							jQuery('#video_overlay_creative').val('');
							jQuery('#tmp_video_overlay_creative').val('');
							jQuery('#tmp_video_overlay').val('');
						}

						if (window.FileReader)
						{
							reader = new FileReader();
							reader.readAsDataURL(file);
						}
						if (formdata)
						{
							formdata.append("creative", file);
							formdata.append("api_key", api_key);
						}

						//If everything goes right move to a tmp location
						if (isvalid_creative==true)
						{
							//Validate the particular feild
							form.validate().element(jQuery('#video_overlay_creative'));
							if (formdata)
							{
								jQuery.ajax({
									//site_url is defined in header.php (advertiser layout) file,
									url: site_url+'/api/v1/video_creative/creative_video_to_tmp_location/format/json',
									type: "POST",
									async:false,
									data: formdata,
									processData: false,
									contentType: false,
									success:function(data, textStatus, jqXHR)
									{
										console.log(data.response);
										if(data.response != 'error')
										{
											jQuery('#tmp_video_overlay').val(data.response.file_name);
											jQuery('#tmp_video_overlay_creative').val(data.response.file_name);
											jQuery('#tmp_video_overlay_creative_content_type').val(data.response.file_type);
											jQuery('#tmp_video_overlay_creative_url').val(data.response.full_path);
											jQuery('#tmp_video_overlay_creative_raw_name').val(data.response.raw_name);
											jQuery('#tmp_video_overlay_creative_file_ext').val(data.response.file_ext);
										}
										else
										{	
											//window.location.replace(data.redirect);
											jQuery('#tmp_video_overlay_creative').val('');
											var validator = form.validate();
											validator.showErrors(data.msg);
										}
									}
								});
							}
						}
				}
				else
				{
					var validator = form.validate();
					jQuery('#tmp_video_overlay').val('');
					jQuery('#video_overlay_creative').val('');
					jQuery('#video_overlay_element').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"video_overlay_creative": "Creative must be an video "});
				}
				
			}	
		}
	}	
	
	/* name:reset_video_upload
	 * @param:
	 * 
	 * Make video upload refresh when change delivery type is changed
	 * */
	 
	function reset_video_upload()
	{
		jQuery('#video_overlay_element.fileupload').removeClass('fileupload-exists');
		jQuery('#video_overlay_element.fileupload').addClass('fileupload-new');
		jQuery('#video_overlay_creative').val('');
		jQuery('#video_overlay_element .fileupload-preview').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_edit_form" );
		form.validate().element(jQuery('#video_overlay_creative'));
		
		if(jQuery('#tmp_video_overlay_creative').val() !='')
		{
			var tmp_video_overlay_creative_name=jQuery('#tmp_video_overlay_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_video_overlay_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_video_overlay_creative').val('');
		jQuery('#video_overlay_creative').val('');
	}
	
	/* name: 		
	 * @param:		null
	 *
	 * Submit the web creative form
	 * */
	jQuery(function(){
		var form 		= 	jQuery("#video_overlay_creative_edit_form");
		var validator 	= 	form.validate();
		var isvalid_companion;
		jQuery( "#edit_video_overlay_creative" ).unbind().bind('click',function(evt){
			
			if(form.valid()==true)
			{
				if((jQuery('input[name=overlay_type]:checked').val()=='image_overlay' && (jQuery('#tmp_overlay_image_creative').val()!='' || jQuery('#tmp_overlay_image').val()!='')) || (jQuery('input[name=overlay_type]:checked').val()=='swf_overlay' && (jQuery('#tmp_overlay_swf_creative').val()!='' || jQuery('#tmp_overlay_swf').val()!='')) || (jQuery('input[name=overlay_type]:checked').val()=='text_overlay') || (jQuery('input[name=overlay_type]:checked').val()=='vast_overlay'))
				{
					if(jQuery('#overlay_companion_size').val!='' && isvalid_companion==true)
					{
						if(jQuery('#tmp_overlay_companion_creative').val()!='')
						{							
							evt.preventDefault();

							jQuery.ajax({
								type:'POST',
								async:false,
								url: form.attr("action"),
								data:form.serialize(),
								success: function(data, textStatus, jqXHR){
									console.log(jqXHR);
									
									if(data.response == 'ok')
									{	
										
										custom_opt.sDom= 'T<"clear">lfrtip';
										custom_opt.sDom=  'B<"clear">lfrtip';
										custom_opt.buttons= [  
											{
												extend: 'copyHtml5',
												exportOptions: {
												columns:':visible'
												}
											},
											{
												extend: 'csvHtml5',
												exportOptions: {
												columns:':visible'
												}
											},
											{
												extend: 'excelHtml5',
												exportOptions: {
												columns:':visible'
												}
											},
											{
												extend: 'pdfHtml5',
												orientation: 'landscape',
												exportOptions: {
												columns:':visible'
												}
											},
											{
												extend: 'print',
												orientation: 'landscape',
												exportOptions: {
												columns:':visible'
												}
											} 
										];
										jQuery("#edit_video_overlay_creative" ).unbind('click');								
										//var validator = form.validate();
										validator.resetForm();
										form.get(0).reset();
										
										//RELOAD DATATABLES			
										jQuery('.dataTable').dataTable(custom_opt).fnDraw();
										jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
										var t = document.getElementById("admin_banner_list_length_select");		
							new AcostUISelect(t);
										jQuery("#check_all").click(function(e){
											$('input', oTable.fnGetNodes()).prop('checked',this.checked);
										});
										if(jQuery(this).hasClass("dataTable-fixedcolumn")){
											new FixedColumns( oTable );
										}
										if(jQuery(this).hasClass("dataTable-columnfilter")){
											oTable.columnFilter({
												"sPlaceHolder" : "head:after"
											});
										}
										resize_chosen();
										//RELOAD DATATABLES			
										
										//Reset hidden feilds
										jQuery('#tmp_video_overlay').val('');
										jQuery('#tmp_video_overlay_creative').val('');
										jQuery('#tmp_video_overlay_creative_content_type').val('');
										jQuery('#tmp_video_overlay_creative_url').val('');
										
										//Switch modal box
										$('#modal_video_overlay_creative_edit').one('hidden.bs.modal', function (e) {
											jQuery('#modal_video_overlay_creative_edit_success').modal('show');
										}).modal('hide');
										
										//jQuery("#edit_video_overlay_creative" ).bind('click');
									}
									else
									{
										jQuery('.alert-error').show();
										jQuery('#error_msg').html(data.msg);
										//var validator = form.validate();
										validator.showErrors(data.msg);
									}
								}, 
								// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
								error: function(jqXHR, textStatus, errorThrown){
								//alert('Oh no! A problem with the AJAX request!');
								}
							}); 
						}
						else
						{
							validator.showErrors({"overlay_companion_file": "Companion is not uploaded correctly, Please try again.."});
						}
					}
					else
					{
						//jQuery("#edit_video_overlay_creative" ).unbind('click');
						evt.preventDefault();

						jQuery.ajax({
							type:'POST',
							async:false,
							url: form.attr("action"),
							data:form.serialize(),
							success: function(data, textStatus, jqXHR){
								console.log(jqXHR);
								
								if(data.response == 'ok')
								{
									custom_opt.sDom= 'T<"clear">lfrtip';
									custom_opt.sDom=  'B<"clear">lfrtip';
									custom_opt.buttons= [  
									{
									extend: 'copyHtml5',
									exportOptions: {
									columns:[1,2,3,4,5,6,7,8]
									}
									},
									{
								extend: 'csvHtml5',
								exportOptions: {
								columns:[1,2,3,4,5,6,7,8]
								}
								},
								{
								extend: 'excelHtml5',
								exportOptions: {
								columns:[1,2,3,4,5,6,7,8]
								}
								},
								{
								extend: 'pdfHtml5',
								orientation: 'landscape',
								exportOptions: {
								columns:[1,2,3,4,5,6,7,8]
									}
								},
								{
								extend: 'print',
								orientation: 'landscape',
								exportOptions: {
								columns:[1,2,3,4,5,6,7,8]
								}
								} 
								];
									jQuery('#edit_video_overlay_creative').unbind('click');
									//var validator = form.validate();
									validator.resetForm();
									form.get(0).reset();
									
									//RELOAD DATATABLES			
									jQuery('.dataTable').dataTable(custom_opt).fnDraw();
									jQuery('.dataTables_filter input').attr("placeholder", "Search here...");
									var t = document.getElementById("admin_banner_list_length_select");		
							new AcostUISelect(t);
									jQuery("#check_all").click(function(e){
										$('input', oTable.fnGetNodes()).prop('checked',this.checked);
									});
									if(jQuery(this).hasClass("dataTable-fixedcolumn")){
										new FixedColumns( oTable );
									}
									if(jQuery(this).hasClass("dataTable-columnfilter")){
										oTable.columnFilter({
											"sPlaceHolder" : "head:after"
										});
									}
									resize_chosen();
									//RELOAD DATATABLES			
									
									//Reset hidden feilds
									jQuery('#tmp_video_overlay').val('');
									jQuery('#tmp_video_overlay_creative').val('');
									jQuery('#tmp_video_overlay_creative_content_type').val('');
									jQuery('#tmp_video_overlay_creative_url').val('');
									//Switch modal box
									jQuery('#modal_video_overlay_creative_edit').modal('hide');
									jQuery('#modal_video_overlay_creative_edit_success').modal('show');
									jQuery("#edit_video_overlay_creative" ).bind('click');
								}
								else
								{
									jQuery('.alert-error').show();
									jQuery('#error_msg').html(data.msg);
									//var validator = form.validate();
									validator.showErrors(data.msg);
								}
							}, 
							// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
							error: function(jqXHR, textStatus, errorThrown){
							//alert('Oh no! A problem with the AJAX request!');
							}
						}); 
					}
				}
				else
				{
					if(jQuery('input[name=overlay_type]:checked').val()=='image_overlay')
					{
						validator.showErrors({"overlay_image": "Overlay image is not uploaded correctly, Please try again.."});
					}
					else if(jQuery('input[name=overlay_type]:checked').val()=='swf_overlay')
					{
						validator.showErrors({"overlay_swf": "Overlay swf is not uploaded correctly, Please try again.."});
					}
				}
			}
		});
	});

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when creative is uplaoded and changed as a Streaming creative(RTMP Banner)
	 * */

	jQuery( "#overlay_delivery_method" ).click(function(evt){
		if (jQuery('#overlay_delivery_method').val()=='streaming')
		{
			reset_video_upload();
		}
	});
	
	
	//Define default for Companion Banner

	var companion = document.getElementById("overlay_companion_file"),formdata = false;
	//Bind the event to onchange of the url file
	companion.addEventListener("change",handleFileSelect , false);	
	if (window.FormData)
	{
  		formdata = new FormData();
  	}
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
	var form = jQuery( "#video_overlay_creative_edit_form" );

	/* name: handleFileSelect
	 * @param:
	 * 
	 * Description:Handle creative select for companion banner, validate and process through ajax.
	 * */

	function handleFileSelect(evt)
 	{
		var selcted_creative_size=jQuery('#overlay_companion_size').val();
		var creative_size_split = selcted_creative_size.split('x');
		var iab_max_width= parseInt(creative_size_split[0], 10); 
		var iab_max_height= parseInt(creative_size_split[1], 10);

		var form = jQuery( "#video_overlay_creative_edit_form" );

		var isvalid_creative=true;		//form check list
		
		var i = 0, len = this.files.length, img, reader, file;
		for ( ; i < len; i++ )
		{
			file = this.files[i];
			var file, img;

			//Check weather it's image
			if ((file = this.files[0]))
			{	
				//If a image is uploaded and changed before submit trigger the remove click event to delete the old creative
				if(jQuery('#tmp_overlay_companion_creative').val()!='')
				{
					var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
					jQuery.ajax({
						type:'POST',
						async:false,
						url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
						data: {creative_name:tmp_overlay_companion_creative_name,api_key:api_key},
						success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						console.log(data.response);

							if(data.response == 'ok')
							{
								console.log(data.msg);
							}
							else
							{
								console.log(data.msg);
							}
						//Validate the particular feild
						form.validate().element(jQuery('#overlay_companion_file'));
						}, 
						// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
						error: function(jqXHR, textStatus, errorThrown){
						//alert('Error ! A problem with the request try again!');
						}
					}); 
				}
				jQuery('#tmp_overlay_companion_creative').val('');//empty temporary feild value
		
				if (!!file.type.match(/image.*/))
				{
					var freader = new FileReader();	
				
					freader.onload = function(evt) //After programatically loding selcted image get inside the method
					{
						img = new Image();
						img.src = evt.target.result;
						//To fetch wight and heigh of the selected image using File API.
						
						img.onload = function() //After programatically loding selcted image get inside the method
						{
							//Fetch creative attribute
							var creative_size=file.size;
							var creative_type=file.type;
							var creative_width=parseInt(this.width,10);
							var creative_height=parseInt(this.height,10);

							//VALIDATE THE SELECTED IMAGE
							//IAB type check
							var creative_type_flag=jQuery.inArray(creative_type, iab_file_type);
							if (creative_type_flag =='-1')//if -1 it is not a supported image type, 1 is valid.
							{
								var validator = form.validate();
								validator.showErrors({"overlay_companion_file": "Creative file format should be jpeg, png, jpg or gif"});
								isvalid_creative=false;
								jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#overlay_companion_file').val('');
								jQuery('#tmp_overlay_companion_creative').val('');
							}
							//IAB size check
							else if (creative_size > iab_max_size )
							{
								var validator = form.validate();
								validator.showErrors({"overlay_companion_file": "Creative file size should not exceeds "+iab_size_kb});
								isvalid_creative=false;
								jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#overlay_companion_file').val('');
								jQuery('#tmp_overlay_companion_creative').val('');
							}

							//IAB width check
							else if (creative_width != iab_max_width )
							{
								var validator = form.validate();
								validator.showErrors({"overlay_companion_file": "Upload creative with ("+iab_max_width+"x"+iab_max_height+") dimensions"});
								isvalid_creative=false;
								jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#overlay_companion_file').val('');
								jQuery('#tmp_overlay_companion_creative').val('');
							}

							//IAB height check
							/*if (creative_height != iab_max_height )
							{
								var validator = form.validate();
								validator.showErrors({"overlay_companion_file": "creative height is not match to IAB standard."});
								isvalid_creative=false;
								jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
								jQuery('#overlay_companion_file').val('');
								jQuery('#tmp_overlay_companion_creative').val('');
							}*/

							
							
							if (window.FileReader)
							{
								reader = new FileReader();
								reader.readAsDataURL(file);
							}
							if (formdata)
							{
								formdata.append("creative", file);
								formdata.append("api_key", api_key);
							}

							//If everything goes right move to a tmp location
							if (isvalid_creative==true)
							{
								//Validate the particular feild
								form.validate().element(jQuery('#overlay_companion_file'));
								if (formdata)
								{
									jQuery.ajax({
										//site_url is defined in header.php (advertiser layout) file,
										url: site_url+'/api/v1/video_creative/creative_to_tmp_location/format/json',
										type: "POST",
										async:false,
										data: formdata,
										processData: false,
										contentType: false,
										success:function(data, textStatus, jqXHR)
										{
											console.log(data.response);
											if(data.response != 'error')
											{
												jQuery('#tmp_overlay_companion_creative').val(data.response.file_name);
												jQuery('#tmp_overlay_companion_creative_content_type').val(data.response.image_type);
												jQuery('#tmp_overlay_companion_creative_url').val(data.response.full_path);
											}
											else
											{	
												//window.location.replace(data.redirect);
												jQuery('#tmp_overlay_companion_creative').val('');
												var validator = form.validate();
												validator.showErrors(data.msg);
											}
										}
									});
								}
							}
						}
					}
					freader.readAsDataURL(file);
				}
				else
				{
					var validator = form.validate();
					jQuery('#overlay_companion_file').val('');
					jQuery('#overlay_companion').removeClass('fileupload-exists').addClass('fileupload-new');
					validator.showErrors({"overlay_companion_file": "Creative must be an image "});
				}
			}	
		}
	}
	
	/* name:reset_upload
	 * @param:
	 * 
	 * Make image upload refresh when creative size is changed
	 * */
	 
	function reset_upload()
	{
		jQuery('#overlay_companion.fileupload').removeClass('fileupload-exists');
		jQuery('#overlay_companion.fileupload').addClass('fileupload-new');
		jQuery('#overlay_companion_file').val('');
		jQuery('#preview_image').html('');
		//Validate the particular field
		var form = jQuery( "#video_overlay_creative_edit_form" );
		form.validate().element(jQuery('#overlay_companion_file'));
		
		if(jQuery('#tmp_overlay_companion_creative').val() !='')
		{
			var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
			jQuery.ajax({
				type:'POST',
				async:false,
				url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
				data: {creative_name:tmp_overlay_companion_creative_name,api_key:api_key},
				success: function(data, textStatus, jqXHR){
					console.log(jqXHR);

					if(data.response == 'ok')
					{
						console.log(data.msg);
					}
					else
					{
						console.log(data.msg);
					}
				}, 
				/* Failed to load request. This could be caused by any number
					of problems like server issues, bad links, etc. */
					
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Error ! A problem with the request try again!');
				}
			}); 
				
		}
		jQuery('#tmp_overlay_companion_creative').val('');
		jQuery('#overlay_companion_file').val('');
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Retorr to old creative
	 * */

	function restore(creative_type)
 	{
		if(jQuery('#old_'+creative_type+'_creative_url').val() !='')
		{
			if(creative_type=='video_overlay')
			{
				jQuery( "#video_overlay_creative_edit_form" ).validate().element(jQuery('#'+creative_type+'_creative'));
				jQuery( '#'+creative_type+'_group' ).removeClass( "error" ).addClass( "success" );
				jQuery( '#'+creative_type+'_element').removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			}
			else if(creative_type=='overlay_image')
			{
				jQuery( "#video_overlay_creative_edit_form" ).validate().element(jQuery('#'+creative_type));
				jQuery( '#img_block' ).removeClass( "error" ).addClass( "success" );
				jQuery( '#'+creative_type+'_element').removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			}
			else if(creative_type=='overlay_swf')
			{
				jQuery( "#video_overlay_creative_edit_form" ).validate().element(jQuery('#'+creative_type));
				jQuery( '#swf_block' ).removeClass( "error" ).addClass( "success" );
				jQuery( '#'+creative_type+'_element').removeClass( "fileupload-new" ).addClass( "fileupload-exists" );
			}
					
			var old_creative				=	jQuery('#old_'+creative_type+'_creative').val();
			var old_creative_content_type	=	jQuery('#old_'+creative_type+'_creative_content_type').val();
			var old_creative_url			=	jQuery('#old_'+creative_type+'_creative_url').val();
			
			if(jQuery('#tmp_'+creative_type+'_creative').val() !='')
			{
				var tmp_creative_name	=	jQuery('#tmp_'+creative_type+'_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_creative_name},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
					}, 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
					
			}
		
			jQuery('#tmp_'+creative_type).val(old_creative);
			jQuery('#tmp_'+creative_type+'_creative').val('');
			jQuery('#tmp_'+creative_type+'_creative_content_type').val('');
			jQuery('#tmp_'+creative_type+'_creative_url').val('');
			
			if(creative_type=='overlay_image')
			{
				jQuery('#preview_'+creative_type).html("<img src='"+old_creative_url+"'/>");
			}
			else
			{
				jQuery('#preview_'+creative_type).html(old_creative);
			}
		}
	}
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_companion" ).click(function(evt){
			var form = jQuery("#video_overlay_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#overlay_companion_file'));
			
			jQuery('#overlay_companion.fileupload').removeClass('fileupload-exists');
			jQuery('#overlay_companion.fileupload').addClass('fileupload-new');
			jQuery('#overlay_companion_file').val('');
			jQuery('#preview_image').html('');
			
			if(jQuery('#tmp_overlay_companion_creative').val() !='')
			{
				var tmp_overlay_companion_creative_name=jQuery('#tmp_overlay_companion_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_overlay_companion_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#overlay_companion_file'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_overlay_companion_creative').val('');//empty temporary feild value
		});
	});
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove" ).click(function(evt){
			var form = jQuery("#video_overlay_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#video_overlay_creative'));
			
			jQuery('#video_overlay_element.fileupload').removeClass('fileupload-exists');
			jQuery('#video_overlay_element.fileupload').addClass('fileupload-new');
			jQuery('#video_overlay_creative').val('');
			jQuery('#video_overlay_element .fileupload-preview').html('');
		
			if(jQuery('#tmp_video_overlay_creative').val() !='')
			{
				var tmp_video_overlay_creative_name=jQuery('#tmp_video_overlay_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_video_overlay_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#video_overlay_creative'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_video_overlay_creative').val('');//empty temporary feild value
			
		});
	});
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_image" ).click(function(evt){
			var form = jQuery("#video_overlay_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#overlay_image'));
			
			jQuery('#overlay_image_element.fileupload').removeClass('fileupload-exists');
			jQuery('#overlay_image_element.fileupload').addClass('fileupload-new');
			jQuery('#overlay_image').val('');
			jQuery('#preview_overlay_image').html('');
				
			if(jQuery('#tmp_overlay_image_creative').val() !='')
			{
				var tmp_overlay_image_creative_name=jQuery('#tmp_overlay_image_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_overlay_image_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#overlay_image'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_overlay_image_creative').val('');//empty temporary feild value
			
		});
	});
	
	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#remove_swf" ).click(function(evt){
			var form = jQuery("#video_overlay_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#overlay_swf'));
			
			jQuery('#overlay_swf_element.fileupload').removeClass('fileupload-exists');
			jQuery('#overlay_swf_element.fileupload').addClass('fileupload-new');
			jQuery('#overlay_image').val('');
			jQuery('#preview_overlay_swf').html('');
			
			if(jQuery('#tmp_overlay_swf_creative').val() !='')
			{
				var tmp_overlay_swf_creative_name=jQuery('#tmp_overlay_swf_creative').val();
				jQuery.ajax({
					type:'POST',
					async:false,
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_overlay_swf_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#overlay_swf'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_overlay_swf_creative').val('');//empty temporary feild value
			
		});
	});

	function vast_upload()
	{
		if(jQuery('#is_vast_upload').is(':checked'))
		{
			jQuery('#vast_tag_url').attr('disabled','disabled');
			jQuery('#oupload_vast').show();
		}
		else
		{
			jQuery('#vast_tag_url').removeAttr('disabled');
			jQuery('#oupload_vast').hide();
		}
	}
	
	/* name: xml_upload
	 * @param:null
	 * 
	 * switch between Local and URL.
	 * */
	
	function xml_upload(target)
	{
		var form = jQuery("#video_overlay_creative_edit_form");
		var isvalid_creative=false;
		var file;
		if(file	= target.files[0])
		{
			var type=	file.type;
			var size=	file.size;
			
			if(type=='text/xml')
			{
				var isvalid_creative=true;
				
				if (formdata)
				{
					formdata.append("creative", file);
					formdata.append("api_key", api_key);
				}

				//If everything goes right move to a tmp location
				if (isvalid_creative==true)
				{
					$("#add_video_overlay_creative").val('please wait').attr('disabled',true);
					//Validate the particular feild
					form.validate().element(jQuery('#vast_tag_upload'));
					if (formdata)
					{
						jQuery.ajax({
							//site_url is defined in header.php (advertiser layout) file,
							url: site_url+'/api/v1/video_creative/creative_xml_to_tmp_location/format/json',
							type: "POST",
							data: formdata,
							processData: false,
							contentType: false,
							success:function(data, textStatus, jqXHR)
							{
								console.log(data.response);
								if(data.response != 'error')
								{
									$("#add_video_overlay_creative").val('Submit').removeAttr('disabled');
									jQuery('#tmp_vast_tag_upload_creative').val(data.response.file_name);
									jQuery('#tmp_vast_tag_upload_creative_content_type').val(data.response.file_type);
									jQuery('#tmp_vast_tag_upload_creative_url').val(data.response.full_path);
								}
								else
								{											
									//window.location.replace(data.redirect);
									jQuery('#tmp_vast_tag_upload_creative').val('');
									var validator = form.validate();
									validator.showErrors(data.msg);
								}
							}
						});
					}
				}
			}
			else
			{
				var validator = form.validate();
				jQuery('#vast_tag_upload').val('');
				jQuery('#vast_tag_upload_element').removeClass('fileupload-exists').addClass('fileupload-new');
				validator.showErrors({"vast_tag_upload": "Upload must be an xml file"});
			}
		}		
	}

	/* name: 		
	 * @param:		null
	 * 
	 * Delete the creative when remove button is clicked
	 * */

	jQuery(function(){
		jQuery( "#vast_tag_remove" ).click(function(evt){
			var form = jQuery("#video_overlay_creative_edit_form");
			evt.preventDefault();
			form.validate().element(jQuery('#vast_tag_upload'));
			
			jQuery('#vast_tag_upload_element.fileupload').removeClass('fileupload-exists');
			jQuery('#vast_tag_upload_element.fileupload').addClass('fileupload-new');
			jQuery('#vast_tag_upload').val('');
			jQuery('#preview_vast_tag_upload').html('');
			
			if(jQuery('#tmp_vast_tag_upload_creative').val() !='')
			{
				var tmp_vast_creative_name=jQuery('#tmp_vast_tag_upload_creative').val();
				jQuery.ajax({
					type:'POST',
					url: site_url+'/api/v1/video_creative/delete_a_tmp_creative/format/json',
					data: {creative_name:tmp_vast_creative_name,api_key:api_key},
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);

						if(data.response == 'ok')
						{
							console.log(data.msg);
						}
						else
						{
							console.log(data.msg);
						}
						//Validate the particular feild
						form.validate().element(jQuery('#inline_companion_file'));
					}, 
					/* Failed to load request. This could be caused by any number
						of problems like server issues, bad links, etc. */
						
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Error ! A problem with the request try again!');
					}
				}); 
			}
			jQuery('#tmp_vast_tag_upload_creative').val('');//empty temporary feild value
			
		});
	});

	function show_skippable(val)
	{
		if(val=='yes')
		{
			jQuery('#skip_ad').show();
		}
		else
		{
			jQuery('#skip_ad').hide();
		}
	}
	
	function vast_selection_type(val)
	{
		if(val=='3')
		{
			jQuery('#skippable').show();			
		}
		else
		{
			jQuery('#skippable').hide();			
		}
	}
