$(document).ready(function ()
{
	if($('.form-validate').length > 0)
	{
		$('.form-validate').each(function(){
			var id = $(this).attr('id');

			$("#"+id).validate({
				errorElement:'span',
				errorClass: 'help-block error',
				errorPlacement:function(error, element){
					element.parents('.controls').append(error);
				},
				highlight: function(label) {
					$(label).closest('.control-group').removeClass('error success').addClass('error');
				},
				success: function(label) {
					label.addClass('valid').closest('.control-group').removeClass('error success').addClass('success');
				}
			});
		});
	}
});
/* Edit Category */


$(function(){
	jQuery.validator.setDefaults({
		debug: true,
		success: "valid"
	});
		
	var form = $("#edit_device_form");

	var validator = form.validate();
	
	$("#save_edit_device").unbind().bind('click',function(evt) {
		// console.log(form);
		if(form.valid()==true){
			
			evt.preventDefault();
			
			$.ajax({
				type:'POST',
				url: form.attr("action"),
				data:form.serialize(),
				// Success function. the 'data' parameter is an array of objects that can be looped over
				success: function(data, textStatus, jqXHR){
					//console.log(jqXHR);
					if(data.response == 'ok'){
						$('#save_edit_device').unbind('click');
						
						custom_opt.dom= 'Bfrtip';
							custom_opt.select=  { 'style':'multi' };
							custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
							custom_opt.buttons=[
							{
								extend: 'copyHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							} 
				 
							];	
							
						
						$('#device_list.dataTable').dataTable(custom_opt).fnDraw();
						var t = document.getElementById("device_list_length_select");
						new AcostUISelect(t);															
						resize_chosen();	
						
						//Switch modal box
						$('#modal_edit_device').one('hidden.bs.modal', function (e) {
							jQuery('.modal-backdrop').remove();
							jQuery('#modal_edit_device_success').modal('show');
						}).modal('hide');
					}
					else
					{
						validator.showErrors(data.msg);
					}

				}, 
				// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
				error: function(jqXHR, textStatus, errorThrown){
				//alert('Oh no! A problem with the AJAX request!');
				}
			}); 
				
		}
	});
	
});
