// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"aaSorting" : [[1, 'desc']], 
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sProcessing": "<img src='"+site_url+"/templates/theme/img/loader.gif'>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/targeting/fetch_mobile_os",
	
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			 "orderable": false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
				var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
				return checkbox;
			}
		},
		{
			"aTargets": [1],
			"mData":"id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
					$(nTd).addClass('checkbox_id'); // Remove border                        
			},
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":"name",
		},
        {
			"aTargets": [3],
			"mData": "value",
		},
		{
			"aTargets": [4],
			"mData":null,
			"mRender": function (data, type, full) {
			  var os_id=full.id;
			   var status=full.is_blocked;
			  return action_button(os_id,status);
			}
		},
		
    	]
    };

 
function action_button(os_id,status)
{
	var rev_url = site_url+'/admin/targeting/edit_mobile_os'; 
	var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="btn btn-small" data-target="#modal-edit-mobile-operatingsystem" href="'+rev_url+'/'+os_id+'"><i class="icon-edit"></i></a>';
	
	var del_url = '';
	var del_btn = '<button class="btn btn-small site" title="Delete" data-id="'+os_id+'" data-toggle="modal" onclick="delete_mobile_os('+os_id+')"><i class="icon-trash"></i></button>';
	//return rev_btn+del_btn;
	 
	 if(status==0)
	{  
	   var block_btn = '&nbsp;<button class="btn btn-small btn-danger confirm" title="Block" data="'+os_id+'" data-bb="confirm"><i class="icon-lock"></i></button>';
	}  
	else
	{
		var block_btn = '&nbsp;<button class="btn btn-small btn-success confirm_unblock" title="Unblock" data="'+os_id+'" data-bb="confirm"><i class="icon-key"></i></button>';
	}
	 return rev_btn+' '+del_btn+' '+block_btn;
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_mobile_os(os_id)
{   
	$("#id").val(os_id);
    $('#modal_delete_mobile_operating_system').modal('show');	
}



// Block  Functionality with Confirm Box

	$(document).on("click", ".confirm", function(e) {
	 
	 	bootbox.confirm("Are you sure you want to block this Mobile Operating System ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/mobile_block_os/format/json',
					data:{'id':$(e.target).attr('data'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							 
							$('select').select2("val", "");
							
							$('#mob_os_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_os_msg').attr("data-notify-message",data.msg);
							
							$('#del_os_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 });


// UnBlock  Functionality with Confirm Box

	$(document).on("click", ".confirm_unblock", function(e) {
	 
	 	bootbox.confirm("Are you sure you want to unblock this Mobile operating system ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/mobile_unblock_os/format/json',
					data:{'id':$(e.target).attr('data'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							 
							$('select').select2("val", "");
							
							$('#mob_os_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_os_msg').attr("data-notify-message",data.msg);
							
							$('#del_os_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 });

function mos_block()
{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#mos_id").val(box_check);
			$('#modal_block_mos').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
}

function mos_unblock()
{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
			$("#blkmos_id").val(box_check);
			$('#modal_unblock_mos').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function delete_mos_list()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	if(box_check!="")	
	{
		$("#id").val(box_check);
		$('#modal_delete_mobile_operating_system').modal('show');	
	}
	else
	{
		$('#modal_no_selection').modal('show');
	}
}
