// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"aaSorting" : [[0, 'desc']],
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center'><img src='"+site_url+"/template/flat/img/loader.gif' alt='Loading...'/></div>",					
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/targeting/fetch_mobile_capability",
	
		"aoColumnDefs": [
	  {
		"aTargets": [0],
		"mData":"id",
		"orderable": false,
		"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
		{
					$(nTd).addClass('with-checkbox'); // center the link                        
		},				"mRender"	: function (data, type, full)
				{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
				}
		},
		{
			"aTargets": [1],
			"mData":"id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
					$(nTd).addClass('checkbox_id'); // Remove border                        
			},
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":"name",
		},
        {
			"aTargets": [3],
			"mData": "value",
		},
		{
			"aTargets": [4],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			  var capability_id=full.id;
			  var status=full.is_blocked;
			  return action_button(capability_id,status);
			}
		},
		
    	],
    	dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3 ],
                       rows: '.selected'
                 },
            }  
         
        ]

    };

 
function action_button(capability_id,status)
{
	var rev_url = site_url+'/admin/targeting/edit_mobile_capability'; 
	var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="table-buttons-optimize" data-target="#modal_edit_mobile_capability" href="'+rev_url+'/'+capability_id+'"><span></span></a>';
	
	var del_url = '';
	var del_btn = '<a data-toggle="modal" role="button" class="table-buttons-delete" data-id="'+capability_id+'" title="Delete" onclick="delete_mobile_capability('+capability_id+')"><span></span></a>'; 
	
	 //return rev_btn+del_btn;
	 
	 if(status==0)
	{  
	  var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testcheck" data-toggle="modal" role="button" class="table-buttons" onclick="blockfunc('+capability_id+');" title="Block" data="'+capability_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-lock"></span></a>';   
	}
	else  
	{	
		var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testuncheck" data-toggle="modal" role="button" class="table-buttons" onclick="unblockfunc('+capability_id+');"  title="Unblock" data="'+capability_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-key"></i></span></a>';
	}
	 return rev_btn+' '+del_btn+' '+block_btn;
}

$('.modal').on('hidden', function () {
$(this).removeData('modal');
});

function delete_mobile_capability(capability_id)
{
	$("#mob_capability_id").val(capability_id);
    $('#modal_delete_mobile_capability').modal('show');	
}

// Block  Functionality with Confirm Box

	function blockfunc(capability_id)
	{
	 
	 	bootbox.confirm("Are you sure you want to block this Mobile capability ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/mobile_block_capability/format/json',
					data:{'id':capability_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							
							custom_opt.dom= 'Bfrtip';
							custom_opt.select=  { 'style':'multi' };
							custom_opt.columnDefs=[
								{
									'checkboxes': {
									   'selectRow': true
										}
									 }
								];
							custom_opt.buttons=[
							{
									extend: 'copyHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'csvHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'excelHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'pdfHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'print',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								} 
					 
							];										
														
							$('#capable_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("capable_list_length_select");
							new AcostUISelect(t);
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_capability_msg').attr("data-notify-message",data.msg);
							
							$('#del_capability_msg').trigger('click');	  
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 }


// UnBlock  Functionality with Confirm Box

	function unblockfunc(capability_id)
	{
	 
	 	bootbox.confirm("Are you sure you want to unblock this Mobile capability ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/mobile_unblock_capability/format/json',
					data:{'id':capability_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){	

							custom_opt.dom= 'Bfrtip';
							custom_opt.select=  { 'style':'multi' };
							custom_opt.columnDefs=[
								{
									'checkboxes': {
									   'selectRow': true
										}
									 }
								];
							custom_opt.buttons=[
							{
									extend: 'copyHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'csvHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'excelHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'pdfHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'print',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								} 
					 
							];			
							
													
							$('#capable_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("capable_list_length_select");
							new AcostUISelect(t);
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_capability_msg').attr("data-notify-message",data.msg);
							
							$('#del_capability_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	}
	
function Mobile_capab_Block()
{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
			$("#block_id").val(box_check);
			$('#modal_block_Mobile_capbty').modal('show'); 
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
}

function Mobile_capab_Unblock()
{
	
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
				$("#unblock_id").val(box_check);
				$('#modal_unblock_Mobile_capbty').modal('show');	
		}
		else
		{  
				$('#modal_no_selection').modal('show');
		}
	 
}

function Mobile_capab_delete()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
   	if(box_check!="")	
		{
			$("#del_id").val(box_check);
			$('#modal_del_Mobile_capbty').modal('show');
		}
		else
		{  
		$('#modal_no_selection').modal('show');
		}
	 
}
