// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"aaSorting" : [[0, 'desc']],
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center'><img src='"+site_url+"/templates/theme/img/loader.gif' alt='Loading...'/></div>",											
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/targeting/fetch_targ_list/language",	
		"aoColumnDefs": [
				{
		"aTargets": [0],
		"mData":"id",
		"orderable": false,
		"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
		{
					$(nTd).addClass('with-checkbox'); // center the link                        
		},
				"mRender"	: function (data, type, full)
				{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
				}
		},
		{
			"aTargets": [1],
			"mData":"id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('checkbox_id'); // Remove border                        
			},
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":"name",
		},
        {
			"aTargets": [3],
			"mData": "value",
		},
		{
			"aTargets": [4],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			  var targ_id	=	full.id;
			  var status	=	full.is_blocked;
			  return action_button(targ_id,status);
			}
		},
		
    	],
    	dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3],
                     rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3],
                       rows: '.selected'
                 },
            }  
         
        ]
    };

 
function action_button(targ_id,status)
{
	var rev_url = site_url+'/admin/targeting/edit_targeting/language'; 
	var rev_btn = '<a data-toggle="modal" role="button"  title="Review" class="table-buttons-optimize" data-target="#modal_edit_language" href="'+rev_url+'/'+targ_id+'"><span></span></a>';
	
	var del_url = '';
	var del_btn = '<a data-toggle="modal" role="button" class="table-buttons-delete" title="Delete" onclick="delete_language('+targ_id+')"><span></span></a>'; 
	
	
	if(status==0)
	{ 	     
	    var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testcheck" data-toggle="modal" role="button" class="table-buttons" onclick="blockfunc('+targ_id+');" title="Block" data="'+targ_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-lock"></span></a>';
	   
	}
	else
	{  
		var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testuncheck" data-toggle="modal" role="button" class="table-buttons" onclick="unblockfunc('+targ_id+');"  title="Unblock" data="'+targ_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-key"></i></span></a>';		
	}
	return rev_btn+' '+del_btn+' '+block_btn;
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_language(targ_id)
{
	$("#del_targ_id").val(targ_id);
    $('#modal_delete_language').modal('show');	
}

// Block  Functionality with Confirm Box

	function blockfunc(id) {
	 
	 	bootbox.confirm("Are you sure you want to block this language ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/block_targeting/format/json',
					data:{'targ_id':id,'api_key':api_key,'targ_type':'language','targ_table':targ_table},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							
							custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
								  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
								  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							} 
				 
						];						 
						
																			
							$('#language_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("language_list_length_select");
							new AcostUISelect(t);					
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_targ_msg').attr("data-notify-message",data.msg);
							
							$('#del_targ_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 }


// UnBlock  Functionality with Confirm Box

	function unblockfunc(id) {
	 
	 	bootbox.confirm("Are you sure you want to unblock this language ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/unblock_targeting/format/json',
					data:{'targ_id':id,'api_key':api_key,'targ_type':'language','targ_table':targ_table},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							
						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							} 
				 
						];						 
														
							$('#language_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("language_list_length_select");
							new AcostUISelect(t);							
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_targ_msg').attr("data-notify-message",data.msg);
							
							$('#del_targ_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	}
function language_Block()
{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
	       $("#block_id").val(box_check);
	       $("#targ_type").val('language');
	       $("#targ_table").val(targ_table);
		   $('#modal_block_lang').modal('show');
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
}

function language_Unblock()
{
	
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
		$("#unblock_id").val(box_check);
	    $("#targ_unblock_type").val('language');
	    $("#targ_unblock_table").val(targ_table);
	 	$('#modal_unblock_Language').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function language_delete()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
			
	  $("#del_id").val(box_check);
	  $("#delete_targ_type").val('language');
	  $("#delete_targ_table").val(targ_table);
      $('#modal_del_Language').modal('show');
		}
		else
		{  
		$('#modal_no_selection').modal('show');
		}
	 
}
