// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"aaSorting" : [[0, 'desc']],
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center'><img src='"+site_url+"/templates/theme/img/loader.gif' alt='Loading...'/></div>",										"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/targeting/fetch_targ_list/carrier",	
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			 "orderable": false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
				var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
				return checkbox;
			}
		},
		{
			"aTargets": [1],
			"mData":"id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('checkbox_id'); // Remove border                        
			},
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":"start_ip",
		},
        {
			"aTargets": [3],
			"mData": "end_ip",
		},
		{
			"aTargets": [4],
			"mData": "country",
		},
		{
			"aTargets": [5],
			"mData": "carriername",
		},
		{
			"aTargets": [6],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
				var targ_id	=	full.id;
				var status	=	full.is_blocked;
				return action_button(targ_id,status);
			}
		},
		
    	],
    	dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [1, 2, 3,4,5],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                     rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3,4,5 ],
                     rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3, 4, 5 ],
                     rows: '.selected'
                 },
            }  
         
        ]

    };

 
function action_button(targ_id,status)
{
	var rev_url = site_url+'/admin/targeting/edit_targeting/carrier'; 
	var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="table-buttons-optimize" data-target="#modal_edit_carrier" href="'+rev_url+'/'+targ_id+'"><span></span></a>';
	
	var del_url = '';
	var del_btn = '<a data-toggle="modal" role="button" class="table-buttons-delete" title="Delete" onclick="delete_carrier('+targ_id+')"><span></span></a>'; 
	
	if(status==0)
	{  
	   var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testcheck" data-toggle="modal" role="button" class="table-buttons" onclick="blockfunc('+targ_id+');" title="Block" data="'+targ_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-lock"></span></a>';
	}
	else
	{  
		var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testuncheck" data-toggle="modal" role="button" class="table-buttons" onclick="unblockfunc('+targ_id+');"  title="Unblock" data="'+targ_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-key"></i></span></a>';
	}
	return rev_btn+' '+del_btn+' '+block_btn;
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_carrier(targ_id)
{
	$("#del_targ_id").val(targ_id);
    $('#modal_delete_carrier').modal('show');	
}

// Block  Functionality with Confirm Box

	function blockfunc(targ_id)
	{
	 
	 	bootbox.confirm("Are you sure you want to block this carrier ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/block_targeting/format/json',
					data:{'targ_id':targ_id,'api_key':api_key,'targ_type':'carrier','targ_table':targ_table},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){

							custom_opt.dom= 'Bfrtip';
								custom_opt.select=  { 'style':'multi' };
								custom_opt.columnDefs=[
								{
									'checkboxes': {
									   'selectRow': true
										}
									 }
								];
							custom_opt.buttons=[
							{
									extend: 'copyHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'csvHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'excelHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'pdfHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'print',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								} 
					 
							];								 	
								
							$('#carrier_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("carrier_list_length_select");
							new AcostUISelect(t);						
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_targ_msg').attr("data-notify-message",data.msg);
							
							$('#del_targ_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 }


// UnBlock  Functionality with Confirm Box

	function unblockfunc(targ_id)
	{
	 	bootbox.confirm("Are you sure you want to unblock this carrier ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/unblock_targeting/format/json',
					data:{'targ_id':targ_id,'api_key':api_key,'targ_type':'carrier','targ_table':targ_table},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							
								custom_opt.dom= 'Bfrtip';
								custom_opt.select=  { 'style':'multi' };
								custom_opt.columnDefs=[
								{
									'checkboxes': {
									   'selectRow': true
										}
									 }
								];
							custom_opt.buttons=[
							{
									extend: 'copyHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'csvHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'excelHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'pdfHtml5',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								},
								{
									extend: 'print',
									exportOptions: {
										columns: ':visible:not(.not-exported)',
										rows: '.selected' 
									},
								} 
					 
							];	
							
							$('#carrier_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("carrier_list_length_select");
							new AcostUISelect(t);
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_targ_msg').attr("data-notify-message",data.msg);
							
							$('#del_targ_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	}


function carrier_delete()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#del_targ_id").val(box_check);
			$('#modal_delete_carrier').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function carrier_Block()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{ 
			$("#targ_id").val(box_check);
			$('#modal_block_carrier').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function carrier_Unblock()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#untarg_id").val(box_check);
			$('#modal_unblock_carrier').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');  
		}
	 
}
