// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
        "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<img src='"+site_url+"/template/flat/img/loader.gif'>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/payments/fetch_advertiser_deposit_list",
		"aaSorting" : [[0, 'desc']],
		 dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
				{
						extend: 'selectAll',
					   exportOptions: {
								columns: [ 0,1, 2, 3,4,5 ],
							 rows: '.selected'
						},
						action:function(e){
							$('#adv_deposit tbody tr').addClass('selected');
							$('.buttons-select-none').removeClass('disabled');
							$('#adv_deposit tbody tr#tfoot').removeClass('selected');
							var rows= $('#adv_deposit tbody tr.selected').length;
							console.log(rows);
							if(rows>0)
							 {
								 
								 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
							 }
							 else
							 {
								
								 $('.dataTables_info span.rows_select').html("");
							 }
						}
					},
					{
						extend: 'selectNone',
					   exportOptions: {
							columns: [ 0,1, 2, 3,4,5 ],
							 rows: '.selected'
						},
						action:function(e){
							$('#adv_deposit tbody tr').removeClass('selected');
							$('.buttons-select-none').addClass('disabled');
							var rows= $('#adv_deposit tbody tr.selected').length;
							console.log(rows);
							if(rows>0)
							 {
								 
								 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
							 }
							 else
							 {
								
								 $('.dataTables_info span.rows_select').html("");
							 }
						}
					},
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 0,1, 2, 3,4,5 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [  0,1, 2, 3,4,5],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [  0,1, 2, 3,4,5 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                //orientation: 'landscape',
               exportOptions: {
                     columns: [ 0,1, 2, 3,4,5],
                     rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [  0,1, 2, 3,4,5],
                     rows: '.selected'
                 },
            }  
         
        ],
		"aoColumnDefs": [
		{
			"aTargets": [0],
			"mData":"id",
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"asSorting": [ "desc"],
			"aTargets": [1],
			"mData":null,
			"mRender":function (data,type,full) {
			   var paid_date= full.date;
			   return getFormattedDate(paid_date);
			}
		},
		{
			"aTargets": [2],
			"mData":"name",
		},
        {
			"aTargets": [3],
			"mData": "email",
		},
		{
			"aTargets": [4],
			"mData": null,
			"mRender": function (data, type, full) {
			  var amount=currency +' '+full.amount;
			  return amount;
			}
		},
		{
			"aTargets": [5],
			"mData": null,
			"mRender": function (data, type, full) {
			  var pay_type=full.payment_type;
			  var b_id=full.billing_id;
			  return action_button(pay_type,b_id);
		  }
		},
		{
			"aTargets": [6],
			"mData":null,
			"mRender": function (data, type, full) {
				var a= full.admin_approval_status;
			  
				if(a==0)
				{
					return '<a role="button"  class="" title="Pending"><i class="icon-circle" style="color:Red"></i></a>';
				}
				else if(a==1)
				{
					return '<a role="button"  class="" title="Paid"><i class="icon-circle" style="color:green"></i></a>';
				}
				else
				{
					return '<a role="button"  class="" title="Cancelled"><i class="icon-ok-circle" style="color:red"></i></a>';
					
				} 
			}
			
		},
		
    	]
    };

//date seperator
function getFormattedDate(dString)
{
	var d = new Date(dString.split(".")[0].replace(/-/g,"/")); 
	var mm = d.getMonth()+1;
	var dd = d.getDate();
	if (mm<10)mm="0"+mm;
	if (dd<10)dd="0"+dd;
	return d.getFullYear()+"/"+mm+"/"+dd;
}

function action_button(pay_type,b_id)
{	
	if(pay_type==1)
	{ 
		var block_btn = '&nbsp;<a onclick="call_detail('+b_id+');" role="button" class="" data-toggle="modal">Wire</a>';  
	}
	else if(pay_type==2) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="" data-toggle="modal">Paypal</a>';
	}
	else if(pay_type==3) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="" data-toggle="modal">Zpurse</a>';
	}
	else if(pay_type==4) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="" data-toggle="modal">Bitcoin</a>';
	}
	else if(pay_type==5) 
	{
		var block_btn = '&nbsp;<a onclick="return call_detail('+b_id+');" role="button" class="" data-toggle="modal">Authorize</a>';
	}
	
	return block_btn;
}

//$('#submit_search').click(function (){
function run(){	
	var status				=	$('#status').val();
	var payment_type		=	$('#payment_type').val();
	custom_opt.sAjaxSource	=	site_url+"/admin/payments/fetch_advertiser_deposit_list";
	custom_opt.fnServerParams	= function ( aoData ) {
										aoData.push({ "name": "status", "value": status});							 		
										aoData.push({ "name": "payment_type", "value": payment_type});							 		
									};
	custom_opt.fnServerData	= 	function ( sSource, aoData, fnCallback ) {
									$.ajax({
										"dataType": 'json',
										"type": "POST",
										"url": sSource,
										"data":aoData,
										"success":fnCallback,
									  }
									);
								};
	dataTableRedraw();
	//$('.dataTable').dataTable(custom_opt);
//});
}
function dataTableRedraw(){
	$('#adv_deposit.dataTable').dataTable(custom_opt);
	var adv_deposit_ln = document.getElementById('adv_deposit_length_select');
	new AcostUISelect(adv_deposit_ln);
	$('.dataTables_filter input').attr("placeholder", "Search here...");
	//~ $(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
		//~ disable_search_threshold: 9999999
		//~ });
	$("#check_all").click(function(e){
		$('input', oTable.fnGetNodes()).prop('checked',this.checked);
	});
	if($(this).hasClass("dataTable-fixedcolumn")){
		new FixedColumns( oTable );
	}
	if($(this).hasClass("dataTable-columnfilter")){
		oTable.columnFilter({
			"sPlaceHolder" : "head:after"
		});
	}
	//~ resize_chosen();	
}

	$(document).on("click", ".confirm", function(e) {
		//assign values to the variables
		var pay_id=($(this).data('id'));
		var account_id=($(this).data('accountid'));
		var amount=($(this).data('amount'));
	    bootbox.confirm("Are you sure you want to change status for this payment?", function(result) {
  		
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					url: site_url+'/api/v1/approval/payment_approve/format/json',
					data:{'pay_id':pay_id,'account_id':account_id,'amount':amount,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR); 
						if(data.response=='ok'){
							$('select').select2("val", "");
							$('#adv_deposit.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							//~ $(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								//~ disable_search_threshold: 9999999
							//~ });
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							//~ resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#pay_app_msg').attr("data-notify-message",'Status has been changed successfully.');
							
							$('#pay_app_msg').trigger('click');

							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				});				
			}
		}); 
	 
	});
	
