// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"aaSorting" : [[0, 'desc']],
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center'><img src='"+site_url+"/template/flat/img/loader.gif' alt='Loading...'/></div>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/settings/fetch_keyword_list",
	
		"aoColumnDefs": [
		{
			"aTargets": [0],
			"mData":"id",
			"orderable": false,
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('with-checkbox'); // center the link                        
				},
				"mRender"	: function (data, type, full)
				{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
				}
		},
		{
			"aTargets": [1],
			"mData":"id",
			
		},
        {
			"aTargets": [2],
			"mData":"keywords",
		},
       
		{
			"aTargets": [3],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			  var id=full.id;
			  
			  return action_button(id);
			}
		},
		
    	],dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2],
                       rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2],
                     rows: '.selected'
                 },
            }  
         
        ]

    };

 
function action_button(id)
{
	var rev_url = site_url+'/admin/settings/edit_main_keywords'; 
	var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="table-buttons-optimize" data-target="#modal-edit-main-keywords" href="'+rev_url+'/'+id+'"><span></span></a>';
	
	var del_url = '';
	var del_btn = '<a data-toggle="modal" role="button" class="table-buttons-delete" title="Delete" onclick="delete_cat('+id+')"><span></span></a>';
	
    	 
	return rev_btn+' '+del_btn;
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_cat(id)
{
	$("#single_del_category_id").val(id);
    $('#modal_delete_main_keyword').modal('show');	  
}


// Block  Functionality with Confirm Box

	function blockfunc(category_id)
	{	 
	 	bootbox.confirm("Are you sure you want to block this category ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/block_category/format/json',
					data:{'cat_id':category_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok')
						{							
						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
								  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							} 
				 
						];	
																					
							$('#main_category_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("main_category_list_length_select");
							new AcostUISelect(t);	
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_cat_msg').attr("data-notify-message",data.msg);
							
							$('#del_cat_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 }


// UnBlock  Functionality with Confirm Box

	function unblockfunc(category_id)
	{	 
	 	bootbox.confirm("Are you sure you want to unblock this category ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/targeting/unblock_category/format/json',
					data:{'cat_id':category_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){

						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
								  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
								  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									  columns: [ 1, 2, 3 ],
									rows: '.selected' 
								},
							} 
				 
						];	
			
														
							$('#main_category_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("main_category_list_length_select");
							new AcostUISelect(t);							
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_cat_msg').attr("data-notify-message",data.msg);							
							$('#del_cat_msg').trigger('click');	  
						}
						else
						{
							//validator.showErrors(data.msg);
						}
			
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	}
function main_cat_Block()
{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();


		if(box_check!="")	
		{
			$("#cat_id").val(box_check);
				$('#modal_block_main_category').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
}

function main_cat_Unblock()
{
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
		$("#sub_cat_id").val(box_check);
		$('#modal_unblock_main_category').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function delete_main_cat()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
	   $("#maincat_id").val(box_check);
		$('#modal_del_main_category').modal('show');
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

