// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/template/flat/img/ajax-loader.gif' alt='Loading...' /></div>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/geo_settings/fetch_geo_list",
        	
		"aoColumnDefs": [
		{
			"aTargets": [0],
			"mData":"id",
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [1],
			"mData":"cpm_value",
		},
        {
			"aTargets": [2],
			"mData": "country_name",
		},
		{
			"aTargets": [3],
			"mData":null,
			"sClass":"table-buttons",
			"mRender": function (data, type, full) {
				var geo_id=full.id;
				var status=full.status;//Get blocked status
			  return action_button(geo_id,status);
			}
		},
		
    	],
    	dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
				{
						extend: 'selectAll',
					   exportOptions: {
						    columns: [ 0,1,2],
							 rows: '.selected'
						},
						action:function(e){
							$('#geo_list tbody tr').addClass('selected');
							$('.buttons-select-none').removeClass('disabled');
							var rows= $('#geo_list tbody tr.selected').length;
							console.log(rows);
							if(rows>0)
							 {
								 
								 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
							 }
							 else
							 {
								
								 $('.dataTables_info span.rows_select').html("");
							 }
						}
					},
					{
						extend: 'selectNone',
					   exportOptions: {
						    columns: [ 0,1,2],
							rows: '.selected'
						},
						action:function(e){
							$('#geo_list tbody tr').removeClass('selected');
							$('.buttons-select-none').addClass('disabled');
							var rows= $('#geo_list tbody tr.selected').length;
							console.log(rows);
							if(rows>0)
							 {
								 
								 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
							 }
							 else
							 {
								
								 $('.dataTables_info span.rows_select').html("");
							 }
						}
					},
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 0,1, 2 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 0,1, 2 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 0,1, 2 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 0,1, 2],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 0,1, 2],
                      rows: '.selected'
                 },
            }  
         
        ]

    };

 
function action_button(geo_id,status)
{
	var rev_url = site_url+'/admin/geo_settings/edit_geo'; 
	var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="table-buttons-optimize" data-target="#modal-edit-geo" href="'+rev_url+'/'+geo_id+'"><span></span></a>';
	
	var del_url = '';
	var del_btn = '<a role="button" class="table-buttons-delete site" data-id="'+geo_id+'" title="Delete" data-toggle="modal" onclick="delete_geo('+geo_id+')"><span></span></a>';
	
    if(status==0)
	{
	   var block_btn = '<a role="button" onclick="blockfunc('+geo_id+');" id="blockbutton" class="table-buttons confirm" title="Block" data="'+geo_id+'" data-bb="confirm"><span><i class="icon-lock" id="lock-icon"></i></span></button>';
	}
	else 
	{
		var block_btn = '<a role="button" onclick="unblockfunc('+geo_id+');" id="blockbutton" class="table-buttons confirm_unblock" title="Unblock"  data="'+geo_id+'" data-bb="confirm"><span><i class="icon-key" id="lock-icon"></i></span></a>';
	}
	//var block_btn = '<button class="btn btn-small btn-success" data-id="'+geo_id+'" data-toggle="modal" onclick="block_manager('+geo_id+')"><i class="icon-lock"></i>&nbsp;&nbsp;Block</button>';
	 
	return rev_btn+' '+del_btn+' '+block_btn;
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function delete_geo(geo_id)
{
	console.log('cat_id'+geo_id);
	$("#del_geo_id").val(geo_id);
    $('#modal_delete_geo').modal('show');	
}


// Block  Functionality with Confirm Box

	//$(document).on("click", ".confirm", function(e) {
		function blockfunc(block_id){
	 
	 	bootbox.confirm("Are you sure you want to block this geo setting ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/geo_settings/block_geo/format/json',
					data:{'geo_id':block_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						if(data.response == 'ok'){
							 
							//$('select').select("val", "");
							
							custom_opt.sDom= 'T<"clear">lfrtip';
							custom_opt.sDom=  'B<"clear">lfrtip';
							custom_opt.buttons= [   
							{
								extend: 'selectAll'
							},
							{
								extend: 'selectNone'
							},
							{
								extend: 'copyHtml5'
							},
							{
								extend: 'csvHtml5'
							},
							{
								extend: 'excelHtml5'
							},
							{
								extend: 'pdfHtml5'
							},
							{
								extend: 'print'
							}
						 
							];  
						
							
							$('#geo_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							// $(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
							// 	disable_search_threshold: 9999999
							// 	});
							var t = document.getElementById("geo_list_length_select");		
							new AcostUISelect(t);	
							/*if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}*/
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_cat_msg').attr("data-notify-message",data.msg);
							
							$('#del_cat_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 }
	 
	 //});


// UnBlock  Functionality with Confirm Box

	//$(document).on("click", ".confirm_unblock", function(e) {
		function unblockfunc(unblock_id) {
	 
	 	bootbox.confirm("Are you sure you want to unblock this geo setting ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/geo_settings/unblock_geo/format/json',
					data:{'geo_id':unblock_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							 
							//$('select').select("val", "");
							
							custom_opt.sDom= 'T<"clear">lfrtip';
							custom_opt.sDom=  'B<"clear">lfrtip';
							custom_opt.buttons= [   
								{
								extend: 'selectAll'
								},
								{
									extend: 'selectNone'
								},
								{
									extend: 'copyHtml5'
								},
								{
									extend: 'csvHtml5'
								},
								{
									extend: 'excelHtml5'
								},
								{
									extend: 'pdfHtml5'
								},
								{
									extend: 'print'
								}						 
								];  						
							
							
							$('#geo_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							// $(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
							// 	disable_search_threshold: 9999999
							// });
							var t = document.getElementById("geo_list_length_select");		
							new AcostUISelect(t);
							
							/*$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}*/
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_cat_msg').attr("data-notify-message",data.msg);
							
							$('#del_cat_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 }
	 
	//});
$('#geo_list tbody').on('click', 'tr td', function(e){
		
		var rows= $('#geo_list tbody tr.selected').length;
		//console.log(rows);
     if(rows>0)
	 {
		 
		 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
	 }
	 else
	 {
		
		 $('.dataTables_info span.rows_select').html("");
	 }
 
     });
