// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/template/flat/img/ajax-loader.gif' alt='Loading...' /></div>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/adblock_domains/adblock_domain_list",
          	
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			"orderable": false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
				var checkbox=	"<input name='check_all' class='checkbox_count' id='check_all' value='"+data+"' type='checkbox'>";
				return checkbox;
			}			
		},		
		{
			"aTargets": [1],
			"mData":"id",			
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('checkbox_id'); // Remove border                        
			},							
			"mRender": function (data, type, full)
			{
				return full.row_number;  
			}
		},	
        {
			"aTargets": [2],
			"mData":"status",
			"mRender": function (data, type, full) {
				var domain_id=full.id;
				var status=full.status;//Get blocked status
			  return blk_unblk_button(domain_id,status);
			}			
		},		
        {
			"aTargets": [3],
			"mData":"DATE",
		},
        {
			"aTargets": [4],
			"mData":"url",
		},

        {
			"aTargets": [5],
			"mData":null,
			"sClass":"table-buttons",
			"mRender": function (data, type, full) {
				var domain_id=full.id;
				var status=full.status;//Get blocked status
			  return action_button(domain_id,status);
			}
		},
		
    	],
    	dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
				{
						extend: 'selectAll',
					   exportOptions: {
						    columns: [ 0,1,2,3,4],
							 rows: '.selected'
						},
						action:function(e){
							$('#domain_list tbody tr').addClass('selected');
							$('.buttons-select-none').removeClass('disabled');
							var rows= $('#domain_list tbody tr.selected').length;
							console.log(rows);
							if(rows>0)
							 {								 
								 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
							 }
							 else
							 {
								
								 $('.dataTables_info span.rows_select').html("");
							 }
						}
					},
					{
						extend: 'selectNone',
					   exportOptions: {
						    columns: [ 0,1,2,3,4],
							rows: '.selected'
						},
						action:function(e){
							$('#domain_list tbody tr').removeClass('selected');
							$('.buttons-select-none').addClass('disabled');
							var rows= $('#domain_list tbody tr.selected').length;
							console.log(rows);
							if(rows>0)
							 {
								 
								 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
							 }
							 else
							 {
								
								 $('.dataTables_info span.rows_select').html("");
							 }
						}
					},
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 0,1,2,3,4],
                       rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 0,1,2,3,4],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 0,1,2,3,4],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 0,1,2,3,4],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',                
                exportOptions: {
                     columns: [ 0,1,2,3,4],
                      rows: '.selected'
                 },
            }  
         
        ]

    };

 
function action_button(domain_id,status)
{
	var rev_url = site_url+'/admin/adblock_domains/edit_domain'; 
	var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="table-buttons-optimize" data-target="#modal-edit-domain" href="'+rev_url+'/'+domain_id+'"><span></span></a>';
	
	var del_url = '';
	var del_btn = '<a role="button" class="table-buttons-delete" title="Delete" data-id="'+domain_id+'" onclick="domain_delete('+domain_id+')"><span></span></a>';

	
	
    if(status==0)
	{
	   var block_btn = '<a role="button" onclick="blockfunc('+domain_id+');" id="blockbutton" class="table-buttons btn-danger confirm" title="Block" data="'+domain_id+'" data-bb="confirm"><span><i class="icon-lock" id="lock-icon"></i></span></a>';
	}
	else 
	{
		var block_btn = '<a role="button" id="blockbutton" class="table-buttons btn-success confirm_unblock" title="Unblock"  onclick="unblockfunc('+domain_id+');" data="'+domain_id+'" data-bb="confirm"><span><i class="icon-key" id="lock-icon"></i><span></a>';

	}
	 
	return rev_btn+' '+del_btn+' '+block_btn;
}

function blk_unblk_button(domain_id,status)
{
    if(status==0)
	{
	   var block_btn = '<button onclick="blockfunc('+domain_id+');" class="btn btn-small confirm" title="Block" data="'+domain_id+'" data-bb="confirm" style="background:none !important;"><i class="icon-circle" style="color:red"></i></button>';
	}
	else 
	{
		var block_btn = '<button class="btn btn-small confirm_unblock" title="Unblock"  data="'+domain_id+'" data-bb="confirm" onclick="unblockfunc('+domain_id+');"  style="background:none !important;"><i class="icon-circle" style="color:green"></i></button>';

	}
	 
	return block_btn;
}

$('.modal').on('hidden', function () {
	$(this).removeData('modal');
});

function domain_delete(domain_id)
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	
	if(box_check!="")	
		{
			$("#delete_domain_id").val(box_check);
			$('#modal_delete_domain').modal('show');	
		}
		else
		{  
			$("#delete_domain_id").val(domain_id);
			$('#modal_delete_domain').modal('show');
		}

}

function domain_Block()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{ 
			$("#domain_id").val(box_check);
			$('#modal_block_domain').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function domain_Unblock()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#unblock_domain_id").val(box_check);
			$('#modal_unblock_domain').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}


// Block  Functionality with Confirm Box
function blockfunc(block_id)
{
	//$(document).on("click", ".confirm", function(e) {
	 
	 	bootbox.confirm("Are you sure you want to block this domain ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/adblock_domains/block_domain/format/json',
					data:{'domain_id':block_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						console.log(jqXHR);
						if(data.response == 'ok'){	

							custom_opt.sDom= 'T<"clear">lfrtip';
							custom_opt.sDom=  'B<"clear">lfrtip';
							custom_opt.buttons= [   
							{
								extend: 'selectAll'
							},
							{
								extend: 'selectNone'
							},
							{
								extend: 'copyHtml5'
							},
							{
								extend: 'csvHtml5'
							},
							{
								extend: 'excelHtml5'
							},
							{
								extend: 'pdfHtml5'
							},
							{
								extend: 'print'
							}
						 
							];  
																				
							$('#domain_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("domain_list_length_select");		
							new AcostUISelect(t);
							// $(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
							// 	disable_search_threshold: 9999999
							// 	});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#domain_msg').attr("data-notify-message",data.msg);
							
							$('#domain_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	//});
}


// UnBlock  Functionality with Confirm Box

	//$(document).on("click", ".confirm_unblock", function(e) {
	 function unblockfunc(unblock_id) 
	 {
	 	bootbox.confirm("Are you sure you want to unblock this domain ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/adblock_domains/unblock_domain/format/json',
					data:{'unblock_domain_id':unblock_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok' && data.result!=false){
							
							custom_opt.sDom= 'T<"clear">lfrtip';
							custom_opt.sDom=  'B<"clear">lfrtip';
							custom_opt.buttons= [   
							{
								extend: 'selectAll'
							},
							{
								extend: 'selectNone'
							},
							{
								extend: 'copyHtml5'
							},
							{
								extend: 'csvHtml5'
							},
							{
								extend: 'excelHtml5'
							},
							{
								extend: 'pdfHtml5'
							},
							{
								extend: 'print'
							}
						 
							];  
																			 
							$('#domain_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("domain_list_length_select");		
							new AcostUISelect(t);
							// $(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
							// 	disable_search_threshold: 9999999
							// });
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#domain_msg').attr("data-notify-message",data.msg);
							
							$('#domain_msg').trigger('click');	
						}
						else
						{
												
							$('#domain_msg').attr("data-notify-message",data.msg);
							
							$('#domain_msg').trigger('click');	
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	//});
}
$('#domain_list tbody').on('click', 'tr td', function(e){
		
		var rows= $('#domain_list tbody tr.selected').length;
		//console.log(rows);
     if(rows>0)
	 {
		 
		 $('.dataTables_info span.rows_select').html('- '+rows+' rows selected');
	 }
	 else
	 {
		
		 $('.dataTables_info span.rows_select').html("");
	 }
 
     });  
