// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/templates/theme/img/loader.gif' alt='Loading...' /></div>",						
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/news/admin_news_list",
	
		"aoColumnDefs": [
		{
			"aTargets": [0],
			"mData":"sno",
		},
        {
			"aTargets": [1],
			"mData":"date",
		},
        {
			"aTargets": [2],
			"mData": "heading",
		},
		{
			"aTargets"	: [3],
			"mData"		:"is_display",
			"mRender"	:function(data,type,full)
			{
				if(full.is_display==0)
				{
					return '<span style="color:red">Blocked</span>';
				}
				else
				{
					return '<span style="color:green">Displaying</span>';
				}
			}			 
			 
		},	
		{
			"aTargets": [4],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			 return news_action(full);
			}
		},		
    	],
		dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
		],
        select:
        {
			style:'multi'
		},
		buttons: [
			    {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 0,1, 2, 3 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 0,1, 2, 3 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 0,1, 2, 3 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 0,1, 2, 3 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 0,1, 2, 3 ],
                     rows: '.selected'
                 },
            }  
         
        ]
    };

 
function news_action(full)
{
	var display='';
	if(full.is_display==0)
	{	
	display  ='<a role="button" style="box-sizing:content-box;top:-12px;" title="Display" class="table-buttons" onclick="run('+full.sno+')" ><span><i id="lock-icon" class="icon-play-circle"></i></span></a>' ;
	}
	else 
	{ 
	display  ='<a role="button" style="box-sizing:content-box;top:-12px;" id="'+full.sno+'" title="Block" class="table-buttons" onclick="pause('+full.sno+')"><span><i id="lock-icon" class="icon-off"></i></span></a>' ;
	}
	
	var edit_url ='<a role="button" title="Review" class="table-buttons-optimize" href="'+site_url+'/admin/news/edit_news/'+full.sno+'"><span></span></a>';
	return display+' '+edit_url;	
}

function pause(sno)
{	 
	 	bootbox.confirm("Are you sure you want to pause this News ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					format:'json',
					url: site_url+'/api/v1/news/block/format/json',
					data:{'sno':sno,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){				
						
						if(data.response == 'ok'){
							
						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							} 
				 
						];							
																							
							$('#news_content.dataTable').dataTable(custom_opt).fnDraw();
							
							var t = document.getElementById("news_content_length_select");
							new AcostUISelect(t);
							
							//$('#save_site').unbind('click');
							$('#news_msg').attr("data-notify-message",data.msg);							
							$('#news_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
}

function run(sno)
{
	bootbox.confirm("Are you sure you want to run this News ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					format:'json',
					url: site_url+'/api/v1/news/run/format/json',
					data:{'sno':sno,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){				
						
						if(data.response == 'ok'){
							
						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							} 
				 
						];							
																							
							$('#news_content.dataTable').dataTable(custom_opt).fnDraw();
							
							var t = document.getElementById("news_content_length_select");
							new AcostUISelect(t);
							
							//$('#save_site').unbind('click');
							$('#news_msg').attr("data-notify-message",data.msg);							
							$('#news_msg').trigger('click');	
						}
						else
						{
							$('#news_msg').attr("data-notify-message",data.msg);  
							$('#news_msg').attr("data-notify-title",'error');
							$('#news_msg').trigger('click');
						}				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
	});
	
}
