// dataTables

var account_id = $('#manager_account_id').val();

//Preload with the first column since you know it will always be there
var includedColumns = [{ 	
							"mData"		:"user_id",
							 "orderable": false,
							"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
							{
								$(nTd).addClass('with-checkbox'); // center the link                        
							},
							"mRender"	: function (data, type, full)
							{	
								var checkbox=	"<input class='count_check' name='check_all' id='check_all' value='"+data+"' type='checkbox'>";
								return checkbox;
							}
						}];
includedColumns.push({ 	"mData"		: "user_id",
						"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
						{
							$(nTd).addClass('checkbox_id'); // Remove border                        
						},
						//"asSorting": [ "desc","asc"],
						"mRender": function (data, type, full)
						{
							return full.row_number;
						}
						});
//Add additional columns
includedColumns.push({ 	"mData"		:null,
						"mRender"	: function (data, type, full)
						{
							return full.contact_name.charAt(0).toUpperCase()+full.contact_name.slice(1);
						}
					});
includedColumns.push({ "mData"		: "email_address" });
includedColumns.push({ "mData"		: "role_name" });
if (check_manager_permission('113') || check_manager_permission('115'))
{
	includedColumns.push({ 	"mData"		: null,

						"sClass":"no-print table-buttons",

						"mRender"	: function (data, type, full) {

							var user_id	=	full.user_id;

							var account_id	=	full.default_account_id;

							var status		=	full.user_status;
							
							var is_default		=	full.default_user;
							
							var role_block		=	full.role_block;

							return action_button(user_id,account_id,status,is_default,role_block);

						}
					});
}

$.each(includedColumns, function (i, column) {
	column.aTargets = [i];
});

//options dataTable

var custom_opt = {

        "bProcessing": true,

        "bAutoWidth": false,

		"bDestroy" : true,
		
		"iDisplayLength" : parseInt(app_configdefault_per_page),

        "oLanguage":{

						"sSearch": "<span>Search:</span> ",

						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						
						"sProcessing": "<img src='"+site_url+"/templates/theme/img/loader.gif'>",

						"sLengthMenu": "_MENU_ <span>entries per page</span>"

					},

        "sPaginationType": "full_numbers",

        "sAjaxSource": site_url+"/admin/managers/fetch_manager_user/"+account_id,
		//"aaSorting": [ 0,"desc"],
		// "aaSorting" : [[1, 'desc']],
		"aoColumnDefs": includedColumns,
		dom: 'Bfrtip',
         'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
  buttons: [
               {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4 ],
                     rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3,4 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                      columns: [ 1, 2, 3,4 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                orientation: 'landscape',
                exportOptions: {
                      columns: [ 1, 2, 3,4 ],
                      rows: '.selected'
                 },
            }  
         
        ]
    };

// Action 

function action_button(user_id,account_id,status,is_default,role_block)
{

	if(is_default==0)
	{	
		if(check_manager_permission('113')){
			var rev_url = site_url+'/admin/managers/edit_manager_user'; 

			var rev_btn = '<a data-toggle="modal" role="button" title="Review" class="table-buttons-optimize" data-target="#modal_edit_manager_user" data_backdrop="static" href="'+rev_url+'/'+user_id+'/'+account_id+'"><span></span></a>';
		}
		else
		{
			var rev_btn='';	
		}
	
		if(role_block!=1)
		{
			if(check_manager_permission('115'))
			{  
				if(status==1)			
				{			
					var block_btn = '&nbsp;<a  role="button" id="blockbutton" class="btn-color confirm" title="Block" onclick="block_user('+user_id+')" data="'+user_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-lock"></i></span></a>';
				}			
				else			
				{			
					var block_btn = '&nbsp;<a  role="button"  id="blockbutton" class="btn-color confirm_unblock" onclick="unblock_user('+user_id+')" title="Unblock" data="'+user_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-key"></i></span></a>';
				}
			}
			else
			{
			   var block_btn	=	'';	
			}
		}
		else
		{
			var block_btn='( Role is Blocked ) ';	
		}
	}
 	else
	{
		var  block_btn	=	'';
		var  rev_btn	=	'(Default-Manager)';
	}
 
	return rev_btn+block_btn;

}



$('.modal').on('hidden', function () {

	$(this).removeData('modal');

});


function delete_manager(account_id)
{

	$("#del_account_id").val(account_id);

    $('#modal_delete_manager').modal('show');	

}

// Block  Functionality with Confirm Box

	//$(document).on("click", ".confirm", function(e) {
function block_user(user_id)
{
	 	bootbox.confirm("Are you sure you want to block this users ?", function(result) {

  			//alert(result);

			if(result===true){

				// AJAX request to get the data

				$.ajax({

					// URL from the link that was clicked on

					type:'GET',

					url: site_url+'/api/v1/manager/block_manager_users/format/json',

					data:{'id':user_id,'api_key':api_key},//$(e.target).attr('data')

					// Success function. the 'data' parameter is an array of objects that can be looped over

					success: function(data, textStatus, jqXHR){

						//console.log(jqXHR);

						if(data.response == 'ok'){

							$('select').val("");
								exportdatabutton();
						$('#item').hide();
							$('#manager_user_list.dataTable').dataTable(custom_opt).fnDraw();

							/*$('.dataTables_filter input').attr("placeholder", "Search here...");

							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({

								disable_search_threshold: 9999999

							});

							if($(this).hasClass("dataTable-fixedcolumn")){

								new FixedColumns( oTable );

							}

							if($(this).hasClass("dataTable-columnfilter")){

								oTable.columnFilter({

									"sPlaceHolder" : "head:after"

								});

							}

							resize_chosen();	*/
							
							//$('#save_site').unbind('click');
							var select_element=document.getElementById('manager_user_list_length_select');
							new AcostUISelect(select_element);	

							$('#block_manager_msg').attr("data-notify-message",data.msg);

							$('#block_manager_msg').trigger('click');	

						}
						else
						{
							//validator.showErrors(data.msg);
						}			

					}, 

					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 

					error: function(jqXHR, textStatus, errorThrown){

					//alert('Oh no! A problem with the AJAX request!');

					}

				}); 

			}

		});

	//});
}
	// UnBlock  Functionality with Confirm Box
function unblock_user(user_id)
{
	//$(document).on("click", ".confirm_unblock", function(e) {

	 	bootbox.confirm("Are you sure you want to unblock this users ?", function(result) {

  			//alert(result);

			if(result===true){

				// AJAX request to get the data

				$.ajax({

					// URL from the link that was clicked on

					type:'GET',

					url: site_url+'/api/v1/manager/unblock_manager_users/format/json',

					data:{'id':user_id,'api_key':api_key},//$(e.target).attr('data')

					// Success function. the 'data' parameter is an array of objects that can be looped over

					success: function(data, textStatus, jqXHR){

						//console.log(jqXHR);

						if(data.response == 'ok'){

							$('select').val( "");
					exportdatabutton();
						$('#item').hide();
							$('#manager_user_list.dataTable').dataTable(custom_opt).fnDraw();

						/*	$('.dataTables_filter input').attr("placeholder", "Search here...");

							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({

								disable_search_threshold: 9999999

							});

							$("#check_all").click(function(e){

								$('input', oTable.fnGetNodes()).prop('checked',this.checked);

							});

							if($(this).hasClass("dataTable-fixedcolumn")){

								new FixedColumns( oTable );

							}

							if($(this).hasClass("dataTable-columnfilter")){

								oTable.columnFilter({

									"sPlaceHolder" : "head:after"

								});

							}

							resize_chosen();	*/
							
							//$('#save_site').unbind('click');
							var select_element=document.getElementById('manager_user_list_length_select');
							new AcostUISelect(select_element);	

							$('#block_manager_msg').attr("data-notify-message",data.msg);

							$('#block_manager_msg').trigger('click');	

						}
						else
						{
							//validator.showErrors(data.msg);
						}			

					}, 

					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 

					error: function(jqXHR, textStatus, errorThrown){

					//alert('Oh no! A problem with the AJAX request!');

					}

				}); 

			}

		}); 

	 //});
}

function muser_Block()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#id").val(box_check);
			$('#modal_block_manager_user').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function muser_Unblock()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{
			$("#unbl_id").val(box_check);
			$('#modal_unblock_manager_user').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}
