// dataTables
//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<img src='"+site_url+"/template/flat/img/loader.gif'>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/careers/fetch_careers",
	
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
			}	
			
		},
		{
			"aTargets": [1],
			"mData":"id",
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":"job_category",
		},
		 {
			"aTargets": [3],
			"mData":"job_title",
		},
		{
			"aTargets": [4],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			  var id=full.id;
			  var status=full.is_blocked;//Get blocked status
			  return action_button(id,status);
			}
		},
		
    	],
    	dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                orientation: 'landscape',
                exportOptions: {
                     columns: [ 1, 2, 3,4,5 ],
                     rows: '.selected'
                 },
            }  
         
        ]		
    };


function action_button(id,status)
{
	var rev_url = site_url+'/admin/careers/edit_careers'; 
	var rev_btn = '<a data-toggle="modal" role="button"  class="table-buttons-optimize" href="'+rev_url+'/'+id+'"><span></span></a>';
		
	var del_btn = '<a data-toggle="modal" role="button" class="table-buttons-delete" title="Delete" onclick="delete_careers('+id+')"><span></span></a>'; 
	
	
	if(status==0)
	{  
	   var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testcheck" data-toggle="modal" role="button" class="table-buttons" onclick="blockfunc('+id+');" title="Block" data="'+id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-lock"></span></a>';
	}
	else
	{  
		var block_btn = '&nbsp;<a style="box-sizing:content-box;top:-12px;" id="testuncheck" data-toggle="modal" role="button" class="table-buttons" onclick="unblockfunc('+id+');"  title="Unblock" data="'+id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-key"></i></span></a>';
	}
	 return rev_btn+' '+del_btn+' '+block_btn;
}

function delete_careers(id)
{
	$("#id").val(id);
    $('#modal_delete_careers').modal('show');	
}

$('.modal').on('hidden', function () {
$(this).removeData('modal'); 
});


function blockfunc(id)
	{	 
	       bootbox.confirm("Are you sure you want to block this career ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/jobs/block_careers/format/json',
					data:{'id':id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){			
							
						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							} 
				 
						];	
			
												
							$('#careers_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("careers_list_length_select");
							new AcostUISelect(t);
							
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_careers_msg').attr("data-notify-message",data.msg);
							
							$('#del_careers_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	}


// UnBlock  Functionality with Confirm Box

	function unblockfunc(id)
	{	 
	 	bootbox.confirm("Are you sure you want to unblock this career ?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/jobs/unblock_careers/format/json',
					data:{'id':id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){	

						custom_opt.dom= 'Bfrtip';
						custom_opt.select=  { 'style':'multi' };
						custom_opt.columnDefs=[
							 {
								'checkboxes': {
								   'selectRow': true
									}
								 }
							  ];
						custom_opt.buttons=[
						{
								extend: 'copyHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'csvHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'excelHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'pdfHtml5',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							},
							{
								extend: 'print',
								exportOptions: {
									columns: ':visible:not(.not-exported)',
									rows: '.selected' 
								},
							} 
				 
						];	
			
													
							$('#careers_list.dataTable').dataTable(custom_opt).fnDraw();
							var t = document.getElementById("careers_list_length_select");
							new AcostUISelect(t);							
							resize_chosen(); 	
							
							//$('#save_site').unbind('click');
							$('#del_careers_msg').attr("data-notify-message",data.msg);							
							$('#del_careers_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	}
