// dataTables
jQuery.ajax({
		
		type:'GET',
		url: site_url+'/api/v1/app_settings/get_values',
		dataType: 'json',
		async:false,
		data:{'api_key':api_key,'network_id':'1'},
		success: function(data, textStatus, jqXHR){
				app_configdefault_per_page = data[0].default_per_page;
				}, 
		error: function(jqXHR, textStatus, errorThrown){
		}
		}); 

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
        "iDisplayLength" : parseInt(app_configdefault_per_page),
        "bDestroy": true,
       
        "bDom":'Bfrtip',
       "sPaginationType": "full_numbers",
       "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<img src='"+site_url+"/template/flat/img/loader.gif'>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
               dom: 'Bfrtip',
	    'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            }  
         
        ],
        "sAjaxSource": site_url+"/admin/network/fetch_country_list",
	
		"aoColumnDefs": [
			{
				"aTargets"	: [0],
				"mData"		:"id",
				"orderable":false,
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('with-checkbox'); // center the link                        
				},
				"mRender"	: function (data, type, full)
				{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
				}
			},
			{
				"aTargets": [1],
				"mData": "id",
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('checkbox_id'); // Remove border                        
				},
				"mRender": function (data, type, full)
				{
					return full.row_number;
				}
			},
			{
				"aTargets": [2],
				"mData":"clientname",
				"mRender": function (data, type, full)
				{
					return data.charAt(0).toUpperCase() + data.slice(1);
				}	
				
			},
			{
				"aTargets": [3],
				"mData":"camp_name",
							"mRender": function (data, type, full)
				{
					return campaign_name(full);
				}	
				
			},
			
			{
				"aTargets": [4],
				"mData":"rev_type",
				
			},
			{
				"aTargets": [5],
				"mData":"name",
				"mRender": function (data, type, full)
				{
					return country_name(full);
				}
				
			},
			{
				"aTargets": [6],
				"mData":"bidding",
			},
			{
				"aTargets": [7],
				"mData": "status",
				"sClass":"no-print table-buttons",
				"mRender": function (data, type, full)
				{
					return action_column(full);
				}
				
			}
		
    	]/*,
		"fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
			var index = (iDisplayIndexFull + 1);
			$("td:first", nRow).html(index);
			return nRow;
		}*/
    };
    
    
function country_name(full)
{
	if(full.name != null)
	{
		return full.name.charAt(0).toUpperCase() + full.name.slice(1);
	}
	else
	{
		return full.name;
	}
}

function campaign_name(full)
{
	if(full.camp_name)
	{
		return full.camp_name.charAt(0).toUpperCase() + full.camp_name.slice(1);
	}
	else
	{
		return '';
	}
}
    
function action_column(full)
{	
	
		
	var edit_url = site_url+'/admin/network/edit_countrywise_bidding';
	//var delete_url = site_url+'/admin/network/delete_countrywise_bidding';
	
	var data_target="#modal_countrywise_edit";  
	
	var data_backdrop="static";
	
	var edit_btn = '<a data-toggle="modal" role="button"  class="table-buttons-optimize" title="Edit" data-target="'+data_target+'" data-backdrop="'+data_backdrop+'" href="'+edit_url+'/'+full.id+'"><span></span></i></a>';
	
	var delete_btn = '<a data-toggle="modal" role="button"  class="table-buttons-delete" title="Delete" onclick="delete_country_bidding('+full.id+')"><span></span></a>';
	
	//var del_btn = '&nbsp;<button class="btn btn-small site confirm"  data="'+data+'" data-bb="confirm"><i class="icon-trash"></i>&nbsp;&nbsp;Delete</i></button>';
		
	return edit_btn+''+delete_btn;

	
}

//Delete a country bidding

function delete_country_bidding(country_id)
{
	
	$("#delete_country_id").val(country_id);
    $('#modal_del_country').modal('show');	
}

function delete_bidd()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();

		if(box_check!="")	
		{console.log(box_check);
			$("#bidd_id").val(box_check);
			$('#form_delete_bidd').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}
function run(){	
	var campaign		    =	$('#cam_name').val();  
	var campaign_type		=	$('#campaign_type').val();
	custom_opt.sAjaxSource	=	site_url+"/admin/network/fetch_country_list";
	custom_opt.fnServerParams	= function ( aoData ) {
										aoData.push({ "name": "campaign_type", "value": campaign_type});							 		
										aoData.push({ "name": "campaign", "value": campaign});							 		
									};
	custom_opt.fnServerData	= 	function ( sSource, aoData, fnCallback ) {
									$.ajax({
										"dataType": 'json',
										"type": "POST",
										"url": sSource,
										"data":aoData,
										"success":fnCallback,
									  }
									);
								};
	dataTableRedraw();	

}
function dataTableRedraw(){
	$('#bidding_list.dataTable').dataTable(custom_opt);
	 var t = document.getElementById("bidding_list_length_select");	
  						new AcostUISelect(t);
	/*$('.dataTables_filter input').attr("placeholder", "Search here...");
	$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
		disable_search_threshold: 9999999
		});*/
	$("#check_all").click(function(e){
		$('input', oTable.fnGetNodes()).prop('checked',this.checked);
	});
	if($(this).hasClass("dataTable-fixedcolumn")){
		new FixedColumns( oTable );
	}
	if($(this).hasClass("dataTable-columnfilter")){
		oTable.columnFilter({
			"sPlaceHolder" : "head:after"
		});
	}
	resize_chosen();	
}

function import_countrywise()
{
	$('#countrywise_import').modal('show');       
}

function export_countrywise()
{
	
	
	
        var camparr = jQuery("input:checkbox:checked").map(function(i, el) {
            return jQuery(el).attr("value");
        }).get();
        if (camparr != '') {
            jQuery("#export_campaign_id").val(camparr);
            jQuery('#modal_export_country').modal('show');
        } else {
            $('#modal_no_selection').modal('show');   
        }
    
}
