// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"aaSorting" : [[1, 'desc']],
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/template/flat/img/ajax-loader.gif' alt='Loading...' /></div>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        dom: 'Bfrtip',
	     'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                       rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                //orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3,4,5,6 ],
                     rows: '.selected'
                 },
            }  
         
        ],
        "sAjaxSource": site_url+"/admin/approvals/fetch_payment_list",
		//"aaSorting" : [[0, 'desc']],
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			"orderable": false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
				var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox' data-account_id='"+full.account_id+"' data-amount='"+full.amount+"' >";
				return checkbox;
			}
		},
		{
			"aTargets": [1],
			"mData":"id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('checkbox_id'); // Remove border                        
				},
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":null,
			"mRender":function (data,type,full) {
			   var paid_date= full.date;
			   return getFormattedDate(paid_date);
			}
		},
		{
			"aTargets": [3],
			"mData":"name",
		},
        {
			"aTargets": [4],
			"mData": "email",
		},
		{
			"aTargets": [5],
			"mData": null,
			"mRender": function (data, type, full) {
			  var amount=currency +' '+full.amount;
			  return amount;
			}
		},
		{
			"aTargets": [6],
			"mData": "payment_type",
		},
		{
			"aTargets": [7],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			  return action_button(full);
			}
		},
		
    	]
    };

//date seperator
function getFormattedDate(dString)
{
	var d = new Date(dString.split(".")[0].replace(/-/g,"/")); 
	var mm = d.getMonth()+1;
	var dd = d.getDate();
	if (mm<10)mm="0"+mm;
	if (dd<10)dd="0"+dd;
	return d.getFullYear()+"/"+mm+"/"+dd;
}

function action_button(full)
{
	
	var view_url = site_url+'/admin/approvals/payment_details_viewmore';
	var view_btn = '<a id="blockbutton" data-toggle="modal" role="button" title="Viewmore" class="table-buttons" data-target="#modal_payment_details_view" href="'+view_url+'/'+full.id+'"><span><i id="lock-icon" class="glyphicon-more_windows"></i></span></a>';

	var app_url = '';
	
	// var app_btn = '<a button class="btn btn-small site confirm" title="Approve" id="approve" data-accountid="'+full.account_id+'" data-amount="'+full.amount+'" data-id="'+full.id+'" data-bb="confirm"><i class="icon-thumbs-up"></i></button></a>';
	 var app_btn = '<a id="blockbutton" button class="table-buttons site confirm" title="Approve" id="approve" onclick="security_checking(&#39;approve_payment&#39;,'+full.id+','+full.amount+','+full.account_id+')" ><span><i id="lock-icon"  class="icon-thumbs-up"></i></span></button></a>';
	 
	var rej_url = '';
	
	//var rej_btn ='<a button class="btn btn-small site confirm_reject" title="Reject" id="reject" data-id="'+full.id+'" data-bb="confirm"><i class="icon-thumbs-down"></i></button></a>';
	var rej_btn ='<a id="blockbutton" button class="table-buttons site confirm_reject" title="Reject" id="reject" onclick="security_checking(&#39;reject_payment&#39;,'+full.id+','+full.amount+','+full.account_id+')"><span><i id="lock-icon" class="icon-thumbs-down"></i></span></button></a>';
	
	return view_btn+app_btn+rej_btn;	 	
}

// approve Functionality with Confirm Box
	//$(document).on("click", ".confirm", function(e) {
	function adv_payment_approves(pay_id,amount,account_id){	
		
	    bootbox.confirm("Are you sure you want to approve this payment?", function(result) {
  			//alert($(this).data('account_id'));
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					url: site_url+'/api/v1/approval/payment_approve/format/json',
					data:{'pay_id':pay_id,'account_id':account_id,'amount':amount,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR); 
						if(data.response=='ok'){
							exportdatabutton();
							$('#adv_pay_approve_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("adv_pay_approve_list_length_select");		
							new AcostUISelect(t);
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#pay_app_msg').attr("data-notify-message",data.msg);
							
							$('#pay_app_msg').trigger('click');

							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				});				
			}
		}); 
	 }
	//});
		
	// reject Functionality with Confirm Box
	//$(document).on("click", ".confirm_reject", function(e) {
	function adv_payment_rejects(pay_id,amount,account_id){	
	 	//assign values to the variables
		//var pay_id=($(this).data('id'));
			bootbox.confirm("Are you sure you want to reject this payment?", function(result) {
  			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					url: site_url+'/api/v1/approval/payment_reject/format/json',
					data:{'rej_pay_id':pay_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR); 
						if(data.response=='ok'){
							exportdatabutton();
							$('#adv_pay_approve_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("adv_pay_approve_list_length_select");		
							new AcostUISelect(t);
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#pay_app_msg').attr("data-notify-message",data.msg);
							
							$('#pay_app_msg').trigger('click');
							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 }
	//});

function adv_payment_approve()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	var accountid = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("data-account_id"); }).get();   
    var amount = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("data-amount"); }).get();  
		if(box_check!="")	
		{
			$("#pay_id").val(box_check);
			$('#account_id').val(accountid);
			$('#amount').val(amount);
			$('#modal_approve_payment').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function adv_payment_reject()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
			$("#rej_pay_id").val(box_check);
			$('#modal_reject_payment').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}
function security_checking(action,id,amount,accountid){
	//console.log(bannerid);
	if(id == ""){
		var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check==""){
			$('#modal_no_selection').modal('show');
			return false;
		}
	}
	
	$.ajax({
			method: "GET",
			async: false,
			data: { 'action' : action, 'api_key':api_key },
			//dataType : "json",
			url: site_url+"/api/v1/network/security_check/format/json",
			success: function(data){
				if(data.response == 'ok' || data.response == 'info')
				{
					
							$('#mobile_span').html("Please enter your mobile number (Ends with xxxxx"+data.mobileno.slice(-3)+" )");
							$('#mobileno').val(data.mobileno);
						
							$('#email_span').html("Please enter your email id (Ends with xxxxx"+data.email.slice(-4)+" )");
							$('#email').val(data.email);
							$('#question').html(data.question);
							$('#pay_id').val(id);
							$('#action_type').val(action);
							$('#amount').val(amount);
							$('#accountid').val(accountid);
							$('#question').hide();
							$('#mobile_span').hide();
							$('#email_span').hide();
							$('#verify_code').hide();
							$('#verification_code').val("");
							$('#verify_codes').val("");
							$('#error_verification').html("");
							$("select option[value='']").prop("selected",true);	
							$('#modal_verification_code').modal('show');
				}
				else{
					if(action == 'approve_payment'){
						if(id){
						adv_payment_approves(id,amount,accountid);}else{adv_payment_approve();}
					}
					if(action == 'reject_payment'){
						
						if(id){
						adv_payment_rejects(id,amount,accountid);}else{adv_payment_reject();}
					}
				}
			},
			 error: function(){
					//return '2';
			}
		});
	
}


function run()
{
   exportdatabutton();
   custom_opt.sAjaxSource  = site_url+"/admin/approvals/fetch_payment_list";
   dataTableRedraw();
}
function dataTableRedraw(){

	$('#adv_pay_approve_list.dataTable').dataTable(custom_opt);	

	var t = document.getElementById("adv_pay_approve_list_length_select");		
	   	new AcostUISelect(t);
	resize_chosen();
}
function exportdatabutton()
{
                custom_opt.sDom= 'T<"clear">lfrtip';
	            custom_opt.sDom=  'B<"clear">lfrtip';
				custom_opt.select=  {
								'style':'multi'
							};
				custom_opt.columnDefs=[
						 {
							
							'checkboxes': {
							   'selectRow': true
							}
						 }
					  ];
				custom_opt.buttons=[
                {
						extend: 'copyHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'csvHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'excelHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'pdfHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'print',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					} 
         
				];
}
