// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"iDisplayLength" : parseInt(app_configdefault_per_page),
		"aaSorting" : [[0, 'desc']],
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries <span class='rows_select'></span>",
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/template/flat/img/ajax-loader.gif' alt='Loading...' /></div>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
         dom: 'Bfrtip',
	     'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                //orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3,4,5 ],
                     rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3,4,5 ],
                     rows: '.selected'
                 },
            }  
         
        ],
        "sAjaxSource": site_url+"/admin/approvals/fetch_mobile_application",
		"aaSorting" : [[1, 'desc']],
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			 "orderable": false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
				var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
				return checkbox;
			}
		},
		{
			"aTargets": [1],
			"mData": "temp_id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('checkbox_id'); // Remove border                        
				},
			"mRender": function (data, type, full)
			{				
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":"email",
		},
        {
			"aTargets": [3],
			"mData": "os_type",
		},
		{
			"aTargets": [4],
			"mData": "app_url",
		},
		{
			"aTargets": [5],
			"mData": "app_name",
		},
		{
			"aTargets": [6],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full) {
			  var app_id=full.id;
			  return action_button(app_id);
			}
		},
		
    	]
    };

 
function action_button(app_id)
{
	var app_url = '';
	var app_btn = '<a id="blockbutton" data-toggle="modal" role="button" title="Approve" class="table-buttons confirm" data-app_id="'+app_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-thumbs-up" data-app_id="'+app_id+'"></i></span></a>';
	 
	var rej_url = '';
	var rej_btn = '<a id="blockbutton" data-toggle="modal" role="button" title="Reject" class="table-buttons confirm_reject" data-app_id="'+app_id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-thumbs-down" data-app_id="'+app_id+'"></i></span></a>';
	
	return app_btn+rej_btn; 	
	
}
var app_ids='';
// approve  Functionality with Confirm Box

	$(document).on("click", ".confirm", function(e) {
	  app_ids= $(e.target).attr('data-app_id');  
	 	bootbox.confirm("Are you sure you want to approve this Mobile application ?", function(result) {
  			//alert(result);
			if(result===true){
				
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/approval/approve_mobileapp/format/json?app_id='+app_ids,
					data:{'app_id':$(e.target).attr('data-app_id'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							exportdatabutton();					
							$('#mobileapp_approve_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("mobileapp_approve_list_length_select");		
							new AcostUISelect(t);
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							$('#mobile_app_msg').attr("data-notify-message",data.msg);							
							$('#mobile_app_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 });


// reject  Functionality with Confirm Box

	$(document).on("click", ".confirm_reject", function(e) {
		 app_ids= $(e.target).attr('data-app_id');  
	 	bootbox.confirm("Are you sure you want to reject this Mobile application?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/approval/reject_mobileapp/format/json?reject_app_id='+app_ids,
					data:{'reject_app_id':$(e.target).attr('data-app_id'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							exportdatabutton();					
							$('#mobileapp_approve_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("mobileapp_approve_list_length_select");		
							new AcostUISelect(t);
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#mobile_app_msg').attr("data-notify-message",data.msg);							
							$('#mobile_app_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	});

	
function mobile_app_approve()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	if(box_check!="")	
		{
			$("#app_id").val(box_check);
			$('#modal_approve_mobileapp').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function mobile_app_reject()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
			$("#reject_app_id").val(box_check);
			$('#modal_reject_creative').modal('show');
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}
function exportdatabutton()
{
                custom_opt.sDom= 'T<"clear">lfrtip';
	            custom_opt.sDom=  'B<"clear">lfrtip';
				custom_opt.select=  {
								'style':'multi'
							};
				custom_opt.columnDefs=[
						 {
							
							'checkboxes': {
							   'selectRow': true
							}
						 }
					  ];
				custom_opt.buttons=[
                {
						extend: 'copyHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'csvHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'excelHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'pdfHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'print',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					} 
         
				];
}
