// dataTables

//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,		
		"iDisplayLength" : parseInt(app_configdefault_per_page),
        "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sProcessing": "<div class='loading' style='text-align:center;'><img src='"+base_url+"/template/flat/img/ajax-loader.gif' alt='Loading...' /></div>",
						"sLengthMenu": "_MENU_ <span>entries per page</span>"
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/admin/approvals/fetch_dcampaign_list",
		dom: 'Bfrtip',
	     'columnDefs': [
         {
         	
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
       select:
        {
			style:'multi'
		},
		buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'csvHtml5',
               exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'excelHtml5',
                //text: 'Export selected',
                exportOptions: {
                      columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'pdfHtml5',
                //orientation: 'landscape',
               exportOptions: {
                     columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            },
            {
                extend: 'print',
                
                exportOptions: {
                     columns: [ 1, 2, 3,4,5,6 ],
                      rows: '.selected'
                 },
            }  
         
        ],
		"aoColumnDefs": [
		{
			"aTargets"	: [0],
			"mData"		:"id",
			 "orderable": false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
			{
				$(nTd).addClass('with-checkbox'); // center the link                        
			},
			"mRender"	: function (data, type, full)
			{	
				var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
				return checkbox;
			}
		},
	  	{
			"aTargets": [1],
			"mData":"id",
			//"orderable":false,
			"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('checkbox_id'); // Remove border                        
				},
			"mRender": function (data, type, full)
			{
				return full.row_number;
			}
		},
        {
			"aTargets": [2],
			"mData":null,
			"mRender":function (data,type,full)
			{
			   var paid_date= full.date;
			   return getFormattedDate(paid_date);
			}
		},
		{
			"aTargets": [3],
			"mData":"campaignname",
		},
        {
			"aTargets": [4],
			"mData": "email",
		},
		{
			"aTargets": [5],
			"mData": null,
			"mRender": function (data, type, full)
			{
				var amount=currency +' '+full.amount;
				return amount;
			}
		},
		{
			"aTargets": [6],
			"mData": "payment_type",
		},
		{
			"aTargets": [7],
			"mData":null,
			"sClass":"no-print table-buttons",
			"mRender": function (data, type, full)
			{
				return action_button(full);
			}
		},
		
    	]
    };

//date seperator
function getFormattedDate(dString)
{
	var d = new Date(dString.split(".")[0].replace(/-/g,"/")); 
	var mm = d.getMonth()+1;
	var dd = d.getDate();
	if (mm<10)mm="0"+mm;
	if (dd<10)dd="0"+dd;
	return d.getFullYear()+"/"+mm+"/"+dd;
}

function action_button(full)
{	
	var view_url = site_url+'/admin/approvals/payment_details_viewmore';
	
	var view_btn = '<a id="blockbutton" data-toggle="modal" role="button"  class="table-buttons" title="ViewMore" data-target="#modal_payment_details_view" href="'+view_url+'/'+full.id+'"><span><i id="lock-icon" class="glyphicon-more_windows"></i></span></a>';

	var app_url = '';
	var app_btn = '<a role="button" id="blockbutton" class="table-buttons site confirm" id="approve" title="Approve" data-campaignid="'+full.campaignid+'" data-amount="'+full.amount+'" data-id="'+full.id+'" data-bb="confirm"><span><i id="lock-icon" class="icon-thumbs-up"></i></span></button></a>';
	 
	var rej_url = '';
	var rej_btn ='<a id="blockbutton" role="button" class="table-buttons site confirm_reject" title="Reject" id="reject" data-id="'+full.id+'" data-bb="confirm"><span><i id="lock-icon"  class="icon-thumbs-down"></i></span></button></a>';
	
	//return view_btn+app_btn+rej_btn;
	
	var review_url = site_url+'/admin/campaign_review/overview_campaign';
	var review_btn = '<a id="blockbutton" role="button"  class="table-buttons"  title="Campaign Review" href="'+review_url+'/'+full.campaignid+'"><span><i id="lock-icon" class="icon-edit"></i></span></a>';

	return review_btn+app_btn+rej_btn;
	 	
}

// approve Functionality with Confirm Box
	$(document).on("click", ".confirm", function(e) {
		//assign values to the variables
		 var pay_id=($(this).data('id'));
		 var campaignid=($(this).data('campaignid'));
		 var amount=($(this).data('amount'));
	     bootbox.confirm("Are you sure want to approve this payment?", function(result) {
  			//alert($(this).data('account_id'));
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					url: site_url+'/api/v1/approval/direct_payment_approve/format/json',
					data:{'pay_id':pay_id,'campaign_id':campaignid,'amount':amount,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						console.log(data); 
						if(data.response=='ok'){ 
							exportdatabutton();
							$('#direct_pay_approve_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("direct_pay_approve_list_length_select");		
							new AcostUISelect(t);
					
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#pay_app_msg').attr("data-notify-message",data.msg);
							
							$('#pay_app_msg').trigger('click');

							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();	
						}
						else
						{
							$('#pay_app_msg').attr("data-notify-message",data.msg);
							
							$('#pay_app_msg').trigger('click');
							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();

							//validator.showErrors(data.msg);
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	});
		
	// reject Functionality with Confirm Box
	$(document).on("click", ".confirm_reject", function(e) {
	 	//assign values to the variables
		var pay_id=($(this).data('id'));
		bootbox.confirm("Are you sure you want to reject this payment?", function(result) {
  			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'POST',
					url: site_url+'/api/v1/approval/direct_payment_reject/format/json',
					data:{'rej_pay_id':pay_id,'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR); 
						if(data.response=='ok'){
							exportdatabutton();
							$('#direct_pay_approve_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							var t = document.getElementById("direct_pay_approve_list_length_select");		
							new AcostUISelect(t);
							
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#pay_app_msg').attr("data-notify-message",data.msg);
							
							$('#pay_app_msg').trigger('click');
							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();	
						}
						else
						{
							$('#pay_app_msg').attr("data-notify-message",data.msg);
							
							$('#pay_app_msg').trigger('click');
							//Refresh notification @ top right
							//empty previous notification
							jQuery('#approval_notify').html('');	
							notification();
						}
				
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 
				
			}
		}); 
	 
	 });
function direct_pay_approve()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	var accountid = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("data-account_id"); }).get();   
    var amount = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("data-amount"); }).get();  
		if(box_check!="")	
		{
			$("#pay_id").val(box_check);
			$('#account_id').val(accountid);
			$('#amount').val(amount);
			$('#modal_approve_payment').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function direct_pay_reject()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
		if(box_check!="")	
		{
			$("#rej_pay_id").val(box_check);
			$('#modal_reject_payment').modal('show');	
		}
		else
		{  
			$('#modal_no_selection').modal('show');
		}
	 
}

function exportdatabutton()
{
                custom_opt.sDom= 'T<"clear">lfrtip';
	            custom_opt.sDom=  'B<"clear">lfrtip';
				custom_opt.select=  {
								'style':'multi'
							};
				custom_opt.columnDefs=[
						 {
							
							'checkboxes': {
							   'selectRow': true
							}
						 }
					  ];
				custom_opt.buttons=[
                {
						extend: 'copyHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'csvHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'excelHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'pdfHtml5',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					},
					{
						extend: 'print',
						exportOptions: {
							columns: ':visible:not(.not-exported)',
							rows: '.selected' 
						},
					} 
         
				];
}
