// dataTables
var ajax_url	=	site_url+"/admin/ad_blocks/fetch_adblocks";
if(account_id) {
	ajax_url	=	ajax_url + '/' + account_id;
	if(site_id)
		ajax_url=	ajax_url + '/' + site_id;		
}

//Preload with the first column since you know it will always be there
var includedColumns = [{ 	"mData": "zoneid",
							"mRender": function (data, type, full)
							{
								return full.row_number;
							}						
						}];
//Add additional columns
includedColumns.push({ 	"mData": "zonename",
						"mRender": function (data, type, full) {
							return (data)?data:'<span style="color:red;font-size:12px;">{No Name}</span>';
						}
					});
includedColumns.push({ 	"mData": "site_name" });
includedColumns.push({ 	"mData" : "site_url",
						"sClass": "datatables_capitalize"
					});
					
includedColumns.push({ 	"mData" : "ad_type"	});

includedColumns.push({ 	"mData" : "delivery",
						"mRender": function (data, type, full) {
							return size(full);
						}
					});

if(check_manager_permission('160'))
{
	includedColumns.push({	"mData" : "zoneid",
							"mRender": function (data, type, full) {
								if(full.zone_type!='Display' && full.zone_type!='Video' && full.zone_type!='Special')
								{
									return mobile_sdk(data);
								}
								else
								{
									return '-';
								}							
							}
						});
}

includedColumns.push({	"mData" : "zoneid",
						"sClass" : "no-print",
						"mRender": function (data, type, full) {
							return generate_ad_tag(full,data);
						}
					});

if(check_manager_permission('158') || check_manager_permission('159'))
{					
	includedColumns.push({	"mData" : "zoneid",
							"sClass" : "no-print",
							"mRender": function (data, type, full) {
								return action_button(data);
							}
						});
}
					
$.each(includedColumns, function (i, column) {
	column.aTargets = [i];
});
//options dataTable
var custom_opt = {
        "bProcessing": true,
        "bAutoWidth": false,
		"bDestroy" : true,
		"aaSorting" : [[1, 'desc']],		
		"oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sLengthMenu": "_MENU_ <span>entries per page</span>",
						"sProcessing": "<img src='"+site_url+"/template/flat/img/loader.gif'>",
						"sEmptyTable": "Sorry, no Ad blocks has been found."
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": ajax_url,
        "aoColumnDefs": [
			{
				"aTargets"	: [0],
				"mData"		:"zoneid",
				 "orderable": false,
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('with-checkbox'); // center the link                        
				},
				"mRender"	: function (data, type, full)
				{	
					var checkbox=	"<input name='check_all' id='check_all' class='checkbox_count' value='"+data+"' type='checkbox'>";
					return checkbox;
				}
			},
			{
				"aTargets": [1],
				"mData": "zoneid",
				//"orderable":false,
				"fnCreatedCell": function(nTd, sData, oData, iRow, iCol)
				{
					$(nTd).addClass('checkbox_id'); // center the link                        
				},							
				"mRender": function (data, type, full)
				{
					return full.row_number;
				}
			
			},
			{
				"aTargets": [2],
				"mData": "zonename",
				"mRender": function (data, type, full) {
					return (data)?data:'<span style="color:red;font-size:12px;">{No Name}</span>';
				}
			},
			{
				"aTargets": [3],
				"mData": "site_url",
				"mRender": function (data, type, full) {			
					
						return site_url_render(full);
				}
			
			},
			{
				
				"aTargets": [4],
				"mData" : "zone_type",
				"sClass": "datatables_capitalize"
			},
			{
				
				"aTargets": [5],
				"mData" : "ad_type"
			},
			{
				"aTargets": [6],
				"mData" : "delivery",
				"mRender": function (data, type, full) {
					
					//console.log(full);
						return size(full);
				}
			},
			{
				"aTargets": [7],
				"mData": "IMP",				
			},	
			{
				"aTargets": [8],
				"mData": "CLK",				
			},
			{
				"aTargets": [9],
				"mData": "CTR",				
			},	
			{
				"aTargets": [10],
				"mData": "ECPM",				
			},
			{
				"aTargets": [11],
				"mData": "Revenue",				
			},			
			/*{
				"aTargets": [6],
				"mData" : "zoneid",
				"mRender": function (data, type, full) {
					if(full.zone_type!='Display' && full.zone_type!='Video' && full.zone_type!='Special')
					{
						return mobile_sdk(data);
					}
					else
					{
						return '-';
					}
					
				}
			},*/
			/*{
				
				"aTargets": [6],
				"mData" : "rotator_block_status",
				"mRender": function (data, type, full) {
					if(full.rotator_block_status == 0){
						return 'Automatic';
					}else{
						return 'Manual';
					}
				}
			},*/
			/*{
				"aTargets": [6],
				"mData" : "zoneid",
				"sClass" : "no-print",
				"mRender": function (data, type, full) {
					return generate_ad_tag(full,data);
				}
			},*/
			{
				"aTargets": [12],
				"mData" : "zoneid",
				"sClass" : "no-print",
				"mRender": function (data, type, full) {
					return action_button(data,full);
				}
			},
		]  ,dom:'Bfrtip',
  buttons: [
                {
                extend: 'copyHtml5',
                exportOptions: {
                   columns: [ 1, 2, 3,4,5,6,7,8,9,10,11 ]
                }
            },
            {
                extend: 'csvHtml5',
                exportOptions: {
                    columns: [ 1, 2, 3,4,5,6,7,8,9,10,11 ]
                }
            },
            {
                extend: 'excelHtml5',
                exportOptions: {
                     columns: [ 1, 2, 3,4,5,6,7,8,9,10,11 ]
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                     columns: [ 1, 2, 3,4,5,6,7,8,9,10,11 ]
                }
            },
                        {
                extend: 'print',
                exportOptions: {
                   columns: [ 1, 2, 3,4,5,6,7,8,9,10,11 ]
                }
            }
         
        ]
    };


//Sizes based on type
function size(full)
{
	if(full.dj_zone_type ==='W_A_PUP' || full.dj_zone_type ==='W_A_PUN' || full.dj_zone_type ==='W_A_DL'){
		var size = 'Full';
	}else if(full.dj_zone_type !='W_TEXT' && full.dj_zone_type !='M_A_TXT' && full.dj_zone_type !='M_A_DLG' &&  full.dj_zone_type !='M_A_NF' && full.zone_type !='Video'){
		var size = full.width+'x'+full.height;
	}else if(full.dj_zone_type ==='W_TEXT'){
		var size = 'Text';
	}
	else if(full.dj_zone_type =='M_A_TXT')
	{
		var size = 'Mob-Text';
	}
	else if(full.dj_zone_type =='M_A_DLG')
	{
		var size = 'Mob-Dialog';
	}
	else if(full.dj_zone_type =='M_A_NF')
	{
		var size = 'Mob-Notification';
	}
	else{
		var size = '-';	
	}
	return size;
}

//Generate Ad Tag
function generate_ad_tag(full,data)
{
	if(full.zone_type ==='Video')
	{
		var url = site_url+'/admin/ad_blocks/generate_video_ad_tag';
		
		var btn = '<a href="'+url+'/'+data+'" role="button" data-toggle="modal" class="btn btn-small g_video" data-target="#modal_generate_ad_tags" data-zoneid="'+data+'" data-zone-type="'+full.dj_zone_type+'" data-zone-name="'+full.zonename+'" data-backdrop="static"><i class="icon-pencil"></i>&nbsp;&nbsp;Generate Ad Tag</a>';
	
		
	}else{
		var url = site_url+'/admin/ad_blocks/generate_ad_tag';		
		
		var js_tag = '<a role="button" data-toggle="modal" class="btn btn-small"  data-target="#modal_generate_ad_tags" data-backdrop="static" href="'+url+'/'+data+'"><i class="icon-pencil"></i>&nbsp;&nbsp;Generate Ad Tag</a>';
		
		var btn=js_tag;
	}
	
	return btn;	
}

//Mobile sdk
function mobile_sdk(data)
{
	var url = site_url+'/admin/ad_blocks/mobile_sdk';
	var btn = '<a role="button" data-toggle="modal" class="btn btn-small"  data-target="#modal_mobile_sdk" data-zonename="'+data.zonename+'" href="'+url+'/'+data+'"><i class="icon-pencil"></i>&nbsp;&nbsp;Mobile SDK</a>';
	
	return btn;	
}


//Action
function action_button(data,full)
{	
	var edit_btn 	=	'';
	var del_btn 	=	'';
	
	var edit_url 		=	site_url+'/admin/ad_blocks/edit_adblock';
	var link_url 		=	site_url+'/admin/ad_blocks/link_ads';
	var link_camp_url 	=	site_url+'/admin/ad_blocks/link_campaigns';
	
	if(check_manager_permission('158'))
	{
		var edit_btn	=	'<a role="button"title="Review" class="btn btn-small" href="' + edit_url + '/' + data +((account_id!='')?'/'+account_id:'')+((site_id!='')?'/'+site_id:'')+'"><i class="icon-edit"></i></a>';
	}
	
	if(check_manager_permission('159'))
	{
		var del_url 	= 	'';
		var del_btn 	= 	'<button class="btn btn-small site confirm" title="Delete" data="'+data+'" data-bb="confirm"><i class="icon-trash"></i></button>';
	}
	
	//var link_btn	=	'<a role="button"  class="btn btn-small" href="' + link_url + '/' + data +'"><i class="icon-link"></i>&nbsp;&nbsp;Linked Ads</a>';

	//var link_camp_btn	=	'<a role="button"  class="btn btn-small" href="' + link_camp_url + '/' + data +'"><i class="icon-link"></i>&nbsp;&nbsp;Linked Campaigns</a>';
	
	if(full.zone_type ==='Video')
	{
		var url = site_url+'/admin/ad_blocks/generate_video_ad_tag';
	}
	else
	{
		var url = site_url+'/admin/ad_blocks/generate_ad_tag';	
	}
	
	var report_url=site_url+'/admin/reports/publishers_adblock/'+data;
	
	var report='&nbsp;<a role="button" class="btn btn-small" title="Report" href="'+report_url+'"><i class="glyphicon-charts"></i></a>';
		
	if(full.ostype=="andriod")
	{
		var andriod_url =site_url+'/admin/mobile_ad_blocks/download/android';
		var btn ='<a role="button" data-toggle="modal" class="btn btn-small" title="Andriod SDK" data-backdrop="static" href="'+andriod_url+'/'+data+'"><i class="icon-reorder"></i></a>'	
	}
	else if (full.ostype=="ios")
	{
		var ios_url =site_url+'/admin/mobile_ad_blocks/download/ios';
		var btn ='<a role="button" data-toggle="modal"  title="iOS SDK" class="btn btn-small" data-backdrop="static" href="'+ios_url+'/'+data+'"><i class="icon-file"></i></a>'	
	}
	else
	{	
	var btn = '<a role="button" title="Get Tag" data-toggle="modal" class="btn btn-small"  data-target="#modal_generate_ad_tags" data-backdrop="static" href="'+url+'/'+data+'"><i class="icon-reorder"></i></a>';	
	}

	
	return btn+edit_btn+del_btn+report;
}

	// Delete Functionality with Confirm Box
		
		
	$(document).on("click", ".confirm", function(e) {
	 
	 	bootbox.confirm("Are you sure you want to delete?", function(result) {
  			//alert(result);
			if(result===true){
				// AJAX request to get the data
				$.ajax({
					// URL from the link that was clicked on
					type:'GET',
					url: site_url+'/api/v1/web_adblock/delete/format/json',
					data:{'zone_id':$(e.target).attr('data'),'api_key':api_key},
					// Success function. the 'data' parameter is an array of objects that can be looped over
					success: function(data, textStatus, jqXHR){
						//console.log(jqXHR);
						if(data.response == 'ok'){
							 
							$('select').select2("val", "");
							//html5 export data buttons
							exportdatabutton();
							$('#adblock_list.dataTable').dataTable(custom_opt).fnDraw();
							$('.dataTables_filter input').attr("placeholder", "Search here...");
							$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
								disable_search_threshold: 9999999
							});
							$("#check_all").click(function(e){
								$('input', oTable.fnGetNodes()).prop('checked',this.checked);
							});
							if($(this).hasClass("dataTable-fixedcolumn")){
								new FixedColumns( oTable );
							}
							if($(this).hasClass("dataTable-columnfilter")){
								oTable.columnFilter({
									"sPlaceHolder" : "head:after"
								});
							}
							resize_chosen();	
							
							//$('#save_site').unbind('click');
							$('#del_site_msg').attr("data-notify-message",data.msg);
							
							$('#del_site_msg').trigger('click');	
						}
						else
						{
							//validator.showErrors(data.msg);
						}
					$("#check_all").attr('checked', false);
					}, 
					// Failed to load request. This could be caused by any number of problems like server issues, bad links, etc. 
					error: function(jqXHR, textStatus, errorThrown){
					//alert('Oh no! A problem with the AJAX request!');
					}
				}); 				
			}
		}); 	 
	});
	
//Using check box 
function delete_adbs()
{
	var box_check = jQuery("input[name='check_all']:checked").map(function(i, el) { return jQuery(el).attr("value"); }).get();
	if(box_check!="")	
	{
		$("#zone_id").val(box_check);
		$('#modal_del_adblocks').modal('show');	
	}
	else
	{  
		$('#modal_no_selection').modal('show');
	}
}
function site_url_render(full)
{
	return '<label title='+full.site_url+'>'+full.site_url.substring(0,30)+'</label>';
}
