<?php
namespace PayPal\PayPalAPI;

use PayPal\EBLBaseComponents\AbstractResponseType;

/**
 * Type of button. One of the following: BUYNOW, CART,
 * GIFTCERTIFICATE. SUBSCRIBE, PAYMENTPLAN, AUTOBILLING,
 * DONATE, VIEWCART or UNSUBSCRIBE
 */
class BMGetButtonDetailsResponseType
  extends AbstractResponseType
{

    /**
     *
     * @access    public
     * @namespace ns
     * @var string
     */
    public $Website;

    /**
     *
     * @access    public
     * @namespace ns
     * @var string
     */
    public $Email;

    /**
     *
     * @access    public
     * @namespace ns
     * @var string
     */
    public $Mobile;

    /**
     *
     * @access    public
     * @namespace ns
     * @var string
     */
    public $HostedButtonID;

    /**
     * Type of button. One of the following: BUYNOW, CART,
     * GIFTCERTIFICATE. SUBSCRIBE, PAYMENTPLAN, AUTOBILLING,
     * DONATE, VIEWCART or UNSUBSCRIBE
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonType;

    /**
     * Type of button code. One of the following: hosted, encrypted
     * or cleartext
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonCode;

    /**
     * Button sub type. optional for button types buynow and cart
     * only Either PRODUCTS or SERVICES
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonSubType;

    /**
     * Button Variable information Character length and
     * limitations: 63 single-byte alphanumeric characters
     * @array
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonVar;

    /**
     *
     * @array
     * @access    public
     * @namespace ns
     * @var \PayPal\PayPalAPI\OptionDetailsType
     */
    public $OptionDetails;

    /**
     * Text field
     * @array
     * @access    public
     * @namespace ns
     * @var string
     */
    public $TextBox;

    /**
     * Button image to use. One of: REG, SML, or CC
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonImage;

    /**
     * Button URL for custom button image.
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonImageURL;

    /**
     * Text to use on Buy Now Button. Either BUYNOW or PAYNOW
     * @access    public
     * @namespace ns
     * @var string
     */
    public $BuyNowText;

    /**
     * Text to use on Subscribe button. Must be either BUYNOW or
     * SUBSCRIBE
     * @access    public
     * @namespace ns
     * @var string
     */
    public $SubscribeText;

    /**
     * Button Country. Valid ISO country code or 'International'
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonCountry;

    /**
     * Button language code. Character length and limitations: 3
     * single-byte alphanumeric characters
     * @access    public
     * @namespace ns
     * @var string
     */
    public $ButtonLanguage;

}
