<?php 
class User_registration extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	public function index()
	{
		$this->referral();
	}
	/*
	 * 
	 * name		:index
	 * @param   :Null
	 * @return  :Registration page
	 */	
	 
	 
	function referral($referral=FALSE)
	{	
		if($referral!=FALSE)
		{
			$data['referral_id']	=	base64_decode(urldecode($referral));
		}	
		else
		{
			$data['referral_id']	=	0;
		}
		
		$data['page_title'] = 	$this->config->item('prod_name')." - Registration ";
		$approve_user		=	$this->rest->get('api/v1/user/get_agency_id','','php');				
		$data['agencyid']	=	$approve_user[0]['agency_id'];
		$data['content'] 	= 	$this->load->view('user_registration/registration',$data,TRUE);
		$this->template->set_layout('user_login_layout');
		$this->template->build('view', $data);		
	}
	
	function success($account_type)
	{
		$data['account_type']=$account_type;
		$data['page_title']=$this->config->item('prod_name')." - Registration - Success ";
	    $this->load->view('user_registration/success',$data);		
	}
	
	
	function approve()
	{
		$user_id = $this->uri->segment(3);
		$approve_user=$this->rest->get('api/v1/user/email_approve',array('user_id'=>$this->uri->segment(3),'email_verification_code'=>$this->uri->segment(4)),'php');	
		if($approve_user)
		{
			redirect('site');
		}		
		else
		{
			redirect('site');
		}
	}
}
