<?php 

class User_login extends CI_Controller {

	

	function __construct()
	{
		parent::__construct();     

	    $this->no_cache();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');
		$this->load->library('email');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}

	
	/*

	 * 

	 * name		:index

	 * @param   :Null

	 * @return  :Login page

	 */	


	function index()
	{
		$this->admin();	
	}


	/*

	 * 

	 * name		:admin

	 * @param   :Null

	 * @return  :Login on success

	 */	
	

	function admin()
	{
		$data['page_title'] 	= 	"Admin Login ";		

		$data['breadcrumb'] 	= 	'';

		$data['acc_type'] 		= 	'ADMIN';	

		$data['content'] 		= 	$this->load->view('user_login/login',$data,TRUE);

		$this->template->set_layout('user_login_layout');

		$this->template->build('view', $data);

	}


	/*

	 * 

	 * name		:manager

	 * @param   :Null

	 * @return  :Login on success

	 */	
	

	function manager()
	{

		$data['page_title'] = "Manager Login ";
        $data['breadcrumb'] = '';
        $data['acc_type']   = 'MANAGER';
        $data['content']    = $this->load->view('user_login/login', $data, TRUE);
        $this->template->set_layout('user_login_layout');
        $this->template->build('view', $data);

	}

	/*

	 * 

	 * name		:advertiser

	 * @param   :Null

	 * @return  :Login on success

	 */	


	function advertiser()
	{

		$data['page_title'] 	= 	"Advertiser Login ";		

		$data['breadcrumb'] 	= 	'';

		$data['acc_type'] 		= 	'ADVERTISER';	

		$data['content'] 		= 	$this->load->view('user_login/login',$data,TRUE);

		$this->template->set_layout('user_login_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:advertiser

	 * @param   :Null

	 * @return  :Login on success

	 */	

	

	function publisher()
	{

		$data['page_title'] 	= 	"Publisher Login ";		

		$data['breadcrumb'] 	= 	'';

		$data['acc_type'] 		= 	'TRAFFICKER';		

		$data['content'] 		= 	$this->load->view('user_login/login',$data,TRUE);

		$this->template->set_layout('user_login_layout');

		$this->template->build('view', $data);

	}


	protected function no_cache(){

		header('Cache-Control: no-store, no-cache, must-revalidate');

		header('Cache-Control: post-check=0, pre-check=0',false);

		header('Pragma: no-cache'); 

	}


	/*

	 * 

	 * name		:forget_password

	 * @param   :Null

	 * @return  :Forget Password page

	 */	


	function forget_password($acc_type = FALSE)
	{
		if(!empty($acc_type))
		{

			$data['page_title'] = "Forgot Password ";		

			$data['breadcrumb'] = '';

			$data['acc_type']	= strtoupper($acc_type);

				

			$data['content'] = $this->load->view('user_login/forget_password',$data,TRUE);

			$this->template->set_layout('user_login_layout');

			$this->template->build('view', $data);

		}else{

			redirect('user_login');	

		}

	}	
	

	function logout($acc_type = FALSE)
	{	
		$session	  =	$this->session->all_userdata();
				
		$logged_admin=get_session('is_logged_from_admin');	
						
		if($session)
		{
			if($logged_admin=='1')
			{		
				$primary_id=$session['primary_id'];
				if($primary_id!='')
				{
				$SQL="select * from djax_admin_session where id=".$primary_id;
				$query=$this->db->query($SQL);			
				if($query->num_rows() > 0){
					$admin_data = $query->result_array();
				}	
												
				if($admin_data!='')
				{
					$CI = &get_instance();
		        	$CI->load->library('encrypt');		
					$this->session->sess_destroy();	
					$pdt_name = $CI->config->item('prod_name');
					$sess_array = array();		
					$common_session=array('session_id','primary_id','account_id','account_type','ip_address',
					'user_agent','last_activity','user_data','time_zone',$pdt_name.'_first_name',
					$pdt_name.'_last_name',$pdt_name.'_username',$pdt_name.'_default_manager',
					$pdt_name.'_agencyid',$pdt_name.'_account_id',$pdt_name.'_account_type',
					$pdt_name.'_email',$pdt_name.'_api_key',$pdt_name.'_denied',$pdt_name.'_default_account_id',
					$pdt_name.'_default_advertiser_account_id',$pdt_name.'_default_advertiser_client_id',$pdt_name.'_time_zone',$pdt_name."_cur_login_time");
					$res['session_id']=$admin_data[0]['session_id'];
					$res['primary_id']=$admin_data[0]['id'];
					$res['account_id']=$admin_data[0]['account_id'];
					$res['account_type']=$admin_data[0]['account_type'];
					$res['ip_address']=$admin_data[0]['ip_address'];
					$res['user_agent']=$admin_data[0]['user_agent'];
					$res['last_activity']=$admin_data[0]['last_activity'];
					$res['user_data']=$admin_data[0]['user_data'];
					$res['time_zone']=$admin_data[0]['time_zone'];					
					$res[$pdt_name.'_first_name']=$admin_data[0]['Adgate_first_name'];
					$res[$pdt_name.'_last_name']=$admin_data[0]['Adgate_last_name'];
					$res[$pdt_name.'_username']=$admin_data[0]['Adgate_username'];
					$res[$pdt_name.'_default_manager']=$admin_data[0]['Adgate_default_manager'];
					$res[$pdt_name.'_agencyid']=$admin_data[0]['Adgate_agencyid'];
					$res[$pdt_name.'_account_id']=$admin_data[0]['Adgate_account_id'];
					$res[$pdt_name.'_account_type']=$admin_data[0]['Adgate_account_type'];
					$res[$pdt_name.'_email']=$admin_data[0]['Adgate_email'];
					$res[$pdt_name.'_api_key']=$admin_data[0]['Adgate_api_key'];
					$res[$pdt_name.'_denied']=$admin_data[0]['Adgate_denied'];
					$res[$pdt_name.'_default_account_id']=$admin_data[0]['Adgate_default_account_id'];
					$res[$pdt_name.'_default_advertiser_account_id']=$admin_data[0]['Adgate_default_advertiser_account_id'];
					$res[$pdt_name.'_default_advertiser_client_id']=$admin_data[0]['Adgate_default_advertiser_client_id'];
					$res[$pdt_name.'_time_zone']=$admin_data[0]['Adgate_time_zone'];
					$res[$pdt_name.'_cur_login_time']=$admin_data[0]['Adgate_cur_login_time'];	
					
					
					
					if(!empty($common_session))
					{					
						foreach ($common_session as $key)
						{
							if(in_array($key,array_keys($res)))
							{							    
							$sess_array[$key] = $res[$key];																						
							}
						}
					}
					$this->session->set_userdata($sess_array);					
					//$DELETE_SQL="delete from djax_admin_session where id=".$primary_id;
					//$this->db->query($DELETE_SQL);
					
				}	
				}				
			}
			else
			{
			$this->session->unset_userdata($session);
			$this->session->sess_destroy();						
			}
		}		
																
		if(strtoupper($acc_type)==='ADMIN')
		{			
			redirect($acc_type);
		}
		else if($logged_admin=='1')
		{ 				
			redirect("admin/dashboard");			
		}
		else
		{  
			redirect();  
		}

	}	



	function link_banners($zone_id=FALSE){

		if($zone_id){

			$SQL = "SELECT 

						oxb.bannerid,

						oxb.description,

						oxb.width,

						oxb.height,

						oxb.dj_banner_type,

						oxc.campaignid,

						oxc.campaignname,

						oxcl.clientid,

						oxcl.clientname,

						dj_is_default as HouseAds 

					FROM `ox_ad_zone_assoc` as t 

						JOIN ox_banners as oxb ON oxb.bannerid= t.ad_id

						JOIN ox_campaigns as oxc ON oxc.campaignid= oxb.campaignid

						JOIN ox_clients as oxcl ON oxcl.clientid= oxc.clientid

					WHERE t.zone_id={$zone_id}";

			$query = $this->db->query($SQL);

		

			if($query->num_rows() > 0){

				$t = $query->result_array();

				//print_r($t);

				$data['page_title'] = $this->config->item('prod_name')." - Linked Banners";		

				$data['breadcrumb'] = '';

				$data['banners'] = $t;

				$data['content'] = $this->load->view('user_login/banners',$data,TRUE);			

				echo $data['content'];

			}

		}

	}

	

	function view_child_banners($banner_id=FALSE){
	

		if($banner_id){

			$SQL = "SELECT `banner_id`,`file_path`,`width`,`height`,`content_type`,`display_type`FROM `djax_additional_banners` WHERE `banner_id`={$banner_id}";

			$query = $this->db->query($SQL);

			

			if($query->num_rows() > 0){

				$t = $query->result_array();

				//print_r($t);

				$data['page_title'] = $this->config->item('prod_name')." - View Banners";		

				$data['breadcrumb'] = '';

				$data['banners'] = $t;

				$data['content'] = $this->load->view('user_login/vbanners',$data,TRUE);

				echo $data['content'];

			}

		}

	}
	
	function demo_viewers()
    {
        $SQL    = "SELECT * FROM djax_login_info";
        $query  = $this->db->query($SQL);
        $result = array();
        if ($query->num_rows() > 0)
        {
            $result = $query->result_array();
        }
        $data['page_title'] = $this->config->item('prod_name')." - View Banners";
        $data['breadcrumb'] = '';
        $data['login_list'] = $result;
        $data['content']    = $this->load->view('user_login/view_logins', $data, TRUE);
        echo $data['content'];
    }
	/*

	 * 

	 * name		:verification_code

	 * @param   :Null

	 * @return  :Verification Code

	 */	


	function verification_code($acc_type = FALSE)
	{
		/*if(!empty($acc_type))
		{*/

			$data['page_title'] = "verification Code ";		

			$data['breadcrumb'] = '';

			$data['acc_type']	= strtoupper($acc_type);

				

			$data['content'] = $this->load->view('user_login/verification_code',$data,TRUE);

			$this->template->set_layout('user_login_layout');

			$this->template->build('view', $data);

		/*}else{

			redirect('user_login');	

		}*/

	}
	/*

	 * 

	 * name		:backup_verification_code

	 * @param   :Null

	 * @return  :Backup Verification Code

	 */	


	function backup_verification_code($acc_type = FALSE)
	{
		/*if(!empty($acc_type))
		{*/

			$data['page_title'] = "Backup verification ";		

			$data['breadcrumb'] = '';

			$data['acc_type']	= strtoupper($acc_type);

				

			$data['content'] = $this->load->view('user_login/backup_verification_code',$data,TRUE);

			$this->template->set_layout('user_login_layout');

			$this->template->build('view', $data);

		/*}else{

			redirect('user_login');	

		}*/

	}
	
	function lock_account($account_id = FALSE,$acc_type = FALSE)
	{
		if(!empty($account_id))
		{

			$data['page_title'] = "Lock Account";		

			$data['breadcrumb'] = '';

			$data['account_id']	= $account_id;
			$data['acc_type']	= $acc_type;
			if($acc_type == 'ADVERTISER'){
			$where_user	=	array('default_account_id'	=>	$account_id);
			
			$oxUserDet	=	array(
							"active"		=>	0
							);
							
			$this->db->where($where_user);							
			$this->db->update(TAB_USERS,$oxUserDet);	
			
			$where_cli	=	array('account_id'	=>	$account_id);
			
			$clientInfo	=	array(
							"dj_is_denied"		=>	1
							);
							
			$this->db->where($where_cli);							
			$this->db->update(TAB_CLIENTS,$clientInfo);
			}
			$user_details						=	$this->rest->get('api/v1/user/fetch_advertiser_details',array("account_id"=>$account_id,"account_type"=>$acc_type),'json');
			
			$admin_details						=	$this->rest->get('api/v1/user/fetch_admin_details',array(),'json');
			//$this->rest->debug();
			
			$admin_email				=	json_decode($admin_details);
			$advObj						=	json_decode($user_details);
			$from 						=  	$admin_email->email;
			$admin_name 				= 	$admin_email->firstname." ".$admin_email->lastname;
			$to  						=  	$advObj->email;
			$user_name 					= 	$advObj->first_name." ".$advObj->last_name;
			$user_email					=	$advObj->email;
			$type 						= 	"LOCK_ACCOUNT_LOGIN";
			$account_type				= 	$advObj->account_type;
			$to_mail 					=	$advObj->email;
			$mail_content				=	array(
											"subject" 		=> "Your Account Locked",
											"to_name" 		=> $user_name,				
											"from_name"		=> $admin_name,
											"email"  		=> $user_email,
											"admin_email"	=>$admin_email->email,
											"account_type" 	=>	$account_type,
											
										);			
			send_mail($type,$from,$to_mail,$mail_content);
			$data['admin_email']	= $from;
			
			$data['content'] = $this->load->view('user_login/lock_account',$data,TRUE);

			$this->template->set_layout('user_login_layout');

			$this->template->build('view', $data);

		}else{

			redirect('user_login');	

		}

	}
}
