<?php
class Do_campaign extends CI_Model
{
	/*
	 * name: fetch_type
	 * @param
	 * @return
	 *
	 * This method get list of campaign type
	 * 
	 */

	function fetch_type()
	{
		$this->db->select('revenue_type as campaign_type_name,revenue_type_value  as campaign_type_value');
		$this->db->where('status','1');
		$query = $this->db->get(TAB_CONF_REVENUE_TYPE);		
		$result = $query->result_array();
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * name: add_new_campaign
	 * @param
	 * @return
	 *
	 * This method creates a new campaign for
	 * the advretiser
	 * 
	 */

	function add_new_campaign($camapign_data,$client_id,$global_tracker)
	{
		if($camapign_data AND $client_id)
		{
			$this->db->trans_start();

			$this->db->insert(TAB_CAMPAIGNS,$camapign_data);

			$campaign_id=$this->db->insert_id();

		
			//Create trackers for a campaign
				$tracker_data=array(
								"trackername"=>$camapign_data['campaignname'].'_tracker',
								"clientid"=>$camapign_data['clientid'],
								"updated"=>$camapign_data['dj_added_date'],
								);
				$this->db->insert(TAB_TRACKERS,$tracker_data);
				$tacker_id=$this->db->insert_id();
				$tracker_mapigng_data=array(
								"campaignid"=>$campaign_id,
								"trackerid"=>$tacker_id,
								"cookieless_tracker"=>$global_tracker,
								);
				$this->db->insert(TAB_CAM_TRACKERS,$tracker_mapigng_data);


			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return $campaign_id;
			}
		}
		else
			return FALSE;
	}
	/*
	 * name: fetch_linked_creative
	 * @param
	 * @return
	 *
	 * In this method will fetch all the creatives linked to given campaign id
	 * 
	 */

	function fetch_linked_creative($campaign_id)
	{
		
		if($campaign_id)
		{
				 $SQL = "SELECT bannerid,campaignid,description,filename,storagetype,dj_banner_type,url,dj_admin_approve,imageurl,
					CASE
						WHEN `dj_banner_type` = 'W_IMG'  THEN 'Image creative'
						WHEN `dj_banner_type` = 'W_URL' THEN 'URL creative'
						WHEN `dj_banner_type` = 'W_SQL'  THEN 'Database creative'
						WHEN `dj_banner_type` = 'W_HTML'  THEN 'HTML creative'
						WHEN `dj_banner_type` = 'V_IN'  THEN 'Inline video creative'
						WHEN `dj_banner_type` = 'V_OL'  THEN 'Overlay video creative'
						WHEN `dj_banner_type` = 'M_MR_INT'  THEN 'Interstital creative'
						WHEN `dj_banner_type` = 'M_MR_EXP'  THEN 'Expand creative'
						WHEN `dj_banner_type` = 'M_MR_REV'  THEN 'Reveal creative'
						WHEN `dj_banner_type` = 'M_RS_FS'  THEN 'Filmstrip creative'
						WHEN `dj_banner_type` = 'M_RS_FL'  THEN 'Flex creative'
						WHEN `dj_banner_type` = 'M_RS_PL'  THEN 'Pull creative'
						WHEN `dj_banner_type` = 'M_RS_ADH'  THEN 'Adhesion creative'
						WHEN `dj_banner_type` = 'M_RS_SL'  THEN 'Slider creative'
						WHEN `dj_banner_type` = 'M_IMG'  THEN 'Image creative'
						WHEN `dj_banner_type` = 'M_TEXT'  THEN 'Text creative'
						WHEN `dj_banner_type` = 'W_TEXT'  THEN 'Text creative'
						WHEN `dj_banner_type` = 'W_SWF'  THEN 'Flash creative'
						WHEN `dj_banner_type` = 'W_POP'  THEN 'Pop-under/Pop-up creative'
						WHEN `dj_banner_type` = 'W_LAY'  THEN 'Layer/Interstitial creative'
						WHEN `dj_banner_type` = 'W_GB'  THEN 'Gamebox creative'
						WHEN `dj_banner_type` = 'W_BB'  THEN 'Bannerbox creative'
						WHEN `dj_banner_type` = 'W_SL'  THEN 'Slider creative'
						WHEN `dj_banner_type` = 'W_CF'  THEN 'Catfish creative'
						WHEN `dj_banner_type` = 'W_SS'  THEN 'Site-Skin creative'
						WHEN `dj_banner_type` = 'V_RD'  THEN 'Read video creative'
						WHEN `dj_banner_type` = 'V_SM'  THEN 'Small video creative'
						WHEN `dj_banner_type` = 'V_BOX' THEN 'Box video creative'
						WHEN `dj_banner_type` = 'V_HEAD' THEN 'Head video creative'
						
						
					END as creative_type

					FROM 
						".TAB_BANNERS."
					WHERE  dj_is_deleted =0 AND dj_admin_approve != '-1' AND campaignid=$campaign_id";

					
		
			 $SQL .= " ORDER BY dj_added_date" ;
			
			$query = $this->db->query($SQL);

			$result = $query->result_array();
		
							
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	/*
	 * name: add_campaign_creative_assoc
	 * @param
	 * @return
	 *
	 * This method links the campaign to the creative
	 * 
	 */

	function add_campaign_creative_assoc($campaign_id,$creative_ids)
	{
		if($campaign_id AND $creative_ids)
		{
			$this->db->trans_start();

			foreach($creative_ids as $creative_id)
			{
				//CHECK IF ALREADY EXIST
				$this->db->select('ban_camp_assoc_id');
				$this->db->where('banner_id',$creative_id);
				$this->db->where('campaign_id',$campaign_id);
				$query = $this->db->get(TAB_BAN_CAM_ASSOC);		

				if($query->num_rows()>0)
				{
					$result = $query->result_array();

					if($result)
					{
						$this->db->where('banner_id',$creative_id);
						$this->db->where('campaign_id',$campaign_id);
						$this->db->delete(TAB_BAN_CAM_ASSOC);
					}
				}

				$camp_crative_assoc_data=array('banner_id'=> $creative_id ,'campaign_id'=>$campaign_id );
				$this->db->insert(TAB_BAN_CAM_ASSOC,$camp_crative_assoc_data);
			}

			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	/*
	 * name: edit_campaign
	 * @param
	 * @return
	 *
	 * This method edits a campaign for
	 * the advretiser
	 * 
	 */

	function edit_campaign($camapign_data,$client_id,$campaign_id,$global_tracker)
	{
		if($camapign_data  AND $client_id  AND $campaign_id)
		{
			$this->db->trans_start();

			$this->db->where('campaignid',$campaign_id);
			$this->db->update(TAB_CAMPAIGNS,$camapign_data);
			$tracker_mapigng_data=array(
								"campaignid"=>$campaign_id,								
								"cookieless_tracker"=>$global_tracker,
								);
			$this->db->where('campaignid',$campaign_id);
			$this->db->update(TAB_CAM_TRACKERS,$tracker_mapigng_data);
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	/*
	 * name: complete_campaign
	 * @param
	 * @return
	 *
	 * This method edits a campaign for
	 * the advretiser
	 * 
	 */

	function complete_campaign($camapign_id,$campaign_status_data)
	{
	
		if($camapign_id  AND $campaign_status_data)
		{
			$this->db->trans_start();

			$this->db->where('campaignid',$camapign_id);
			
			$this->db->update(TAB_CAMPAIGNS,$campaign_status_data);

			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				return FALSE;
			}
			else
			{
				$this->db->trans_commit();
				return TRUE;
			}
		}
		else
			return FALSE;
	}
	
	/*

   * 

   * name: insert_campaign_payment

   * @param : $paypal_order

   * @return :TRUE or FALSE

   * 

   */

    function insert_campaign_payment($campaign_details)
    {
		$check_exist_txn_id	=	$this->db->query('select count(*) as duplicate from djax_direct_campaign_payment where invoice_code="'.$campaign_details['invoice_code'].'"');
		$check=$check_exist_txn_id->result_array();
		if($check[0]['duplicate']==0)
		{
        
			$query=$this->db->query("Update rv_campaigns set dj_is_checkout=1 where campaignid=".$campaign_details['campaign_id']);
			$query = $this->db->query("insert into djax_direct_campaign_payment(campaign_id,name,email,payment_type,date,amount,currency,clearing_date,status,is_default,transaction,admin_approval_status,invoice_code,id_no,approved_date,txn_id,receiver_email) 
						values('".$campaign_details['campaign_id']."','".$campaign_details['name']."','".$campaign_details['payer_email']."','".$campaign_details['payment_type']."','".$campaign_details['date']."','".$campaign_details['amount']."','".$campaign_details['mc_currency']."','".$campaign_details['clearing_date']."','".$campaign_details['status']."','".$campaign_details['is_default']."','".$campaign_details['transaction']."','".$campaign_details['admin_approval_status']."','".$campaign_details['invoice_code']."','".$campaign_details['id_no']."','".$campaign_details['approved_date']."','".$campaign_details['txn_id']."','".$campaign_details['receiver_email']."');");
			
			$prod_name = $this->config->item('prod_name'); 
			unset($_COOKIE[$prod_name.'_campaign_user_data']);
			
			if($this->db->affected_rows()>0)

			{
				return $this->db->insert_id();
			}
			else
			{
				return FALSE;
			}
		}
    }
	/*
	 * 
	 * name: fetch
	 * @param :
	 * @return : $result
	 * 
	 * Lists all the Campaign of an advertiser
	 */
	function fetch($account_id=false)
	{
		$SQL = "SELECT @i := @i +1 AS row_number,c.*
				FROM
				(SELECT a.campaignid,a.campaignname,a.dj_targetting_type,a.status,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web campaign'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile campaign'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '0' THEN 'Running'
					WHEN `status` = '1' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
					
				END as formated_status

				FROM 
					 ".TAB_CAMPAIGNS." as a

				JOIN ".TAB_CLIENTS." as b ON b.clientid=a.clientid
				WHERE 
					 a.dj_is_deleted =0 AND b.dj_is_deleted =0 AND b.dj_is_default != 2 ";//b.dj_is_default = 2 is a signupless campaign
					if($account_id!=false)
					{
						$SQL	.=" AND b.account_id=".$account_id;
					}
					else
					{
						if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
			
							$SQL	.=" AND b.account_id IN (".$this->user_authentication->manager_adv_pub_id.") ";
						else:						
							$SQL	.=" AND b.account_id!=".$this->user_authentication->default_advertiser_account_id;
						endif;
					}
	
		 $SQL .= " ORDER BY a.campaignid DESC) as c,(SELECT @i := 0) as rowcount" ;

		 
		$query = $this->db->query($SQL);
		
		$result = $query->result_array();
	
				
		if($result)
			return $result;
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: delete_campaign
	 * @param : creative_id
	 * @return : $result
	 * 
	 * Delete the creative
	 */
	 function delete_campaign($campaign_id=false)
	 {
		if($campaign_id)
		{
			$this->db->trans_start();
			
			$this->db->where('campaignid',$campaign_id); 
			$this->db->update(TAB_CAMPAIGNS,array('dj_is_deleted'=>'1'));

			//UPDATE THE LINKED CREAIVE TOO
			
				$this->db->select('bannerid');
				$this->db->where('campaignid',$campaign_id);
				$query = $this->db->get(TAB_BANNERS);		
				if($query->num_rows()>0)
				{
					$result = $query->result_array();

					if($result)
					{
						foreach($result as $data_array)
						{
							$this->db->where('bannerid',$data_array['bannerid']); 
							$this->db->update(TAB_BANNERS,array('dj_is_deleted'=>'1'));
						}
					}
				}
			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
		
	}
	/*
	 * 
	 * name: camapign_status
	 * @param : campaighn_id
	 * @return : $result
	 * 
	 * run a campaign
	 */
	 function camapign_status($campaign_id=false,$update_data)
	 {
		if($campaign_id)
		{
			$this->db->trans_start();
			
			$this->db->where('campaignid',$campaign_id);
			$this->db->update(TAB_CAMPAIGNS,$update_data);

			if ($this->db->trans_status() === FALSE)
				$this->db->trans_rollback();
			else
				$this->db->trans_commit();
		}
		else
			return FALSE;
	}

	
	/*
	 * 
	 * name: fetch_campaign
	 * @param :
	 * @return : $result
	 * 
	 * Lists all the Campaign of an advertiser
	 */
	 function fetch_campaign($campaign_id)
	 {
			$SQL = "SELECT a.clientid,a.campaignid,a.campaignname,a.dj_targetting_type,a.status,a.activate_time,a.expire_time,a.revenue_type as revenue_type,a.session_capping as capping,a.block,a.dj_category_id,a.dj_campaign_budget,a.dj_daily_budget,a.revenue,a.weight,b.category_name,a.dj_is_retargeted,a.dj_max_retargetting,dj_is_rtb_campaign,dj_rtb_buyer_id,a.dj_company_name,a.dj_email_address,a.dj_company_address,a.dj_company_city,a.dj_company_state,a.dj_company_state,a.dj_company_country,a.dj_mobile_number,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web targeting'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile targeting'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '0' THEN 'Running'
					WHEN `status` = '1' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
				END as formated_status,

				CASE
					WHEN `revenue_type` = '1' THEN 'CPM'
					WHEN `revenue_type` = '2' THEN 'CPC'
					WHEN `revenue_type` = '3' THEN 'CPA'
				END as formated_revenue_type

				FROM 
					".TAB_CAMPAIGNS." as a
				LEFT JOIN
				".TAB_SITE_CATEGORIES." as b ON (b.value = a.dj_category_id || b.category_id = a.dj_category_id)
                
				WHERE 
					 a.dj_is_deleted =0 AND a.campaignid=$campaign_id";
	
		$SQL .= " ORDER BY a.dj_added_date" ;
		
		
		$query = $this->db->query($SQL);

		//echo $this->db->last_query();
        
       $result = $query->result_array();
						
		if($result)
			return $result;
		else
			return FALSE;
		
	}
	
	/*
	 * 
	 * name: fetch_houseads_campaign
	 * @param :
	 * @return : $result
	 * 
	 * Lists all the Campaign of an admin
	 */
	 function fetch_houseads_campaign($campaign_id)
	 {
			$SQL = "SELECT a.clientid,a.campaignid,a.campaignname,a.dj_targetting_type,a.status,a.activate_time,a.expire_time,a.revenue_type as revenue_type,a.session_capping as capping,a.block,a.dj_category_id,a.dj_campaign_budget,a.dj_daily_budget,a.revenue,a.weight,a.dj_is_retargeted,a.dj_max_retargetting,
				CASE
					WHEN `dj_targetting_type` = 'WEB'  THEN 'Web targeting'
					WHEN `dj_targetting_type` = 'MOBILE' THEN 'Mobile targeting'
					
				END as formated_dj_targetting_type,
				CASE
					WHEN `status` = '0' THEN 'Running'
					WHEN `status` = '1' THEN 'Paused'
					WHEN `status` = '2' THEN 'Awaiting'
					WHEN `status` = '3' THEN 'Completed'
					WHEN `status` = '4' THEN 'Halt'
				END as formated_status,

				CASE
					WHEN `revenue_type` = '1' THEN 'CPM'
					WHEN `revenue_type` = '2' THEN 'CPC'
					WHEN `revenue_type` = '3' THEN 'CPA'
				END as formated_revenue_type

				FROM 
					".TAB_CAMPAIGNS." as a

				WHERE 
					 a.dj_is_deleted =0 AND a.campaignid=$campaign_id";
	
		$SQL .= " ORDER BY a.dj_added_date" ;
		
		$query = $this->db->query($SQL);
        
		$result = $query->result_array();
						
		if($result)
			return $result;
		else
			return FALSE;
		
	}
	
	
	
    /*
	 * name: fetch_camapign_targeting
	 * @param
	 * @return
	 *
	 * This method get list of campaign targeting details
	 * 
	 */

	function fetch_camapign_targeting($where=false)
	{
		if($where)
		{
			$this->db->select('data');
			$this->db->where($where);
			
			$query = $this->db->get(TAB_ACLS);		
			$result = $query->result_array();
			if($result)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	
    /*
	 * name: fetch_campaign_tracker
	 * @param
	 * @return
	 *
	 * This method get the campaign corresponding tracker code
	 * 
	 */

	function fetch_campaign_tracker($campaign_id=false)
	{
		
		if($campaign_id)
		{
			$this->db->select('trackerid,cookieless_tracker');
			//$this->db->select('trackerid');
			$this->db->where('campaignid',$campaign_id);
			
			$query = $this->db->get(TAB_CAM_TRACKERS);		
			
			$result = $query->result_array();			
			
			if($query->num_rows()>0)
				return $result;
			else
				return FALSE;
		}
		else
			return FALSE;
	}

	/*
	 * name: fetch_advertiser
	 * @param
	 * @return
	 *
	 * This method get the advertisers
	 * 
	 */
	 
	function fetch_advertiser()
	{
		$this->db->select('oc.clientid,oc.clientname,oa.account_id');
		$this->db->from(TAB_ACCOUNTS.' as oa');// I use aliasing make joins easier
		$this->db->join(TAB_USERS.' as ou', 'ou.default_account_id = oa.account_id');
		$this->db->join(TAB_CLIENTS.' as oc', 'oc.account_id = ou.default_account_id');
		$this->db->where('oa.account_type','ADVERTISER');
		$this->db->where('oc.dj_is_default','0');
		$this->db->where('oc.dj_is_deleted','0');
		if($this->user_authentication->manager_adv_pub_id!='' && $this->user_authentication->manager_role_id=='4'):
			
			$adv	=	explode(',',$this->user_authentication->manager_adv_pub_id);
		
			$this->db->where_in('oa.account_id',$adv);
		endif;
		
		$result = $this->db->get();
	 
		if($result->num_rows()>0)
			return $result->result_array();
		else
			return FALSE;

	}
	
	/*
	 * name: fetch_advertiser
	 * @param
	 * @return
	 *
	 * This method get the advertisers
	 * 
	 */
	 
	function remove_direct_uncheckout()
	{
		$whr_camp	=	array(
								'dj_is_checkout'	=>	0,
								'dj_is_direct'		=>	1
							);
									
		$this->db->select('campaignid');				
		$this->db->where($whr_camp);
		$c	=	$this->db->get(TAB_CAMPAIGNS);
		if($c->num_rows()>0)
		{
			foreach($c->result_array() as $camp)
			{
				$whr_ban	=	array(
									'campaignid'	=>	$camp['campaignid'],
									'dj_is_direct'	=>	1
								);
				
				$this->db->select('bannerid');				
				$this->db->where($whr_ban);
				$b	=	$this->db->get(TAB_BANNERS);
				
				if($b->num_rows()>0)
				{
					foreach($b->result_array() as $ban)
					{
						
						$this->db->where('banner_id',$ban['bannerid']);
						$this->db->delete(TAB_BAN_DEPEND);						
						
						$this->db->where('banner_id',$ban['bannerid']);
						$this->db->delete(TAB_BAN_VAST_ELE);
						
						$this->db->where('ad_id',$ban['bannerid']);
						$this->db->delete(TAB_AD_ZONE_ASSOC);
						
						$this->db->where('bannerid',$ban['bannerid']);
						$this->db->delete(TAB_BANNERS);						
					}
				}
				$this->db->where('campaignid',$camp['campaignid']);
				$this->db->delete(TAB_CAM_TRACKERS);
				
				$this->db->where('campaignid',$camp['campaignid']);
				$this->db->delete(TAB_ACLS);
						
				$this->db->where('campaignid',$camp['campaignid']);
				$this->db->delete(TAB_CAMPAIGNS);
			}
		}
		
		return TRUE;

	}
	
	public function direct_campaign_approve($campaignid=FALSE)
	{
		$date	=	date('Y-m-d H:m:s');
		
		if($campaignid!=FALSE)
		{
			
			$whr_camp	=	array(
									'campaignid'	=>	$campaignid,
									'dj_is_direct'	=>	1
								);
			//Camapign Approve					
			$camp		=	array(
									'dj_is_approved'=>	1
								);
								
			$this->db->where($whr_camp);
			$this->db->update(TAB_CAMPAIGNS,$camp);
			
			//Banner Approve
			$ban		=	array(
									'dj_admin_approve'	=>	1,
									'dj_approved_date'	=>	$date
								);
								
			$this->db->where($whr_camp);
			$this->db->update(TAB_BANNERS,$ban);
			
			//Payment Approve
			$whr_pay	=	array(
									'campaign_id'	=>	$campaignid,
									'is_default'	=>	1
								);
			$pay		=	array(
									'admin_approval_status'	=>	1,
									'approved_date'			=>	$date,
									'clearing_date'			=>	$date
								);
								
			$this->db->where($whr_pay);
			$this->db->update('djax_direct_campaign_payment',$pay);
			
			return TRUE;
		}		
		else
		{
			return FALSE;
		}
	}
	
	/*
	 * name: fetch_ssp_type
	 * @param
	 * @return
	 *
	 * This method get list of ssp type
	 * 
	 */

	function fetch_ssp_type($agency_id=false)
	{
		$this->db->select('exchange_name as ssp_type_name,exchange_id as exchangeid');
		$this->db->where('type','SSP');
		$this->db->where('status','1');
		if($agency_id!='')
		{
			$this->db->where('agency_id',$agency_id);
		}
		$query = $this->db->get(TAB_PARTY_ADX);		
		$result = $query->result_array();		
		if($result)
			return $result;
		else
			return FALSE;
	}
	
	/*
	 * name: fetch_publisher_campaign
	 * @param
	 * @return
	 *
	 * This method get list of campaign listing with banner image.
	 * 
	 */
	
	function fetch_publisher_campaign()
	{
		$this->db->select('oxc.campaignid');
		$this->db->from(TAB_ACCOUNTS.' as oa');
		$this->db->join(TAB_USERS.' as ou', 'ou.default_account_id = oa.account_id');
		$this->db->join(TAB_CLIENTS.' as oc', 'oc.account_id = ou.default_account_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxc', 'oxc.clientid = oc.clientid');
		$this->db->where('oc.dj_is_default','0');
		$this->db->where('oc.dj_is_deleted','0');
		$this->db->where('oxc.dj_is_deleted','0');
		$this->db->order_by('oxc.campaignid');
		$this->db->group_by('oxc.campaignid'); 
		$query = $this->db->get(TAB_BANNERS.'as oxb');			
		$result = $query->result_array();
		
		$ban_res='';  
		
		foreach($result as $ad)
		{
			$campaign_id = $ad['campaignid'];  
			
			$SQL="select oxc.campaignname,oxc.campaignid,oxb.filename,oxb.bannerid,oxb.htmltemplate,oxb.htmlcache,oxc.revenue,oxb.storagetype from ".TAB_BANNERS." AS oxb join ".TAB_CAMPAIGNS." AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid=$campaign_id AND oxb.dj_is_deleted='0' AND oxc.dj_is_deleted='0'";
			
			$banner_result = $this->db->query($SQL);
			//return $this->db->last_query();
			if($banner_result->num_rows()>0)
			{
				$SQL .= " AND oxb.filename!=''";
				$SQL .= " group by oxc.campaignid ";
				
				$web_banner_result = $this->db->query($SQL);
				if($web_banner_result->num_rows()>0)
				{
					$web_ban_res=$web_banner_result->result_array();
					
					$cam_id=$web_ban_res[0]['campaignid'];
					$ban_res[$cam_id]['campaignid']=$web_ban_res[0]['campaignid'];
					$ban_res[$cam_id]['campaignname']=$web_ban_res[0]['campaignname']; 
					$ban_res[$cam_id]['filename']=$web_ban_res[0]['filename']; 
					$ban_res[$cam_id]['bannerid']=$web_ban_res[0]['bannerid']; 
					$ban_res[$cam_id]['htmltemplate']=$web_ban_res[0]['htmltemplate']; 
					$ban_res[$cam_id]['htmlcache']=$web_ban_res[0]['htmlcache']; 
					$ban_res[$cam_id]['revenue']=$web_ban_res[0]['revenue']; 
					$ban_res[$cam_id]['storagetype']=$web_ban_res[0]['storagetype']; 
				}
				else
				{
					$SQL ="select oxc.campaignname,oxc.campaignid,oxb.filename,oxb.bannerid,oxb.htmltemplate,oxb.htmlcache,oxc.revenue,oxb.storagetype from ".TAB_BANNERS." AS oxb join ".TAB_CAMPAIGNS." AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid=$campaign_id AND oxb.filename='' AND oxb.dj_is_deleted='0' AND oxc.dj_is_deleted='0' group by oxc.campaignid";					
					$other_banner_result = $this->db->query($SQL);
					 if($other_banner_result->num_rows()>0)
					 {
						$other_ban_res=$other_banner_result->result_array();
						$ban_res[$cam_id]['campaignid']=$other_ban_res[0]['campaignid'];
						$ban_res[$cam_id]['campaignname']=$other_ban_res[0]['campaignname']; 
						$ban_res[$cam_id]['filename']=$other_ban_res[0]['filename']; 
						$ban_res[$cam_id]['bannerid']=$other_ban_res[0]['bannerid']; 
						$ban_res[$cam_id]['htmltemplate']=$other_ban_res[0]['htmltemplate']; 
						$ban_res[$cam_id]['htmlcache']=$other_ban_res[0]['htmlcache']; 
						$ban_res[$cam_id]['revenue']=$other_ban_res[0]['revenue']; 
						$ban_res[$cam_id]['storagetype']=$other_ban_res[0]['storagetype'];
						
					 }
					
				}							
				
			}
						
		}		
				
		if($ban_res)
			return $ban_res;
		else
			return FALSE;		
		
	}
	
	
	function fetch_selected_campaign_list($campaign_id)
	{
		$ban_res = '';
		
		$SQL="select oxc.campaignname,oxc.campaignid,oxb.filename,oxb.bannerid,oxb.htmltemplate,oxb.htmlcache,oxc.revenue,oxb.storagetype,oxb.width,oxb.height from ".TAB_BANNERS." AS oxb join ".TAB_CAMPAIGNS." AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid=$campaign_id AND oxb.dj_is_deleted='0' AND oxc.dj_is_deleted='0'";
			
		$banner_result = $this->db->query($SQL);

		if($banner_result->num_rows()>0)
			{
				$SQL .= " AND oxb.filename!=''";
				$SQL .= " group by oxc.campaignid ";
				
				$web_banner_result = $this->db->query($SQL);
				if($web_banner_result->num_rows()>0)
				{
					$web_ban_res=$web_banner_result->result_array();
					
					$cam_id=$web_ban_res[0]['campaignid'];
					$ban_res[$cam_id]['campaignid']=$web_ban_res[0]['campaignid'];
					$ban_res[$cam_id]['campaignname']=$web_ban_res[0]['campaignname']; 
					$ban_res[$cam_id]['filename']=$web_ban_res[0]['filename']; 
					$ban_res[$cam_id]['bannerid']=$web_ban_res[0]['bannerid']; 
					$ban_res[$cam_id]['htmltemplate']=$web_ban_res[0]['htmltemplate']; 
					$ban_res[$cam_id]['htmlcache']=$web_ban_res[0]['htmlcache']; 
					$ban_res[$cam_id]['revenue']=$web_ban_res[0]['revenue']; 
					$ban_res[$cam_id]['storagetype']=$web_ban_res[0]['storagetype']; 
					$ban_res[$cam_id]['width']=$web_ban_res[0]['width'];
					$ban_res[$cam_id]['height']=$web_ban_res[0]['height'];
				}
				else
				{
					$SQL ="select oxc.campaignname,oxc.campaignid,oxb.filename,oxb.bannerid,oxb.htmltemplate,oxb.htmlcache,oxc.revenue,oxb.storagetype,oxb.width,oxb.height from ".TAB_BANNERS." AS oxb join ".TAB_CAMPAIGNS." AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid=$campaign_id AND oxb.filename='' group by oxc.campaignid";
					$other_banner_result = $this->db->query($SQL);
					 if($other_banner_result->num_rows()>0)
					 {
						$other_ban_res=$other_banner_result->result_array();
						$ban_res[$cam_id]['campaignid']=$other_ban_res[0]['campaignid'];
						$ban_res[$cam_id]['campaignname']=$other_ban_res[0]['campaignname']; 
						$ban_res[$cam_id]['filename']=$other_ban_res[0]['filename']; 
						$ban_res[$cam_id]['bannerid']=$other_ban_res[0]['bannerid']; 
						$ban_res[$cam_id]['htmltemplate']=$other_ban_res[0]['htmltemplate']; 
						$ban_res[$cam_id]['htmlcache']=$other_ban_res[0]['htmlcache']; 
						$ban_res[$cam_id]['revenue']=$other_ban_res[0]['revenue']; 
						$ban_res[$cam_id]['storagetype']=$other_ban_res[0]['storagetype'];
						$ban_res[$cam_id]['width']=$other_ban_res[0]['width'];
						$ban_res[$cam_id]['height']=$other_ban_res[0]['height'];
						
					 }
					
				}							
				
			}
			
			
			/* Display all banners of the campaign */
			
			/*$BANNER_SQL="select * from ".TAB_BANNERS." AS oxb where oxb.campaignid=$campaign_id AND oxb.dj_is_deleted='0'";
			
			$cam_banner_result = $this->db->query($BANNER_SQL);
			
			$cam_ban_res=$cam_banner_result->result_array();
			
			foreach($cam_ban_res as $ban)
			{
				$ban_res[$campaign_id]['bannerid']=$ban['bannerid'];
				
			}*/
			
			
						
		if($ban_res)
			return $ban_res;
		else
			return FALSE;			
	}
	
	function fetch_campaign_list($country,$category,$creatives_size)
	{
		
		$this->db->select('oxc.campaignid');
		$this->db->from(TAB_ACCOUNTS.' as oa');
		$this->db->join(TAB_USERS.' as ou', 'ou.default_account_id = oa.account_id');
		$this->db->join(TAB_CLIENTS.' as oc', 'oc.account_id = ou.default_account_id');
		$this->db->join(TAB_CAMPAIGNS.' as oxc', 'oxc.clientid = oc.clientid');
		$this->db->where('oc.dj_is_default','0');
		$this->db->where('oc.dj_is_deleted','0');
		$this->db->where('oxc.dj_is_deleted','0');
		//if($country!='all') {}
		if($category!='all' && $category!='') 
		{
			$this->db->where('oxc.dj_category_id',$category);
		}		
		
		$this->db->group_by('oxc.campaignid'); 
		$query = $this->db->get(TAB_BANNERS.'as oxb');			
		$result = $query->result_array();	
		//return $this->db->last_query();
		$campaign_id='';
		
		foreach($result as $ad)
		{
			$campaign_id.=$ad['campaignid'].","; 
		}
		
		$campaign_id=rtrim($campaign_id,",");
		
		if($creatives_size!='all' && $creatives_size!='' )
		{	
			$ad_size=explode("x",$creatives_size);
			$width=$ad_size[0];
			$height=$ad_size[1];
			
			$camp_id=explode(",",$campaign_id);
			foreach($camp_id as $cam_id)
			{							   
				$cam_result=$this->db->query("select * from ".TAB_BANNERS." AS oxb join ".TAB_CAMPAIGNS." AS oxc ON oxb.campaignid=oxc.campaignid where oxb.width='$width' AND oxb.height='$height' AND oxb.campaignid='$cam_id'");
				if($cam_result->num_rows()>0)
				{
					$ad_campaign_id.=$cam_id.","; 
				}
				
			}
		$campaign_id=rtrim($ad_campaign_id,",");		
		}
		
		$banner_result=$this->db->query('select oxc.campaignname,oxc.campaignid,oxb.filename,oxb.htmltemplate,oxb.htmlcache,oxc.revenue,oxb.storagetype from '.TAB_BANNERS.' AS oxb join ' .TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid IN('.$campaign_id.') group by oxc.campaignid ORDER BY oxb.bannerid DESC'); 
					
		$ban_res=$banner_result->result_array();
					
		if($ban_res)
			return $ban_res;
		else
			return FALSE;
		
	}
	
	function fetch_rotator_campaign($campaignid)
	{
				
		$campaign_id='';
		
		foreach($campaignid as $ad)
		{
			$campaign_id.=$ad.","; 
		}
		
		
		$campaign_id=rtrim($campaign_id,",");
		
		$banner_result=$this->db->query('select oxc.campaignname,oxc.campaignid,oxb.width,oxb.height,oxb.dj_banner_type from '.TAB_BANNERS.' AS oxb join ' .TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid IN('.$campaign_id.')  and oxb.width >= 0 and oxb.height >= 0 and oxc.dj_is_rtb_campaign IS NULL GROUP BY oxc.campaignname,oxc.campaignid,oxb.width,oxb.height');
		//return $this->db->last_query();	
		$ban_res=$banner_result->result_array();
			//return $banner_result;			
		if($ban_res)
			return $ban_res;
		else
			return FALSE;
		
		
	}
	
	function fetch_exist_banner($campaignid,$width,$height)
	{
				
		$campaign_id='';
		
		foreach($campaignid as $ad)
		{
			$campaign_id.=$ad.","; 
		}
		
		$camp_array=array();
		$campaign_id=rtrim($campaign_id,",");
		
		$banner_result=$this->db->query('select distinct oxc.campaignname,oxc.campaignid,oxb.width,oxb.height,oxb.dj_banner_type from '.TAB_BANNERS.' AS oxb join ' .TAB_CAMPAIGNS.' AS oxc ON oxb.campaignid=oxc.campaignid where oxc.campaignid IN('.$campaign_id.') and oxb.width = '.$width.' and oxb.height = '.$height.' and oxc.dj_is_rtb_campaign IS NULL GROUP BY oxc.campaignname,oxc.campaignid,oxb.width,oxb.height'  );
			
		$rows=$banner_result->num_rows();
		$ex_cam=explode(",",$campaign_id);
		$countofex=count($ex_cam);
		
		$ban_res=$banner_result->result_array();
			
		if($ban_res)
			return $ban_res;
		else
			return FALSE;
		
		
	}
}
