<?php

/*
 * name : Adgate site
 * Author: Adgate
 * Worked by : suganthi
 */
  
class site extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->no_cache();	
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));	
		$this->load->config('report_configurations');
		$this->load->library('pdf');		
	}
	
	
	/*
	 * 
	 * name		:index
	 * @param   :Null
	 * @return  :Login page
	 */	
	 
	 
	function index()
	{		
		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/home',$data,TRUE);
	}
	
	/*
	 * 
	 * name		:advertisers
	 * @param   :Null
	 * @return  :Advertiser page
	 */	
	 
	function advertisers()
	{		

		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));
		$data['referral_id']	=	0;	
		$data['breadcrumb'] 	= 	'';
		$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');				
		$data['agencyid']		=	$approve_user[0]['agency_id'];
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$phone_verify			=	$this->rest->get('api/v1/user/get_phone_verify_config',array('network_id'=>$approve_user[0]['agency_id']),'php'); 
		
		$data['phone_verify']	=$phone_verify[0]['phone_verify'];
		$payment_info			=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>$adm[0]['api_key'],'payment_type'=>1),'php');
		$data['wire_details']	=	($payment_info!='error' && is_array($payment_info))?$payment_info[0]:'';
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>$adm[0]['api_key']),'php');
		$data['security_question']=$security_question;	
		/*$data['content'] 		= 	$this->load->view('site/advertisers',$data,TRUE);
		
		$this->template->set_layout('direct_layout');
		$this->template->build('view', $data);*/
		echo $data['content'] 	= 	$this->load->view('site/advertisers',$data,TRUE);
		//$this->rest->debug();exit;
	}
	
	/*
	 * 
	 * name		:publishers
	 * @param   :Null
	 * @return  :Publisher page
	 */	
	 
	function publishers($type=FALSE,$referral=FALSE)
	{	
		if($type=='referral')
		{
			if($referral!=FALSE)
			{
				$data['referral_id']	=	base64_decode(urldecode($referral));
			}	
			else
			{
				$data['referral_id']	=	0;
			}
		}
		else
		{
			$data['referral_id']	=	0;
		}
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php');
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>$adm[0]['api_key']),'php');
		$data['security_question']=$security_question;	
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		
		$data['breadcrumb'] 	= 	'';
		$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');				
		$data['agencyid']		=	$approve_user[0]['agency_id'];		
		
		if($type ==true && $referral ==true )
		{
			$data['type']			=	'pub';
			echo $data['content']=$this->load->view('site/signup',$data,TRUE); 
		}
		else 
		{
		echo $data['content'] 	= 	$this->load->view('site/publishers',$data,TRUE);
	}
	}
	
	/*
	 * 
	 * name		:network
	 * @param   :Null
	 * @return  :Network page
	 */	
	 
	function network()
	{	
		$data['page_title'] = 	"Media Kit";

		$data['breadcrumb'] = 	'';
		
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		
			
		/************ Guest Advertiser *************/
		
		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$data['api_key']),'php');
		
		$data['campaign_type']	= $this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$data['api_key']),'php');
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		$set = $this->config->item('report_config');
		//print_r($set['ADMIN']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']); 
		
		$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$data['api_key']),'php');
		
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$data['api_key']),'php');
		
		$data['browsers']		= 	$this->rest->get('api/v1/targeting/fetch_browsers',array('api_key'=>$data['api_key']),'php');
		
		$data['language']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$data['api_key'],'type'=>'language'),'php');
		
		$data['os']				= 	$this->rest->get('api/v1/targeting/fetch_os',array('api_key'=>$data['api_key']),'php');
		
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$data['api_key']),'php');
						
		echo $data['content'] 			= 	$this->load->view('site/network',$data,TRUE);
				
		//$this->template->set_layout('direct_layout');
		
		//$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:FAQs
	 * @param   :Null
	 * @return  :Frequently asked questions
	 */	
	 
	function FAQs()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/FAQs',$data,TRUE);
	}
	/*
	 * 
	 * name		:cookies
	 * @param   :Null
	 * @return  :Cookies information questions
	 */	
	 
	function cookies()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/cookies',$data,TRUE);
	}
	
	/*
	 * 
	 * name		:news
	 * @param   :Null
	 * @return  :News page
	 */	
	 
	function news()
	{				

		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$news	=	$this->rest->post('api/v1/site/news',array('api_key'=>$api_key),'json');
		$length	=	$this->rest->get('api/v1/app_settings/get_values',array('api_key'=>$api_key,'network_id'=>1),'php');
		$data['length']=$length[0]['default_per_page'];
		 
		$data['news_content']=json_decode($news,true);
		echo $data['content'] 	= 	$this->load->view('site/news',$data,TRUE);
	}
	/*
	 * 
	 * name		:contact_us
	 * @param   :Null
	 * @return  :Contact page
	 */	
	 
	/*
	 * 
	 * name		:contact_us
	 * @param   :Null
	 * @return  :Contact page
	 */	
	 
	function contact_us()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$approve_user			=	$this->rest->get('api/v1/user/contactus','','php');
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/contact_us',$data,TRUE);
	}
	/*
	 * 
	 * name		:supports
	 * @param   :Null
	 * @return  :support page
	 */	
	 
	function supports()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$approve_user			=	$this->rest->get('api/v1/user/contactus','','php');
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/supports',$data,TRUE);
	}
	
	/*
	 * 
	 * name		:careers
	 * @param   :Null
	 * @return  :Careers page
	 */	
	 
	function careers($cat=FALSE)
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		$data['personal_info']	=   $personal_info[0];
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];		
		$data['country']		=   $this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		$data['category_list']	=   $this->rest->get('api/v1/utilities/fetch_job_category',array('api_key'=>$api_key),'php');
		$data['job_listing']	=   $this->rest->get('api/v1/user/job_listing',array('api_key'=>$api_key),'php');
		if($cat!=FALSE)
		{
			if($cat=="IT")
			{
				$category="6";
			}
			else if($cat=="SALES")
			{
				$category="8";
			}
			else if($cat=="MARKETING")
			{
				$category="7,4";
			}
			else if($cat=="CORPORATE")
			{
				$category="5,3";
			}
			else if($cat=="FINANCE")
			{
				$category="1,2";
			}
			
			$data['careers_list']	=   $this->rest->get('api/v1/utilities/careers_list',array('api_key'=>$api_key,'category'=>$category),'php');
			echo $this->load->view('site/careers_list',$data,TRUE); 		
		}
		else
		{   
			echo $data['content'] 	= 	$this->load->view('site/careers',$data,TRUE);   
		}
	}
	
	/*
	 * 
	 * name		:view_job
	 * @param   :Null
	 * @return  :View job details
	 */	
	 
	function view_job($enc_val,$title)
	{	
		$job_list=str_replace('-', ' ', $id);
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	  
		$data['job_listing']	=   $this->rest->get('api/v1/jobs/job_listing',array('api_key'=>$api_key,'job_title_enc'=>$enc_val),'php');			
		echo $data['content'] 	= 	$this->load->view('site/view_job',$data,TRUE);
	}
	
	
	
	
	
	
	/*
	 * 
	 * name		:sign_up
	 * @param   :Null
	 * @return  :Sign Up page
	 */	
	 
	function sign_up($type='adv',$ref=FALSE,$referral=FALSE)
	{		
		if($type=='pub' && $ref=='referral')
		{
			if($referral!=FALSE)
			{
				$data['referral_id']	=	base64_decode(urldecode($referral));
			}	
			else
			{
				$data['referral_id']	=	0;
			}
		}
		else
		{
			$data['referral_id']	=	0;
		}
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$payment_info			=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>$adm[0]['api_key'],'payment_type'=>1),'php');
		$data['wire_details']	=	($payment_info!='error' && is_array($payment_info))?$payment_info[0]:'';
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>$adm[0]['api_key']),'php');
		$data['security_question']=$security_question;	
		
		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';			
		$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');				
		$data['agencyid']		=	$approve_user[0]['agency_id'];
		$data['type']			=	$type;
		echo $data['content'] 	= 	$this->load->view('site/sign_up',$data,TRUE);
	}	
	
	/*
	 * 
	 * name		:apply_job
	 * @param   :Null
	 * @return  :Apply for php debveloper page
	 */	
	 
	/*function apply_job($title_enc,$title)
	{	
		if($title!=FALSE)
		{
			$job_list=str_replace('-', '', $title);
		}
		$data['page_title'] 	= 	"Careers-".$job_list;	
		$data['breadcrumb'] 	= 	'';
		$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');	
		$data['account_info']	=   $account_info[0];	
		//$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$approve_user			=	$this->rest->get('api/v1/user/apply_job',array('api_key'=>get_session('api_key')),'php');
		$data['title'] 			= $title;
		echo $data['content']	= $this->load->view('site/apply_job',$data,TRUE);
		
	}*/

	function apply_job($id=FALSE)
	{	
		$adm = $this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$job = $this->rest->get('api/v1/utilities/fetch_job',array('api_key'=>$adm[0]['api_key'],'id'=>$id),'php');
		$data['job']=$job[0];
		$data['api_key']=$adm[0]['api_key'];
		echo $this->load->view('site/apply_job',$data,TRUE);       		
	}
	
	/*
	 * 
	 * name		:about
	 * @param   :Null
	 * @return  :About page
	 */	
	 
	function about()
	{		

		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/about',$data,TRUE);
	}
	
	/*
	 * 
	 * name		:terms_of_use
	 * @param   :Null
	 * @return  :Terms of use page
	 */	
	 
	function terms_of_use()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/terms_of_use',$data,TRUE);
	}
	
	function job_appplication()
	{
		$data['page_title'] 	= 	"Careers";	
		$data['breadcrumb'] 	= 	'';
		//$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');	
		$data['account_info']=$account_info[0];	
			//$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
		$approve_user			=	$this->rest->get('api/v1/user/apply_job',array('api_key'=>get_session('api_key')),'php');	
		
		
		echo $approve_user;
		
		exit;
		
		echo $data['content'] 	= 	$this->load->view('site/apply_php',$data,TRUE);

		$data['acc_type'] 		= 	'PUBLIC';}
	/*
	 * 
	 * name		:privacy_policy
	 * @param   :Null
	 * @return  :Privacy policy page
	 */	
	 
	function privacy_policy()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/privacy_policy',$data,TRUE);
	}
	
	protected function no_cache(){
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0',false);
		header('Pragma: no-cache'); 
	}
	
	public function fetch_country_stat($format='json',$c,$from_date,$to_date)
	{
		
		/************ Guest Advertiser *************/
		$gadv				=	$this->rest->get('api/v1/user/get_admin_api',array(),'php');
		
		$data['guest_adv']	=	$gadv[0];
		
		$api_key			=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		//$api_key 	= get_session('api_key');
		$account_type 	= 	get_session('account_type');
		$page			= 	'REPORT_GEO_GRAPHICAL';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'NETWORK',
					  );
					  
		$env = $this->input->post('env');
		$country = $this->input->post('country');
		$adsize		= 	clean_data($this->input->post('adsize'));
		$camtyp 	= 	clean_data($this->input->post('revtype'));
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$brow		= 	clean_data($this->input->post('browser'));
		$os			= 	clean_data($this->input->post('os'));
		$dev_type	= 	clean_data($this->input->post('dev_type'));
		$brow_lang	= 	clean_data($this->input->post('brow_lang'));
		$bid_price	= 	clean_data($this->input->post('bid_price'));
		if(!empty($country) && $country!='all')
		{
			$input['country'] = explode(',',$country);
		}
		if(!empty($dev_type) && $dev_type!='all')
		{
			$input['dev_type'] = explode(',',$dev_type);
		}
		if($from_date == NULL){
		  $from_date = $this->input->post('from_date');
		}
		if($to_date == NULL){
			$to_date = $this->input->post('to_date');
		}
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($country != 'all'){
			$input['country_id'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($brow != 'all'){
			$input['browser'] = ($brow)?((is_array($brow))?$brow:explode(',',$brow)):'';
		}
		if($brow_lang != 'all'){
			$input['brow_lang'] = ($brow_lang)?((is_array($brow_lang))?$brow_lang:explode(',',$brow_lang)):'';
		}
		
		if($os != 'all'){
			$input['os'] = ($os)?((is_array($os))?$os:explode(',',$os)):'';
		}
		if($bid_price != ''){
			$input['bid_price'] = $bid_price;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		if(!empty($_POST['dimensions']))	
		{
			$input['dimensions']	= $_POST['dimensions'];
		}
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		//echo $this->rest->debug();exit;
		
		echo $data;
	
	}
	function test()
	{
		echo file_put_contents("text_doc.txt","Hello World. Testing!");
	}

	/*
	 * 
	 * name		:Direct ads
	 * @param   :Null
	 * @return  :Direct Ads page
	 */	
	 
	function directads()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));
		$data['breadcrumb'] 	= 	'';
		
		$data['acc_type'] 		= 	'PUBLIC';	
		echo $data['content'] 	= 	$this->load->view('site/directads',$data,TRUE);
	}

	function direct_demo()
	{	
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));
		$data['breadcrumb'] 	= 	'';
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];
		
		$data['browsers']	= 	$this->rest->get('api/v1/utilities/fetch_target_browsers',array("api_key"=>$api_key),'php');
		$data['language']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'language'),'php');
		$data['os']			= 	$this->rest->get('api/v1/utilities/fetch_target_os',array("api_key"=>$api_key),'php');
		$data['keywords']	= 	$this->rest->get('api/v1/utilities/fetch_target_keyword',array("api_key"=>$api_key),'php');
		$data['manu']		= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_manu',array("api_key"=>$api_key),'php');
		$data['capability']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_capability',array("api_key"=>$api_key),'php');
		$data['carrier']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_carrier',array("api_key"=>$api_key),'php');
		$data['continent']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'continent'),'php');
		$data['countries']	= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>$api_key),'php');
		$data['dev_type']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'dev_type'),'php');
		$data['device']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'device'),'php');
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		$data['days']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'days'),'php');
		$data['connection']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'connection'),'php');
		
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>$api_key,'adblock_type'=>'black'),'php');		
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>$api_key,'adblock_type'=>'white'),'php');		
			
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$api_key),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>$api_key),'php');
		
		$data['search_date']      	= 	get_search_date($set['ADVERTISER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['acc_type'] 		= 	'PUBLIC';	
		
		echo $data['content'] 	= 	$this->load->view('site/demo/direct_demo',$data,TRUE);
		
		//$data['content'] 	= 	$this->load->view('site/demo/direct_demo',$data,TRUE);
		//$this->template->set_layout('direct_layout');
		//$this->template->build('view', $data);
	}
	
	function download_invoice()
	{
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));
		$data['breadcrumb'] 	= 	'';
		
		$pdf_name = 'Adgate_Invoice_'.date('d.m.Y');
		$this->pdf->load_view('site/demo/download_invoice',$data);
		$this->pdf->render();
		$this->pdf->stream("$pdf_name.pdf");
	}
	
	public function demo_creative($parameters=FALSE)
	{
		$params	=	explode('__',urldecode(base64_decode($parameters)));
		
		$data['type']			=	($params[0])?$params[0]:'';
		
		$data['url']			=	($params[1])?$params[1]:'';
		
		if($params[0]=='img' || $params[0]=='txt')
		{
			$data['content']		=	($params[2])?$params[2]:'';
		}
			
		$this->load->view('site/demo/demo_creative',$data);		
	}
	
	function custom_url()
	{		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';	
		$data['personal_info']=$personal_info[0];		
		echo $data['content'] 	= 	$this->load->view('site/customurl',$data,TRUE);
	}
	
	/*
	 * 
	 * name		:Stats
	 * @param   :Null
	 * @return  :Report page
	 */	
	 
	function report($acc_type=false)
	{		
		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));
		$data['referral_id']	=	0;	
		$data['breadcrumb'] 	= 	'';
		$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');				
		$data['agencyid']		=	$approve_user[0]['agency_id'];
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>$adm[0]['api_key']),'php');
		if($acc_type)
		{
			$data['acc_type'] 	= 	$acc_type;
		}
		echo $data['content'] 	= 	$this->load->view('reports/report',$data,TRUE);
		//$this->rest->debug();exit;
	}
	
	/*
	 * 
	 * name		:overview
	 * @param   :Null
	 * @return  :Generate advertser reports by the datewise.
	 */	

	public function remove_session()
	{
		//$this->ci->session->sess_destroy();
		$session	  =	$this->session->all_userdata();

		$account_type = get_session('account_type');					
		
		if($session)
		{
			$this->session->unset_userdata($session);
		}	
		
		$this->session->sess_destroy();
		
		redirect();

	}
	
	/*
	 * 
	 * name		:adv_overview
	 * @param   :Null
	 * @return  :Advertiser Report page
	 */	
	
	
	public function adv_overview()
	{
		$data['page_title'] 	= 	"Advertiser reports";

		$data['breadcrumb'] 	= 	'';
		
		$adv_details = $_POST;
		if($adv_details['api_key'])
		{
		$api_key				=	$adv_details['api_key'];
		$account_id				=	$adv_details['account_id'];
		$agency_id				=	$adv_details['agency_id'];

		/* Advertiser Filter */
		//$data['adv_data'] 		=	$this->rest->get('api/v1/report/fetch_advertiser',array('api_key'=>$api_key),'php');
		
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$api_key,'account_id'=>$account_id,'agency_id'=>$agency_id),'php');
		
		$data['creatives']		= 	$this->rest->get('api/v1/report/fetch_creatives',array("api_key"=>$api_key,'account_id'=>$account_id),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
			
		$data['campaign_type']	= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['adv_details'] 	= 	$adv_details;
		//$set 					= 	$this->config->item('report_config');
		$data['search_date'] 	= 	get_search_date($set['ADMIN']['REPORT_ADVERTISER']['CHART']['DEFAULT_INTERVAL']);
		
		echo /*$data['content'] 		= */	$this->load->view('reports/admin_adv_report',$data,TRUE);
		//$this->template->set_layout('report_index_layout');
		//$this->template->build('view', $data);
	}
	}
	
	
	/*
	 * 
	 * name		:pub_overview
	 * @param   :Null
	 * @return  :Publi sher Report page
	 */	
	 
	 
	public function pub_overview()
	{	
		$data['page_title'] = 	"Publisher reports";

		$data['breadcrumb'] = 	'';
		
		$pub_details = $_POST;
		if($pub_details['api_key'])
		{
		$api_key				=	$pub_details['api_key'];
		$account_id				=	$adv_details['account_id'];
		
		/* Publisher Filter */
		//$data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key,'account_id'=>$account_id),'php');
		
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,'account_id'=>$account_id),'php');
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['pub_details'] 	= 	$pub_details;
		//$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_PUBLISHER']['CHART']['DEFAULT_INTERVAL']);
		echo $this->load->view('reports/admin_pub_report',$data,TRUE);
		/*$data['content'] 	= 	$this->load->view('reports/admin_pub_report',$data,TRUE);*/
		//~ $this->template->set_layout('report_index_layout');
		//~ $this->template->build('view', $data);
		}
	}
	
	 
	function news_data($id=FALSE)
	{				
 
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$news	=	$this->rest->post('api/v1/site/news',array('api_key'=>$api_key),'json');
		if($id){
			$data['present_id']=$id;
		}
		$data['news_content']=json_decode($news,true);
		echo $data['content'] 	= 	$this->load->view('site/news_data',$data);
	}
	
	function news_list($month=FALSE,$year=FALSE)
	{
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];//	echo $month.'ss'.$year;exit;
		$news	=	$this->rest->post('api/v1/site/news',array('api_key'=>$api_key,'month'=>$month,'year'=>$year),'json');
		echo convert_to_datatable_format($news);
	}
	
	function admarket()
	{
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$data['adm_camp_data']	=	$this->rest->post('api/v1/site/admarket_pgm',array('api_key'=>$api_key),'php');
		  //~ print_r($data);exit;
		//~ echo $data['content'] 	= 	$this->load->view('site/admarket_pgm',$data,TRUE);
		echo $data['content'] 	= 	$this->load->view('site/admarket_pgm');
	}
	
	function admarket_clist($month=FALSE,$year=FALSE)
	{
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];//	echo $month.'ss'.$year;exit;
		$news	=	$this->rest->post('api/v1/site/admarket_pgm',array('api_key'=>$api_key),'json'); 
		//print_r($this->rest->debug());exit;
		echo convert_to_datatable_format($news);
	}
	function partner($adv_id=false)
	{
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$arr=array('api_key'=>$api_key);
		if($adv_id)
		{
			$arr['adv_id']=$adv_id;
			$data['banner_count']	=	$this->rest->post('api/v1/site/banner_count',$arr,'php'); 
			$data['adv_id']=$adv_id;
			$data['adm_camp_data']	=	$this->rest->post('api/v1/site/admarket_pgm',$arr,'php');
			$data['adm_camp_data_country']	=	$this->rest->post('api/v1/site/admarket_pgm_country',$arr,'php');
			
			 
			if(!is_array($data['adm_camp_data'])) 
			{
				echo $data['content'] 	= 	$this->load->view('site/admarket_pgm');
			}else
			{ 
				echo $data['content'] 	= 	$this->load->view('site/partner/advertiser',$data,TRUE);
			}
		}
		else
		{
			echo $data['content'] 	= 	$this->load->view('site/admarket_pgm',$data,TRUE);
		}
	}
	public function partnerprogramme($market_id=false)
	{
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';
		$data['acc_type'] 		= 	'PUBLIC';
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$arr=array('api_key'=>$api_key);
		if($market_id)
		{
			$data['banner_count']	=	$this->rest->post('api/v1/site/banner_count',array('api_key'=>$api_key,'market_id'=>$market_id),'php'); //print_r($data['banner_count']);exit;
			$data['adm_camp_data']	=	$this->rest->post('api/v1/site/admarket_pgm',array('api_key'=>$api_key,'market_id'=>$market_id),'php'); //print_r($this->rest->debug());exit;
			$data['country']	=	$this->rest->post('api/v1/site/admarket_pgm_country',array('api_key'=>$api_key,'market_id'=>$market_id),'php'); 
			$data['adm_camp_data_country']	=	$this->rest->post('api/v1/site/admarket_pgm_country',array('api_key'=>$api_key,'market_id'=>$market_id),'php');
		
			echo $data['content'] 	= 	$this->load->view('site/partner/advertiser',$data,TRUE);
		}
		else
		{
			echo $data['content'] 	= 	$this->load->view('site/admarket_pgm',$data,TRUE);
		}
	}
	function materials($market_id=FALSE)
	{
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$data['api_key']		=	$api_key; 
		$data['market_id']			=	$market_id;  
		echo $data['content'] 	= 	$this->load->view('site/partner/materials',$data,TRUE);
	}
	public function fetch_ad_materials($market_id=FALSE)
	{
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$api_key				=	$adm[0]['api_key'];	
		$array_val=array('api_key'=>$api_key);
		if($market_id)
		{
			$array_val['market_id']=$market_id;
		}
		$result = $this->rest->post('api/v1/site/fetch_ad_materials',$array_val,'json');
		//print_r($result);exit;
		echo convert_to_datatable_format($result);	 
	}
	
	function login()
	{		
		$data['page_title'] = "";
		echo $data['content'] 	= 	$this->load->view('site/login',$data,TRUE);		
	}

	
	/*

	 * 

	 * name		:admin

	 * @param   :Null

	 * @return  :Login on success

	 */	
	

	function admin()
	{
		$data['page_title'] 	= 	"Admin Login ";		
		$data['acc_type'] 		= 	'ADMIN';	
		echo $data['content'] 		= 	$this->load->view('site/admin_login',$data,TRUE);
	}

	
	function advertiser()
	{	
		$data['page_title'] = "";
		$data['acc_type'] 		= 	'ADVERTISER';		
		echo $data['content'] 	= 	$this->load->view('site/adv_login',$data,TRUE);		
	}
	
	function publisher()
	{	
		$data['page_title'] = "";
		$data['acc_type'] 		= 	'TRAFFICKER';		
		echo $data['content'] 	= 	$this->load->view('site/pub_login',$data,TRUE);		
	}
	
	function signup($type='adv',$ref=FALSE,$referral=FALSE)
	{
		if($type=='pub' && $ref=='referral')
		{
			if($referral!=FALSE)
			{
				$data['referral_id']	=	base64_decode(urldecode($referral));
			}	
			else
			{
				$data['referral_id']	=	0;
			}
		}
		else
		{
			$data['referral_id']	=	0;
		}
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$payment_info			=	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>$adm[0]['api_key'],'payment_type'=>1),'php');
		$data['wire_details']	=	($payment_info!='error' && is_array($payment_info))?$payment_info[0]:'';
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>$adm[0]['api_key']),'php');
		$data['security_question']=$security_question;	
		
		
		$data['page_title'] 	= 	ucwords($this->config->item('prod_name'));	
		$data['breadcrumb'] 	= 	'';			
		$approve_user			=	$this->rest->get('api/v1/user/get_agency_id','','php');				
		$data['agencyid']		=	$approve_user[0]['agency_id'];
		$data['type']			=	$type;				
			
		echo $data['content']=$this->load->view('site/signup',$data,TRUE); 
	}
	
	function forget_password($acc_type = FALSE)
	{	
		if(!empty($acc_type))
		{
			$data['page_title'] = "Forgot Password ";		
		
			$data['acc_type']	= strtoupper($acc_type);    
									
			echo $data['content'] = $this->load->view('site/forget_password',$data,TRUE);

		}
		else
		{
			redirect('site');	
		}

	}	
	
	function logout($acc_type = FALSE)
	{
	
     	$session	  =	$this->session->all_userdata();				
		$logged_admin=get_session('is_logged_from_admin');
						
		if($session)
		{
			if($logged_admin=='1')
			{		
				$primary_id=$session['primary_id'];  
				if($primary_id!='')
				{
				$SQL="select * from djax_admin_session where id=".$primary_id;
				$query=$this->db->query($SQL);			
				if($query->num_rows() > 0){
					$admin_data = $query->result_array();
				}	
												
				if($admin_data!='')
				{
					$CI = &get_instance();
		        	$CI->load->library('encrypt');		
					$this->session->sess_destroy();	
					$pdt_name = $CI->config->item('prod_name');
					$sess_array = array();		
					$common_session=array('session_id','primary_id','account_id','account_type','ip_address',
					'user_agent','last_activity','user_data','time_zone',$pdt_name.'_first_name',
					$pdt_name.'_last_name',$pdt_name.'_username',$pdt_name.'_default_manager',
					$pdt_name.'_agencyid',$pdt_name.'_account_id',$pdt_name.'_account_type',
					$pdt_name.'_email',$pdt_name.'_api_key',$pdt_name.'_denied',$pdt_name.'_default_account_id',
					$pdt_name.'_default_advertiser_account_id',$pdt_name.'_default_advertiser_client_id',$pdt_name.'_time_zone',$pdt_name."_cur_login_time");
					$res['session_id']=$admin_data[0]['session_id'];
					$res['primary_id']=$admin_data[0]['id'];
					$res['account_id']=$admin_data[0]['account_id'];
					$res['account_type']=$admin_data[0]['account_type'];
					$res['ip_address']=$admin_data[0]['ip_address'];
					$res['user_agent']=$admin_data[0]['user_agent'];
					$res['last_activity']=$admin_data[0]['last_activity'];
					$res['user_data']=$admin_data[0]['user_data'];
					$res['time_zone']=$admin_data[0]['time_zone'];					
					$res[$pdt_name.'_first_name']=$admin_data[0]['Adgate_first_name'];
					$res[$pdt_name.'_last_name']=$admin_data[0]['Adgate_last_name'];
					$res[$pdt_name.'_username']=$admin_data[0]['Adgate_username'];
					$res[$pdt_name.'_default_manager']=$admin_data[0]['Adgate_default_manager'];
					$res[$pdt_name.'_agencyid']=$admin_data[0]['Adgate_agencyid'];
					$res[$pdt_name.'_account_id']=$admin_data[0]['Adgate_account_id'];
					$res[$pdt_name.'_account_type']=$admin_data[0]['Adgate_account_type'];
					$res[$pdt_name.'_email']=$admin_data[0]['Adgate_email'];
					$res[$pdt_name.'_api_key']=$admin_data[0]['Adgate_api_key'];
					$res[$pdt_name.'_denied']=$admin_data[0]['Adgate_denied'];
					$res[$pdt_name.'_default_account_id']=$admin_data[0]['Adgate_default_account_id'];
					$res[$pdt_name.'_default_advertiser_account_id']=$admin_data[0]['Adgate_default_advertiser_account_id'];
					$res[$pdt_name.'_default_advertiser_client_id']=$admin_data[0]['Adgate_default_advertiser_client_id'];
					$res[$pdt_name.'_time_zone']=$admin_data[0]['Adgate_time_zone'];
					$res[$pdt_name.'_cur_login_time']=$admin_data[0]['Adgate_cur_login_time'];	
					
					
					
					if(!empty($common_session))
					{					
						foreach ($common_session as $key)
						{
							if(in_array($key,array_keys($res)))
							{							    
							$sess_array[$key] = $res[$key];																						
							}
						}
					}
					
					$this->session->set_userdata($sess_array);					
					//$DELETE_SQL="delete from djax_admin_session where id=".$primary_id;
					//$this->db->query($DELETE_SQL);
					
				}	
				}				
			}
			else
			{  
			$this->session->unset_userdata($session);
			$this->session->sess_destroy();						
			}
		}		
																
		if(strtoupper($acc_type)==='ADMIN')
		{			
			redirect($acc_type);
		}
		else if($logged_admin=='1')
		{ 				
			redirect("admin/dashboard");			
		}
		else
		{  
			redirect();  
		}

	}	

}
