<?php
/**
 * PayPal_Lib Controller Class (Paypal IPN Class)
 *
 * Paypal controller that provides functionality to the creation for PayPal forms, 
 * submissions, success and cancel requests, as well as IPN responses.
 *
 * The class requires the use of the PayPal_Lib library and config files.
 *
 * @package     CodeIgniter
 * @subpackage  Libraries
 * @category    Commerce
 * @author      Ran Aroussi <ran@aroussi.com>
 * @copyright   Copyright (c) 2006, http://aroussi.com/ci/
 *
 */

class Paypal extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		//installCheck();
		$this->load->library('Paypal_Lib');
		$this->load->model('do_campaign');
		/* Libraries */
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('email');
		//$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		//$this->load->library('rest');
	}

	function index()
	{
		$this->form();
	}
	
	/*
	 * Triggers the form for add fund or make payment according to type
	 * Method: form_get()
	 * @params : 
	 * @return :
	*/
	function form()
	{
			
		$paypal_info= 	$this->rest->get('api/v1/network/fetch_admin_paypal_info',array('api_key'=>get_session('api_key')),'php');
		$paypal_id 	= 	$paypal_info[0]['paypal_id'];
		$account_id	= 	$this->get('account_details');
		$amount 	= 	$this->get('amount'); 
		 
		// ASSIGN Administrator PAY PAL Account EMAIL ID 
		 
		$this->paypal_lib->add_field('business',$admin_details->paypal_id);
	    $this->paypal_lib->add_field('return', site_url('api/v1/paypal/success'));
	    $this->paypal_lib->add_field('cancel_return', site_url('api/v1/paypal/cancel'));
	    $this->paypal_lib->add_field('notify_url', site_url('api/v1//paypal/ipn')); // <-- IPN url
	    $this->paypal_lib->add_field('custom', $account_id); // <-- Verify return

	    $this->paypal_lib->add_field('item_name', 'Increase Budget For Direct Campaigns');
	    $this->paypal_lib->add_field('item_number', '1');
		$this->paypal_lib->add_field('currency_code', $this->config->item('currency_transaction_symbol'));
	    $this->paypal_lib->add_field('amount', $amount);

		// if you want an image button use this:
		$this->paypal_lib->image('button_03.gif');
		
		// otherwise, don't write anything or (if you want to 
		// change the default button text), write this:
		// $this->paypal_lib->button('Click to Pay!');
		
	    $data['paypal_form'] = $this->paypal_lib->paypal_form();
	
        $this->load->view('advertiser/paypal/form', $data);
        
	}

	function auto_form($campaign_id=FALSE,$amount=FALSE,$name,$type,$mode)
	{
		
		// GET Administrator PAYPAL Account ID 
			
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		if($type=="campaign")
		{
			$custom=$campaign_id.":".$type.":".$name.":".$mode; 
		}
		
		$adm		=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 	
		$paypal_info= 	$this->rest->get('api/v1/network/fetch_admin_paypal_info',array('api_key'=>$adm[0]['api_key']),'php');
		
		$paypal_id 	= 	$paypal_info[0]['paypal_id'];
		
		 
		// ASSIGN Administrator PAY PAL Account EMAIL ID 
		 
		$this->paypal_lib->add_field('business',$paypal_id);
		
		$this->paypal_lib->add_field('return', site_url('site/paypal/success'));
		$this->paypal_lib->add_field('cancel_return', site_url('site/paypal/cancel/'.$temp_user_id));
		$this->paypal_lib->add_field('notify_url', site_url('site/paypal/ipn')); // <-- IPN url
		$this->paypal_lib->add_field('custom',$custom); // <-- Verify return

		$this->paypal_lib->add_field('item_name', 'Add Fund for Campaign');
		$this->paypal_lib->add_field('item_number', '1');
		$this->paypal_lib->add_field('currency_code', $this->config->item('currency_transaction_symbol'));
		$this->paypal_lib->add_field('amount', $amount);
		
		$data['button']=$this->paypal_lib->get_button_content();
		$data['form']=$this->paypal_lib->get_paypal_form_content();

		$this->load->view("site/paypal/auto_form", $data);
		
	}
	
	function cancel($user_id)
	{
		log_message('info', 'We are in Failure...');
		$data['page_title'] = "Payment Cancel";
		
		$this->do_campaign->delete_campaign($user_id);
		
		/*-------------------------------------------------------------
				Embed current page content into template layout
		-------------------------------------------------------------*/
        $this->load->view('site/paypal/cancel',$data);
           
	}
	
	function success()
	{		
		// This is where you would probably want to thank the user for their order
		// or what have you.  The order information at this point is in POST 
		// variables.  However, you don't want to "process" the order until you
		// get validation from the IPN.  That's where you would have the code to
		// email an admin, update the database with payment status, activate a
		// membership, etc.
	
		// You could also simply re-direct them to another page, or your own 
		// order status page which presents the user with the status of their
		// order based on a database (which can be modified with the IPN code 
		// below).
		log_message('info', 'We are Success...');
		$data['page_title'] = "Processing Success";      
		$ipn_data = $this->input->post();
		mail('fortestingpurpose14@gmail.com','ipn',$ipn_data);
		$data['pp_info'] = $ipn_data;
	
		$this->load->view('site/paypal/success',$data);
    }
	
	function ipn()
	{			

		// Payment has been received and IPN is verified.  This is where you
		// update your database to activate or process the order, or setup
		// the database with the user's order details, email an administrator,
		// etc. You can access a slew of information via the ipn_data() array.
 
		// Check the paypal documentation for specifics on what information
		// is available in the IPN POST variables.  Basically, all the POST vars
		// which paypal sends, which we send back for validation, are now stored
		// in the ipn_data() array.
 
		// For this example, we'll just email ourselves ALL the data.
		//$to = 'ramya.p@dreamajax.com';
          
		
		if ($this->paypal_lib->validate_ipn()) 
		{
			 $customs  =  $this->paypal_lib->ipn_data['custom'];
             $explode_custom= explode(":",$customs);
					
             $campaign_id=$explode_custom[0];
             $type = $explode_custom[1];
             $campname = $explode_custom[2];
             $mode = $explode_custom[3];
         
			if($type =="campaign")
			{
				if($mode=="new")
				{
					$status=0;
					$is_default=1;
				}
				if($mode=="edit")
				{
					$status=1;
					$is_default=0;
				}
				
				
								 
				 $payer_email    = $this->paypal_lib->ipn_data['payer_email'];
                 $receiver_email = $this->paypal_lib->ipn_data['receiver_email'];
				 $payment_gross  = $this->paypal_lib->ipn_data['payment_gross'];
				 $mc_currency    = $this->paypal_lib->ipn_data['mc_currency'];
				 $invoice_code 	 = 	random_string('numeric',10);
				 $ipn_no		 = $this->paypal_lib->ipn_data['ipn_track_id'];
				 $ipn_txn_id	 = $this->paypal_lib->ipn_data['txn_id'];
				 $update_camp_payment = array(
                            'campaign_id'   =>  $campaign_id,
                            'name'	 		=> 	$campname,
                            'email' 		=> 	$receiver_email,
                            'payer_email'   =>  $payer_email,
                            'payment_type'	=> '2' ,
                            'date'        	=>  date('Y-m-d H:i:s'),
                            'amount'  		=>  $payment_gross,
                            'currency'   	=>  $mc_currency,
                            'clearing_date' =>  date('Y-m-d H:i:s'),
                            'status'   		=>  $status,
                            'is_default'   	=>  $is_default,
                            'transaction'   => 'credit' ,
                            'admin_approval_status'  	=>  0,
                            'invoice_code'	=> 	$invoice_code ,   
                            'id_no'			=>	$ipn_no,
                            'txn_id'		=>	$ipn_txn_id,
                            'receiver_email'=>  $receiver_email,                       
                            'approved_date' =>  date('Y-m-d H:i:s')
                        );
                   
				$payment_response_id = $this->do_campaign->insert_campaign_payment($update_camp_payment);
		
				//$this->rest->post('api/v1/paypal/ipn',array('ipn_data'=>$this->paypal_lib->ipn_data,'transaction_type'=>'credit','api_key'=>get_session('api_key')),'json');
			}
			else
			{
				$this->rest->post('api/v1/user/create',array('ipn_data'=>$this->paypal_lib->ipn_data),'json');
			}
        }
	}
	
	function add_payment($campaign_id,$amount,$name,$mode)
	{
		$data['page_title'] = "Payment Gateway - Paypal";
		$data['payment_mode'] = "Paypal";
		$data['amount'] = $amount;
		$data['camp_name'] = $name;
		$data['campaign_id'] = $campaign_id;
		$data['mode'] = $mode;
	
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/

		$this->load->view('site/paypal/add_payment',$data);
	 }	
}
?>
