<?php

/*
 * name : Adgate networkkit
 * Author: Adgate
 * Worked by : Ramya P
 */
  
class networkkit extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));	
	}
	
	
	/*
	 * 
	 * name		:index
	 * @param   :Null
	 * @return  :Login page
	 */	
	 
	 
	function index()
	{
		$this->network();
	}
	
	/*
	 * 
	 * name		:mediakit
	 * @param   :Null
	 * @return  :Media Kit page
	 */	
	 
	function network()
	{		
		$data['page_title'] = 	"Network Kit";

		$data['breadcrumb'] = 	'';
		
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		/*echo $data['api_key'];
		$this->rest->debug();
		exit;*/
			
		/************ Guest Advertiser *************/
		
		$data['campaign_data'] = $this->rest->get('api/v1/report/fetch_campaigns',array('api_key'=>$data['api_key']),'php');
		/*print_r($data['campaign_data']);
		$this->rest->debug();
		exit;*/
		$set = $this->config->item('report_config');
		
		$data['search_date'] = get_search_date($set['ADMIN']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$data['api_key']),'php');
				
		$data['content'] 			= 	$this->load->view('site/networkkit',$data,TRUE);
		
		$this->template->set_layout('direct_layout');
		
		$this->template->build('view', $data);
	}
	
	public function fetch_country_stat($env='all',$con_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$api_key			=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		//$api_key 	= get_session('api_key');
		$account_type 	= get_session('account_type');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($con_id != 'all'){
			$input['country_id'] = $con_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
					  
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
	
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//$this->rest->debug();
		//exit;
		echo $data;
	}
	 
}

?>
