<?php 

class Creatives extends CI_Controller

{

    function __construct()
	{
		
		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}

	function index()
	{
		$this->creatives();
	}

	/*

	 * 

	 * name		:creatives

	 * @param   :Null

	 * @return  :List all the creatives for a particular
	
	 */	

	public function creatives()
	{
		
		$data['page_title'] = "Manage creatives";

		$data['breadcrumb'] = '';

		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key']),'php');
	
		// GET DEFAULT PERIOD FROM CONFIG FILE

		$set = $this->config->item('report_config');

		$data['search_date'] = get_search_date($set['ADVERTISER']['REPORT_CREATIVE']['CHART']['DEFAULT_INTERVAL']);

		$data['content'] = $this->load->view('creatives/manage_creatives',$data,TRUE);

		$this->template->set_layout('direct_layout');

		$this->template->build('view', $data);

	}

	/*

	 * 

	 * name		:fetch_creative

	 * @param   :Null

	 * @return  :List all the creatives for a particular

	 * 			 advertiser

	 */	

	public function fetch_creative()
	{
		
		$creatives		= $this->rest->get('api/v1/creative/fetch',array("api_key"=>$data['api_key']),'json');
	
		echo convert_to_datatable_format($creatives);

	}

	/*

	 * 

	 * name   : add_web_creatives

	 * @param : Null

	 * @return: Loads a page to create a new web creative

	 */	

	public function add_web_creatives()
	{

		$data['page_title'] = "Add web creative";

		$data['breadcrumb'] = '';

		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		/************ Video Enable/Disable *************/

		$data['content'] = $this->load->view('creatives/add_web_creative',$data,TRUE);

		$this->template->set_layout('direct_layout');

		$this->template->build('view', $data);

	}

	/*

	 * name   : web_creative

	 * @param : Null

	 * @return: Loads web creative modal box

	 */	

	public function web_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_web_creative',$data);	
	}
	
	/*

	* name   : display_creative

	* @param : Null

	* @return: Loads web creative modal box

	*/	

	public function display_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_display_creative',$data);	
	}


	/*

	 * name   : html_creative

	 * @param : Null

	 * @return: Loads html creative modal box

	 */	

	public function html_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_html_creative',$data);	

	}

	/*

	 * name   : flash_creative

	 * @param : Null

	 * @return: Loads html creative modal box

	 */	

	public function flash_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_flash_creative',$data);	

	}

	/*

	 * 

	 * name   : text_creative

	 * @param : Null

	 * @return: Loads TEXT creative modal box

	 */	

	public function text_creative()
	{

		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_text_creative',$data);	

	}

	/*
	 * name   : popup_creative
	 * @param : Null
	 * @return: Loads popup creative modal box
	 */	
	public function popup_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_popup_creative',$data);	
	}
	
	/*
	 * name   : layer_creative
	 * @param : Null
	 * @return: Loads layer creative modal box
	 */	
	public function layer_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_layer_creative',$data);	
	}	
	
	/*
	 * name   : gamebox_creative
	 * @param : Null
	 * @return: Loads gamebox creative modal box
	 */	
	public function gamebox_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_gamebox_creative',$data);	
	}
	
	/*
	 * name   : slider_creative
	 * @param : Null
	 * @return: Loads slider creative modal box
	 */	
	public function sliderad_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_sliderad_creative',$data);	
	}
	
	/*
	 * name   : catfish_creative
	 * @param : Null
	 * @return: Loads catfish creative modal box
	 */	
	public function catfish_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_catfish_creative',$data);	
	}
	
	/*
	 * name   : siteskin_creative
	 * @param : Null
	 * @return: Loads site skin creative modal box
	 */	
	public function siteskin_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_siteskin_creative',$data);	
	}
	
	/*
	 * name   : bannerbox_creative
	 * @param : Null
	 * @return: Loads bannerbox creative modal box
	 */	
	public function bannerbox_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_bannerbox_creative',$data);	
	}
	
	
	
	/*
	 * 
	 * name   : popup_creative
	 * @param : Null
	 * @return: Loads popup creative modal box
	 */	
	public function edit_popup_creative($creative_id=false)
	{
		if($creative_id)
		{
			
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>	$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_popup_creative',$data);	
		}
	}
	
	/*
	 * 
	 * name   : layer_creative
	 * @param : Null
	 * @return: Loads layer creative modal box
	 */	
	public function edit_layer_creative($creative_id=false,$api_key=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>	$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			//$data['companion_id']  = $creative_data[0]['dj_additional_layer'];
			
			echo $this->load->view('creatives/modal_creatives/content/edit_layer_creative',$data);
		}	
	}
	
	
	/*
	 * 
	 * name   : gamebox_creative
	 * @param : Null
	 * @return: Loads gamebox creative modal box
	 */	
	public function edit_gamebox_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			
			$parent_data			= 	$this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$child_data				= 	$this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$data['parent_data']	=	$parent_data[0];
			$data['child_data']		=	$child_data;		
			
			echo $this->load->view('creatives/modal_creatives/content/edit_gamebox_creative',$data);	
		}
	}	
	
	/*
	 * 
	 * name   : bannerbox_creative
	 * @param : Null
	 * @return: Loads bannerbox creative modal box
	 */	
	public function edit_bannerbox_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			
			$parent_data			= 	$this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$child_data				= 	$this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$data['parent_data']	=	$parent_data[0];
			$data['child_data']		=	$child_data;		
			//print_r($child_data); exit;
			echo $this->load->view('creatives/modal_creatives/content/edit_bannerbox_creative',$data);	
		}
	}
	
	/*
	 * 
	 * name   : slider_creative
	 * @param : Null
	 * @return: Loads slider creative modal box
	 */	
	public function edit_sliderad_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>		$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_sliderad_creative',$data);
		}	
	}
	
	/*
	 * 
	 * name   : catfish_creative
	 * @param : Null
	 * @return: Loads catfish creative modal box
	 */	
	public function edit_catfish_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>		$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_catfish_creative',$data);	
		}
	}
	
	/*
	 * 
	 * name   : siteskin_creative
	 * @param : Null
	 * @return: Loads site skin creative modal box
	 */	
	public function edit_siteskin_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$parent_data			= 	$this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$child_data				= 	$this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$data['parent_data']	=	$parent_data[0];
			$data['child_data']		=	$child_data;		
			echo $this->load->view('creatives/modal_creatives/content/edit_siteskin_creative',$data);	
		}
	}
	
	/*

	* 

	* name   : edit_display_creative

	* @param : Null

	* @return: Loads web creative details in a modal box

	*/	

	public function edit_display_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data			= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=	$creative_data[0];
			
			$creative_depend_data	= 	$this->rest->get('api/v1/creative/fetch_creative_dependiences',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_dependiency_data']=	$creative_depend_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_display_creative',$data);

		}

	}

	/*

	 * 

	 * name   : edit_web_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_web_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_web_creative',$data);

		}

	}

	/*

	 * 

	 * name   : edit_flash_creative

	 * @param : Null

	 * @return: Loads flash creative details in a modal box

	 */	

	public function edit_flash_creative($creative_id=false)

	{

		if($creative_id)

		{

			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/creative/fetch_creative_dependiences',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data[0];



			echo $this->load->view('creatives/modal_creatives/content/edit_flash_creative',$data);

		}

	}
	

	/*

	 * 

	 * name   : edit_text_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_text_creative($creative_id=false)

	{

		if($creative_id)

		{
			
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
		
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');

			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_text_creative',$data);

		}

	}

	/*

	 * 

	 * name   : edit_text_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_html_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_html_creative',$data);

		}

	}

	

	/****************************************************************************************

	

								VIDEO CREATIVES ADD AND EDIT



	*****************************************************************************************/

	/*

	 * 

	 * name   : video_inline_creative

	 * @param : Null

	 * @return: Loads video inline creative modal box

	 */	

	public function video_inline_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
				
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_inline_creative',$data);	

	}
	
	public function video_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_creative',$data);	

	}
	
	/*

	 * 

	 * name   : video_inline_creative

	 * @param : Null

	 * @return: Loads video inline creative modal box

	 */	

	public function video_real_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_real_creative',$data);	

	}
	
	
	public function video_small_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_small_creative',$data);	

	}
	
	
	public function video_box_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_box_creative',$data);	

	}
	
	
	public function video_head_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_head_creative',$data);	

	}


	/*

	 * name   : video_overlay_creative

	 * @param : Null

	 * @return: Loads video overlay creative modal box

	 */	

	public function video_overlay_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_video_overlay_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_video_inline_creative



	 * @param : Null

	 * @return: Loads video inline creative modal box

	 */	

	public function edit_video_inline_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$companion_id				=	$vast_data[0]['vast_companion_banner_id'];

			if($companion_id!=0)

			{

				$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>$data['api_key'],"creative_id"=>$companion_id),'php');

				if($companion_data)

				{

					$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

				}

				else

				{

					$data['comp_size']	=	'';

				}

			}

			else

			{

				$data['comp_size']		=	'';

			}

			

			$data['creative_data']		=	$creative_data[0];

			$data['vast_data']			=	$vast_data[0];

			

			echo $this->load->view('creatives/modal_creatives/content/edit_video_inline_creative',$data);	

		}

	}

	

	/*

	 * 

	 * name   : edit_video_overlay_creative

	 * @param : Null

	 * @return: Loads video overlay creative modal box

	 */	

	public function edit_video_overlay_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$companion_id				=	$vast_data[0]['vast_companion_banner_id'];

			if($companion_id!=0)

			{

				$companion_data			= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>$data['api_key'],"creative_id"=>$companion_id),'php');

				if($companion_data)

				{

					$data['comp_size']	=	$companion_data[0]['width'].'x'.$companion_data[0]['height'];						

				}

				else

				{

					$data['comp_size']	=	'';

				}

			}

			else

			{

				$data['comp_size']		=	'';

			}

			

			$data['creative_data']		=	$creative_data[0];

			$data['vast_data']			=	$vast_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_video_overlay_creative',$data);	

		}

	}

	

	/*

	 * name   : filter_companions

	 * @param : Null

	 * @return: Loads a page to existing  web creatives

	 */	

	public function filter_companions($campaign_id=false,$width=false,$height=false,$companion_id=false)
	{	

		if($width && $height)
		{

			$data['companion']		= 	$this->rest->get('api/v1/video_creative/filter_companions',array("api_key"=>$data['api_key'],"campaign_id"=>$campaign_id,"width"=>$width,"height"=>$height),'php');

			if($companion_id!=false)
			{
				$data['companion_id']	=	$companion_id;
			}
			else
			{
				$data['companion_id']	=	0;
			}

			$this->load->view('creatives/modal_creatives/content/filter_companions',$data,TRUE);

		}

	}
	
	/****************************************************************************************

	

								MOBILE CREATIVES ADD AND EDIT



	*****************************************************************************************/

	

	/*

	 * 

	 * name   : add_mobile_creatives

	 * @param : Null

	 * @return: Loads a page to create a new mobile creative

	 */	



	public function add_mobile_creatives()

	{

		$data['page_title'] = "Add mobile creative";



		$data['breadcrumb'] = '';

		

		$data['content'] = $this->load->view('creatives/add_mobile_creative',$data,TRUE);

		

		$this->template->set_layout('direct_layout');

		$this->template->build('view', $data);

	}

	

	/* 

	 * name   : image_creative

	 * @param : Null

	 * @return: Loads mobile image creative modal box

	 */	

	public function image_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		$mobile_screens_size	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>$data['api_key']),'php');

		
		$data['wide'] 			= 	$mobile_screens_size[0];

		$data['static'] 		= 	$mobile_screens_size[1];

		$data['interstitial'] 	= 	$mobile_screens_size[2];


		$data['small'] 			= 	$mobile_screens_size[5];

		$data['medium'] 		= 	$mobile_screens_size[4];

		$data['large'] 			= 	$mobile_screens_size[3];


		$data['tab_small'] 		= 	$mobile_screens_size[6];

		$data['tab_medium'] 	= 	$mobile_screens_size[7];

		$data['tab_large'] 		= 	$mobile_screens_size[8];
		
		echo $this->load->view('creatives/modal_creatives/content/add_image_creative',$data,TRUE);

	}	

	/*

	 * 

	 * name   : edit_image_creative

	 * @param : creative id

	 * @return: Loads image creative details in a modal box

	 */	

	public function edit_image_creative($creative_id=false)

	{

		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$mobile_screens_size	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>$data['api_key']),'php');

		$data['wide'] = $mobile_screens_size[0];

		$data['static'] = $mobile_screens_size[1];

		$data['interstitial'] = $mobile_screens_size[2];

		

		$data['large'] = $mobile_screens_size[3];

		$data['medium'] = $mobile_screens_size[4];

		$data['small'] = $mobile_screens_size[5];



		$data['tab_small'] = $mobile_screens_size[6];

		$data['tab_medium'] = $mobile_screens_size[7];

		$data['tab_large'] = $mobile_screens_size[8];

		

		if($creative_id)

		{

			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;



			echo $this->load->view('creatives/modal_creatives/content/edit_image_creative',$data);

		}

	}

	

	/*

	 * 

	 * name   : mobile_text_creative

	 * @param : Null

	 * @return: Loads TEXT creative modal box

	 */	

	public function mobile_text_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_mob_text_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_mob_text_creative

	 * @param : Null

	 * @return: Loads web creative details in a modal box

	 */	

	public function edit_mob_text_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_mob_text_creative',$data);

		}

	}
	
	/* 

	 * name   : interstitial_creative

	 * @param : Null

	 * @return: Loads mobile interstitial creative modal box

	 */	

	public function interstitial_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_interstitial_creative',$data);	

	}



	/*

	 * 

	 * name   : edit_interstitial_creative

	 * @param : creative id

	 * @return: Loads interstitial creative details in a modal box

	 */	

	public function edit_interstitial_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_interstitial_creative',$data);

		}

	}

	

	/* 

	 * name   : expand_creative

	 * @param : Null

	 * @return: Loads mobile expand creative modal box

	 */	

	public function expand_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/

		echo $this->load->view('creatives/modal_creatives/content/add_expand_creative',$data);	

	}



	/*

	 * 

	 * name   : edit_adhesion_creative

	 * @param : creative id

	 * @return: Loads ADHESION creative details in a modal box

	 */	

	public function edit_adhesion_creative($creative_id=false)

	{

		if($creative_id)

		{

			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			/*$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_creative',array("creative_id"=>$creative_id),'php');

			

			$data['creative_details_parent']=$creative_data[0];

			$data['creative_details_child']=$creative_data[1];*/

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;

			

			echo $this->load->view('creatives/modal_creatives/content/edit_adhesion_creative',$data);

		}

	}

	

	/*

	 * 

	 * name   : edit_flex_creative

	 * @param : creative id

	 * @return: Loads flex creative details in a modal box

	 */	

	public function edit_flex_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			

			

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;

			

			echo $this->load->view('creatives/modal_creatives/content/edit_flex_creative',$data);

		}

	}

	

	/*

	 * 

	 * name   : edit_expand_creative

	 * @param : creative id

	 * @return: Loads expand creative details in a modal box

	 */	

	public function edit_expand_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;



			echo $this->load->view('creatives/modal_creatives/content/edit_expand_creative',$data);

		}

	}

	

	/* 

	 * name   : reveal_creative

	 * @param : Null

	 * @return: Loads mobile reveal creative modal box

	 */	

	public function reveal_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_reveal_creative',$data);	

	}

	

	/*

	 * 

	 * name   : edit_reveal_creative

	 * @param : creative id

	 * @return: Loads reveal creative details in a modal box

	 */	

	public function edit_reveal_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;



			echo $this->load->view('creatives/modal_creatives/content/edit_reveal_creative',$data);

		}

	}

	

	/* 

	 * name   : filmstrip_creative

	 * @param : Null

	 * @return: Loads mobile filmstrip creative modal box

	 */	

	public function filmstrip_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_filmstrip_creative',$data);	

	}



	/* 

	 * name   : adhesion_creative

	 * @param : Null

	 * @return: Loads mobile adhesion creative modal box

	 */	

	public function adhesion_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

		echo $this->load->view('creatives/modal_creatives/content/add_adhesion_creative',$data);	

	}

	/* 

	 * name   : flex_creative

	 * @param : Null

	 * @return: Loads mobile adhesion creative modal box

	 */	

	public function flex_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/

		echo $this->load->view('creatives/modal_creatives/content/add_flex_creative',$data);	

	}



	

	/*

	 * 

	 * name   : edit_filmstrip_creative

	 * @param : creative id

	 * @return: Loads filmstrip creative details in a modal box

	 */	

	public function edit_filmstrip_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
				
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;



			echo $this->load->view('creatives/modal_creatives/content/edit_filmstrip_creative',$data);

		}

	}



	/* 

	 * name   : pull_creative

	 * @param : Null

	 * @return: Loads mobile pull creative modal box

	 */	

	public function pull_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
				
		echo $this->load->view('creatives/modal_creatives/content/add_pull_creative',$data);	

	}	

	/*

	 * 

	 * name   : edit_pull_creative

	 * @param : creative id

	 * @return: Loads pull creative details in a modal box

	 */	

	public function edit_pull_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data= $this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_details']=$creative_data[0];



			$creative_dependiency_data= $this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			

			$data['creative_dependiency_data']=$creative_dependiency_data;

			echo $this->load->view('creatives/modal_creatives/content/edit_pull_creative',$data);

		}

	}

	

	/* 

	 * name   : slider_creative

	 * @param : Null

	 * @return: Loads mobile slider creative modal box

	 */	

	public function slider_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_slider_creative',$data);	

	}	

	/*

	 * 

	 * name   : edit_slider_creative

	 * @param : creative id

	 * @return: Loads slider creative details in a modal box

	 */	

	

	public function edit_slider_creative($creative_id=false)

	{

		if($creative_id)

		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] = $this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$parent_data			= 	$this->rest->get('api/v1/mobile_creative/fetch_parent_creative',array("api_key"=>$data['api_key'],"account_id"=>get_session('account_id'),"creative_id"=>$creative_id),'php');

			$child_data				= 	$this->rest->get('api/v1/mobile_creative/fetch_child_creative',array("api_key"=>$data['api_key'],"account_id"=>get_session('account_id'),"creative_id"=>$creative_id),'php');

			$data['parent_data']	=	$parent_data[0];

			$data['child_data']		=	$child_data;

			echo $this->load->view('creatives/modal_creatives/content/edit_slider_creative',$data);

		}

	}

	

	/*

	 * 

	 * name: preview_creative

	 * @param : null

	 * @return : list of creatives to preview.

	 */	



	public function preview_creative($banner_id=FALSE)

	{  

		$data['creative_list']	=	$this->rest->get('api/v1/approval/preview_creative',array("api_key"=>$data['api_key'],'banner_id'=>$banner_id),'php'); 
		
		echo $this->load->view('creatives/modal_creatives/content/preview_creative',$data);

	}
	
	public function mobile_html_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_mob_html_creative',$data);	

	}
	
	// Link Zones Details
	public function link_zones($creative_id = FALSE)
	{
		if(!$creative_id || !is_numeric($creative_id))
		{
			$this->creatives();
		}
		else
		{
			$data['page_title'] 	= 	"Banner, Zone linking";
			$data['breadcrumb']		= 	'';
			$data['creative_id']	=	$creative_id;
			/*$zone_data				= 	$this->rest->get('api/v1/creative/fetch_adblocks', array("api_key"=>$data['api_key'], "creative_id" => $creative_id),'json');
			$data['zone_data']		=	json_decode($zone_data, true);*/
			
			$data['banner_data'] 	= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'], "creative_id" => $creative_id),'php');
			
			if($data['banner_data'][0]['dj_admin_approve'] == 0)
			{
				redirect('advertiser/creatives');
			}
			
			// GET DEFAULT PERIOD FROM CONFIG FILE
			$data['content'] 		=	$this->load->view('creatives/link_zones',$data,TRUE);
			$this->template->set_layout('direct_layout');
			$this->template->build('view', $data);
		}
	}

	/*
	* name   : tablet_creative
	* @param : Null
	* @return: Loads tablet creative modal box
	*/	
	public function tablet_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_tablet_creative',$data);	
	}	
	
	/*
	* 
	* name   : tablet_creative
	* @param : Null
	* @return: Loads tablet creative modal box
	*/	
	public function edit_tablet_creative($creative_id=false,$api_key=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>	$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			//$data['companion_id']  = $creative_data[0]['dj_additional_layer'];
			
			echo $this->load->view('creatives/modal_creatives/content/edit_tablet_creative',$data);
		}	
	}
	
	/*
	 * 

	 * name   : edit_video_small_creative

	 * @param : Null

	 * @return: Loads video small creative modal box

	 */	

	public function edit_video_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$creative_images			= 	$this->rest->get('api/v1/video_creative/fetch_small',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$data['creative_data']		=	$creative_data[0];

			$data['vast_data']			=	$vast_data[0];

			$data['addbannerimage']  	=   $creative_images[0];
 						
			echo $this->load->view('creatives/modal_creatives/content/edit_video_creative',$data);	
				
		}

	}
	
	/*
	* 
	* name   : topbar_creative
	* @param : Null
	* @return: Loads topbar creative modal box
	*/	
	public function topbar_creative($type=false)
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
			
		$data['type']			=	$type;
		$data['adv_list']		= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>$data['api_key']),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB","type"=>$type),'php');
		echo $this->load->view('creatives/modal_creatives/content/add_topbar_creative',$data);	
	}	
	
	/*
	* 
	* name   : edit_web_creative
	* @param : Null
	* @return: Loads web creative details in a modal box
	*/	
	public function edit_topbar_creative($creative_id=false,$type=false)
	{		
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['type']			=	$type;
			$data['adv_list']		= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>$data['api_key']),'php');
			$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB","type"=>$type),'php');
			$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			$creative_data			= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			$data['creative_details']=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_topbar_creative',$data);
		}
	}
	
	/*
	* 
	* name   : Notification_creative
	* @param : Null
	* @return: Loads dialog creative modal box
	*/	
	public function notification_creative($type=false)
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
			
		$data['type']			=	$type;
		$data['adv_list']		= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>$data['api_key']),'php');
		$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE","type"=>$type),'php');
		echo $this->load->view('creatives/modal_creatives/content/add_mob_notification_creative',$data);	
	}
	
	/*
	* 
	* name   : edit_mob_notification_creative
	* @param : Null
	* @return: Loads notification creative details in a modal box
	*/	
	public function edit_mob_notification_creative($creative_id=false,$type=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['type']			=	$type;
			$data['adv_list']		= 	$this->rest->get('api/v1/utilities/fetch_advertiser',array("api_key"=>$data['api_key']),'php');
			$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE","type"=>$type),'php');
			
			$creative_data			= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			$data['creative_details']=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_mob_notification_creative',$data);
		}
	}	
	
	/*
	* name   : catfish_creative
	* @param : Null
	* @return: Loads catfish creative modal box
	*/	
	public function mob_catfish_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_type']	=	'Mobile';
		
		echo $this->load->view('creatives/modal_creatives/content/add_catfish_creative',$data);	
	}
	
	/*
	* 
	* name   : catfish_creative
	* @param : Null
	* @return: Loads catfish creative modal box
	*/	
	public function edit_mob_catfish_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			$data['creative_type']	=	'Mobile';
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>	$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_catfish_creative',$data);	
		}
	}
	
	/*
	* name   : mob_sliderad_creative
	* @param : Null
	* @return: Loads mobile slider creative modal box
	*/

	public function mob_sliderad_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_type']	=	'Mobile';
		
		echo $this->load->view('creatives/modal_creatives/content/add_sliderad_creative',$data);	

	}
	
	/*
	* 
	* name   : catfish_creative
	* @param : Null
	* @return: Loads catfish creative modal box
	*/
		
	public function edit_mob_sliderad_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			$data['creative_type']	=	'Mobile';
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>	$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_sliderad_creative',$data);	
		}
	}
	
	/* 

	* name   : app_interstitial_creative

	* @param : Null

	* @return: Loads mobile interstitial creative modal box

	*/	

	public function app_interstitial_creative()

	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		$data['creative_type']	=	'App';
		
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_interstitial_creative',$data);	

	}


	/*

	* 

	* name   : edit_app_interstitial_creative

	* @param : creative id

	* @return: Loads interstitial creative details in a modal box

	*/	

	public function edit_app_interstitial_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 	= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"MOBILE"),'php');

			$creative_data			= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$data['creative_details']=	$creative_data[0];
			
			$data['creative_type']	=	'App';

			echo $this->load->view('creatives/modal_creatives/content/edit_interstitial_creative',$data);

		}

	}

	/*
	* name   : app_catfish_creative
	* @param : Null
	* @return: Loads catfish creative modal box
	*/	
	public function app_catfish_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['creative_type']	=	'App';
		
		echo $this->load->view('creatives/modal_creatives/content/add_catfish_creative',$data);	
	}
	
	/*
	* 
	* name   : edit_app_catfish_creative
	* @param : Null
	* @return: Loads catfish creative modal box
	*/	
	public function edit_app_catfish_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			$data['creative_type']	=	'App';
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"	=>	$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/creative/fetch_creative',array("api_key"	=>	$data['api_key'],"creative_id"	=>	$creative_id),'php');
			$data['creative_details']	=	$creative_data[0];
			echo $this->load->view('creatives/modal_creatives/content/edit_catfish_creative',$data);	
		}
	}
	
	/*
	*
	* name   : video_html5_creative
	* @param : Null
	* @return: Loads video inline creative modal box
	*/

	public function video_html5_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
				
		/************ Guest Advertiser *************/
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_html5_creative',$data);	

	}
	
	
	/*
	*
	* name   : edit_video_inline_creative
	* @param : Null
	* @return: Loads video inline creative modal box
	*/

	public function edit_video_html5_creative($creative_id=false)
	{
		if($creative_id)
		{
			/************ Guest Advertiser *************/
			$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']		=	$gadv[0];
			
			$data['api_key']		=	$data['guest_adv']['api_key'];
			
			/************ Guest Advertiser *************/
			
			$data['campaign_data'] 		= 	$this->rest->get('api/v1/creative/fetch_campaigns',array("api_key"=>$data['api_key'],"campaign_type"=>"WEB"),'php');
			$creative_data				= 	$this->rest->get('api/v1/video_creative/fetch_video',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');

			$vast_data					= 	$this->rest->get('api/v1/video_creative/fetch_video_vast',array("api_key"=>$data['api_key'],"creative_id"=>$creative_id),'php');
			
			$data['creative_data']		=	$creative_data[0];

			$data['vast_data']			=	$vast_data[0];

			echo $this->load->view('creatives/modal_creatives/content/edit_video_html5_creative',$data);	

		}

	}
	
	/*
	*
	* name   : app_video_html5_creative
	* @param : Null
	* @return: Loads video inline creative modal box
	*/

	public function app_video_html5_creative()
	{
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
				
		/************ Guest Advertiser *************/
		
		$data['creative_type']	=	'App';
		
		echo $this->load->view('creatives/modal_creatives/content/add_video_html5_creative',$data);	

	}

	public function demo_creative($bannerid)
	{
		
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
				
		/************ Guest Advertiser *************/
		
		$creative_data				=  	$this->rest->get('api/v1/creative/fetch_demo_creative',array("api_key"	=>	$data['api_key'],"creative_id"=>$bannerid),'php');
		
		$data['creative_data']		=	$creative_data;
			
		$this->load->view('creatives/demo_creative',$data);		
	}
}
