<?php

/*
 * name : Adgate site
 * Author: Adgate
 * Worked by : suganthi
 */
  
class Campaigns extends CI_Controller {
	
	function __construct()
	{		
		parent::__construct();
		$this->load->library('Paypal_Lib');
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));	
		
	}
	
	/*
	 * 
	 * name		:index
	 * @param   :Null
	 * @return  :Direct campaign page
	 */	 
	 
	public function index()
	{	
		$this->direct();
	}
	
	public function direct($campdata=FALSE)
	{
		$data['page_title'] = 	"Add campaigns";

		$data['breadcrumb'] = 	'';
		
		$camp_id	=	'';
		
		if($campdata!=FALSE)
		{
			$campban	=	explode('/',base64_decode(urldecode($campdata)));
			
			$camp_id	=	($campban[0])?$campban[0]:'';
		}	
		
		$data['camp_id']		=	$camp_id;
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/
				
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		
		$data['target']				=	$this->targeting_list($data['api_key']);
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>$data['api_key']),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>$data['api_key']),'php');
		
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
		$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>$adm[0]['api_key'],'adblock_type'=>'black'),'php');		
		$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>$adm[0]['api_key'],'adblock_type'=>'white'),'php');		
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>$data['api_key']),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$data['api_key']),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$data['api_key']),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$data['api_key']),'php');
	
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>$data['api_key']),'php');
		
		$data['bid_data']			=	($bid_data!='error')?$bid_data[0]:'';
		
		
		//echo $_COOKIE[$prod_name.'_campaign_user_data']; die("fvsdg");
		if(isset($_COOKIE[$prod_name.'_campaign_user_data'])!='' || $camp_id!='') 
		{
				$campaign_id	=	($camp_id!='')?$camp_id:$_COOKIE[$prod_name.'_campaign_user_data'];				
				
				//Fetch Campaign details
				$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
								
				if(!empty($campaign_details[0]) && $campaign_details[0]['dj_is_checkout']==0)
				{
					$data['campaign_det']		=	$campaign_details[0];
					
					$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>$data['api_key']),'php');
					
					//Fetch browser targeting details
					$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch os targeting details
					$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch profile targeting details
					$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$campaign_id),'php');
					
					//Fetch mobile os targeting details
					$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch mobile manufactures targeting details
					$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch mobile capability details
					$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch geo targeting details
					$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>$data['api_key']),'php');
					
					$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>$data['api_key']),'php');
									
					//Language
					$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>$data['api_key']),'php');
					
					//City
					$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>$data['api_key']),'php');
					
					//Zip
					$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>$data['api_key']),'php');
					
					//Device
					$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>$data['api_key']),'php');
					
					//Blacklist
					$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Blacklist","api_key"=>$data['api_key']),'php');
					
					//Whitelist
					$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Whitelist","api_key"=>$data['api_key']),'php');
					
					//Blacklist
					$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>$data['api_key']),'php');
					
					//Whitelist
					$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>$data['api_key']),'php');
								
					//Time
					$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>$data['api_key']),'php');
					
					//Daypart
					$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>$data['api_key']),'php');
					
					//Day time
					//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>$data['api_key']),'php');
					
					//URL Keyword
					$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>$data['api_key']),'php');
					
					//Connection
					$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>$data['api_key']),'php');
					
					//Carrier
					$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>$data['api_key']),'php');
					
					$data['targ_geo_include']	=	$geoinclude_details[0];
					$data['targ_geo_exclude']	=	$geoexclude_details[0];
					$data['targ_lang']			=	$lang_details[0];
					$data['targ_city']			=	$city_details[0];
					$data['targ_zip']			=	$zip_details[0];
					$data['targ_device']		=	$device_details[0];
					$data['targ_black']			=	$black_details[0];
					$data['targ_white']			=	$white_details[0];
					$data['targ_pblack']		=	$pblack_details[0];
					$data['targ_pwhite']		=	$pwhite_details[0];
			
					$data['targ_time']			=	$time_details[0];
					$data['targ_daypart']		=	$daypart_details[0];
					//$data['targ_day_time']		=	$daytime_details[0];				
					$data['targ_url']			=	$url_details[0];
					$data['targ_connect']		=	$connect_details[0];
					$data['targ_carrier']		=	$carrier_details[0];
					
					//Traffic sources
					$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Country Bidding
					$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					$data['campaign_id']		=	$campaign_id;				
					$data['s2s_details']		=	$s2s_details[0];
					$data['targ_browser']		=	$browser_details[0];
					$data['targ_os']			=	$os_details[0];
					$data['targ_time']			=	$time_details[0];
					
					$data['profile_age']		=	$profile_age[0];
					$data['profile_gender']		=	$profile_gender[0];
					$data['profile_color']		=	$profile_color[0];
					$data['profile_height']		=	$profile_height[0];
					$data['profile_weight']		=	$profile_weight[0];
					
					$data['profile_keyword']	=	$profile_keyword[0];
					
					$data['targ_mob_manu']		=	$mobile_manu_details[0];
					$data['targ_mob_capa']		=	$mobile_capa_details[0];
					$data['targ_mob_tele']		=	$mobile_telecom_details[0];
				}
	    }
		
		/**** Cookie setup-- end ************/
			
	echo	$data['content'] 			= 	$this->load->view('site/campaigns/add_campaign',$data,TRUE);
		
	//	$this->template->set_layout('direct_layout');
	//	$this->template->build('view', $data);
	}
	
	public function direct2()
	{
		
		$data['page_title'] = 	"Add campaigns";

		$data['breadcrumb'] = 	'';
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		
		//Minimum Budget & Bid Rate & creatives allowed
		$data['min_budget']		=	$this->default_configurations->get('min_budget');
		
		$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
		
		$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
		
		/************ Video Enable/Disable *************/
				
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		
		$data['target']				=	$this->targeting_list($data['api_key']);
		
		/************ Guest Advertiser *************/
		
		$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
		
		$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>$data['api_key']),'php');
		
		$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>$data['api_key']),'php');
		
		//Fetch Publisher
		$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
		$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
		$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
				
		//Fetch available site categories
		$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>$data['api_key']),'php');

		$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$data['api_key']),'php');

		//Fetch Country
		$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$data['api_key']),'php');		
		
		//Fetch available campaign type
		$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$data['api_key']),'php');
	
		/**** Cookie setup -- start ************/
		$prod_name = $this->config->item('prod_name'); 
		
		$bid_data 					=	$this->rest->get('api/v1/campaign/fetch_realtime_bidding',array('api_key'=>$data['api_key']),'php');
		
		$data['bid_data']			=	($bid_data!='error')?$bid_data[0]:'';
		
		
		//echo $_COOKIE[$prod_name.'_campaign_user_data']; die("fvsdg");
		if(isset($_COOKIE[$prod_name.'_campaign_user_data'])!='') 
		{
				$campaign_id	=	$_COOKIE[$prod_name.'_campaign_user_data'];				
				
				//Fetch Campaign details
				$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
								
				if($campaign_details[0]['dj_is_checkout']==0)
				{
					$data['campaign_det']		=	$campaign_details[0];
					
					$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>$data['api_key']),'php');
					
					//Fetch browser targeting details
					$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch os targeting details
					$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch profile targeting details
					$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$campaign_id),'php');
					
					//Fetch mobile os targeting details
					$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch mobile manufactures targeting details
					$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch mobile capability details
					$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Fetch geo targeting details
					$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>$data['api_key']),'php');
					
					$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>$data['api_key']),'php');
									
					//Language
					$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>$data['api_key']),'php');
					
					//City
					$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>$data['api_key']),'php');
					
					//Zip
					$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>$data['api_key']),'php');
					
					//Device
					$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>$data['api_key']),'php');
					
					//Blacklist
					$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Blacklist","api_key"=>$data['api_key']),'php');
					
					//Whitelist
					$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Whitelist","api_key"=>$data['api_key']),'php');
									
					//Time
					$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>$data['api_key']),'php');
					
					//Daypart
					$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>$data['api_key']),'php');
					
					//Day time
					//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>$data['api_key']),'php');
					
					//URL Keyword
					$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>$data['api_key']),'php');
					
					//Connection
					$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>$data['api_key']),'php');
					
					//Carrier
					$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>$data['api_key']),'php');
					
					$data['targ_geo_include']	=	$geoinclude_details[0];
					$data['targ_geo_exclude']	=	$geoexclude_details[0];
					$data['targ_lang']			=	$lang_details[0];
					$data['targ_city']			=	$city_details[0];
					$data['targ_zip']			=	$zip_details[0];
					$data['targ_device']		=	$device_details[0];
					$data['targ_black']			=	$black_details[0];
					$data['targ_white']			=	$white_details[0];
					
					$data['targ_time']			=	$time_details[0];
					$data['targ_daypart']		=	$daypart_details[0];
					//$data['targ_day_time']		=	$daytime_details[0];				
					$data['targ_url']			=	$url_details[0];
					$data['targ_connect']		=	$connect_details[0];
					$data['targ_carrier']		=	$carrier_details[0];
					
					//Traffic sources
					$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					//Country Bidding
					$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
					
					$data['campaign_id']		=	$campaign_id;				
					$data['s2s_details']		=	$s2s_details[0];
					$data['targ_browser']		=	$browser_details[0];
					$data['targ_os']			=	$os_details[0];
					$data['targ_time']			=	$time_details[0];
					
					$data['profile_age']		=	$profile_age[0];
					$data['profile_gender']		=	$profile_gender[0];
					$data['profile_color']		=	$profile_color[0];
					$data['profile_height']		=	$profile_height[0];
					$data['profile_weight']		=	$profile_weight[0];
					
					$data['profile_keyword']	=	$profile_keyword[0];
					
					$data['targ_mob_manu']		=	$mobile_manu_details[0];
					$data['targ_mob_capa']		=	$mobile_capa_details[0];
					$data['targ_mob_tele']		=	$mobile_telecom_details[0];
				}
	    }
		
		/**** Cookie setup-- end ************/
			
		$data['content'] 			= 	$this->load->view('site/campaigns/add_campaign_dev',$data,TRUE);
		
		$this->template->set_layout('direct_layout');
		$this->template->build('view', $data);
	}
	
	 /*
     * 
     * name: edit campaigns
     * @param : campaign_id
     * @return : fetch the campaign details
     */
    public function edit()
    {
		$data['page_title']  	= 	"Edit campaigns";
        $data['breadcrumb']  	= 	'';
        $camp_id 				= 	$this->uri->segment(4);
		
        /************ Campaign Decryption *************/
        $data['campaign_id']	= 	base64_decode(urldecode($camp_id));
        
		$is_valid            	= 	$this->rest->get('api/v1/user/get_valid_campaign', array('campaign_id' => $data['campaign_id']), 'php');
    
		/************ Campaign Decryption *************/
		if ($data['campaign_id'] != '' && $is_valid == 1) 
		{
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			
			//Minimum Budget & Bid Rate & creatives allowed
			$data['min_budget']		=	$this->default_configurations->get('min_budget');
			
			$data['min_bid_rate']	=	$this->default_configurations->get('min_bid_rate');
			
			$data['creat_allowed']	=	$this->default_configurations->get('direct_creative_type');
			
			/************ Video Enable/Disable *************/
					
			/************ Guest Advertiser *************/
			$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
			
			$data['guest_adv']			=	$gadv[0];
			
			$data['api_key']			=	$data['guest_adv']['api_key'];
			
			$data['target']				=	$this->targeting_list($data['api_key']);
			
			/************ Guest Advertiser *************/
			
			$data['creative_size'] 		= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>$data['api_key']),'php');
			
			$data['mob_screen_size']	= 	$this->rest->get('api/v1/mobile_creative/fetch_mobile_screen_sizes',array("api_key"=>$data['api_key']),'php');
			
			$data['lang_data'] 			=	$this->rest->get('api/v1/campaign/fetch_language',array('api_key'=>$data['api_key']),'php');
			
			//Fetch Publisher
			$adm						=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 
			$data['pub_data'] 			=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$adm[0]['api_key']),'php');
			$data['adb_data'] 			=	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$adm[0]['api_key']),'php');
			
			$data['preset_black']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>$adm[0]['api_key'],'adblock_type'=>'black'),'php');		
			$data['preset_white']		= 	$this->rest->get('api/v1/zone_limitations/fetch_zone_limitations',array('api_key'=>$adm[0]['api_key'],'adblock_type'=>'white'),'php');		
				
			//Fetch available site categories
			$data['campaign_category']	=	$this->rest->get('api/v1/utilities/categorylist/parent/1',array("api_key"=>$data['api_key']),'php');

			$data['camp_sub_category']	=	$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$data['api_key']),'php');

			//Fetch Country
			$data['countrylist']		=	$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$data['api_key']),'php');		
			
			//Fetch available campaign type
			$data['campaign_type']		= 	$this->rest->get('api/v1/utilities/fetch_type',array("api_key"=>$data['api_key']),'php');
		
            $campaign_id				=	$data['campaign_id'];
            
            //Fetch Campaign details
			$campaign_details	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
				
			$data['campaign_det']		=	$campaign_details[0];
			
			$s2s_details		= 	$this->rest->get('api/v1/campaign/fetch_tracker',array("campaign_id"=>$campaign_id,"s2s"=>'1',"api_key"=>$data['api_key']),'php');
			
			//Fetch browser targeting details
			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			//Fetch os targeting details
			$os_details			= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			//Fetch profile targeting details
			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			$profile_gender		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			$profile_color		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			$profile_height		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			$profile_weight		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			$profile_keyword	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$campaign_id),'php');
			
			//Fetch mobile os targeting details
			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			//Fetch mobile manufactures targeting details
			$mobile_manu_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			//Fetch mobile capability details
			$mobile_capa_details= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			//Fetch geo targeting details
			$geoinclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Include:country","api_key"=>$data['api_key']),'php');
			
			$geoexclude_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"Exclude:country","api_key"=>$data['api_key']),'php');
							
			//Language
			$lang_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Client:Language","api_key"=>$data['api_key']),'php');
			
			//City
			$city_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:City","api_key"=>$data['api_key']),'php');
			
			//Zip
			$zip_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Geo:Zip","api_key"=>$data['api_key']),'php');
			
			//Device
			$device_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"device:".strtolower($data['campaign_det']['dj_targetting_type']),"api_key"=>$data['api_key']),'php');
			
			//Blacklist
			$black_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Blacklist","api_key"=>$data['api_key']),'php');
			
			//Whitelist
			$white_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Whitelist","api_key"=>$data['api_key']),'php');
			
			//Blacklist
			$pblack_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_blacklist","api_key"=>$data['api_key']),'php');
			
			//Whitelist
			$pwhite_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:preset_whitelist","api_key"=>$data['api_key']),'php');
									
			//Time
			$time_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Hour","api_key"=>$data['api_key']),'php');
			
			//Daypart
			$daypart_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Time:Day","api_key"=>$data['api_key']),'php');
			
			//Day time
			//$daytime_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"deliveryLimitations:Day:Time","api_key"=>$data['api_key']),'php');
			
			//URL Keyword
			$url_details		= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"profile:url","api_key"=>$data['api_key']),'php');
			
			//Connection
			$connect_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"connection","api_key"=>$data['api_key']),'php');
			
			//Carrier
			$carrier_details	= 	$this->rest->get('api/v1/campaign/fetch_targeting_list',array("campaign_id"=>$campaign_id,"target_type"=>"carrier","api_key"=>$data['api_key']),'php');
			
			$data['targ_geo_include']	=	$geoinclude_details[0];
			$data['targ_geo_exclude']	=	$geoexclude_details[0];
			$data['targ_lang']			=	$lang_details[0];
			$data['targ_city']			=	$city_details[0];
			$data['targ_zip']			=	$zip_details[0];
			$data['targ_device']		=	$device_details[0];
			$data['targ_black']			=	$black_details[0];
			$data['targ_white']			=	$white_details[0];
			$data['targ_pblack']		=	$pblack_details[0];
			$data['targ_pwhite']		=	$pwhite_details[0];
			
			$data['targ_time']			=	$time_details[0];
			$data['targ_daypart']		=	$daypart_details[0];
			//$data['targ_day_time']		=	$daytime_details[0];				
			$data['targ_url']			=	$url_details[0];
			$data['targ_connect']		=	$connect_details[0];
			$data['targ_carrier']		=	$carrier_details[0];
			
			//Traffic sources
			$data['traffic']			= 	$this->rest->get('api/v1/campaign/fetch_campaign_traffic',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			//Country Bidding
			$data['country_bid']		= 	$this->rest->get('api/v1/campaign/fetch_campaign_bidding',array("campaign_id"=>$campaign_id,"api_key"=>$data['api_key']),'php');
			
			$data['campaign_id']		=	$campaign_id;				
			$data['s2s_details']		=	$s2s_details[0];
			$data['targ_browser']		=	$browser_details[0];
			$data['targ_os']			=	$os_details[0];
			$data['targ_time']			=	$time_details[0];
			
			$data['profile_age']		=	$profile_age[0];
			$data['profile_gender']		=	$profile_gender[0];
			$data['profile_color']		=	$profile_color[0];
			$data['profile_height']		=	$profile_height[0];
			$data['profile_weight']		=	$profile_weight[0];
			
			$data['profile_keyword']	=	$profile_keyword[0];
			
			$data['targ_mob_manu']		=	$mobile_manu_details[0];
			$data['targ_mob_capa']		=	$mobile_capa_details[0];
			$data['targ_mob_tele']		=	$mobile_telecom_details[0];
				
            $data['content']           = $this->load->view('site/campaigns/edit_campaigns', $data, TRUE);
            $this->template->set_layout('guest_layout');
            $this->template->build('view', $data);
        }
        else
        {
            $this->load->view('site/page_not_found');
        }
    }
	
	
	
	/*

	 * name   : fetch_campaign_crative

	 * @param : campaign_id

	 * @return: Fetch creative for particular campaign

	 */	

	public function fetch_campaign_creative($campaign_id=false)
	{
		
		$camp_id					= 	($campaign_id!=false)?$campaign_id:$this->input->post('_campaign_id');
		
		/************ Guest Advertiser *************/
		$gadv						=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']			=	$gadv[0];
		
		$data['api_key']			=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		//$check_edit=$this->input->post('api_key');
		//Fetch available linked creatives

		$data['existing_creative']	= 	$this->rest->get('api/v1/campaign/fetch_linked_creative',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');
		//$this->rest->debug();//print_r($data); die("sdff");
		echo $this->load->view('site/campaigns/edit_existing_creative',$data);
		

	}
	 
	/*

	 * name   : overview_campaign

	 * @param : campaign_id

	 * @return: Fetch creative for particular campaign

	 */	

	public function overview_campaign($campaign_id=false)
	{

		$camp_id			= 	($campaign_id!=false)?$campaign_id:$this->input->post('_campaign_id');
		
		/************ Guest Advertiser *************/
		$gadv				=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']	=	$gadv[0];
		
		$data['api_key']	=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/

		//Fetch Campaign details

		$camp['campaign_details']	= 	$this->rest->get('api/v1/campaign/fetch_campaign',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id,"view_type"=>'formated'),'json');
		$camp_arr	=	json_decode($camp['campaign_details']);//For verification

		 if($camp_arr[0]->dj_targetting_type=='WEB')
		{
			//Fetch browser targeting details

			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$campaign_id),'php');

			$targ_browsers_name	=	'';

			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_arr	=	explode(',',$browser_details[0]['data']);

				foreach($browser_details_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query 	= 	$this->db->get(TAB_TARG_BROWSERS);		

					$result = 	$query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_browsers_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch os targeting details

			$os_details		= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_os_name	=	'';

			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_arr	=	explode(',',$os_details[0]['data']);

				foreach($os_details_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query 	= 	$this->db->get(TAB_TARG_OS);		

					$result = 	$query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_os_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch time targeting details

			$time_details	= 	$this->rest->get('api/v1/campaign/fetch_time_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_time_name	=	'';

			if(isset($time_details[0]['data']) AND !empty($time_details[0]['data']))
			{
				$targ_time_arr		=	array(
											'0'	=>	'0:00-0:59',
											'1'	=>	'1:00-1:59',
											'2'	=>	'2:00-2:59',
											'3'	=>	'3:00-3:59',
											'4'	=>	'4:00-4:59',
											'5'	=>	'5:00-5:59',
											'6'	=> 	'6:00-6:59',
											'7'	=> 	'7:00-7:59',
											'8'	=>	'8:00-8:59',
											'9'	=> 	'9:00-9:59',
											'10'=>	'10:00-10:59',
											'11'=>	'11:00-11:59',
											'12'=>	'12:00-12:59',
											'13'=>	'13:00-13:59',
											'14'=>	'14:00-14:59',
											'15'=>	'15:00-15:59',
											'16'=>	'16:00-16:59',
											'17'=> 	'17:00-17:59',
											'18'=> 	'18:00-18:59',
											'19'=>	'19:00-19:59',
											'20'=>	'20:00-20:59',
											'21'=> 	'21:00-21:59',
											'22'=> 	'22:00-22:59',
											'23'=>	'23:00-23:59'
											);

				$time_details_arr	=	explode(',',$time_details[0]['data']);

				foreach($time_details_arr as $value)
				{
					if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))

						$targetted_time_display_name	.=	ucfirst($targ_time_array[$value]).',';
				}
			}

			//Fetch geo targeting details

			$geo_details	= 	$this->rest->get('api/v1/campaign/fetch_geo_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_geo_name	=	'';

			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_arr	=	explode(',',$geo_details[0]['data']);

				foreach($geo_details_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query 	= 	$this->db->get(TAB_TARG_COUNTRY);		

					$result = 	$query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_geo_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			$capping	=	$camp_arr[0]->capping;

			$block		=	$camp_arr[0]->block/3600;

			$frequency_capping	=	$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			
			//Fetch keyword targeting details

			$profile_keyword 	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_key_name	=	'';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))
			{
				$profile_keyword_arr	=	explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_arr as $value)
				{
					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);	

					$result = $query->result_array();					

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targ_prof_key_name	.=	ucfirst($result[0]['keyword']).',';
				}
			}

			//Fetch profile targeting details

			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_age_name	=	'';

			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_arr	=	array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');

				$profile_age_arr		=	explode(',',$profile_age[0]['data']);

				foreach($profile_age_arr as $value)
				{
					if(isset($targ_profile_age_arr[$value]) AND !empty($targ_profile_age_arr[$value]))

						$targ_prof_age_name	.=	ucfirst($targ_profile_age_arr[$value]).',';
				}
			}

			$profile_gender			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_gender_name	=	'';

			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_arr	=	array('male'=>'Gender: Male','female'=>'Gender: Female');

				$profile_gender_arr			=	explode(',',$profile_gender[0]['data']);

				foreach($profile_gender_arr as $value)
				{
					if(isset($targ_profile_gender_arr[$value]) AND !empty($targ_profile_gender_arr[$value]))

						$targ_prof_gender_name	.=	ucfirst($targ_profile_gender_arr[$value]).',';
				}
			}

			$profile_color			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_color_name	=	'';

			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_arr	=	array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');

				$profile_color_arr		=	explode(',',$profile_color[0]['data']);

				foreach($profile_color_arr as $value)
				{
					if(isset($targ_profile_color_arr[$value]) AND !empty($targ_profile_color_arr[$value]))

						$targ_prof_color_name	.=	ucfirst($targ_profile_color_arr[$value]).',';
				}
			}

			$profile_height			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_height_name	=	'';

			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_arr	=	array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');

				$profile_height_arr			=	explode(',',$profile_height[0]['data']);

				foreach($profile_height_arr as $value)
				{
					if(isset($targ_profile_height_arr[$value]) AND !empty($targ_profile_height_arr[$value]))

						$targ_prof_height_name	.=	ucfirst($targ_profile_height_arr[$value]).',';
				}
			}

			$profile_weight			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_weight_name	=	'';

			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_arr=	array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');

				$profile_weight_arr		=	explode(',',$profile_weight[0]['data']);

				foreach($profile_weight_arr as $value)
				{
					if(isset($targ_profile_weight_arr[$value]) AND !empty($targ_profile_weight_arr[$value]))

						$targ_prof_weight_name	.=	ucfirst($targ_profile_weight_arr[$value]).',';
				}
			}

			$final_profile_targ	=	$targ_prof_age_name.''.$targ_prof_gender_name.''.$targ_prof_color_name.''.$targ_prof_height_name.''.$targ_prof_weight_name;
			

			$final_targeting	=	array(
											$camp_arr[0]->dj_targetting_type	=>	array(
																						'targ_1'	=>	array("label"=>"Targeted browser","value"=>$targ_browsers_name,"desc"=>"Selected web browsers for targeting"),
																						'targ_2'	=>		array("label"=>"Targeted OS","value"=>$targ_os_name,"desc"=>"Selected Operating system for targeting"),
																						'targ_3'	=>	array("label"=>"Targeted time","value"=>$targ_time_name,"desc"=>"Selected targeted time"),
																						'targ_4'	=>	array("label"=>"Targeted Geographical location","value"=>$targ_geo_name,"desc"=>"Selected Geographical locations for targeting"),
																						'targ_5'	=>	array("label"=>"Frequency capping","value"=>$frequency_capping,"desc"=>"Frequency capping for this campaign"),
																						'targ_6'	=>array("label"=>"Profile targeting","value"=>$final_profile_targ,"desc"=>"Selected profile targeting"),	
																						'targ_7'	=>	array("label"=>"Contextual targeting","value"=>$targ_prof_keyword_name,"desc"=>"Select Contextual targeting")
																						)

										);
		}
		elseif($camp_arr[0]->dj_targetting_type=='MOBILE')
		{
			//Fetch mobile os targeting details

			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_mob_os_name	=	'';

			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_arr	=	explode(',',$mobile_os_details[0]['data']);

				foreach($mobile_os_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_OS);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_mob_os_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details

			$mobile_manu_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_mob_manu_name		=	'';

			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_arr	=	explode(',',$mobile_manu_details[0]['data']);

				foreach($mobile_manu_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_MANU);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_mob_manu_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile capability details

			$mobile_capa_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_mob_capa_name		=	'';

			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_arr	=	explode(',',$mobile_capa_details[0]['data']);

				foreach($mobile_capa_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_CAPA);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_mob_capa_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile tecom details

			$mobile_telecom_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_mob_telecom_name	=	'';

			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{
				$mobile_telecom_arr	=	explode(',',$mobile_telecom_details[0]['data']);

				foreach($mobile_telecom_arr as $value)
				{
					$this->db->select("id as id,CONCAT(country,'-',carriername) as name",false);

					$this->db->where('id',$value);

					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		

					$result = $query->result_array();

					if(isset($result[0]['id']) AND !empty($result[0]['name']))

						$targ_mob_telecom_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch moblie geo targetting details

			$mobile_geo_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_mob_geo_name	=	'';

			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_arr	=	explode(',',$mobile_geo_details[0]['data']);

				foreach($mobile_geo_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_CAPA);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_mob_geo_name	.=	ucfirst($result[0]['name']).',';
				}
			}


            ///Fetch keyword targeting details

			$profile_keyword		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_keyword_name	=	'';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))
			{
				$profile_keyword_arr	=	explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_arr as $value)
				{
					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);		

					$result = $query->result_array();

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targ_prof_keyword_name	.=	ucfirst($result[0]['keyword']).',';
				}
			}

			//Fetch profile targeting details

			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_age_name	=	'';

			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_arr	=	array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');

				$profile_age_arr		=	explode(',',$profile_age[0]['data']);

				foreach($profile_age_arr as $value)
				{
					if(isset($targ_profile_age_arr[$value]) AND !empty($targ_profile_age_arr[$value]))

						$targ_prof_age_name	.=	ucfirst($targ_profile_age_arr[$value]).',';
				}
			}

			$profile_gender			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_gender_name	=	'';

			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{

				$targ_profile_gender_arr	=	array('male'=>'Gender: Male','female'=>'Gender: Female');

				$profile_gender_arr			=	explode(',',$profile_gender[0]['data']);

				foreach($profile_gender_arr as $value)
				{
					if(isset($targ_profile_gender_arr[$value]) AND !empty($targ_profile_gender_arr[$value]))

						$targ_prof_gender_name	.=	ucfirst($targ_profile_gender_arr[$value]).',';
				}
			}

			$profile_color			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_color_name	=	'';

			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_arr	=	array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');

				$profile_color_arr		=	explode(',',$profile_color[0]['data']);

				foreach($profile_color_arr as $value)
				{
					if(isset($targ_profile_color_arr[$value]) AND !empty($targ_profile_color_arr[$value]))

						$targ_prof_color_name	.=	ucfirst($targ_profile_color_arr[$value]).',';
				}
			}

			$profile_height			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_height_name	=	'';

			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_arr=	array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');

				$profile_height_arr		=	explode(',',$profile_height[0]['data']);

				foreach($profile_height_arr as $value)
				{
					if(isset($targ_profile_height_arr[$value]) AND !empty($targ_profile_height_arr[$value]))

						$targ_prof_height_name	.=	ucfirst($targ_profile_height_arr[$value]).',';
				}
			}

			$profile_weight				=	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_profile_weight_name	=	'';

			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_arr=	array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');

				$profile_weight_arr		=	explode(',',$profile_weight[0]['data']);

				foreach($profile_weight_arr as $value)
				{
					if(isset($targ_profile_weight_arr[$value]) AND !empty($targ_profile_weight_arr[$value]))

						$targ_profile_weight_name	.=	ucfirst($targ_profile_weight_arr[$value]).',';
				}
			}

			$final_profile_targ	=	$targ_prof_age_name.''.$targ_prof_gender_name.''.$targ_prof_color_name.''.$targ_prof_height_name.''.$targ_prof_weight_name;

			$final_targeting	=	array(
											$camp_arr[0]->dj_targetting_type	=>	array(
																					'targ_1'	=>	array("label"=>"Targeted operating system","value"=>$targ_mob_os_name,"desc"=>"Selected  mobile operating system for targeting"),
																					'targ_2'	=>	array("label"=>"Targeted manufacturers","value"=>$targ_mob_manu_name,"desc"=>"Selected manufactures for targeting"), 
																					'targ_3'	=>	array("label"=>"Targeted capability","value"=>$targ_mob_capa_name,"desc"=>"Selected targeted mobile capabiliy"), 
																					'targ_4'	=>	array("label"=>"Targeted telecom","value"=>$targ_mob_telecom_name,"desc"=>"Selected telecom for targeting"),  
																					'targ_5'	=>	array("label"=>"Targeted geographical location","value"=>$targ_mob_geo_name,"desc"=>"Selected geographical locations for targeting"), 
																					'targ_6'	=>	array("label"=>"Profile targeting","value"=>$final_profile_targ,"desc"=>"Selected profile targeting"),  
																					'targ_7'	=>	array("label"=>"contextual_targeting","value"=>$targ_prof_keyword_name,"desc"=>"Select contextual targeting"), 																					)
											);
		}
			elseif($camp_arr[0]->dj_targetting_type=='TABLET')
		{
			//Fetch mobile os targeting details

			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_os_name	=	'';

			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_arr	=	explode(',',$mobile_os_details[0]['data']);

				foreach($mobile_os_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_OS);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_os_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details

			$mobile_manu_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_manu_name		=	'';

			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_arr	=	explode(',',$mobile_manu_details[0]['data']);

				foreach($mobile_manu_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_MANU);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_manu_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile capability details

			$mobile_capa_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_capa_name		=	'';

			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_arr	=	explode(',',$mobile_capa_details[0]['data']);

				foreach($mobile_capa_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_CAPA);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_capa_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile tecom details

			$mobile_telecom_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_telecom_name	=	'';

			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{
				$mobile_telecom_arr	=	explode(',',$mobile_telecom_details[0]['data']);

				foreach($mobile_telecom_arr as $value)
				{
					$this->db->select("id as id,CONCAT(country,'-',carriername) as name",false);

					$this->db->where('id',$value);

					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		

					$result = $query->result_array();

					if(isset($result[0]['id']) AND !empty($result[0]['name']))

						$targ_tablet_telecom_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch moblie geo targetting details

			$mobile_geo_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_geo_name	=	'';

			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_arr	=	explode(',',$mobile_geo_details[0]['data']);

				foreach($mobile_geo_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_CAPA);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_geo_name	.=	ucfirst($result[0]['name']).',';
				}
			}


            ///Fetch keyword targeting details

			$profile_keyword		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_prof_keyword_name	=	'';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))
			{
				$profile_keyword_arr	=	explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_arr as $value)
				{
					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);		

					$result = $query->result_array();

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targ_tablet_prof_keyword_name	.=	ucfirst($result[0]['keyword']).',';
				}
			}

			//Fetch profile targeting details

			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_prof_age_name	=	'';

			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_arr	=	array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');

				$profile_age_arr		=	explode(',',$profile_age[0]['data']);

				foreach($profile_age_arr as $value)
				{
					if(isset($targ_profile_age_arr[$value]) AND !empty($targ_profile_age_arr[$value]))

						$targ_tablet_prof_age_name	.=	ucfirst($targ_profile_age_arr[$value]).',';
				}
			}

			$profile_gender			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_prof_gender_name	=	'';

			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{

				$targ_profile_gender_arr	=	array('male'=>'Gender: Male','female'=>'Gender: Female');

				$profile_gender_arr			=	explode(',',$profile_gender[0]['data']);

				foreach($profile_gender_arr as $value)
				{
					if(isset($targ_profile_gender_arr[$value]) AND !empty($targ_profile_gender_arr[$value]))

						$targ_tablet_prof_gender_name	.=	ucfirst($targ_profile_gender_arr[$value]).',';
				}
			}

			$profile_color			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_prof_color_name	=	'';

			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_arr	=	array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');

				$profile_color_arr		=	explode(',',$profile_color[0]['data']);

				foreach($profile_color_arr as $value)
				{
					if(isset($targ_profile_color_arr[$value]) AND !empty($targ_profile_color_arr[$value]))

						$targ_tablet_prof_color_name	.=	ucfirst($targ_profile_color_arr[$value]).',';
				}
			}

			$profile_height			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_prof_height_name	=	'';

			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_arr=	array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');

				$profile_height_arr		=	explode(',',$profile_height[0]['data']);

				foreach($profile_height_arr as $value)
				{
					if(isset($targ_profile_height_arr[$value]) AND !empty($targ_profile_height_arr[$value]))

						$targ_tablet_prof_height_name	.=	ucfirst($targ_profile_height_arr[$value]).',';
				}
			}

			$profile_weight				=	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_profile_weight_name	=	'';

			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_arr=	array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');

				$profile_weight_arr		=	explode(',',$profile_weight[0]['data']);

				foreach($profile_weight_arr as $value)
				{
					if(isset($targ_profile_weight_arr[$value]) AND !empty($targ_profile_weight_arr[$value]))

						$targ_tablet_profile_weight_name	.=	ucfirst($targ_profile_weight_arr[$value]).',';
				}
			}

			$final_tablet_profile_targ	=	$targ_tablet_prof_age_name.''.$targ_tablet_prof_gender_name.''.$targ_tablet_prof_color_name.''.$targ_tablet_prof_height_name.''.$targ_tablet_prof_weight_name;

			$final_targeting	=	array(
											$camp_arr[0]->dj_targetting_type	=>	array(
																					'targ_1'	=>	array("label"=>"Targeted operating system","value"=>$targ_tablet_os_name,"desc"=>"Selected  mobile operating system for targeting"),
																					'targ_2'	=>	array("label"=>"Targeted manufacturers","value"=>$targ_tablet_manu_name,"desc"=>"Selected manufactures for targeting"), 
																					'targ_3'	=>	array("label"=>"Targeted capability","value"=>$targ_tablet_capa_name,"desc"=>"Selected targeted mobile capabiliy"), 
																					'targ_4'	=>	array("label"=>"Targeted telecom","value"=>$targ_tablet_telecom_name,"desc"=>"Selected telecom for targeting"),  
																					'targ_5'	=>	array("label"=>"Targeted geographical location","value"=>$targ_tablet_geo_name,"desc"=>"Selected geographical locations for targeting"), 
																					'targ_6'	=>	array("label"=>"Profile targeting","value"=>$final_tablet_profile_targ,"desc"=>"Selected profile targeting"),  
																					'targ_7'	=>	array("label"=>"contextual_targeting","value"=>$targ_tablet_prof_keyword_name,"desc"=>"Select contextual targeting"), 																					)
											);
		}
		elseif($camp_arr[0]->dj_targetting_type=='ALL')
		{
			
			//Fetch browser targeting details

			$browser_details	= 	$this->rest->get('api/v1/campaign/fetch_browser_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$campaign_id),'php');

			$targ_browsers_name	=	'';

			if(isset($browser_details[0]['data']) AND !empty($browser_details[0]['data']))
			{
				$browser_details_arr	=	explode(',',$browser_details[0]['data']);

				foreach($browser_details_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query 	= 	$this->db->get(TAB_TARG_BROWSERS);		

					$result = 	$query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_browsers_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch os targeting details

			$os_details		= 	$this->rest->get('api/v1/campaign/fetch_os_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_os_name	=	'';

			if(isset($os_details[0]['data']) AND !empty($os_details[0]['data']))
			{
				$os_details_arr	=	explode(',',$os_details[0]['data']);

				foreach($os_details_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query 	= 	$this->db->get(TAB_TARG_OS);		

					$result = 	$query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_os_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch time targeting details

			$time_details	= 	$this->rest->get('api/v1/campaign/fetch_time_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_time_name	=	'';

			if(isset($time_details[0]['data']) AND !empty($time_details[0]['data']))
			{
				$targ_time_arr		=	array(
											'0'	=>	'0:00-0:59',
											'1'	=>	'1:00-1:59',
											'2'	=>	'2:00-2:59',
											'3'	=>	'3:00-3:59',
											'4'	=>	'4:00-4:59',
											'5'	=>	'5:00-5:59',
											'6'	=> 	'6:00-6:59',
											'7'	=> 	'7:00-7:59',
											'8'	=>	'8:00-8:59',
											'9'	=> 	'9:00-9:59',
											'10'=>	'10:00-10:59',
											'11'=>	'11:00-11:59',
											'12'=>	'12:00-12:59',
											'13'=>	'13:00-13:59',
											'14'=>	'14:00-14:59',
											'15'=>	'15:00-15:59',
											'16'=>	'16:00-16:59',
											'17'=> 	'17:00-17:59',
											'18'=> 	'18:00-18:59',
											'19'=>	'19:00-19:59',
											'20'=>	'20:00-20:59',
											'21'=> 	'21:00-21:59',
											'22'=> 	'22:00-22:59',
											'23'=>	'23:00-23:59'
											);

				$time_details_arr	=	explode(',',$time_details[0]['data']);

				foreach($time_details_arr as $value)
				{
					if(isset($targ_time_array[$value]) AND !empty($targ_time_array[$value]))

						$targetted_time_display_name	.=	ucfirst($targ_time_array[$value]).',';
				}
			}

			//Fetch geo targeting details

			$geo_details	= 	$this->rest->get('api/v1/campaign/fetch_geo_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_geo_name	=	'';

			if(isset($geo_details[0]['data']) AND !empty($geo_details[0]['data']))
			{
				$geo_details_arr	=	explode(',',$geo_details[0]['data']);

				foreach($geo_details_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query 	= 	$this->db->get(TAB_TARG_COUNTRY);		

					$result = 	$query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_geo_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			$capping	=	$camp_arr[0]->capping;

			$block		=	$camp_arr[0]->block/3600;

			$frequency_capping	=	$capping.'&nbsp;impression in '.$block.'&nbsp;Hours';
			
			
			
			//Fetch mobile os targeting details

			$mobile_os_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_os_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_os_name	=	'';

			if(isset($mobile_os_details[0]['data']) AND !empty($mobile_os_details[0]['data']))
			{
				$mobile_os_arr	=	explode(',',$mobile_os_details[0]['data']);

				foreach($mobile_os_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_OS);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_os_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile manufactures targeting details

			$mobile_manu_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_manu_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_manu_name		=	'';

			if(isset($mobile_manu_details[0]['data']) AND !empty($mobile_manu_details[0]['data']))
			{
				$mobile_manu_arr	=	explode(',',$mobile_manu_details[0]['data']);

				foreach($mobile_manu_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_MANU);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_manu_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile capability details

			$mobile_capa_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_capa_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_capa_name		=	'';

			if(isset($mobile_capa_details[0]['data']) AND !empty($mobile_capa_details[0]['data']))
			{
				$mobile_capa_arr	=	explode(',',$mobile_capa_details[0]['data']);

				foreach($mobile_capa_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_CAPA);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_capa_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch mobile tecom details

			$mobile_telecom_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_telecom_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_telecom_name	=	'';

			if(isset($mobile_telecom_details[0]['data']) AND !empty($mobile_telecom_details[0]['data']))
			{
				$mobile_telecom_arr	=	explode(',',$mobile_telecom_details[0]['data']);

				foreach($mobile_telecom_arr as $value)
				{
					$this->db->select("id as id,CONCAT(country,'-',carriername) as name",false);

					$this->db->where('id',$value);

					$query = $this->db->get(TAB_TARG_MOBILE_CARRIER);		

					$result = $query->result_array();

					if(isset($result[0]['id']) AND !empty($result[0]['name']))

						$targ_tablet_telecom_name.=ucfirst($result[0]['name']).',';
				}
			}

			//Fetch moblie geo targetting details

			$mobile_geo_details	= 	$this->rest->get('api/v1/campaign/fetch_mobile_geo_targeting',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_tablet_geo_name	=	'';

			if(isset($mobile_geo_details[0]['data']) AND !empty($mobile_geo_details[0]['data']))
			{
				$mobile_geo_arr	=	explode(',',$mobile_geo_details[0]['data']);

				foreach($mobile_geo_arr as $value)
				{
					$this->db->select('name');

					$this->db->where('value',$value);

					$query = $this->db->get(TAB_TARG_MOB_CAPA);		

					$result = $query->result_array();

					if(isset($result[0]['name']) AND !empty($result[0]['name']))

						$targ_tablet_geo_name	.=	ucfirst($result[0]['name']).',';
				}
			}

			//Fetch keyword targeting details

			$profile_keyword 	= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_keyword',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_key_name	=	'';

			if(isset($profile_keyword[0]['data']) AND !empty($profile_keyword[0]['data']))
			{
				$profile_keyword_arr	=	explode(',',$profile_keyword[0]['data']);

				foreach($profile_keyword_arr as $value)
				{
					$this->db->select('keyword');

					$this->db->where('keyword',$value);

					$query = $this->db->get(TAB_TARG_KEYWORD);	

					$result = $query->result_array();					

					if(isset($result[0]['keyword']) AND !empty($result[0]['keyword']))

						$targ_prof_key_name	.=	ucfirst($result[0]['keyword']).',';
				}
			}

			//Fetch profile targeting details

			$profile_age		= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_age',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_age_name	=	'';

			if(isset($profile_age[0]['data']) AND !empty($profile_age[0]['data']))
			{
				$targ_profile_age_arr	=	array('less_than_20'=>'Age less than 20','T_20_35'=>'Age around: 20-35','T_35_45'=>'Age around: 35-45','more_than_45'=>'Age more than 45');

				$profile_age_arr		=	explode(',',$profile_age[0]['data']);

				foreach($profile_age_arr as $value)
				{
					if(isset($targ_profile_age_arr[$value]) AND !empty($targ_profile_age_arr[$value]))

						$targ_prof_age_name	.=	ucfirst($targ_profile_age_arr[$value]).',';
				}
			}

			$profile_gender			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_gender',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_gender_name	=	'';

			if(isset($profile_gender[0]['data']) AND !empty($profile_gender[0]['data']))
			{
				$targ_profile_gender_arr	=	array('male'=>'Gender: Male','female'=>'Gender: Female');

				$profile_gender_arr			=	explode(',',$profile_gender[0]['data']);

				foreach($profile_gender_arr as $value)
				{
					if(isset($targ_profile_gender_arr[$value]) AND !empty($targ_profile_gender_arr[$value]))

						$targ_prof_gender_name	.=	ucfirst($targ_profile_gender_arr[$value]).',';
				}
			}

			$profile_color			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_color',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_color_name	=	'';

			if(isset($profile_color[0]['data']) AND !empty($profile_color[0]['data']))
			{
				$targ_profile_color_arr	=	array('fair'=>'Color: Fair','weatish'=>'Color: Weatish','dark'=>'Color: Dark');

				$profile_color_arr		=	explode(',',$profile_color[0]['data']);

				foreach($profile_color_arr as $value)
				{
					if(isset($targ_profile_color_arr[$value]) AND !empty($targ_profile_color_arr[$value]))

						$targ_prof_color_name	.=	ucfirst($targ_profile_color_arr[$value]).',';
				}
			}

			$profile_height			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_height',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_height_name	=	'';

			if(isset($profile_height[0]['data']) AND !empty($profile_height[0]['data']))
			{
				$targ_profile_height_arr	=	array('less_than_140'=>'Height less than 140','T_140_155'=>'Height around: 140-155','T_155_175'=>'Height around: 155-175','more_than_175'=>'Height more than 175');

				$profile_height_arr			=	explode(',',$profile_height[0]['data']);

				foreach($profile_height_arr as $value)
				{
					if(isset($targ_profile_height_arr[$value]) AND !empty($targ_profile_height_arr[$value]))

						$targ_prof_height_name	.=	ucfirst($targ_profile_height_arr[$value]).',';
				}
			}

			$profile_weight			= 	$this->rest->get('api/v1/campaign/fetch_profile_targeting_weight',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

			$targ_prof_weight_name	=	'';

			if(isset($profile_weight[0]['data']) AND !empty($profile_weight[0]['data']))
			{
				$targ_profile_weight_arr=	array('less_than_20'=>'Weight less than 20','T_20_35'=>'Weight around: 20-35','T_35_45'=>'weight around: 35-45','more_than_45'=>'weight more than 45');

				$profile_weight_arr		=	explode(',',$profile_weight[0]['data']);

				foreach($profile_weight_arr as $value)
				{
					if(isset($targ_profile_weight_arr[$value]) AND !empty($targ_profile_weight_arr[$value]))

						$targ_prof_weight_name	.=	ucfirst($targ_profile_weight_arr[$value]).',';
				}
			}

			$final_profile_targ	=	$targ_prof_age_name.''.$targ_prof_gender_name.''.$targ_prof_color_name.''.$targ_prof_height_name.''.$targ_prof_weight_name;
			
			
			
			

			$final_targeting	=	array(
											$camp_arr[0]->dj_targetting_type	=>	array(
																						'targ_1'	=>	array("label"=>"Targeted browser","value"=>$targ_browsers_name,"desc"=>"Selected web browsers for targeting"),
																						'targ_2'	=>		array("label"=>"Targeted OS","value"=>$targ_os_name,"desc"=>"Selected Operating system for targeting"),
																						'targ_3'	=>	array("label"=>"Targeted time","value"=>$targ_time_name,"desc"=>"Selected targeted time"),
																						'targ_4'	=>	array("label"=>"Targeted Geographical location","value"=>$targ_geo_name,"desc"=>"Selected Geographical locations for targeting"),
																						'targ_5'	=>	array("label"=>"Frequency capping","value"=>$frequency_capping,"desc"=>"Frequency capping for this campaign"),			
																						'targ_6'	=>	array("label"=>"Targeted operating system","value"=>$targ_tablet_os_name,"desc"=>"Selected  mobile operating system for targeting"),
																						'targ_7'	=>	array("label"=>"Targeted manufacturers","value"=>$targ_tablet_manu_name,"desc"=>"Selected manufactures for targeting"), 
																						'targ_8'	=>	array("label"=>"Targeted capability","value"=>$targ_tablet_capa_name,"desc"=>"Selected targeted mobile capabiliy"), 
																						'targ_9'	=>	array("label"=>"Targeted telecom","value"=>$targ_tablet_telecom_name,"desc"=>"Selected telecom for targeting"),  
																						'targ_10'	=>	array("label"=>"Targeted geographical location","value"=>$targ_tablet_geo_name,"desc"=>"Selected geographical locations for targeting"),'targ_11'	=>array("label"=>"Profile targeting","value"=>$final_profile_targ,"desc"=>"Selected profile targeting"),	
																						'targ_12'	=>	array("label"=>"Contextual targeting","value"=>$targ_prof_keyword_name,"desc"=>"Select Contextual targeting")
																						)

										);
			
		}
		
		$existing_creative	= 	$this->rest->get('api/v1/campaign/fetch_linked_creative',array("api_key"=>$data['api_key'],"campaign_id"=>$camp_id),'php');

		if(!empty($existing_creative))

			$no_of_creative['no_of_linked_creative']=sizeof($existing_creative);

		else

			$no_of_creative['no_of_linked_creative']='0';		

		$result_tmp	=	array_merge($camp,$no_of_creative);

		if(isset($final_targeting))
		{
			$result	=	json_encode(array_merge($result_tmp,$final_targeting));

			print_r($result);
		}
		else
		{
			$result	=	json_encode($result_tmp);

			print_r($result);
		}

	}

	public function targeting_list($key)
	{
		if($key!=FALSE)
		{
			$api_key=	$key;
		}
		else
		{
			$gadv			=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
			$api_key		=	$gadv[0]['api_key'];
		}
		
		$data['browsers']	= 	$this->rest->get('api/v1/utilities/fetch_target_browsers',array("api_key"=>$api_key),'php');
		
		$data['language']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'language'),'php');
		
		$data['os_set']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'os_set'),'php');
		
		$data['os']			= 	$this->rest->get('api/v1/utilities/fetch_target_os',array("api_key"=>$api_key),'php');
		
		$data['keywords']	= 	$this->rest->get('api/v1/utilities/fetch_target_keyword',array("api_key"=>$api_key),'php');
		
		$data['mobile_os']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_os',array("api_key"=>$api_key),'php');
		
		$data['manu']		= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_manu',array("api_key"=>$api_key),'php');
		
		$data['capability']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_capability',array("api_key"=>$api_key),'php');
		
		$data['carrier']	= 	$this->rest->get('api/v1/utilities/fetch_target_mobile_carrier',array("api_key"=>$api_key),'php');
		
		$data['continent']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'continent'),'php');
		
		$data['countries']	= 	$this->rest->get('api/v1/utilities/fetch_target_countries',array("api_key"=>$api_key),'php');
		
		$data['time']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'time'),'php');
		
		$data['days']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'days'),'php');
		
		$data['dev_type']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'dev_type'),'php');
		
		$data['device']		= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'device'),'php');
		
		$data['connection']	= 	$this->rest->get('api/v1/utilities/fetch_target_option',array("api_key"=>$api_key,'type'=>'connection'),'php');
		
		
		return $data;
	}
	
	/*
	 * 
	 * name: preview_creative
	 * @param : null
	 * @return : list of creatives to preview.
	 */	
	public function preview_creative($banner_id=FALSE)
	{ 
		$gadv			=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$api_key		=	$gadv[0]['api_key']; 
		
		$data['banner_id']		=	$banner_id;
		
		$data['creative_list']	=	$this->rest->get('api/v1/approval/preview_creative',array("api_key"=>$api_key,'banner_id'=>$banner_id),'php'); 
		
		echo $this->load->view('campaigns/campaign_preview',$data);
	}
}
