<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bitpay extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
		
		$this->load->model('do_campaign');
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));		
		
	}

	public function index()
	{
		$this->add_payment();
	}
	
	function add_payment($camp_id,$amount,$name,$email,$mode)
	{
		$data['page_title'] 	= 	"Payment Gateway - Authorize.net";
		
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['payment_mode']	= 	"Bitpay";
		$data['amount'] 		= 	$amount;
		$data['camp_name'] 		= 	$name;
		$data['email'] 			= 	urldecode($email);
		$data['campaign_id'] 	= 	$camp_id;
		$data['mode'] 			= 	$mode;
		
		$adm		=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 	
		/*$auth_info	= 	$this->rest->get('api/v1/network/fetch_admin_authorize_info',array('api_key'=>$adm[0]['api_key'],'payment_type'=>'5'),'php');
		
		$data['auth_api_id'] 	= 	$auth_info[0]['api_username'];
		$data['auth_trans_key'] = 	$auth_info[0]['api_signature'];*/
				
		$this->load->view('site/bitpay/add_payment',$data);		
	 }

	
	public function payment_success()
	{
		$data['page_title']		= 	"payment success";
		
		$mode 		= 	$_POST['mode'];
		if($mode=="new")
		{
			$status		=	0;
			$is_default	=	1;
		}
		else if($mode=="edit")
		{
			$status		=	1;
			$is_default	=	0;
		}
		
		$adm			=	$this->rest->get('api/v1/user/get_admin_email',array('user_id'=>1),'php'); 
		
		$data['trans_id'] 		= 	$_POST['id'];
		$data['trans_amount'] 	= 	$_POST['price'];
		$data['trans_code'] 	= 	$_POST['status'];
		$data['cust_id']		=	$_POST['x_cust_id'];
		
		#Get Post values from Authorize.net	
		
		if($_POST['status']=='paid') 
		{
			$invoice_code 	= 	$_POST['x_invoice_num'];
			$ipn_no		 	= 	$_POST['id'];
			$ipn_txn_id	 	= 	$_POST['id'];
			
			$update_camp_payment = array(
										'campaign_id'   =>  $_POST['x_cust_id'],
										'name'	 		=> 	$_POST['buyerName'],
										'email' 		=> 	$adm[0]['email_address'],
										'payer_email'   =>  $_POST['buyerEmail'],
										'payment_type'	=> '6' ,
										'date'        	=>  date('Y-m-d H:i:s'),
										'amount'  		=>  $_POST['price'],
										'btcPrice'  	=>  $_POST['btcPrice'],
										'currency'   	=>  $_POST['currency'],
										'clearing_date' =>  date('Y-m-d H:i:s'),
										'status'   		=>  $status,
										'is_default'   	=>  $is_default,
										'transaction'   => 'credit' ,
										'admin_approval_status'	=>  0,
										'invoice_code'	=> 	$invoice_code ,   
										'id_no'			=>	$ipn_no,
										'txn_id'		=>	$ipn_txn_id,
										'receiver_email'=>  $adm[0]['email_address'],                       
										'approved_date' =>  date('Y-m-d H:i:s')
									);
			   
			$payment_response_id 	= 	$this->do_campaign->insert_campaign_payment($update_camp_payment);
			
			$this->db->where('campaignid',$_POST['x_cust_id']);
			$this->db->update(TAB_CAMPAIGNS,array('dj_invoice_no'=>''));
			
			$this->load->view('site/bitpay/payment_success',$data);
		}
		else
		{
			$data['page_title']		= 	"Payment Failure";
			
			$this->do_campaign->delete_campaign($data['cust_id']);
			
			$this->db->where('campaignid',$data['cust_id']);
			$this->db->update(TAB_CAMPAIGNS,array('dj_invoice_no'=>''));
			
			$this->load->view('site/bitpay/payment_failure', $data);
		}	
	}
	
	public function payment_failure($campaign_id)
	{
		$data['page_title']		= 	"Payment process details";
		
		$this->do_campaign->delete_campaign($campaign_id);
		
		$this->load->view('site/bitpay/payment_failure', $data);
	}
	
	public function payment_process($mode=false,$campaign_id=false)
	{
		$data['page_title']		= 	"Payment Process";
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 	
		
		$pay_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>$adm[0]['api_key'],'payment_type'=>'4'),'php');
		
		$data['apiKey']			=	$pay_info[0]['api_signature'];
		
		$invoice				=	$this->rest->get('api/v1/user/get_invoice_no',array('campaign_id'=>$campaign_id),'php'); 	
		
		$data['inv']			=	$invoice[0];
		
		$data['mode'] 			= 	$mode;
		
		$this->load->view('site/bitpay/payment_process', $data);
	}
	
	public function redirect2bitpay()
	{
		$data['page_title']		= 	"Payment process details";
		
		$adm					=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 	
		
		$pay_info				= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>$adm[0]['api_key'],'payment_type'=>'4'),'php');
		
		$data['apiKey']			=	$pay_info[0]['api_signature'];
		
		$data['bit']			=	$_POST;
		
		$this->load->view('site/bitpay/redirect2bitpay', $data);
	}
	
	public function ipn()
	{
		$data['page_title']		= 	"Payment IPN details";
		
		$this->load->view('site/bitpay/callback', $data);
	}
}
