<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Authorize extends CI_Controller { 

	public function __construct()
	{
		parent::__construct();
		
		$this->load->model('do_campaign');
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		
	}

	public function index()
	{
		$this->add_payment();
	}
	
	function add_payment($camp_id,$amount,$name,$email,$mode)
	{
		$data['page_title'] 	= 	"Payment Gateway - Authorize.net";
		
		/************ Guest Advertiser *************/
		$gadv					=	$this->rest->get('api/v1/user/get_guest_adv',array(),'php');
		
		$data['guest_adv']		=	$gadv[0];
		
		$data['api_key']		=	$data['guest_adv']['api_key'];
		
		/************ Guest Advertiser *************/
		
		$data['payment_mode']	= 	"Authorize.Net";
		$data['amount'] 		= 	$amount;
		$data['camp_name'] 		= 	$name;
		$data['email'] 			= 	urldecode($email);
		$data['campaign_id'] 	= 	$camp_id;
		$data['mode'] 			= 	$mode;
		
		$adm		=	$this->rest->get('api/v1/user/get_admin_api',array(),'php'); 	
		$auth_info	= 	$this->rest->get('api/v1/network/fetch_admin_payinfo',array('api_key'=>$adm[0]['api_key'],'payment_type'=>'5'),'php');
		
		$data['auth_api_id'] 	= 	$auth_info[0]['api_username'];
		$data['auth_trans_key'] = 	$auth_info[0]['api_signature'];
				
		$this->load->view('site/authorize/add_payment',$data);		
	 }

	
	public function payment_success()
	{
		$data['page_title']		= 	"payment success";
		$data['trans_amount'] 	= 	$this->input->post('trans_amount');
		$data['trans_code'] 	= 	$this->input->post('trans_code');
					
		$this->load->view('site/authorize/payment_success',$data);
	}
	
	public function payment_failure($campaign_id)
	{
		$data['page_title']		= 	"Payment process details";
		
		$this->do_campaign->delete_campaign($campaign_id);
		
		$this->load->view('site/authorize/payment_failure', $data);
	}
	
	public function payment_process($mode=FALSE)
	{
		$data['page_title']			= "Payment Process";
		
		if($mode=="new")
		{
			$status		=	0;
			$is_default	=	1;
		}
		else if($mode=="edit")
		{
			$status		=	1;
			$is_default	=	0;
		}
		
		$adm			=	$this->rest->get('api/v1/user/get_admin_email',array('user_id'=>1),'php'); 
		
		$data['code'] 		= 	$_POST['x_response_code'];
		$data['trans_id'] 	= 	$_POST['x_trans_id'];
		$data['amount']		=	$_POST['x_amount'];
		$data['cust_id']	=	$_POST['x_cust_id'];
		
		#Get Post values from Authorize.net	
		
		if($_POST['x_response_code']==1) 
		{
			$invoice_code 	= 	$_POST['x_invoice_num'];
			$ipn_no		 	= 	$_POST['x_trans_id'];
			$ipn_txn_id	 	= 	$_POST['x_trans_id'];
			
			$update_camp_payment = array(
										'campaign_id'   =>  $_POST['x_cust_id'],
										'name'	 		=> 	$_POST['x_first_name'],
										'email' 		=> 	$adm[0]['email_address'],
										'payer_email'   =>  $_POST['x_email'],
										'payment_type'	=> '5' ,
										'date'        	=>  date('Y-m-d H:i:s'),
										'amount'  		=>  $_POST['x_amount'],
										'currency'   	=>  $this->config->item('currency'),
										'clearing_date' =>  date('Y-m-d H:i:s'),
										'status'   		=>  $status,
										'is_default'   	=>  $is_default,
										'transaction'   => 'credit' ,
										'admin_approval_status'	=>  0,
										'invoice_code'	=> 	$invoice_code ,   
										'id_no'			=>	$ipn_no,
										'txn_id'		=>	$ipn_txn_id,
										'receiver_email'=>  $adm[0]['email_address'],                       
										'approved_date' =>  date('Y-m-d H:i:s')
									);
			   
			$payment_response_id 	= 	$this->do_campaign->insert_campaign_payment($update_camp_payment);
		
			$this->load->view('site/authorize/payment_process',$data);
		}
		else
		{
			$data['page_title']		= 	"Payment Failure";
			
			$this->do_campaign->delete_campaign($data['cust_id']);
			
			$this->load->view('site/authorize/payment_failure', $data);
		}	
	}
}
