<?php 
class Sample extends CI_Controller {
	
	
	public function test_advertiser_layout()
	{
		
		$this->config->load('sidebar_settings');
	
		
		
		/*******************************************************
						Meta Data
		 *******************************************************/
		$data['page_title'] = "Home";
		
		$this->load->helper('sidebar_widget');
		
		$data['breadcrumb'] = '';//breadcrumb(); 
		
		$sidebar_data = array('quick_links','tip_of_the_day','quick_links');
		
		$data['content'] = $this->load->view('home',$data,TRUE);
		

		
		$this->template->set_layout('advertiser_layout');
		$this->template->build('view', $data);
	}
	
	
	public function test_publisher_layout()
	{
		/*******************************************************
					Meta Data
		 *******************************************************/
		$data['page_title'] = "Home";
		
		$data['breadcrumb'] = breadcrumb(); 
		

		/*******************************************************
					Loading Template
		 *******************************************************/
		
		$data['content'] = $this->load->view('home_pub',$data,TRUE);
		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	

	public function test_api_client()
	{	
		
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		
		$users = $this->rest->post('/api.v_1/user/create',array("reference_id"=>1),'json');
		
		var_dump($users);
		
	}
	
	public function test_login()
	{
		$this->load->view('login');	
		
	}
	
	public function test_signup()
	{
		$this->load->view('signup_form');
	}
	
	public function test_signup_success()
	{
		$this->load->view('signup_successful');
	}	
	
	public function test_mail()
	{
		$type = 'ADV_REG_SUCCESS';
		
		$this->mail_new_type($type);
		
	}
	
	public function test_session(){
		echo '<pre>';
		print_r($this->session->all_userdata());
		
		echo "Session First Name::".get_session('adv_first_name');
	}
	
	
	private function mail_new_type($type,$to = '',$cc = '',$attachment='')
	{
		$this->load->config('email_configurations');
		
		$email_content = $this->config->item('email_content');
		
		print_r($email_content[$type]);
		
		$subject		=	$email_content[$type]['SUBJECT'];
		$email_data		= 	array(
									"name" =>  $name,
									"username" => $username,
									"email" => $email,
									"pwd"  =>$password	
												  );
		$data['content']	= $this->load->view($email_content[$type]['CONTENT'],$email_data,TRUE);
		$message			= $this->load->view($theme.'/email/email_tpl', $data, TRUE);
						
		$config['protocol'] ="sendmail";
		$config['wordwrap'] =TRUE;		
		$config['mailtype'] ='html';
		$config['charset']	='UTF-8'; 
		$this->email->initialize($config);
		$this->email->from('info@djaxadserver.com');
		$this->email->to($to);        
		$this->email->subject($subject);        
		$this->email->message($message);
		$this->email->send();	
	}
	
	/**
       * 
       * Login Form for Publisher
       * @return the loads the view file for the publisher
    */
	public function test_pub_login()
	{
		$this->load->view('pub_login');		
	}
	
	public function test_custom_func()
	{
		$array = array('1','2','4','10','11','13','15','19','31','51','52','54','55','56','57','58','61');
		$final_arr = array();
		$account_id = 19;
		$user_id = 14;
		
		
		foreach($array as $per_id)
		{
			$final_arr[] = array('account_id'=>$account_id,
								 'user_id'=>$user_id,
								 'permission_id'=>$per_id	
							);
		}	
		echo '<pre/>';
		print_r($final_arr);
		exit;
		
	}
	
	public function test_email_template()
	{
		$this->load->view('email/english/advertiser_forget_password');	
	}
	
	public function advertiser_forgot_password()
	{
		$this->load->view('adv_forgot_password');	
	}
	
	public function test_multiple_modal()
	{
		$this->load->view('test/test');		
	}
	
	public function first()
	{
		$this->load->view('test/first');	
	}
	
	public function second()
	{
		$this->load->view('test/second');	
	}
	
	public function test_permission_layout()
	{
		/*******************************************************
					Meta Data
		 *******************************************************/
		$data['page_title'] = "Home";
		
		
		/*******************************************************
					Loading Template
		 *******************************************************/
		
		$data['content'] = $this->load->view('permission_settings',$data,TRUE);
		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
}
