<!--scripts-->
	
<script src="<?php echo base_url();?>support/highcharts/js/highcharts.js"></script>
<script src="<?php echo base_url();?>support/highcharts/js/modules/exporting.js"></script>
<script src="<?php echo base_url();?>support/highcharts/js/modules/no-data-to-display.src.js"></script>		
<!--scripts-->

<div class="row-fluid">
	<div class="page-header">
		<div class="pull-left">
			<h1><?php echo "Sites Report";?></h1>
			<div class="help-block">
				<?php echo $this->lang->line('overview_helpblock');?>
			</div>
		</div>
		<?php  echo $this->template_widget->widget('pub_earnings');?>
	</div>
	<div class="breadcrumbs">
		<?php echo $breadcrumb; ?>
	</div>
</div>

<div class="page-header">
	<div class="row-fluid">
		<div class="span12">
			<div class="box">
				<div class="box-title">
					<div class="span12">
						<div class="top">
							<div class="highlight-toolbar">
								<div class="pull-left">
									<form id='frm_search' name="frm_search">
									<div class="btn-toolbar">
										<div class="btn-group"></div>
										<div class="btn-group">
											<select id='environment' name="environment" class='chosen-select' data-nosearch="true" data-placeholder="Sort by">
												<option value="all"><?php echo $this->lang->line('env_all');?></option>
												<option value="Display"></option><?php echo $this->lang->line('website');?></option>
												<option value="Mobile"><?php echo $this->lang->line('mobile');?></option>
											</select>
										</div>
										<div class="btn-group">
											<select name="site" id="site" class='chosen-select' data-nosearch="true" onchange="load_adblock(this.value);" data-placeholder="Sort by">
												<option value="all"><?php echo $this->lang->line('All Sitessst');?></option>
												<?php
												if(!empty($sites))
												{
													foreach($sites as $key=>$value)
													{
														if(!empty($site_id) && $value['site_id']==$site_id)
														{
														?>
														<option value="<?php echo $site_id; ?>" selected><?php echo $value['site_url']; ?></option>
														<?php
														}
														else
														{?>
														<option value="<?php echo $value['site_id']; ?>"><?php echo $value['site_url']; ?></option>
												<?php
													}
												}
												}												
												?>
											</select>
										</div>
										<!----- Adblock Filter ----->
										<div class="btn-group" id="ad_block">
											<select name="adblock" id="adblock" class='chosen-select' >
												<option value="all"><?php echo $this->lang->line('all_adb');?></option>
												<?php 
													if(!empty($adb)):
														foreach($adb as $ab):
												?>
													<option value="<?php echo $ab['zoneid']; ?>"><?php echo $ab['zonename']; ?></option>
												<?php endforeach; 
													else: ?>
														<option value=""><?php echo $this->lang->line('no_adbl');?></option>
												<?php endif; ?>
											</select>										
										</div>
										<div class="btn-group" style="margin-bottom:10px;">
											<a href="" name="reservation" id="reservation" class="btn"><span>
											<span id="default_start_date"><?php echo ($search_date != FALSE)?date('M d, Y',strtotime($search_date['from_date'])):''; ?></span> - 
											<span id="default_end_date"><?php echo ($search_date != FALSE)?date('M d, Y',strtotime($search_date['to_date'])):''; ?></span></span>&nbsp;&nbsp;<i class="icon-caret-down"></i></a>				</div>
											<div class="btn-group" style="margin-bottom:10px;">
												<a id='submit_search' class="btn" rel="tooltip" title="Apply filter"><i class="icon-search"></i></a>
											</div>
											
											<div class="btn-group" style="margin-bottom:10px;">
												<a id='refresh_search' class="btn" rel="tooltip" title="Refresh Results"><i class="icon-refresh"></i></a>
											</div>
												
										</div>
									<input type='hidden' value="<?php echo ($search_date != FALSE)?date('Y-m-d',strtotime($search_date['from_date'])):''; ?>"  id='date_from' name='date_from'/>
									<input type='hidden' value="<?php echo ($search_date != FALSE)?date('Y-m-d',strtotime($search_date['to_date'])):''; ?>" id='date_to' name="date_to" />
								</form>

								</div>
							</div>
						</div>
						<div class="bottom">
							<div id="site_chart" style="min-width: 250px; margin: 0 auto"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row-fluid" id="pub_site_report_table_view">
	<div class="span12">
		<div class="box box-color box-bordered lightgrey">
			<div class="box-title">
				<h3>
					<i class="icon-bookmark"></i><?php echo $this->lang->line('sites_report');?>
				</h3>
				<a  data-toggle="modal" role="button" href="#site-chart" class="btn btn-lightgrey pull-right"></a>&nbsp;
	
			</div>
			<div class="box-content nopadding">
				<table id='pub_site_report' class="table table-hover table-nomargin table-striped dataTable dataTable-custom dataTable-scroll-x dataTable-colvis dataTable-tools">
					<thead>
						<tr>
							<th><?php echo $this->lang->line('date');?></th>
							<th><?php echo $this->lang->line('site_name');?></th>
							<th><?php echo $this->lang->line('site_url');?></th>
							<th><?php echo $this->lang->line('impression');?></th>
							<th><?php echo $this->lang->line('clicks');?></th>
							<th><?php echo $this->lang->line('earnings');?></th>
							<th><?php echo $this->lang->line('ecpm');?></th>
						</tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<br/><br/>
<script>

function load_adblock(siteid)
{
	var adblock;
	$.ajax({ 
    url : site_url+"/publisher/reports/sites_adblock/"+siteid,  
    type: "POST",
    success : function(data){
		
		//alert(data);
		$('#ad_block').html(data);        		
    } 
 });	
	
}

	$('#submit_search').click(function (){
	
		var env = $('#environment').val();
		var site = $('#site').val();
		var adb 	= 	$('#adblock').val();
		var df = $('#date_from').val();
		var dt = $('#date_to').val();
		
		custom_opt.sAjaxSource = site_url+"/publisher/reports/fetch_site_stats/"+env+"/"+site+"/"+adb+"/"+df+"/"+dt;
			// Load Chart
		dataTableRedraw();
			
	});
	
	$('#refresh_search').click(function (){
	
		$('#environment').val('all').trigger('liszt:updated');
		$('#site').val('all').trigger('liszt:updated');
		$('#adblock').val('all').trigger('liszt:updated');
		$('#date_from').val(start_default_date);
		$('#date_to').val(end_default_date);
		$('#reservation span').text(default_start_date_txt+' - '+default_end_date_txt);
		custom_opt.sAjaxSource = site_url+"/publisher/reports/fetch_site_stats";
		// Load Chart
		dataTableRedraw();
		
	});

   function dataTableRedraw(){
	   exportdatabutton();
   		$('#pub_site_report.dataTable').dataTable(custom_opt);
		$('.dataTables_filter input').attr("placeholder", "Search here...");
		$(".dataTables_length select").wrap("<div class='input-mini'></div>").chosen({
			disable_search_threshold: 9999999
			});
		$("#check_all").click(function(e){
						$('input', oTable.fnGetNodes()).prop('checked',this.checked);
		});
		if($(this).hasClass("dataTable-fixedcolumn")){
			new FixedColumns( oTable );
		}
		if($(this).hasClass("dataTable-columnfilter")){
			oTable.columnFilter({
				"sPlaceHolder" : "head:after"
			});
		}
		resize_chosen();	
   }
   
   
		var env = $('#environment').val();
		var site = $('#site').val();
		var adb  = 	$('#adblock').val();
		var df = $('#date_from').val();
		var dt = $('#date_to').val();
		

	//options dataTable
var custom_opt = {
       	"bProcessing": true,
	    "bServerSide": true,
        "bAutoWidth": false,
		"bDestroy" : true,
        "oLanguage":{
						"sSearch": "<span>Search:</span> ",
						"sInfo": "Showing <span>_START_</span> to <span>_END_</span> of <span>_TOTAL_</span> entries",
						"sLengthMenu": "_MENU_ <span>entries per page</span>",
						"sEmptyTable": "Sorry, no Ad blocks has been found."
					},
        "sPaginationType": "full_numbers",
        "sAjaxSource": site_url+"/publisher/reports/fetch_site_stats/"+env+"/"+site+"/"+adb,
        "aoColumnDefs": [
			{
				"aTargets": [0],
				"mData": "DATE"
			},
			{
				"aTargets": [1],
				"mData": "SITE_NAME"
			},
			{
				"aTargets": [2],
				"mData": "SITE_URL"
			},
			{
				"aTargets": [3],
				"mData": "IMP"
			
			},
			{
				"aTargets": [4],
				"mData" : "CLK"
			},
			{
				"aTargets": [5],
				"mData" : "PUB_EARN",
				"mRender": function (data, type, full) {
					return currency+data;
				}
			},
			{
				"aTargets": [6],
				"mData" : "PUB_ECPM",
				"mRender": function (data, type, full) {
					return currency+data;
				}
			}
		],
		"fnServerData": function ( sSource, aoData, fnCallback, oSettings ) {
						oSettings.jqXHR = $.ajax( {
						"dataType": 'json',
						"type": "POST",
						"url": sSource,
						"data": aoData,
						"success": function(data, textStatus, jqXHR){
								
								console.log(data);
								
								load_chart(data.overview_chart_data);
								
								$('#pub_site_report').unbind('sort').bind('sort', function () {
									// DataTables has done a sort	
									//alert('Hurray! Table is sorted');
									$('html,body').animate({ scrollTop: $("#pub_site_report_table_view").offset().top },1000);
								});
								
								$('#pub_site_report').unbind('filter').bind('filter', function () {
									// DataTables has done a sort	
									//alert('Hurray! Table is sorted');
									$('html,body').animate({ scrollTop: $("#pub_site_report_table_view").offset().top },1000);
								});
								
								$('#pub_site_report').unbind('page').bind('page', function () {
									// DataTables has done a sort	
									//alert('Hurray! Table is sorted');
									$('html,body').animate({ scrollTop: $("#pub_site_report_table_view").offset().top },1000);
								});
								
								
								fnCallback(data);
								
						}	
				} );
					
		}
		
    };
 
$(document).ready(function() {
	
	start_default_date = jQuery('#date_from').val();
	end_default_date =  jQuery('#date_to').val();
	
	default_start_date_txt = jQuery('#default_start_date').text();
	default_end_date_txt = jQuery('#default_end_date').text();
	
	
  	$('#reservation').daterangepicker({
  	  ranges: {
  		 'Today': [moment(), moment()],
  		 'Yesterday': [moment().subtract('days', 1), moment().subtract('days', 1)],
  		 'Last 7 Days': [moment().subtract('days', 6), moment()],
  		 'Last 30 Days': [moment().subtract('days', 29), moment()],
  		 'This Week': [moment().startOf('week'), moment()],
  		 'This Month': [moment().startOf('month'), moment().endOf('month')],
  		 'Last Month': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')]
  	  },
      startDate: moment().subtract('days', 29),
      endDate: moment()
  	},
  	function(start, end) {
		$('#date_from').val(start.format('YYYY-MM-DD'));
		$('#date_to').val(end.format('YYYY-MM-DD'));
		$('#reservation span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  	});
  });
  

	var chart;
	function load_chart(c_data){
			
			$(function(){
			if(c_data)
				{
					var c_category = c_data.chart_x_axis;
					var c_series = c_data.chart_data;	
					
				}else{
					var c_category = [];
					var c_series = [];
				}
			var options = {
			chart: {
					renderTo: 'site_chart',
					type: 'column'
				},
            title: {
                text: ''
            },
            xAxis: {
                categories:c_category
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'Values'
                },
                stackLabels: {
                    enabled: false,
                    style: {
                        fontWeight: 'bold',
                        color: (Highcharts.theme && Highcharts.theme.textColor) || 'gray'
                    }
                }
            },
            legend: {
                align: 'right',
                x: -70,
                verticalAlign: 'top',
                y: -10,
                floating: true,
                backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColorSolid) || 'white',
                borderColor: '#CCC',
                borderWidth: 1,
                shadow: true
            },
            tooltip: {
                formatter: function() {
					if(this.series.name=='SPEND')
					{
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +': '+currency+ this.y;
					} else if(this.series.name=='CTR') {
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +':'+ this.y+'%';
					}else {
						return '<b>'+ this.x +'</b><br/>'+
							this.series.name +':'+ this.y;
					}
                }
            },
            plotOptions: {
                column: {
                    stacking: 'normal',
                    dataLabels: {
                        enabled: true,
                        color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
                    }
                }
            },
				series: c_series
			};
			
			chart = new Highcharts.Chart(options);
			// SHOW / EMPTY CHART DATA
				if(c_data)
				{
					chart.showLoading();
					chart.hideLoading();
					
				}else{
						
					chart.hideNoData();
					chart.showNoData('No data found. Refine your search filters.');
					chart.hideLoading();
				}
							// FILL / EMPTY TOTAL 
			
				if(!c_data)
				{
					$('#total_imp').html('0');
					$('#total_clk').html('0');
					$('#total_uimp').html('0');
					$('#total_uclk').html('0');
					$('#total_con').html('0');
					$('#total_spend').html('$0');
				}else
				{
					var total = c_data.total;
					for (key in total) {
					var rec = total[key];
					
							if(rec.key == 'ECPM'){
							
								$('#total_'+rec.key.toString().toLowerCase()).html(currency+rec.value)
							}
							else if(rec.key == 'SPEND'){
							
								$('#total_'+rec.key.toString().toLowerCase()).html(currency+rec.value)
							}
							else if(rec.key == 'CTR'){
							
								$('#total_'+rec.key.toString().toLowerCase()).html(rec.value+'%')
							}
							else
							{
						
								$('#total_'+rec.key.toString().toLowerCase()).html(''+rec.value)
							}
					}
				}
		
			});	
	}
	
	
</script>
