<?php 
class Web_ad_blocks extends CI_Controller {
	
	public $source_sel = '';
	
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->web_ad_blocks();		
	}
	
	/*
	 * 
	 * name		:Web ad_blocks
	 * @param   :Null
	 * @return  :List all the Web adblocks for a particular
	 * 			 Publisher
	 */	
	
	public function web_ad_blocks()
	{		
		$data['page_title'] = "Web AdBlocks";	
		$data['breadcrumb'] = '';	
		$api_key = get_session('api_key');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		$data['content'] = $this->load->view('adblocks/web_ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:add_web_adblocks
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_web_adblock()
	{
		
		$api_key=get_session('api_key');
	    $data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array('api_key'=>$api_key),'php');
	    $data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array('api_key'=>$api_key),'php');
       	$data['content']= $this->load->view('adblocks/add_web_adblock',$data,TRUE);
        $this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Edit the adblock
	 * 
	 * name		:edit_web_adblock
	 * @param   :Zone id
	 * @return  :Fetches the ad block content and view it
	 * 
	 * 			 
	 */
	
	public function edit_web_adblock($zone_id = FALSE)
	{
		#$account_id=get_session('account_id');
		$api_key=get_session('api_key');
		$data['min_floor_price'] = $this->default_configurations->get('pub_min_floor_price');
		$data['sites']=$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		$data['zone_sizes']=$this->rest->get('api/v1/web_adblock/zonesizelist',array("api_key"=>$api_key),'php');
		$web_adblock = $this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
		
		//$web_adblock = json_decode($web_adblock);
		
		
		
		//$data['web_adblock'] = (array)$web_adblock[0];
		
		$data['web_adblock'] = $web_adblock[0];
		
		//$this->rest->debug();
		
		
		
		echo $this->load->view('adblocks/modal_adblocks/content/edit_web_adblock',$data);
	}
	
	/*
	 * Lists the Web ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks()
	{
		$api_key = get_session('api_key');
		
		$adblocks		= $this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key),'json');
		
		echo convert_to_datatable_format($adblocks);
	}
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_tag($zone_id = FALSE,$modal_val=false)  
		{		
			if($zone_id=='')
			{
			$zone_id=$this->session->userdata('pub_edit_ad_tg');
			}
				
			
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			$api_key	=	get_session('api_key');
			$data['zone_det'] = $this->rest->get('api/v1/site/fetch_adblocks',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');
			//~ echo $this->rest->debug();exit;
			
			$zone_values    =   $this->rest->get('api/v1/site/fetch_ad_block',array('zone_id'=>$zone_id,"api_key"=>$api_key),'php');
			
			$zone_value=$zone_values[0];
								
			$aff_id=$data['zone_det'][0]['affiliateid'];
			
			$data['exit_popunder_list']=$this->rest->get('api/v1/site/fetch_zone_list',array("api_key"=>get_session('api_key'),"aff_id"=>$aff_id,"width"=>$zone_value['width'],"height"=>$zone_value['height']));  
			
			$data['config_list']		=   $this->rest->get('api/v1/site/fetch_appconfig',array("api_key"=>get_session('api_key')),'php');

			$popunder_enable		=   $this->rest->get('api/v1/network/fetch_app_configuration',array("api_key"=>get_session('api_key')),'php');
			$data['popunder']		=   $popunder_enable[0];				
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
			
			$this->load->library('default_configurations');
			
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
												
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}		
		//	echo 'welcome';	
		if($modal_val=='')
		{
			$data['content']= $this->load->view('adblocks/generate_ad_tag',$data,TRUE);
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);		
		}
		else
		{
			
			echo $this->load->view('adblocks/generate_ad_tag',$data,TRUE);
		
		}	
		}else{
			return FALSE;	
		}	
	}
	
	
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_img_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_img_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			echo $this->load->view('adblocks/modal_adblocks/content/generate_img_adtag',$data);
		}else{
			return FALSE;	
		}	
	}
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */		
	 public function edit_preview_adblock()
	{
		$this->session->unset_userdata('pub_edit_pre_adb');
		$this->session->set_userdata('pub_edit_pre_adb', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_edit_pre_adb'));
	} 
	public function preview_adblock($zone_id=FALSE)
	{  $zone_id=$this->session->userdata('pub_edit_pre_adb');
		$data['zone_id']		=	$zone_id;

		$creative_list	=	$this->rest->get('api/v1/approval/preview_adblock',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 
		
		$array_val=array_rand($creative_list);   
						
		$creative_list_val[0]=$creative_list[$array_val];
		
		$data['creative_list']=$creative_list_val;
		
		if(!empty($creative_list[$array_val]['ad_id']))
		{
			$data['creative_additional_list']= $this->rest->get('api/v1/approval/preview_additional_adblock',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_list[$array_val]['ad_id']),'php'); 
		}						
		echo $this->load->view('adblocks/preview_adblock',$data);
	} 
	public function edit_ad_tag()
	{
		$this->session->unset_userdata('pub_edit_ad_tg');
		$this->session->set_userdata('pub_edit_ad_tg', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_edit_ad_tg'));
	}
	public function generate_video_ad_tag($zone_id = FALSE)
	{
		$zone_id=$this->session->userdata('pub_edit_ad_tg');
		if($zone_id)
		{
			$data['zone_id'] 	= 	$zone_id;
			$data['zone_types'] = $zone_types;
			$api_key			=	get_session('api_key');
			
			$data['zone_det'] 	= 	$this->rest->get('api/v1/site/fetch_adblocks',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');
			/***************** Fecth Tag parameters ***********************/
			$tag				= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']		=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
						
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			$data['content']= $this->load->view('adblocks/generate_video_adtag',$data,TRUE);
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);	
			
		}else{
			return FALSE;	
		}	
	}
	
	
	public function ad_blocks($site_id=FALSE)
	{	
		$data['page_title'] = 	"Ad codes";	
		$data['breadcrumb'] = 	'';	
		$api_key 			= 	get_session('api_key');
		$data['site_id']	= 	$site_id;
		
		// GET DEFAULT PERIOD FROM CONFIG FILE		
		$data['content'] 	= 	$this->load->view('sites/ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}

/*
	 * 
	 * name		:add_adblock
	 * @param   :Null
	 * @return  :Adds the adblock
	 * 			 
	 */	
	
	public function add_ad_block($admarket=FALSE)
	{
		
		
			if($admarket!= false)
			{
				$data['admarket'] = '1';
			}
			if($site_id!=FALSE)
			{
				$data['site_id']		=	$site_id;
				$data['from_site']="1";
				$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key'),"site_id"=>$site_id),'php');
			}
			else
			{
				$data['site_id']		=	'';
				$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');			
			}
									
			if($app_id!=FALSE)
			{
				$data['app_id']		=	$app_id;
			}	
			else
			{
				$data['app_id']		=	'';
				$data['app_list']	=   $this->rest->get('api/v1/apps/fetch_applist',array("api_key"=>get_session('api_key')),'php');
			}
										
			$data['page_title'] 	= 	"Add Ad Block";					
			$api_key				=	get_session('api_key');
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');
			$data['keywords']		= $this->rest->get('api/v1/targeting/fetch_inline_keyword',array('api_key'=>get_session('api_key')),'php');
		
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			$data['creative_size']  =   $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$popunder_enable		=   $this->rest->get('api/v1/network/fetch_app_configuration',array("api_key"=>get_session('api_key')),'php');
			$data['popunder']		=   $popunder_enable[0];
			$data['config_list']	=   $this->rest->get('api/v1/site/fetch_appconfig',array("api_key"=>get_session('api_key')),'php');
			$data['content']		= 	$this->load->view('sites/add_ad_block',$data,TRUE);			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);  																											
	}
			
	public function edit_ad_block($zone_id=FALSE)
	{
		if($zone_id!=FALSE)
		{	
			$data['page_title'] 	= 	"Edit Ad Block";		
			
			$data['adblock_id']		=	$zone_id;
				
			$api_key				=	get_session('api_key');
			
						
			$site			=   $this->rest->get('api/v1/site/fetch_siteid',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['siteid'] =   $site[0]['site_id'];
			
			$app			=   $this->rest->get('api/v1/site/fetch_appid',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['appid']  =   $app[0]['id'];   
			
			
			//echo $this->rest->debug();  die();	
			$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');
			$data['app_list']		=   $this->rest->get('api/v1/site/fetch_applist',array("api_key"=>get_session('api_key')),'php');
			$data['config_list']	=   $this->rest->get('api/v1/site/fetch_appconfig',array("api_key"=>get_session('api_key')),'php');
			
			$zone_values    =   $this->rest->get('api/v1/site/fetch_ad_block',array('zone_id'=>$zone_id,"api_key"=>$api_key),'php');
			
			$zone_value=$zone_values[0];
			
			$aff_id=$data['site_list'][0]['affiliateid']; 
			
			$data['exit_popunder_list']=$this->rest->get('api/v1/site/fetch_zone_list',array("api_key"=>get_session('api_key'),"aff_id"=>$aff_id,"width"=>$zone_value['width'],"height"=>$zone_value['height'])); 
			//echo $this->rest->debug();  die();	
				
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$adb					= 	$this->rest->get('api/v1/site/fetch_adblocks',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			$popunder_enable		=   $this->rest->get('api/v1/network/fetch_app_configuration',array("api_key"=>get_session('api_key')),'php');
			$data['popunder']		=   $popunder_enable[0];		
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
						
			$data['adb']			=	$adb[0];
			$data['site_id']		=	$data['adb']['site_id'];
			
			$data['content']		= 	$this->load->view('sites/edit_ad_block',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);
		}		
	}

	public function download_php_file($filename=FALSE)
	{		
		$name= 'directads.php';
		$file ='/downloaded_php/'.$name;
		$file = realpath($_SERVER['DOCUMENT_ROOT'] ).'/downloaded_php/'.$name;  
		chmod($file, 0777);
		$fh = fopen($file, 'w') or die("can't open file");
		$current = file_get_contents($file);
		$current .= '<?php
		$random1=rand();	
		$random = substr($random1,0,9);
		?>
		<script>
		function jsvalue() {
			var loc=escape(window.location);
			var referrer=escape(document.referrer);
			url = "http://itbuck.com/a4c32938.php?cb="+<?php echo $random;?>+"&loc="+loc+"&ref="+referrer;
			var script = document.createElement("script");
			script.src = url ;
			document.getElementsByTagName("head")[0].appendChild(script);
		}
		jsvalue();
		</script>		
		<?php 
		class Directad {
		protected $tag_id;
		protected $random;
		public function __construct($tag_id,$random) {
			$this->id = $tag_id;
			$this->random = $random;
		}
		function fetch($url) {
			if (!function_exists("curl_version"))
				return;
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$url);
			 $headers = array(	"Accept: application/json",
						"Content-type: application/json",
						"X-ApiKey : XXXXXXXXXX",
						"Accept-Language: en",
						"X-Forwarded-For:".$_SERVER["HTTP_X_FORWARDED_FOR"]
					);
			 curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);			 
			 curl_setopt($ch, CURLOPT_HEADER, false);
			 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			 curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE); 
			 curl_setopt( $ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]); 
			$result = curl_exec($ch);
			
			return $result;
		}		
		public function get_code() {
			$temp = dirname(__FILE__) . "/directad-".$this->id.".js";	
			if ( file_exists($temp) && (time() - filemtime($temp) < 86400) ) {
				$code = file_get_contents($temp);
				return $code;
			} else {


				$userAgent = $_SERVER["HTTP_USER_AGENT"];
				$devicesTypes = array(
				"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*Safari","windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera","safari"),
				"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
				"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini", "BlackBerry","LG","HTC"),        
				"bot"      => array("googlebot", "mediapartners-google", "adsbot-google", "duckduckbot", "msnbot", "bingbot", "ask", "facebook", "yahoo", "addthis")				
				);
				foreach($devicesTypes as $deviceType => $devices) {           
					foreach($devices as $device) {
						if(preg_match("/" . $device . "/i", $userAgent)) {
							$deviceName = $deviceType;
						}
					}
				}
				$device_type= $deviceName;  
				$val="zoneid=".$this->id."&devicetype=".$device_type."&cb=".$this->random."&enc_key=";
				$enc_key="d07484bhd3";
				$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
				$u = "http://itbuck.com/'.$filename.'.php?".$value;		
				$code = $this->fetch($u);?><script><?php print($code);?></script><?php
				file_put_contents($temp, $code);
				chmod($temp, 0755);
				clearstatcache(true, $temp);
				}	
			}
		}
		if (isset($tag_id)) {
			$directad = new Directad($tag_id,$random);
			echo $directad->get_code();
		}
		?>';
		file_put_contents($file, $current);
		fclose($file);
		header('Content-Description: File Transfer');
		header('Content-Type: application/force-download');
		header("Content-Disposition: attachment; filename=\"" . basename($file) . "\";");
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($file));
		ob_clean();
		flush();
		readfile($file); 
		exit;		  			
	}
	
	
}
