<?php 

class Users extends CI_Controller

{

    function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		//$this->load->model('api_v.1/do_creative','asd');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}

	function index()
	{
		$this->users();
	}


	/*

	* 

	* name: users

	* @param : null

	* @return :manage all users.

	*/

	public function users()
	{
		$data['page_title'] = 	"Sub Accounts";

		$data['breadcrumb'] = 	'';
		
		$data['content'] 	= 	$this->load->view('sub_account/users',$data,TRUE);

		$this->template->set_layout('publisher_layout');

		$this->template->build('view', $data);
	}
	

	/*

	* 

	* name	   :	fetch_user

	* @param   :	Null

	* @return  :	List all the users for publisher

	*/	

	public function fetch_user()
	{
		$user	=	$this->rest->get('api/v1/subaccount/fetch',array('api_key'=>get_session('api_key')),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($user);
	}	

	/*

	* 

	* name	   : add_user

	* @param   : Null

	* @return  : Fetch modal box for edit user

	*/	
 	

	public function add_user()
	{
		$data['roles']	=	$this->rest->get('api/v1/subaccount/fetch_roles',array('api_key'=>get_session('api_key')),'php');
		$security_question      =   $this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
		$data['security_question']=$security_question;
		echo $this->load->view('sub_account/modal_users/content/add_user',$data);
	}
	

	/*
	*
	* name	   : edit_user
	* @param   : Null
	* @return  : Fetch individual user details
	*/

	public function edit_user($user_id=FALSE,$account_id=FALSE)
	{
		if($user_id && $account_id)
		{
			$data['roles']	=	$this->rest->get('api/v1/subaccount/fetch_roles',array('api_key'=>get_session('api_key')),'php');
		
			$data['user']	=	$this->rest->get('api/v1/subaccount/fetch_user_details',array('api_key'=>get_session('api_key'),'user_id'=>$user_id,'account_id'=>$account_id),'php');	
			
			echo $this->load->view('sub_account/modal_users/content/edit_user',$data);
		}
	}

}
