<?php 
class Sites extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->sites();	 
	}
	
	/*
	 * 
	 * name		:sites
	 * @param   :Null
	 * @return  :List all the sites for a particular
	 * 			 Publisher
	 */	
	 	
	public function sites()
	{	
		$data['page_title'] 	= "Sites";		
		$data['daily_data']	    =   $this->rest->get('api/v1/site/fetch_daily_statistics',array("api_key"=>get_session('api_key')),'php');	
		$data['total_balance']	=  $this->rest->get('api/v1/site/total_balance',array("api_key"=>get_session('api_key')),'php');
		//echo $this->rest->debug(); die("dd");
		$data['sites'] = $this->rest->get('api/v1/site/fetch',array("api_key"=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('sites/sites',$data,TRUE);	
		$this->template->set_layout('publisher_layout'); 
		$this->template->build('view', $data); 
		
	}
	
	public function add_site()
	{
		
		$api_key = get_session('api_key');
		
		$category =$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
		
		$data['content']		= 	$this->load->view('sites/add_site',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);		
	}
	public function edit_sites()
	{
		$this->session->unset_userdata('edit_id');
		$this->session->set_userdata('edit_id', $_POST['site_id']);
		echo json_encode($this->session->userdata('edit_id'));  
	}
	
	public function edit_site()
	{
		$site_id=$this->session->userdata('edit_id');
					
		$api_key = get_session('api_key');
				
		$site_info = $this->rest->get('api/v1/site/fetch_site',array('site_id'=>$site_id, "api_key"=>$api_key),'php');
		
		$sel_category_id = $this->rest->get('api/v1/site/fetch_site_cat',array('site_id'=>$site_id, "api_key"=>$api_key), 'json');
		
		$category=$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
		
		if(!empty($sel_category_id))
		{  
		  $data['sel_category'] = json_decode($sel_category_id);
			
		}else{
			$data['sel_category'] = '';
		}
		
		$data['site_info'] = $site_info[0];
		$data['site_id']=$site_id;
	
		$data['content']		= 	$this->load->view('sites/edit_site',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);	
		//print_r($data);exit;
		 //~ $response = $this->load->view('sites/edit_site',$data,TRUE);
		 //~ echo json_encode($response);
		 
	}
	
	
	/*
	 * 
	 * name		:add_website
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_website()
	{
		$api_key = get_session('api_key');
		
		$category =$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
	
		echo $this->load->view('sites/modal_sites/content/add_website',$data);
	}
	
	public function edit_website($site_id = FALSE)
	{
		$api_key = get_session('api_key');
				
		$site_info = $this->rest->get('api/v1/site/fetch_site',array('site_id'=>$site_id, "api_key"=>$api_key),'php');
		
		$sel_category_id = $this->rest->get('api/v1/site/fetch_site_cat',array('site_id'=>$site_id, "api_key"=>$api_key), 'json');
		
		$category=$this->rest->get('api/v1/utilities/categorylist',array("api_key"=>$api_key),'php');
		
		if(is_array($category))
		{
			$data['category'] = $category;	
		}else{
			$data['category'] = '';	
		}
		
		if(!empty($sel_category_id))
		{  
		  $data['sel_category'] = json_decode($sel_category_id);
			
		}else{
			$data['sel_category'] = '';
		}
		
		$data['site_info'] = $site_info[0];
		
		echo $this->load->view('sites/modal_sites/content/edit_website',$data);
	}
	
	
	public function fetch_sites()
	{
		#$account_id = get_session('account_id');
		
		$api_key = get_session('api_key'); 
		
		$siteid=$this->input->post('siteid');
		
		if(!empty($siteid))
		{ 
			//changed logic to filer for single siteid also
			$input= ($siteid)?((!empty($siteid))?$siteid:explode(',',$siteid)):'';			
			
			$sites		= $this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key,"site_id"=>$input),'json');
		}
		else
		{ 
			$sites		= $this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'json');
		}
		//$this->rest->debug();  die();
		echo convert_to_datatable_format($sites);
		
	}
	public function edit_adb_list_ids()
	{
		$this->session->unset_userdata('adb_list_edit_id');
		$this->session->set_userdata('adb_list_edit_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adb_list_edit_id'));
	
	}
	/*
	 * 
	 * name		:ad_blocks
	 * @param   :Null
	 * @return  :List all the Web adblocks for a particular
	 * 			 Publisher
	 */	
	
	public function ad_blocks($site_id=FALSE)
	{	
		$data['page_title'] = 	"Ad codes";	
		$data['breadcrumb'] = 	'';	
		$api_key 			= 	get_session('api_key');
		//$data['site_id']	= 	$site_id;
		$data['site_id']	= 	$this->session->userdata('adb_list_edit_id');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE		
		$data['content'] 	= 	$this->load->view('sites/ad_blocks',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * Lists the ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks($site_id=FALSE)
	{
		if($site_id!=FALSE)
		{
			$pval	=	array(
								"api_key"	=>	get_session('api_key'),
								"site_id"	=>	$site_id
							);
		}
		else
		{
			$pval	=	array(
								"api_key"	=>	get_session('api_key')
							);
		}
		
		$adblocks	= 	$this->rest->get('api/v1/site/fetch_adblocks',$pval,'json');
		//echo $this->rest->debug(); die("test");
		
		echo convert_to_datatable_format($adblocks);
	}
	
	public function fetch_adb_sites()
	{
		
		$ad_type=$this->input->get('ad_type');
		$zone_type=$this->input->get('zone_type');
		
		if(!empty($ad_type) || !empty($zone_type))
		{
			$api_key=get_session('api_key');
			$input = array('api_key'	=>	$api_key);			
			$input['ad_type']= ($ad_type)?((is_array($ad_type))?$ad_type:explode(',',$ad_type)):'';
			$input['zone_type']= ($zone_type)?((is_array($zone_type))?$zone_type:explode(',',$zone_type)):'';
			$adblocks		= $this->rest->get('api/v1/site/fetch_adblocks_filter',$input,'json'); 
		}
		else
		{
			$adblocks	= 	$this->rest->get('api/v1/site/fetch_adblocks',array("api_key"=>get_session('api_key')),'json');
			 
		}
		echo convert_to_datatable_format($adblocks);
	}
	public function edit_without_ad_block_id()
	{
		$this->session->unset_userdata('adblock_edit_ur_id');
		$this->session->set_userdata('adblock_edit_ur_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('adblock_edit_ur_id'));
	
	}
	
	/*
	 * 
	 * name		:add_adblock
	 * @param   :Null
	 * @return  :Adds the adblock
	 * 			 
	 */	
	
	public function add_ad_block($site_id=FALSE)
	{
		$site_id = $this->session->userdata('adblock_edit_ur_id');
			if($site_id!=FALSE)
			{
				$data['site_id']		=	$site_id;
				$data['from_site']="1";
				$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key'),"site_id"=>$site_id),'php');
			}
			else
			{
				$data['site_id']		=	'';
				$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');
				
			}
			
			if($app_id!=FALSE)
			{
				$data['app_id']		=	$app_id;
			}	
			else
			{
				$data['app_id']		=	'';
				$data['app_list']	=   $this->rest->get('api/v1/apps/fetch_applist',array("api_key"=>get_session('api_key')),'php');
			}
			

			$aff_id=$data['site_list'][0]['affiliateid']; 
								
			$data['exit_popunder_list']=$this->rest->get('api/v1/site/fetch_zone_list',array("api_key"=>get_session('api_key'),"aff_id"=>$aff_id));
			
			//$app_config=$this->rest->get('api/v1/site/fetch_appconfig',array("api_key"=>get_session('api_key'),'php');		
			$data['config_list']		=   $this->rest->get('api/v1/site/fetch_appconfig',array("api_key"=>get_session('api_key')),'php');
			//die("dfdfd");
			//print_r($data['config_list']);die("dss");				
			$data['page_title'] 	= 	"Add Ad Block";					
					
			$api_key				=	get_session('api_key');
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$data['native_creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'php');
			$data['content']		= 	$this->load->view('sites/add_ad_block',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);  																																																				
				
	}
	
	public function add_ad_blocks($site_id=FALSE)
	{
			if($site_id!=FALSE)
			{
				$data['site_id']		=	$site_id;
				$data['from_site']="1";
				$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key'),"site_id"=>$site_id),'php');
			}
			else
			{
				$data['site_id']		=	'';
				$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');
				
			}
			
			if($app_id!=FALSE)
			{
				$data['app_id']		=	$app_id;
			}	
			else
			{
				$data['app_id']		=	'';
				$data['app_list']	=   $this->rest->get('api/v1/apps/fetch_applist',array("api_key"=>get_session('api_key')),'php');
			}
			

			
							
			$data['page_title'] 	= 	"Add Ad Block";					
					
			$api_key				=	get_session('api_key');
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['market_adblock']="1";
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			$data['creative_size'] = $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$data['content']		= 	$this->load->view('sites/add_ad_block',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);  																																																				
				
	}
	
	public function edit_ad_block_url_id()
	{
		$this->session->unset_userdata('edit_ad_block_id');
		$this->session->set_userdata('edit_ad_block_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('edit_ad_block_id'));
	}
	
	
	/*
	 * 
	 * name		:add_adblock
	 * @param   :Null
	 * @return  :Adds the adblock
	 * 			 
	 */	
	
	public function edit_ad_block()
	{
		$zone_id=$this->session->userdata('edit_ad_block_id');
		if($zone_id!=FALSE)
		{	
			$data['page_title'] 	= 	"Edit Ad Block";		
			
			$data['adblock_id']		=	$zone_id;
				
			$api_key				=	get_session('api_key');
			
						
			$site			=   $this->rest->get('api/v1/site/fetch_siteid',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['siteid'] =   $site[0]['site_id'];
			
			$app			=   $this->rest->get('api/v1/site/fetch_appid',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['appid']  =   $app[0]['id'];   
								
			//echo $this->rest->debug();  die();	
			$data['site_list']		=   $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');
			$data['app_list']		=   $this->rest->get('api/v1/site/fetch_applist',array("api_key"=>get_session('api_key')),'php');
			$data['config_list']		=   $this->rest->get('api/v1/site/fetch_appconfig',array("api_key"=>get_session('api_key')),'php');
			$zone_values    =   $this->rest->get('api/v1/site/fetch_ad_block',array('zone_id'=>$zone_id,"api_key"=>$api_key),'php');
			
			$zone_value=$zone_values[0];
			
			$aff_id=$data['site_list'][0]['affiliateid']; 
			
			$data['exit_popunder_list']=$this->rest->get('api/v1/site/fetch_zone_list',array("api_key"=>get_session('api_key'),"aff_id"=>$aff_id,"width"=>$zone_value['width'],"height"=>$zone_value['height']));  
			//echo $this->rest->debug();  die();	  
			
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php'); //Dynamic domain change
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$adb					= 	$this->rest->get('api/v1/site/fetch_adblocks',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
						
			$data['adb']			=	$adb[0];
			//print_r($data['adb']);exit;
			$data['site_id']		=	$data['adb']['site_id'];
			
			$data['content']		= 	$this->load->view('sites/edit_ad_block',$data,TRUE);
			
			$this->template->set_layout('publisher_layout');
			$this->template->build('view', $data);
		}		
	}
	
	public function download($filename=FALSE)
	{
		
		$file = realpath($_SERVER['DOCUMENT_ROOT'] ).'/csv/download/'.$filename.'.html';
		chmod($file, 0777);
		$fh = fopen($file, 'w') or die("can't open file");
		$current = file_get_contents($file);
		$current .= '<meta name="adgate" content="'.$filename.'">';
		file_put_contents($file, $current);
		fclose($file);
				
		$fd = fopen($file, 'r') or die("can't open file");  		
		if ($fd) { 
			$file_name=$filename.".html"; 
			header('Content-Description: File Transfer');
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename='.$file_name);
			header('Content-Transfer-Encoding: binary');
			header('Expires: 0');
			header('Cache-Control: must-revalidate');
			header('Pragma: public');
			readfile($file);
			}	
		fclose ($fd);			
		exit;		
		
	}
	
	public function download_php_file($filename=FALSE)
	{		
		$name= 'directads.php';
		$file = realpath($_SERVER['DOCUMENT_ROOT'] ).'/downloaded_php/'.$name;
		chmod($file, 0777);
		$fh = fopen($file, 'w') or die("can't open file");
		$current = file_get_contents($file);
		$current .= '<?php
		$random1=rand();	
		$random = substr($random1,0,9);
		?>
		<script>
		function jsvalue() {
			var loc=escape(window.location);
			var referrer=escape(document.referrer);
			url = "http://itbuck.com/a4c32938.php?cb="+<?php echo $random;?>+"&loc="+loc+"&ref="+referrer;
			var script = document.createElement("script");
			script.src = url ;
			document.getElementsByTagName("head")[0].appendChild(script);
		}
		jsvalue();
		</script>		
		<?php 
		class Directad {
		protected $tag_id;
		protected $random;
		public function __construct($tag_id,$random) {
			$this->id = $tag_id;
			$this->random = $random;
		}
		function fetch($url) {
			if (!function_exists("curl_version"))
				return;
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$url);
			 $headers = array(	"Accept: application/json",
						"Content-type: application/json",
						"X-ApiKey : XXXXXXXXXX",
						"Accept-Language: en",
						"X-Forwarded-For:".$_SERVER["HTTP_X_FORWARDED_FOR"]
					);
			 curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);			 
			 curl_setopt($ch, CURLOPT_HEADER, false);
			 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			 curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE); 
			 curl_setopt( $ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]); 
			$result = curl_exec($ch);
			
			return $result;
		}		
		public function get_code() {
			$temp = dirname(__FILE__) . "/directad-".$this->id.".js";	
			if ( file_exists($temp) && (time() - filemtime($temp) < 86400) ) {
				$code = file_get_contents($temp);
				return $code;
			} else {


				$userAgent = $_SERVER["HTTP_USER_AGENT"];
				$devicesTypes = array(
				"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*Safari","windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera","safari"),
				"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
				"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini", "BlackBerry","LG","HTC"),        
				"bot"      => array("googlebot", "mediapartners-google", "adsbot-google", "duckduckbot", "msnbot", "bingbot", "ask", "facebook", "yahoo", "addthis")				
				);
				foreach($devicesTypes as $deviceType => $devices) {           
					foreach($devices as $device) {
						if(preg_match("/" . $device . "/i", $userAgent)) {
							$deviceName = $deviceType;
						}
					}
				}
				$device_type= $deviceName;  
				$val="zoneid=".$this->id."&devicetype=".$device_type."&cb=".$this->random."&enc_key=";
				$enc_key="d07484bhd3";
				$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
				$u = "http://itbuck.com/'.$filename.'.php?".$value;		
				$code = $this->fetch($u);?><script><?php print($code);?></script><?php
				file_put_contents($temp, $code);
				chmod($temp, 0755);
				clearstatcache(true, $temp);
			}	
		}
	}
	if (isset($tag_id)) {
	$directad = new Directad($tag_id,$random);
	echo $directad->get_code();
	}
	?>';
	file_put_contents($file, $current);
	fclose($file);		
    header('Content-Description: File Transfer');
    header('Content-Type: application/force-download');
    header("Content-Disposition: attachment; filename=\"" . basename($file) . "\";");
    header('Content-Transfer-Encoding: binary');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($file));
    ob_clean();
    flush();
    readfile($file); 
    exit;			
	}	
}
