<?php 
class Settings extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('user_authentication');
		$user_auth  = $this->user_authentication;
		
		
	}
	
	function index()
	{ 
		$this->personal_information();		
	}
	
	/*
	 * 
	 * name		:personal_information
	 * @param   :Null
	 * @return  :List personal_information for a particular
	 * 			 Publisher
	 */	
	
	public function personal_information()
	{	
		$data['page_title'] = "Personal Information";	
		$data['breadcrumb'] = '';   
		$api_key = get_session('api_key');
		$personal_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['personal_info']=$personal_info[0];
		$country_val=$personal_info[0]['dj_country'];
		$country_value=$this->rest->get('api/v1/utilities/country_val',array("api_key"=>$api_key,"value"=>$country_val),'php');	
		
		$company_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['company_info']=$company_info[0];
		
		$account_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['account_info']=$account_info[0];	
		$seurity_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['seurity_info']=$seurity_info[0];
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array("api_key"=>$api_key),'php');		
						
		$data['country_value']=$country_value[0]['value'];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$api_key),'php');			
		$data['content'] = $this->load->view('settings/personal_information',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:company_information
	 * @param   :Null
	 * @return  :List company_information for a particular
	 * 			 Publisher
	 */	
	
	public function company_information()
	{	
		$data['page_title'] = "Company Information";
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');	
		$company_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['company_info']=$company_info[0];
		$data['country']=$this->rest->get('api/v1/utilities/countrylist',array("api_key"=>$api_key),'php');			
		$data['content'] = $this->load->view('settings/company_information',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	/*
	 * 
	 * name		:billing_information
	 * @param   :Null
	 * @return  :List billing_information for a particular
	 * 			 Publisher
	 */	
	
	public function billing_information()
	{		
		$data['page_title'] = "Billing Information";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/billing_information',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
		
	/*
	 * 
	 * name		:payment_settings
	 * @param   :Null
	 * @return  :List payment_settings for a particular
	 * 			 Publisher
	 */	
	
	public function payment_settings()
	{	
	    
		$data['page_title'] = "Payment settings";	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');	
		$payment_info=$this->rest->get('api/v1/network/fetch_payment_info',array("api_key"=>$api_key),'php');
		$user_info=$this->rest->get('api/v1/user/profile_info',array("api_key"=>$api_key),'php');
		$paypal_info=$this->rest->get('api/v1/network/fetch_paypal_info',array("api_key"=>$api_key),'php');	
		
		//print_r($bitcoin_info);die("ll");
		
		$webmoney_info=$this->rest->get('api/v1/network/fetch_webmoney_info',array("api_key"=>$api_key),'php');
		$bitcoin_info=$this->rest->get('api/v1/network/fetch_bitcoin_info',array("api_key"=>$api_key),'php');	
		$perfectmoney_info=$this->rest->get('api/v1/network/fetch_perfectmoney_info',array("api_key"=>$api_key),'php');
		$epayments_info=$this->rest->get('api/v1/network/fetch_epayments_info',array("api_key"=>$api_key),'php');
		$paybit_info=$this->rest->get('api/v1/network/fetch_paybit_info',array("api_key"=>$api_key),'php');
		$invoice_info 		=	$this->rest->get('api/v1/network/fetch_invoice_info',array("api_key"=>$api_key),'php');	
		
		//print_r($epayments_info);
		//die('dai');
		
		$data['invoice']	=	$invoice_info[0];
		$data['payment_details']=$payment_info[0];
		$data['paypal']=	$paypal_info[0];
		

		$data['webmoney_details']=$webmoney_info[0];
		$data['epayments_details']=$epayments_info[0];
		$data['paybit_details']=$paybit_info[0];
		$data['perfectmoney_details']=$perfectmoney_info[0];
		$data['bitcoin_details']=$bitcoin_info[0];
		
		
		$data['content'] = $this->load->view('settings/payment_settings',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	
	/*
	 * 
	 * name		:email_preferences
	 * @param   :Null
	 * @return  :List email_preferences for a particular
	 * 			 Publisher
	 */	
	
	public function email_preferences()
	{		
		$data['page_title'] = "Email Preferences";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/email_preferences',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	
	public function activity_log()
	{ 
		$data['page_title']=$this->lang->line('activity_log');
		$data['breadcrumb']='';
		$data['sites'] = $this->rest->get('api/v1/site/fetch',array("api_key"=>get_session('api_key')),'php');
		$data['app_list']	=   $this->rest->get('api/v1/apps/fetch_applisting',array("api_key"=>get_session('api_key')),'php');					
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		
		$redis_status  = $this->rest->get('api/v1/app_settings/redis_settings',array("api_key"=>get_session('api_key')),'php');
		$data['redis_setting'] = $redis_status[0]['redis_setting'];
		
		$data['content'] = $this->load->view('settings/activity_log',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	//function as in live
	public function fetch_activity_log()
	{ 
		$activity_log		= $this->rest->get('api/v1/app_settings/fetch_activity_log',array("api_key"=>get_session('api_key')),'json');
		echo convert_to_datatable_format($activity_log);  
	}
	//renamed old function as per in test
	public function fetch_activity_log_oldone()
	{ 
		$redis_status = $this->rest->get('api/v1/app_settings/redis_settings',array("api_key"=>get_session('api_key')),'php');
		if($redis_status[0]['redis_setting']=='disable')
		{
		$activity_log = $this->rest->get('api/v1/app_settings/fetch_activity_log',array("api_key"=>get_session('api_key')),'json'); 
		
		echo "directads<pre>";print_r($activity_log);exit();	
		$acc_id		  = $this->rest->get('api/v1/app_settings/fetch_accountid',array("api_key"=>get_session('api_key')),'php'); 		
		$activity_log_result = json_decode($activity_log, true);    
				
		$i=0;
								
		foreach($activity_log_result as $res)
		{
			$log_result=array_keys($res); 
			foreach($log_result as $log)
			{ 
			$log_res=explode("::",$log);
			if($log_res[0]==$acc_id)
			{
			$activity_result[$i]['id']=$i+1;
			$activity_result[$i]['account_id']=$log_res[0];	
			$activity_result[$i]['date']=$log_res[5];
			$activity_result[$i]['activity']=$log_res[6]."-".$log_res[7];
			$activity_result[$i]['ip']=$log_res[4];			
			$activity_result[$i]['useragent']=$log_res[1];
			$activity_result[$i]['browser']=$log_res[2];
			$activity_result[$i]['os']=$log_res[3];		
			$i++;
			}
			}
		}
		
		$activity_res=json_encode($activity_result);  
		
		$result=str_replace('\t','', $activity_res);
		}
		else
		{
			$result = $this->rest->get('api/v1/app_settings/fetch_activity_log_from_db',array("api_key"=>get_session('api_key')),'json');   
			
		}
																			
		//echo convert_to_datatable_format($result);     
	}
	
	public function fetch_payment_changes()
	{
		$payment_changes = $this->rest->get('api/v1/app_settings/fetch_payment_changes',array("api_key"=>get_session('api_key')),'json');		
		echo convert_to_datatable_format($payment_changes);  
	}
	
	public function fetch_activity_log_filter($type=false,$format='json')
	{ 
		
		$device= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));		
		$sit_id		= 	clean_data($this->input->post('site'));
		$application_id		=   clean_data($this->input->post('application'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$api_key 	= 	get_session('api_key');
		
		$input = array(
						'api_key'	=>	$api_key,
						'device'	=>	$device,
						'from_date' => $from_date,
						'to_date'   => $to_date				
					  );
		
						
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($application_id != 'all'){
			$input['app_id'] = ($application_id)?((is_array($application_id))?$application_id:explode(',',$application_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}	
			
		$data			= $this->rest->post('api/v1/app_settings/fetch',$input,'json');
		
		echo convert_to_datatable_format($data);  
		
	}
	
	/*
	 * 
	 * name		:referal_programs
	 * @param   :Null
	 * @return  :referal_programs for a particular
	 * 			 Publisher
	 */	
	
	public function referal_programs()
	{	
	
		$data['page_title'] = "Referal Programs";	
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('settings/referal_programs',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: account_settings
	 * @param   : Null
	 * @return  : account_settings for a particular
	 * 			 Publisher
	 */	
	
	public function account_settings()
	{		
		$data['page_title'] = "Account Settings";	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');
		$account_info=$this->rest->get('api/v1/publisher/user_information',array("api_key"=>$api_key),'php');	
		$data['account_info']=$account_info[0];	
		$seurity_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['seurity_info']=$seurity_info[0];
		$data['currency']=$this->rest->get('api/v1/utilities/currencylist',array("api_key"=>$api_key),'php');			
		$data['content'] = $this->load->view('settings/account_settings',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	public function notification_settings()
	{
		$data['page_title'] = "Notification Settings";	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');
		$data['notification_values']=$this->rest->get('api/v1/publisher/notification_value',array("api_key"=>$api_key),'php');//print_r($data['notification_values']);exit;
		$data['campaigns']	=	$this->rest->get('api/v1/campaign/fetch_pub_campaigns',array("api_key"=>$api_key),'php');
		$adgatenews	=	$this->rest->get('api/v1/publisher/fetch_pubadgate_news',array('api_key'=>get_session('api_key')),'php');	
		$data['adgatenews']	=	($adgatenews!='error')?$adgatenews:'';
		$data['content'] = $this->load->view('settings/notification_settings',$data,TRUE);	
		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	public function delete_notification_msg()
	{
	$msg_id = $this->input->post('msg_id');
	$data['msg'] 			= 	$this->rest->get('api/v1/message/delete_notify_message',array('api_key'=>get_session('api_key'),'msg_id'=>$msg_id),'php');
	echo json_encode($data['msg']);
	}
	public function notification_center()
	{
		$data['page_title'] = "Notification center";	
		$data['breadcrumb'] = '';
		$api_key = get_session('api_key');
		
		$data['to_id']	= $this->rest->get('api/v1/message/fetch_receiever_id',array('api_key'=>get_session('api_key')),'php');
		
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'inbox'),'php');
	
		$data['sent'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'sent'),'php');
		$data['trash'] 			= 	$this->rest->get('api/v1/message/fetch_message',array('api_key'=>get_session('api_key'),'message_type'=>'trash'),'php');
		$data['reciever_det']			= 	$this->rest->get('api/v1/message/fetch_data',array('api_key'=>get_session("api_key")),'php');
		
	
		$data['content'] = $this->load->view('settings/notification_center',$data,TRUE);	
		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}

	public function notification_center_list()
	{
		$data['inbox'] 			= 	$this->rest->get('api/v1/message/fetch_messagenotify_list',array('api_key'=>get_session('api_key'),'message_type'=>'Publisher - Site'),'php');
		
			echo convert_to_datatable_format(json_encode($data['inbox']));  
	}
	/*
	 * 
	 * name		:security
	 * @param   :Null
	 * @return  :Loads the form to get user security
	 */	

	public function security()
	{
		$data['page_title'] = "Security";
		$data['breadcrumb'] = '';
		
		$sms_info=$this->rest->get('api/v1/advertiser/sms_option',array('api_key'=>get_session('api_key')),'php');
		$data['app_sms_info'] = $sms_info[0]['sms_verify'];	
			
		$security_info=$this->rest->get('api/v1/advertiser/security',array('api_key'=>get_session('api_key')),'php');	
		$data['security_info']=$security_info[0];		
		$security_question=$this->rest->get('api/v1/advertiser/security_question',array('api_key'=>get_session('api_key')),'php');
		$data['security_question']=$security_question;	
		$personal_info=$this->rest->get('api/v1/advertiser/user_information',array('api_key'=>get_session('api_key')),'php');		
		$data['personal_info']=$personal_info[0];	
		$data['content'] = $this->load->view('settings/security',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	public function fetch_notify_msg($step=false)
	{	
	//	$step=$_GET['step'];
		//$step=$this->input->POST('step');
		if($step == 'step1')
		{
		$message_type = 'site';
		}
		elseif($step == 'step2')
		{
		$message_type = 'app';
		}
		elseif($step == 'step3')
		{
		$message_type = 'adcodes';
		}
		elseif($step == 'step4')
		{
		$message_type = 'payment_setting';
		}
		elseif($step == 'step5')
		{
		$message_type = 'setting_information';
		}
		elseif($step == 'step6')
		{
		$message_type = 'login_security';
		}
		elseif($step == 'step7')
		{
		$message_type = 'newletter_from_campaign';
		}
		elseif($step == 'step8')
		{
		$message_type = 'all';	
		}
		
		$data['message_type'] 			= 	$this->rest->get('api/v1/message/fetch_messagenotify_list',array('api_key'=>get_session('api_key'),'message_type'=>$message_type),'json');
		echo convert_to_datatable_format($data['message_type']);  
	}
	
	
}
