<?php 

class Roles extends CI_Controller {

	

	function __construct()

	{

		parent::__construct();

		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!

		$this->load->library('rest');

		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));

	}

	

	function index()

	{

		$this->manage_roles();		

	}

	

	/*

	 * 

	 * name		:add_role

	 * @param   :Null

	 * @return  :add role_permissions-information for Admin

	 * 		

	 */	

	public function add_role()

	{	

		$data['page_title'] = "Roles and permissions";	

		$data['breadcrumb'] = '';		

		$data['content'] = $this->load->view('roles/permission_settings',$data,TRUE);		

		$this->template->set_layout('publisher_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:edit_role

	 * @param   :Null

	 * @return  :edit role_permissions-information for Admin

	 * 		

	 */	

	public function edit_role($role_id)

	{	

		$data['page_title'] = "Edit roles and permissions";	

		$data['breadcrumb'] = '';
		$user_id=get_session('user_id');
		$data['role']=$this->rest->get('api/v1/subaccount/fetch_roles',array('role_id'=>$role_id,'api_key'=>get_session('api_key')),'php');
		//$this->rest->debug();
		$data['role_permissions']=json_decode($this->rest->get('api/v1/subaccount/fetch_role_permission',array('role_id'=>$role_id,'user_id'=>$user_id,'api_key'=>get_session('api_key')),'json'));
		
		$data['role_id'] = $role_id;
		$data['user_id'] = $user_id;
		$data['content'] = $this->load->view('roles/permission_settings',$data,TRUE);
		//$this->rest->debug();		
//print_r($data['role_permissions']);exit;
		$this->template->set_layout('publisher_layout');

		$this->template->build('view', $data);

	}

	

	/*

	 * 

	 * name		:manage_user_role

	 * @param   :Null

	 * @return  :list user_role for Admin

	 * 		

	 */	

	public function manage_roles()

	{	

		$data['page_title'] = "Manage_roles";	

		$data['breadcrumb'] = '';

		$data['content'] = $this->load->view('roles/user_roles',$data,TRUE);		

		$this->template->set_layout('publisher_layout');

		$this->template->build('view', $data);

    }

	

	/*

	 * 

	 * name		:fetch_user_roles

	 * @param   :Null

	 * @return  :list added-user_role_lists for Admin

	 * 		

	 */	

	public function fetch_user_roles()

	{

	   $user_role_list	  = $this->rest->get('api/v1/subaccount/fetch_roles',array('api_key'=>get_session('api_key')),'json');
	  

	   echo convert_to_datatable_format($user_role_list);

	}

}
