<?php 
class Reports extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->config('report_configurations');
	}
	
	function index()
	{
		$this->overview();		
	}
	
	
	/*
	 * 
	 * name		:overview
	 * @param   :Null
	 * @return  :List all the statistics for a particular
	 * 			 Publisher
	 */	
		
	public function overview()
	{
		$data['page_title'] = 	"Overview reports";
		$data['breadcrumb'] = 	'';
		
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/overview',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_stats($env='all',$site_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_OVERVIEW';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['report_type'] 	= 'overview';
		$input['result_type'] 	= 'DATA';			  
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//echo $this->rest->debug();
		// exit();
		echo $data;
    
	}
	
	/*
	 * 
	 * name		:geographic
	 * @param   :Null
	 * @return  :List all the geo map for a particular
	 * 			 Publisher
	 */	
			
	public function geographic()
	{
		$data['page_title'] = 	"Geographic reports";

		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set 				= 	$this->config->item('report_config');
		
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);	
		$data['content'] 	= 	$this->load->view('reports/geographic',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);		
	}
	
	public function fetch_country_stat($env='all',$site_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE,$date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
						'date'=>$date
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
		
				if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
	
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		//echo $this->rest->debug();exit;
		
		echo $data;
	}
	
	public function edit_report_site()
	{
		
		$this->session->unset_userdata('pub_edit_report_site');
		$this->session->set_userdata('pub_edit_report_site', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_edit_report_site'));
	}
	/*
	 * 
	 * name		:sites
	 * @param   :Null
	 * @return  :List all the sites & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function sites($siteid=FALSE)
	{
		$data['page_title'] = 	"Sites Report";
		$data['breadcrumb'] = 	'';
		$siteid = $this->session->userdata('pub_edit_report_site');
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		if(!empty($siteid))
		{
			$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key,"siteid"=>$siteid),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"site_id"=>$siteid),'php');
		
		}
		else
		{
			$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		}

		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id']=$siteid;
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_SITE']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/sites',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);				
	}
	/*
	 * 
	 * name		:sites
	 * @param   :Null
	 * @return  :List all the sites & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function sites_detail_list($siteid=FALSE,$field_name=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$data['page_title'] = 	"Sites Report Detail";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		if(!empty($siteid))
		{
			$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key,"siteid"=>$siteid),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"site_id"=>$siteid),'php');
		
		}
		else
		{
			$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array("api_key"=>$api_key),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		}

		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['site_id']		=	$siteid;
		$data['field_name']		= 	$field_name;
		$data['from_date']		= 	$from_date;
		$data['to_date']		= 	$to_date;		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_SITE_DETAILS']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/sites_detail_list',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);				
	}
	public function edit_mob_report_site()
	{
	
		$this->session->unset_userdata('pub_mob_app_rept');
		$this->session->set_userdata('pub_mob_app_rept', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_mob_app_rept'));
	}
	public function apps($appid=FALSE)
	{
		$appid = $this->session->userdata('pub_mob_app_rept');
		$data['page_title'] = 	"App Report";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		if(!empty($appid))
		{
			$data['apps']		=	$this->rest->get('api/v1/report/fetch_apps',array("api_key"=>$api_key,"appid"=>$appid),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>$api_key,"appid"=>$appid),'php');
		
		}
		else
		{
			$data['apps']		=	$this->rest->get('api/v1/report/fetch_apps',array("api_key"=>$api_key),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>$api_key),'php');
		
		}  
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['app_id']=$appid;
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_SITE']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/apps',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);				
	}

	public function apps_details($appid=FALSE)
	{
		$data['page_title'] = 	"App Report";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		if(!empty($appid))
		{
			$data['apps']		=	$this->rest->get('api/v1/report/fetch_apps',array("api_key"=>$api_key,"appid"=>$appid),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>$api_key,"appid"=>$appid),'php');
		
		}
		else
		{
			$data['apps']		=	$this->rest->get('api/v1/report/fetch_apps',array("api_key"=>$api_key),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>$api_key),'php');
		
		}  
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['app_id']=$appid;
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_SITE']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/apps_details',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);				
	}
	
	
	
	
	
	function sites_adblock($siteid=FALSE)
	{
		$api_key			=	get_session('api_key');
		$adb		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"site_id"=>$siteid),'php');
		
		$adblock='';
		$adblock="<select name='adblock' id='adblock' class='chosen-select' >
				  <option value='all'>".$this->lang->line('all_adb')."</option>";
				  if(!empty($adb)):
					foreach($adb as $ab):					
					$adblock.="<option value=".$ab['zoneid'].">".$ab['zonename']."</option>";
					endforeach; 
				  else:
					$adblock.="<option value=''>".$this->lang->line('no_adbl')."</option>";
				  endif;
		$adblock.="</select>";	
												

		echo $adblock;
		
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_site_stats($env='all',$site_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_SITE';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		$input['report_type']	= 'site';
	    $input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');		
		//$this->rest->debug(); die();	
		echo $data;
	}
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	/*public function fetch_site_stats_details($env='all',$site_id='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');

		if($field_name=='site_name')
			$page			= 'REPORT_SITE_DETAILS';
		else if($field_name=='site_url')
			$page			= 'REPORT_SITE_DETAILS_SITEURL';
		else if($field_name=='imp')
			$page			= 'REPORT_SITE_DETAILS_IMP';
		else if($field_name=='clk')
			$page			= 'REPORT_SITE_DETAILS_IMP';
		else 
			$page			= 'REPORT_SITE_DETAILS';
			//$page			= 'REPORT_SITE_DETAILS';

		
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
			
	    $input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');		
		//$this->rest->debug();	 die();
		echo $data;
	}*/
	
	public function fetch_app_stats($env='all',$app_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_APP';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($app_id != 'all'){
			$input['app_id'] = $app_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
		//$input['report_type']	= 'app';
	    $input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
		
		//echo $this->rest->debug();
		
		//print_r($data);	
			
		echo $data;
	}
	


	/*public function fetch_apps_stats_details($env='all',$app_id='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{ 
		$api_key 	= get_session('api_key');
		
		if($field_name=='app_name')
			$page			= 'REPORT_APP_DETAILS';
		else if($field_name=='app_url')
			$page			= 'REPORT_APP_DETAILS_APP_URL';
		else if($field_name=='imp')
			$page			= 'REPORT_APP_DETAILS_IMP';
		else if($field_name=='clk')
			$page			= 'REPORT_APP_DETAILS_IMP';
		else 
			$page			= 'REPORT_APP_DETAILS';
			
		
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($app_id != 'all'){
			$input['app_id'] = $app_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
			
	    $input['result_type'] 	= 'DATA';
	    $input['field_name'] 	= $field_name;
	    $input['email'] 	= get_session('email');
			
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	//fetch_detail_info
		//echo $this->rest->debug();	 die();
		echo $data;
	}*/
	
	/*
	 * 
	 * name		:adblocks
	 * @param   :Null
	 * @return  :List all the  Addblocks & Statistics for a particular
	 * 			 Publisher
	 */	
	 public function adblocks_edit_report()
	 {
		$this->session->unset_userdata('pub_edit_adb_rep');
		$this->session->set_userdata('pub_edit_adb_rep', $_POST['url_id']);
		echo json_encode($this->session->userdata('pub_edit_adb_rep'));
	
	 }	
	 	
	public function adblocks($adblock_id=FALSE)
	{
		$adblock_id=$this->session->userdata('pub_edit_adb_rep');
		$data['page_title'] =	"Adblock Report";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key'); 
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		
		// Fetch adblock list
		if(!empty($adblock_id))
		{
			$data['siteid']	= 	$this->rest->get('api/v1/report/fetch_site_adblock',array('api_key'=>$api_key,'adblock_id'=>$adblock_id),'php');
			$site_id		=	$data['siteid'][0]['site_id'];								
			
			$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,'site_id'=>$site_id),'php');			
		}
		else
		{
			$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		}
			
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['adblock_id']=$adblock_id;
		$data['site_id']=$data['siteid'][0];
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/adblocks',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	/*
	 * 
	 * name		:adblocks
	 * @param   :Null
	 * @return  :List all the  Addblocks & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function adblocks_details($adblock_id=FALSE,$field_name=FALSE,$dates=FALSE)
	{
		$data['page_title'] =	"Adblock Report Details";
		$data['breadcrumb'] = 	'';
		$data['dates'] = 	date("Y-m-d", strtotime($dates));
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key'); 
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		
		// Fetch adblock list
		if(!empty($adblock_id))
		{
			$data['siteid']	= 	$this->rest->get('api/v1/report/fetch_site_adblock',array('api_key'=>$api_key,'adblock_id'=>$adblock_id),'php');
			$site_id		=	$data['siteid'][0]['site_id'];								
			
			$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,'site_id'=>$site_id),'php');			
		}
		else
		{
			$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		}
			
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['adblock_id'] 	=	$adblock_id;
		$data['field_name'] 	=	$field_name;
		$data['site_id']=$data['siteid'][0];
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK_DETAILS']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/adblocks_details',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblock_stats($env='all',$site_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_ADBLOCK';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] 	= 	$env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] 		= 	$site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] 	= 	$from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 		= 	$to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] 	= 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 		= 	$_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['report_type']	= 'adblock';
		$input['result_type'] 	= 	'DATA';
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		
		echo $data;
	}
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
/*	public function fetch_adblock_stats_details($env='all',$adb_id='all',$field_name=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');

		if($field_name=='imp' || $field_name=='clk' )
				$page			= 'REPORT_ADBLOCK_DETAILS_IMP';
		else 	
				$page			= 'REPORT_ADBLOCK_DETAILS';
		//zone_name,imp,clk,REPORT_ADBLOCK_DETAILS_IMP
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] 	= 	$env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] 		= 	$site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] 	= 	$from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 		= 	$to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] 	= 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 		= 	$_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['report_type']	= 'adblock';
		$input['result_type'] 	= 	'DATA';
		
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
		//$this->rest->debug(); die();
		echo $data;
	}*/
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_dashboard_stats($from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_DASHBOARD';
		$display_type	= 	'TABLE';
		
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
				
		if($from_date != FALSE){
			$input['date_from'] = 	$from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] 	= 	$to_date;
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] 	= 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 		= 	$_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['report_type'] 	= 	'dash';
		$input['result_type'] 	= 	'DATA';
		
		$data			= 	$this->rest->post('api/v1/report/fetch',$input,'json');
		//echo $this->rest->debug();
		// exit();
		echo $data;
	}
	
	
	
	/***************************************************************
	 * 						Request Report
	 **************************************************************/ 
	 
	 /*
	 * 
	 * name		:adblocks
	 * @param   :Null
	 * @return  :List all the  Addblocks & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function request()
	{
		$data['page_title'] =	"Request Report";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		
		$data['download'] 	= 	$this->rest->get('api/v1/report/download_report',array('api_key'=>$api_key),'json');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_ADBLOCK']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/request',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	/*
	* Lists the Web ad blocks
	* 
	* name		:fetch_adblocks
	* @param   :Null
	* @return  :returns the JSON Object for datatable
	*  			 
	*/	
	
	public function fetch_request()
	{
		$api_key	= 	get_session('api_key');
		$request	= 	$this->rest->get('api/v1/report/fetch_request',array("api_key"=>$api_key),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($request);
	}
	
	/*
	 * 
	 * name		:group_report
	 * @param   :Null
	 * @return  :List all the sites & Statistics for a particular
	 * 			 Publisher
	 */	
	 	
	public function group_report()
	{
		$data['page_title'] = "Report";
		$data['breadcrumb'] = '';
		
		$api_key	=	get_session('api_key');
		
		/* Basic */
		$data['timezone'] =	$this->rest->get('api/v1/report/fetch_timezone',array('api_key'=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']	= $this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_SITE']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/group_report',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	
	/*
	 * Lists the Statistics by Datewise
	 * 
	 * name		:fetch_group_stats
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_group_stats($format='json')
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$timezone	= 	clean_data($this->input->post('timezone'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));

		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));		
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		$page		= 	'REPORT_SITE';
		
		$input = array(
						'api_key'	=>	$api_key,
						'page'		=>	$page,
						'interval'	=>	$interval,
						'timezone'	=>	$timezone,
						'environment'=>	$environment					
					  );
		
		$input['display_type'] 	= 'TABLE';
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}		
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
				array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}				
			
		
		if($format!='php')
		{
			$input['stat_type']		=	'PLATFORM';
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
			$input['report_type']	= 'site';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			
			//$this->rest->debug();
		//echo $this->rest->debug();exit;
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//echo $this->rest->debug();exit;
			
			return json_decode($data);
		}
	}
	
	public function generate_zip()
	{	
		$time	=	time();	
		$rep_name	=	'report_'.$time;
		
		$sdata		=	$this->fetch_group_stats('php');
		
		$interval	= 	clean_data($this->input->post('interval'));
		$from_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('from_date'))));
		$to_date	= 	date('d/m/Y',strtotime(clean_data($this->input->post('to_date'))));		
		
		//$met		= 	clean_data($this->input->post('metrics'));
		//$mcol		= 	clean_data($this->input->post('m_col'));
		$met			="TIME_DATES,IMP,CLK,CON,SPEND,CTR,ECPM,FILL_RATE";
		$mcol			="TIME_DATES,Imp,Clk,Conv,Spend,CTR,ECPM,Fill Rate";
		$dim		= 	clean_data($this->input->post('dimensions'));
		$dcol		= 	clean_data($this->input->post('d_col'));
		$dname		= 	clean_data($this->input->post('d_name'));
		
		$metrics 	= 	($met)?((is_array($met))?$met:explode(',',$met)):'';
		$m_col 		= 	($mcol)?((is_array($mcol))?$mcol:explode(',',$mcol)):'';	
		$dimens		= 	($dim)?((is_array($dim))?$dim:explode(',',$dim)):'';			
		$d_col		= 	($dcol)?((is_array($dcol))?$dcol:explode(',',$dcol)):'';
		$d_name 	= 	($dname)?((is_array($dname))?$dname:explode(',',$dname)):'';	
		
		if(!empty($sdata))
		{
			
			$objPHPExcel = new PHPExcel();
			
			$workSheet	=	 $objPHPExcel->getActiveSheet();			
			
			$objPHPExcel->getProperties()->setCreator("Administrator");
			$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
			$objPHPExcel->getProperties()->setTitle("Publisher_Report_".$time);			
			
			//Default Style Settings For Excel Sheet
			$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
			$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
			$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

			// Set column width
			
			//Set the dimensions for the Table Title Attributes
			$i='A';
			$workSheet->getColumnDimension('B')->setWidth(20);
			
			if($interval!='CUMULATIVE'):				
				if($interval=='HOUR'):	
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
					
					$i++;
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
				else:				
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
				endif;
				$i++;
			endif;
			
			if(!empty($dimens)):
				foreach($dimens as $d):					
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}	
					$i++;				
				endforeach;	
			endif;
			
			if(!empty($metrics)):
				foreach($metrics as $m):
					if($i=='B')
					{
						$workSheet->getColumnDimension($i)->setWidth(20);
					}
					else
					{
						$workSheet->getColumnDimension($i)->setAutoSize(true);
					}
					$i++;				
				endforeach;	
			endif;
			
			//Set the Row dimensions for Each Row 			
			$workSheet->getRowDimension(6)->setRowHeight(20);
			
			// Decalaration of Style in an Array 		
			
			$titleArray	=	array(
									'font'=>array(
												'bold'	=>	true,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);
			$contentArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);	
								
			$dimensArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
									)	
								);		
									
			$metricsArray	=	array(
									'font'=>array(
												'bold'	=>	false,
												'size'	=> 	10,
												'name'  => 'Calibric'
											),
									'alignment' =>array(
										'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
									)	
								);	
				
						
			// Add some data
			//echo date('H:i:s') . " Add some data\n";
			$objPHPExcel->setActiveSheetIndex(0);
			
			//Set the Title and Start Date ,End Date Details 
			$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
			$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Platform Report - '.$from_date.' to '.$to_date);
			$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
			$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
			$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
			$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B3', $from_date);	
			$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
					
			$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
			$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
			$objPHPExcel->getActiveSheet()->SetCellValue('B4', $to_date);
			$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
			
			$workSheet->getStyle(6)->applyFromArray($titleArray);
			
			$j='A';
			if($interval!='CUMULATIVE'):
				if($interval=='HOUR'):
					$workSheet->SetCellValue($j.'6',"Date");
					$j++;
					$workSheet->SetCellValue($j.'6',"Hour");	
				else:
					$workSheet->SetCellValue($j.'6',ucfirst(strtolower($interval)));	
				endif;
				$j++;
			endif;
			
			if(!empty($d_name)):
				foreach($d_name as $d):
					$workSheet->SetCellValue($j.'6',ucfirst($d));
					$j++;
				endforeach;	
			endif;
			
			if(!empty($m_col)):
				foreach($m_col as $m):
					$workSheet->SetCellValue($j.'6',ucfirst($m));
					$j++;
				endforeach;	
			endif;
			
			$col		=	0;
			$row		=	7;
			
			$k=0;
			
			foreach($sdata as $stat_data):
				$cv=0;
				if($interval!='CUMULATIVE'):
					if($interval=='HOUR'):
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->DATE);	
						$cv++;
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->HOUR);
					else:
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$interval);	
					endif;
					$cv++;
				endif;
			
				if(!empty($d_col)):
					foreach($d_col as $dc):
						$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$dc);
						$cv++;
					endforeach;	
				endif;
				
				if(!empty($metrics)):
					foreach($metrics as $m):
						if($m=='FILL_RATE')
						{
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m.'%');
						}
						else
						{
							$workSheet->setCellValueByColumnAndRow($cv,$row,$stat_data->$m);
						}					
						
						$cv++;
					endforeach;	
				endif;
				
				$row++;	
			endforeach;			
			ob_end_clean();
			ob_start();
			$filename	=		$rep_name.'.xls';
			
			//********* TO DOWNLOAD THE EXCEL FILE********
			header('Content-Type: application/vnd.ms-excel');
			header('Content-Disposition: attachment;filename="'.$filename.'"');
			
			$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);		
			
			$objWriter->save($this->config->item('csv_report').$filename);
			
			if($row>1000)
			{
				// Download the file to your desktop. Name it "my_backup.zip"
				$this->zip->read_file($this->config->item('csv_report').$filename);			
				$this->zip->download($rep_name.'.zip');
			}
			else
			{
				$objWriter->save('php://output');
			}
		}
		else
		{
			return false;
		}	
	}
	
	public function download_request()
	{
		//$res		=	clean_data($this->input->post('last_request'));
		$api_key 	= 	get_session('api_key');
		
		$res 		= 	$this->rest->get('api/v1/report/download_report',array('api_key'=>$api_key),'json');
		
		if($res)
		{
			$stat	=	json_decode($res);
			
			$time		=	time();	
			$rep_name	=	'report_'.$time;
			
			$request	=	$stat->request;
			$search		=	$stat->search;
			$rep_data	=	$stat->data;
			$f_date=$stat->data[0];
			
			//$from_date	= 	date('d/m/Y',strtotime($search->date_from));
			//$to_date	= 	date('d/m/Y',strtotime($search->date_to));
			$from_date	= 	date('d/m/Y',strtotime($f_date->DATE));
			$to_date	= 	date('d/m/Y',strtotime($request->date_time));
			if($rep_data)
			{
				$objPHPExcel= 	new PHPExcel();
				$workSheet	=	$objPHPExcel->getActiveSheet();			
				
				$objPHPExcel->getProperties()->setCreator("Administrator");
				$objPHPExcel->getProperties()->setLastModifiedBy("Administrator");
				$objPHPExcel->getProperties()->setTitle();				

				//Default Style Settings For Excel Sheet
				$workSheet->getDefaultStyle()->getFont()->setName('Calibric')->setSize(10);
				$workSheet->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);		
				$workSheet->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);										

				// Set column width
				
				//Set the dimensions for the Table Title Attributes
				$workSheet->getColumnDimension('A')->setAutoSize(true);
				$workSheet->getColumnDimension('B')->setAutoSize(true);
				$workSheet->getColumnDimension('C')->setAutoSize(true);
				$workSheet->getColumnDimension('D')->setAutoSize(true);
				$workSheet->getColumnDimension('E')->setAutoSize(true);
				$workSheet->getColumnDimension('F')->setAutoSize(true);
				$workSheet->getColumnDimension('G')->setAutoSize(true);
				$workSheet->getColumnDimension('H')->setAutoSize(true);		
				
				//Set the Row dimensions for Each Row 			
				$workSheet->getRowDimension(6)->setRowHeight(20);
				
				// Decalaration of Style in an Array 		
				
				$titleArray	=	array(
										'font'=>array(
													'bold'	=>	true,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);
				$contentArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);	
									
				$dimensArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_LEFT
										)	
									);		
										
				$metricsArray	=	array(
										'font'=>array(
													'bold'	=>	false,
													'size'	=> 	10,
													'name'  => 'Calibric'
												),
										'alignment' =>array(
											'horizontal' =>PHPExcel_Style_Alignment::HORIZONTAL_CENTER
										)	
									);				
							
				// Add some data
				//echo date('H:i:s') . " Add some data\n";
				$objPHPExcel->setActiveSheetIndex(0);
				
				//Set the Title and Start Date ,End Date Details 
				$objPHPExcel->getActiveSheet()->SetCellValue('A1', "Report Name");
				$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Report - '.$from_date.' to '.$to_date);
				$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A2', "Report ID");
				$objPHPExcel->getActiveSheet()->getStyle('A2')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B2', $time);
				$objPHPExcel->getActiveSheet()->getStyle('B2')->applyFromArray($contentArray);
				
				$objPHPExcel->getActiveSheet()->SetCellValue('A3', "From Date");
				$objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B3', $from_date);	
				$objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($contentArray);			
						
				$objPHPExcel->getActiveSheet()->SetCellValue('A4', "To Date");
				$objPHPExcel->getActiveSheet()->getStyle('A4')->applyFromArray($titleArray);
				$objPHPExcel->getActiveSheet()->SetCellValue('B4', $to_date);
				$objPHPExcel->getActiveSheet()->getStyle('B4')->applyFromArray($contentArray);
				
				if($search->account_type=='ADVERTISER'):
					$workSheet->SetCellValue('A6',"Campaign");
					$workSheet->SetCellValue('B6',"Creative");	
					$workSheet->SetCellValue('F6',"Spend");				
				elseif($search->account_type=='TRAFFICKER'):
					$workSheet->SetCellValue('A6',"Site");
					$workSheet->SetCellValue('B6',"Adblock");
					$workSheet->SetCellValue('F6',"Revenue");
				endif; 
				$workSheet->SetCellValue('C6',"Impressions");
				$workSheet->SetCellValue('D6',"Clicks");
				$workSheet->SetCellValue('E6',"Conversions");			
				$workSheet->SetCellValue('G6',"CTR");
				$workSheet->SetCellValue('H6',"ECPM");
				
				$workSheet->getStyle('A6:H6')->applyFromArray($titleArray);
				
				$col		=	0;
				$row		=	7;
				
				$k=0;
				
				foreach($rep_data as $stat_data):
					if($search->account_type=='ADVERTISER'):
						$workSheet->setCellValueByColumnAndRow(0,$row,$stat_data->CAM_NAME);	
						$workSheet->setCellValueByColumnAndRow(1,$row,$stat_data->BAN_NAME);
						$workSheet->setCellValueByColumnAndRow(6,$row,html_entity_decode($this->config->item('currency')).$stat_data->SPEND);
						$workSheet->setCellValueByColumnAndRow(7,$row,html_entity_decode($this->config->item('currency')).$stat_data->ECPM);
					elseif($search->account_type=='TRAFFICKER'):
						$workSheet->setCellValueByColumnAndRow(0,$row,$stat_data->SITE_URL);	
						$workSheet->setCellValueByColumnAndRow(1,$row,$stat_data->ZONE_NAME);	
						$workSheet->setCellValueByColumnAndRow(6,$row,html_entity_decode($this->config->item('currency')).$stat_data->PUB_EARN);
						$workSheet->setCellValueByColumnAndRow(7,$row,html_entity_decode($this->config->item('currency')).$stat_data->PUB_ECPM,ENT_QUOTES);
					endif;
					
					$workSheet->setCellValueByColumnAndRow(2,$row,$stat_data->IMP);	
					$workSheet->setCellValueByColumnAndRow(3,$row,$stat_data->CLK);	
					$workSheet->setCellValueByColumnAndRow(4,$row,$stat_data->CON);	
					$workSheet->setCellValueByColumnAndRow(5,$row,$stat_data->CTR.'%');				
					
							
					$row++;	
				endforeach;			
				ob_end_clean();
				ob_start();
				if($search->format=='xls'):
					$filename	=		$rep_name.'.xls';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: application/vnd.ms-excel');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
				elseif($search->format=='csv'):
					$filename	=		$rep_name.'.csv';
					//********* TO DOWNLOAD THE EXCEL FILE********
					header('Content-Type: text/csv');
					header('Content-Disposition: attachment;filename="'.$filename.'"');
				endif;
				
				$objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);	
				
				$objWriter->save('php://output');
				
			}
			else
			{
				echo 'error';
			}
		}
		else
		{
			echo 'error';
		}		
	}	
	
	public function fetch_pub_filter_stats($type=false,$format='json')   
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$from_date	= 	date("Y-m-d", strtotime($from_date));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));

		$sit_id		= 	clean_data($this->input->post('site'));
		$application_id		=   clean_data($this->input->post('application'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));		
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}		
		else
		{
			if($application_id)
			{
			  $page		= 	'REPORT_APP';
			}
			else
			{
			  $page		= 	'REPORT_SITE';	
			}
			
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		$input['display_type'] 	= 'TABLE';
				
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($application_id != 'all'){
			$input['app_id'] = ($application_id)?((is_array($application_id))?$application_id:explode(',',$application_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
		
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
				
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');
			//print_r($input);exit;		
			//echo $this->rest->debug(); die();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	
			//echo $this->rest->debug();  die("test");
			
			return json_decode($data);
		}
	}
	


	public function apps_detail_list($appid=FALSE,$field_name=FALSE)
	{
		$data['page_title'] = 	"App Report Detail";
		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
				
		if(!empty($appid))
		{
			$data['apps']		=	$this->rest->get('api/v1/report/fetch_apps',array("api_key"=>$api_key,"appid"=>$appid),'php');//print_r($data['apps']);exit;
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key,"appid"=>$appid),'php');
		
		}
		else
		{
			$data['apps']		=	$this->rest->get('api/v1/report/fetch_apps',array("api_key"=>$api_key),'php');
			// Fetch adblock list
			$data['adb']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		}

		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['app_id']		=	$appid;
		$data['field_name']		= 	$field_name;
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_SITE_DETAILS']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] 	= 	$this->load->view('reports/app_detail_list',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);				
	}
	
	
	
	public function fetch_detail_apps($env='all',$app_id='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{ 
		$api_key 	= get_session('api_key');
		
		if($field_name=='app_name')
			$page			= 'REPORT_APP_DETAILS';
		else if($field_name=='app_url')
			$page			= 'REPORT_APP_DETAILS_APP_URL';
		else if($field_name=='imp')
			$page			= 'REPORT_APP_DETAILS_IMP';
		else if($field_name=='clk')
			$page			= 'REPORT_APP_DETAILS_IMP';
		else 
			$page			= 'REPORT_APP_DETAILS';
			
		
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($app_id != 'all'){
			$input['app_id'] = $app_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}			  
	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
			
	    $input['result_type'] 	= 'DATA';
	    $input['field_name'] 	= $field_name;
	    $input['email'] 	= get_session('email');
			
		$data			= $this->rest->post('api/v1/report/fetch',$input,'json');	//fetch_detail_info
		//echo $this->rest->debug();	 die();
		echo $data;
	}
	
	public function fetch_site_stats_details($env='all',$site_id='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');

		if($field_name=='site_name')
			$page			= 'REPORT_SITE_DETAILS';
		else if($field_name=='site_url')
			$page			= 'REPORT_SITE_DETAILS_SITEURL';
		else if($field_name=='imp')
			$page			= 'REPORT_SITE_DETAILS_IMP';
		else if($field_name=='clk')
			$page			= 'REPORT_SITE_DETAILS_IMP';
		else 
			$page			= 'REPORT_SITE_DETAILS';
			//$page			= 'REPORT_SITE_DETAILS';

		
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}			  
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		$input['field_name']		= 	$field_name;
		$input['datatable_obj'] = $_REQUEST;	
			
	    $input['result_type'] 	= 'DATA';
		$data			= $this->rest->post('api/v1/report/fetch_detail_info2',$input,'json');		
		//$this->rest->debug();	 die();
		echo $data;
	}
	
	
	public function fetch_apps_stats_details($env='all',$app_id='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{ 
		$api_key 	= get_session('api_key');
		
		if($field_name=='app_name')
			$page			= 'REPORT_APP_DETAILS';
		else if($field_name=='app_url')
			$page			= 'REPORT_APP_DETAILS_APP_URL';
		else if($field_name=='imp')
			$page			= 'REPORT_APP_DETAILS_IMP';
		else if($field_name=='clk')
			$page			= 'REPORT_APP_DETAILS_IMP';
		else 
			$page			= 'REPORT_APP_DETAILS';
			
		
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($app_id != 'all'){
			$input['app_id'] = $app_id;
		}				
		  
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}			  
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}	   
	    if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		
		$input['datatable_obj'] = $_REQUEST;	
			
	    $input['result_type'] 	= 'DATA';
	    $input['field_name'] 	= $field_name;
	    $input['email'] 	= get_session('email');
			
		$data			= $this->rest->post('api/v1/report/fetch_detail_info2',$input,'json');	//fetch_detail_info
		//echo $this->rest->debug();	 die();
		echo $data;
	}	
	
	
	
	public function fetch_adblock_stats_details($env='all',$adb_id='all',$field_name=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');

		if($field_name=='imp' || $field_name=='clk' )
				$page			= 'REPORT_ADBLOCK_DETAILS_IMP';
		else 	
				$page			= 'REPORT_ADBLOCK_DETAILS';
		//zone_name,imp,clk,REPORT_ADBLOCK_DETAILS_IMP
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] 	= 	$env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] 		= 	$site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}			  
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] 	= 	$_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] 		= 	$_REQUEST['iDisplayLength'];
		}
		$input['field_name'] 	= $field_name;
		$input['datatable_obj'] = 	$_REQUEST;
		$input['report_type']	= 'adblock';
		$input['result_type'] 	= 	'DATA';
		
		$data			= $this->rest->post('api/v1/report/fetch_detail_info2',$input,'json');
		//$this->rest->debug(); die();
		echo $data;
	}
	

	public function overview_detail_list($date='all',$field_name=FALSE)
	{
		$data['page_title'] = 	"Overview Detail reports";
		$data['breadcrumb'] = 	'';
		
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		// GET DEFAULT PERIOD FROM CONFIG FILE
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_OVERVIEW']['TABLE']['DEFAULT_INTERVAL']);
		
		$data['date'] = $date;
		$data['field_name'] = $field_name;
		
		$data['content'] 	= 	$this->load->view('reports/overview_detail_list',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
		
	}
	
	/*public function fetch_detail_overview_stats($date='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_OVERVIEW';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($site_id != 'all'){
			$input['site_id'] = $site_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}

		$input['date'] = $date;
		$input['field_name'] = $field_name;
				
		$input['datatable_obj'] = $_REQUEST;
		$input['report_type'] 	= 'overview';
		$input['result_type'] 	= 'DATA';			  
		
		$data			= $this->rest->post('api/v1/report/fetch_detail_overview',$input,'json');
		//echo $this->rest->debug();
		// exit();
		echo $data;
    
	}*/	
	
	
	public function fetch_detail_overview_stats($date='all',$field_name=FALSE,$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	    = get_session('api_key');
		$page			= 'REPORT_OVERVIEW';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type
					  );

		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($_POST['site'] != 'all'){
			$input['site_id'] = $_POST['site'];
		}
		
		if($_POST['adblock'] != 'all'){
			$input['adblock_id'] 	= 	$_POST['adblock'];
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}
		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}

		$dimens		= 	clean_data($this->input->post('dimensions'));
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		$input['date'] = $date;
		$input['field_name'] = $field_name;
				
		$input['datatable_obj'] = $_REQUEST;
		$input['report_type'] 	= 'overview';
		$input['result_type'] 	= 'DATA';			  
		
		$data			= $this->rest->post('api/v1/report/fetch_detail_overview',$input,'json');
		//echo $this->rest->debug();
		// exit();
		echo $data;
    
	}	
	
		
	
	public function geo_detail_list($date='all',$field_name=FALSE,$country=FALSE)
	{
		$data['page_title'] = 	"Geographic reports";

		$data['breadcrumb'] = 	'';
		
		// GET ALL SITES FOR PUBLISHER
		$api_key			=	get_session('api_key');
		
		/* Additional Filter */
		$data['country']	=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']		= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']		=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>get_session('api_key')),'php');
		$data['adblock']	= 	$this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$set 				= 	$this->config->item('report_config');

		$data['date'] = $date;
		$data['countries'] = $country;
		$data['field_name'] = $field_name;
				
		$data['search_date']= 	get_search_date($set['TRAFFICKER']['REPORT_GEO_GRAPHICAL']['TABLE']['DEFAULT_INTERVAL']);	
		$data['content'] 	= 	$this->load->view('reports/geo_detail_list',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);		
	}	
		
	public function fetch_country_detail_stat($date='all',$field_name=FALSE,$country=FALSE,$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 	= get_session('api_key');
		$page			= 'REPORT_GEO_GRAPHICAL';
		$display_type	= 'TABLE';
		
		$input = array(
						'api_key'=>$api_key,
						'page'=>$page,
						'display_type'=>$display_type,
						'stat_type'=>'COUNTRY',
						'date'=>$date
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($_POST['site'] != 'all'){
			$input['site_id'] = $_POST['site'];
		}
		
		if($_POST['adblock'] != 'all'){
			$input['adblock_id'] 	= 	$_POST['adblock'];
		}
		
		if($_POST['country'] != FALSE){
			$input['country'] = $_POST['country'];
		}		
		else
		{
			$input['country'] 	= 	$country;
			$input['report_type'] 	= 'geo';
		}
		
		if($_POST['from_date'] != FALSE){
			$input['date_from'] = $_POST['from_date'];
		}	
		
		if($_POST['to_date'] != FALSE){
			$input['date_to'] = $_POST['to_date'];
		}

		if($_POST['device'] != FALSE){
			$input['device'] = $_POST['device'];
		}			  
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}
		$input['date'] = $date;
		$input['field_name'] = $field_name;
				
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
		
					  
	
		$data			= $this->rest->post('api/v1/report/fetch_detail_overview',$input,'json');
		
		//$this->rest->debug();
		
		echo $data;
	}	
			
	public function group_detail_list($date=FALSE,$field_name=FALSE)
	{
		$data['page_title'] = "Report";
		$data['breadcrumb'] = '';
		
		$api_key	=	get_session('api_key');
		
		/* Basic */
		$data['timezone'] =	$this->rest->get('api/v1/report/fetch_timezone',array('api_key'=>get_session('api_key')),'php');
		
		/* Additional Filter */
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>get_session('api_key')),'php');
			
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>get_session('api_key')),'php');
		
		/* Publisher Filter */
		$data['sites']=$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']	= $this->rest->get('api/v1/report/fetch_adblocks',array("api_key"=>get_session('api_key')),'php');
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['date'] = $date;
		$data['field_name'] = $field_name;		
		$set = $this->config->item('report_config');
		$data['search_date'] = get_search_date($set['TRAFFICKER']['REPORT_SITE']['TABLE']['DEFAULT_INTERVAL']);
		$data['content'] = $this->load->view('reports/group_detail_list',$data,TRUE);
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
				
	}
	public function fetch_publisher_stats_home($api_key=false,$account_id=false,$account_type=false,$env='all',$pub_id='all',$adb_id='all',$from_date=FALSE,$to_date=FALSE)
	{
		$api_key 		= 	$api_key;
		$page			= 	'REPORT_PUBLISHER_HOME';
		$display_type	= 	'TABLE';
		
		$input = array(
						'api_key'		=>	$api_key,
						'account_id'	=>	$account_id,
						'account_type'	=>	$account_type,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
		
		if($env != 'all'){
			$input['environment'] = $env;
		}	
		
		if($pub_id != 'all'){
			$input['pub_account_id'] = $pub_id;
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] 	= 	$adb_id;
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}	
		
		if(isset($_REQUEST['iDisplayStart'])){
			$input['start'] = $_REQUEST['iDisplayStart'];
		}
		
		if(isset($_REQUEST['iDisplayLength'])){
			$input['end'] = $_REQUEST['iDisplayLength'];
		}		  
		
		$input['datatable_obj'] = $_REQUEST;
		$input['result_type'] 	= 'DATA';
					  
		$data			= $this->rest->post('api/v1/report/home_fetch',$input,'json');

		//$this->rest->debug();

		echo $data;
	}
	
	
	
	
	//api-home//
	public function fetch_home_filter_stats($type=false,$format='json',$api_key=false,$account_id=false,$account_type=false)   
	{
		
		
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		//$adv_id		= 	clean_data($this->input->post('advertiser'));
		//$cam_id		=  	clean_data($this->input->post('campaign'));
		//$cre_id		= 	clean_data($this->input->post('creative'));
		//$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$application_id		=   clean_data($this->input->post('application'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));

		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		//$api_key 	= 	get_session('api_key');
		
		if($type!=false && $type=='COUNTRY')
		{
			$page		=	'REPORT_GEO_GRAPHICAL';
		}
		elseif($type!=false && $type=='ENVIRONMENT')
		{
			$page		=	'REPORT_ENVIRONMENT';
		}
		elseif($type!=false && $type=='URL')
		{
			$page		=	'REPORT_URL';
		}
		elseif($type!=false && $type=='VIDEO')
		{
			$page		=	'REPORT_VIDEO';
		}
		else
		{
			if($application_id)
			{
			  $page		= 	'REPORT_APP';
			}
			else
			{
			  $page		= 	'REPORT_SITE';	
			}
			
		}
		
		$input = array(
						'api_key'		=>	$api_key,
						'account_id'	=>	$account_id,
						'account_type'	=>	$account_type,
						'page'			=>	$page,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );		
		
		$input['display_type'] 	= 'TABLE';
				
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($application_id != 'all'){
			$input['app_id'] = ($application_id)?((is_array($application_id))?$application_id:explode(',',$application_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
		
		if($camtyp != 'all'){
			$input['camtyp'] = ($camtyp)?((is_array($camtyp))?$camtyp:explode(',',$camtyp)):'';
		}
		
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		//$type=false; 
		
		if($format!='php')
		{
			$input['stat_type']		=	'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/home_fetch',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/report/home_fetch',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
	}
	public function fetch_profit_pub($from_date=FALSE,$to_date=FALSE)
	{
		
		$period = new DatePeriod(
			 new DateTime($from_date),
			 new DateInterval('P1D'),
			 new DateTime($to_date)
		);

		$api_key 		= 	get_session('api_key');
		$page			= 	'REPORT_DASHBOARD';
		$display_type	= 	'TABLE';
	
		$input = array(
						'api_key'		=>	$api_key,
						'page'			=>	$page,
						'display_type'	=>	$display_type
					  );
				
		 
			$input['date_from'] = 	$from_date;
	 
		
	 
			$input['date_to'] 	= 	$to_date;
		    
		
		 
		
		$input['datatable_obj'] = 	$_REQUEST;
		$input['report_type'] 	= 	'dash';
		$input['result_type'] 	= 	'DATA';
		 
		$datk			= 	$this->rest->post('api/v1/report/fetch_profit',$input,'json');
		$data= json_decode($datk,true);
		 
		$date_value = array();
		$date_value_alt = array();
		foreach ($period as $key => $value) {
			$date_value[] = $value->format('Y-m-d');
			$date_value_alt[$value->format('Y-m-d')] = '0';
		}   
		$date_count = count($date_value); 
		$array_key= array();
		$array_val= array();
		$today_data = $data['counts'];
		$data = $data['chart'];
		
		if($data)
		{  
			for($i=0;$i<=$date_count;$i++)
			{ 
				if (in_array($data[$i]['date'],$date_value))
				{
					$array_key['earnings'][$data[$i]['date']]=(float)$data[$i]['earnings'];					
					 			
				}
							
			}
		} 
		foreach($array_key['earnings'] as $kk =>$val)
		{
			if(in_array($kk,$date_value))
			{
				$date_value_alt_val['earnings'][$kk]=(float)$val;
			}
		}
		
		$earnings= array_merge($date_value_alt,$date_value_alt_val['earnings']);
		
		 $today_data = end($today_data);
		 
			$return_value= array(
			'array_keys'=>	array_keys($date_value_alt),
			'array_keys_last'=>	array($to_date),
			'earnings'=>array_values($earnings),
			'array_imp'=>$today_data['imps'],
			'array_clk'=>$today_data['clicks'],
			'array_conv'=>$today_data['convs'],
			'revenue'=>(float)$today_data['revenue'],
			 
			);
		 
		echo json_encode($return_value);
	}					
}
