<?php 
class Referral extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
		
	function index()
	{
		$this->referral();		
	}
	
	/*
	 * 
	 * name		: referral
	 * @param   : Null
	 * @return  : List all the messages for admin
	 */	
	 	
	public function referral()
	{	
		$data['page_title'] 	= 	"Referral";	
		$data['breadcrumb'] 	= 	'';	
		$account_id				=	get_session('account_id');
		$data['account_id']		=	urlencode(base64_encode($account_id));
		
		$data['content'] 		= 	$this->load->view('referral/referral_program',$data,TRUE);		
		$this->template->set_layout('publisher_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		: Referral
	 * @param   : Null
	 * @return  : List all the referral for pubkisher
	 */	
	
	public function fetch_referral()
	{	
		$api_key = get_session('api_key'); 
		$referral 	= 	$this->rest->get('api/v1/referral/fetch_referral',array("api_key"=>$api_key),'json');
		
		echo convert_to_datatable_format($referral);
	}		
}
